/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.nio.ByteBuffer;
import java.util.Properties;
import org.apache.spark.Partition;
import org.apache.spark.Partition$class;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.rdd.RDD;
import org.apache.spark.scheduler.MapStatus;
import org.apache.spark.scheduler.Task;
import org.apache.spark.scheduler.TaskLocation;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.shuffle.ShuffleManager;
import org.apache.spark.shuffle.ShuffleWriter;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005%b!B\u0001\u0003\u0001\u0011Q!AD*ik\u001a4G.Z'baR\u000b7o\u001b\u0006\u0003\u0007\u0011\t\u0011b]2iK\u0012,H.\u001a:\u000b\u0005\u00151\u0011!B:qCJ\\'BA\u0004\t\u0003\u0019\t\u0007/Y2iK*\t\u0011\"A\u0002pe\u001e\u001c2\u0001A\u0006\u0013!\raQbD\u0007\u0002\u0005%\u0011aB\u0001\u0002\u0005)\u0006\u001c8\u000e\u0005\u0002\r!%\u0011\u0011C\u0001\u0002\n\u001b\u0006\u00048\u000b^1ukN\u0004\"a\u0005\f\u000e\u0003QQ!!\u0006\u0003\u0002\u0011%tG/\u001a:oC2L!a\u0006\u000b\u0003\u000f1{wmZ5oO\"I\u0011\u0004\u0001B\u0001B\u0003%1$I\u0001\bgR\fw-Z%e\u0007\u0001\u0001\"\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\u00111!\u00138u\u0013\tIR\u0002C\u0005$\u0001\t\u0005\t\u0015!\u0003\u001cI\u0005q1\u000f^1hK\u0006#H/Z7qi&#\u0017BA\u0012\u000e\u0011!1\u0003A!A!\u0002\u00139\u0013A\u0003;bg.\u0014\u0015N\\1ssB\u0019\u0001fK\u0017\u000e\u0003%R!A\u000b\u0003\u0002\u0013\t\u0014x.\u00193dCN$\u0018B\u0001\u0017*\u0005%\u0011%o\\1eG\u0006\u001cH\u000fE\u0002\u001d]AJ!aL\u000f\u0003\u000b\u0005\u0013(/Y=\u0011\u0005q\t\u0014B\u0001\u001a\u001e\u0005\u0011\u0011\u0015\u0010^3\t\u0011Q\u0002!\u0011!Q\u0001\nU\n\u0011\u0002]1si&$\u0018n\u001c8\u0011\u0005Y:T\"\u0001\u0003\n\u0005a\"!!\u0003)beRLG/[8o\u0011!Q\u0004A!a\u0001\n\u0013Y\u0014\u0001\u00027pGN,\u0012\u0001\u0010\t\u0004{\u0015CeB\u0001 D\u001d\ty$)D\u0001A\u0015\t\t%$\u0001\u0004=e>|GOP\u0005\u0002=%\u0011A)H\u0001\ba\u0006\u001c7.Y4f\u0013\t1uIA\u0002TKFT!\u0001R\u000f\u0011\u00051I\u0015B\u0001&\u0003\u00051!\u0016m]6M_\u000e\fG/[8o\u0011!a\u0005A!a\u0001\n\u0013i\u0015\u0001\u00037pGN|F%Z9\u0015\u00059\u000b\u0006C\u0001\u000fP\u0013\t\u0001VD\u0001\u0003V]&$\bb\u0002*L\u0003\u0003\u0005\r\u0001P\u0001\u0004q\u0012\n\u0004\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0015\u0002\u001f\u0002\u000b1|7m\u001d\u0011)\u0005M3\u0006C\u0001\u000fX\u0013\tAVDA\u0005ue\u0006t7/[3oi\"I!\f\u0001B\u0001B\u0003%1,Y\u0001\b[\u0016$(/[2t!\tav,D\u0001^\u0015\tqF!\u0001\u0005fq\u0016\u001cW\u000f^8s\u0013\t\u0001WLA\u0006UCN\\W*\u001a;sS\u000e\u001c\u0018B\u0001.\u000e\u0011!\u0019\u0007A!A!\u0002\u0013!\u0017a\u00047pG\u0006d\u0007K]8qKJ$\u0018.Z:\u0011\u0005\u0015TW\"\u00014\u000b\u0005\u001dD\u0017\u0001B;uS2T\u0011![\u0001\u0005U\u00064\u0018-\u0003\u0002lM\nQ\u0001K]8qKJ$\u0018.Z:\t\u000b5\u0004A\u0011\u00018\u0002\rqJg.\u001b;?)!y\u0007/\u001d:tiV4\bC\u0001\u0007\u0001\u0011\u0015IB\u000e1\u0001\u001c\u0011\u0015\u0019C\u000e1\u0001\u001c\u0011\u00151C\u000e1\u0001(\u0011\u0015!D\u000e1\u00016\u0011\u0015QD\u000e1\u0001=\u0011\u0015QF\u000e1\u0001\\\u0011\u0015\u0019G\u000e1\u0001e\u0011\u0015i\u0007\u0001\"\u0001y)\ty\u0017\u0010C\u0003{o\u0002\u00071$A\u0006qCJ$\u0018\u000e^5p]&#\u0007b\u0002?\u0001\u0005\u0004%IaO\u0001\u000eaJ,g-\u001a:sK\u0012dunY:\t\ry\u0004\u0001\u0015!\u0003=\u00039\u0001(/\u001a4feJ,G\rT8dg\u0002B#! ,\t\u000f\u0005\r\u0001\u0001\"\u0011\u0002\u0006\u00059!/\u001e8UCN\\GcA\b\u0002\b!A\u0011\u0011BA\u0001\u0001\u0004\tY!A\u0004d_:$X\r\u001f;\u0011\u0007Y\ni!C\u0002\u0002\u0010\u0011\u00111\u0002V1tW\u000e{g\u000e^3yi\"1\u00111\u0003\u0001\u0005Bm\n!\u0003\u001d:fM\u0016\u0014(/\u001a3M_\u000e\fG/[8og\"9\u0011q\u0003\u0001\u0005B\u0005e\u0011\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005m\u0001\u0003BA\u000f\u0003Gq1\u0001HA\u0010\u0013\r\t\t#H\u0001\u0007!J,G-\u001a4\n\t\u0005\u0015\u0012q\u0005\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0005R\u0004")
public class ShuffleMapTask
extends Task<MapStatus>
implements Logging {
    private final Broadcast<byte[]> taskBinary;
    private final Partition partition;
    private transient Seq<TaskLocation> locs;
    private final transient Seq<TaskLocation> preferredLocs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    private Seq<TaskLocation> locs() {
        return this.locs;
    }

    private void locs_$eq(Seq<TaskLocation> x$1) {
        this.locs = x$1;
    }

    private Seq<TaskLocation> preferredLocs() {
        return this.preferredLocs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public MapStatus runTask(TaskContext context) {
        Tuple2 tuple22;
        long deserializeStartTime = System.currentTimeMillis();
        SerializerInstance ser = SparkEnv$.MODULE$.get().closureSerializer().newInstance();
        Tuple2 tuple2 = (Tuple2)ser.deserialize(ByteBuffer.wrap(this.taskBinary.value()), Thread.currentThread().getContextClassLoader(), ClassTag$.MODULE$.apply(Tuple2.class));
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        RDD rdd = (RDD)tuple2._1();
        ShuffleDependency dep = (ShuffleDependency)tuple2._2();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)rdd, (Object)dep);
        RDD rdd2 = (RDD)tuple23._1();
        ShuffleDependency dep2 = (ShuffleDependency)tuple23._2();
        this._executorDeserializeTime_$eq(System.currentTimeMillis() - deserializeStartTime);
        ShuffleWriter writer = null;
        try {
            ShuffleManager manager = SparkEnv$.MODULE$.get().shuffleManager();
            writer = manager.getWriter(dep2.shuffleHandle(), this.partitionId(), context);
            writer.write(rdd2.iterator(this.partition, context));
            return (MapStatus)writer.stop(true).get();
        }
        catch (Exception exception2) {
            BoxedUnit boxedUnit;
            try {
                boxedUnit = writer == null ? BoxedUnit.UNIT : writer.stop(false);
                throw exception2;
            }
            catch (Exception exception3) {
                this.log().debug("Could not stop writer", (Throwable)exception3);
                boxedUnit = BoxedUnit.UNIT;
            }
            throw exception2;
        }
    }

    @Override
    public Seq<TaskLocation> preferredLocations() {
        return this.preferredLocs();
    }

    public String toString() {
        return new StringOps(Predef$.MODULE$.augmentString("ShuffleMapTask(%d, %d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)super.stageId()), BoxesRunTime.boxToInteger((int)this.partitionId())}));
    }

    public ShuffleMapTask(int stageId, int stageAttemptId, Broadcast<byte[]> taskBinary, Partition partition, Seq<TaskLocation> locs, TaskMetrics metrics, Properties localProperties) {
        this.taskBinary = taskBinary;
        this.partition = partition;
        this.locs = locs;
        super(stageId, stageAttemptId, partition.index(), metrics, localProperties);
        Logging$class.$init$(this);
        this.preferredLocs = this.locs() == null ? Nil$.MODULE$ : this.locs().toSet().toSeq();
    }

    public ShuffleMapTask(int partitionId) {
        this(0, 0, null, new Partition(){

            public boolean org$apache$spark$Partition$$super$equals(Object x$1) {
                return super.equals(x$1);
            }

            public int hashCode() {
                return Partition$class.hashCode(this);
            }

            public boolean equals(Object other) {
                return Partition$class.equals(this, other);
            }

            public int index() {
                return 0;
            }
            {
                Partition$class.$init$(this);
            }
        }, null, null, new Properties());
    }
}

