/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.netty;

import java.nio.ByteBuffer;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.network.BlockDataManager;
import org.apache.spark.network.BlockTransferService;
import org.apache.spark.network.TransportContext;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.client.TransportClientFactory;
import org.apache.spark.network.netty.NettyBlockRpcServer;
import org.apache.spark.network.netty.NettyBlockTransferService$;
import org.apache.spark.network.netty.SparkTransportConf$;
import org.apache.spark.network.sasl.SaslClientBootstrap;
import org.apache.spark.network.sasl.SaslServerBootstrap;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.TransportServer;
import org.apache.spark.network.server.TransportServerBootstrap;
import org.apache.spark.network.shuffle.BlockFetchingListener;
import org.apache.spark.network.shuffle.OneForOneBlockFetcher;
import org.apache.spark.network.shuffle.RetryingBlockFetcher;
import org.apache.spark.network.shuffle.protocol.UploadBlock;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.network.util.TransportConf;
import org.apache.spark.serializer.JavaSerializer;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mf!B\u0001\u0003\u0001\u0019a!!\u0007(fiRL(\t\\8dWR\u0013\u0018M\\:gKJ\u001cVM\u001d<jG\u0016T!a\u0001\u0003\u0002\u000b9,G\u000f^=\u000b\u0005\u00151\u0011a\u00028fi^|'o\u001b\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0011\u0001!\u0004\t\u0003\u001d=i\u0011\u0001B\u0005\u0003!\u0011\u0011AC\u00117pG.$&/\u00198tM\u0016\u00148+\u001a:wS\u000e,\u0007\u0002\u0003\n\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000b\u0002\t\r|gNZ\u0002\u0001!\t)b#D\u0001\u0007\u0013\t9bAA\u0005Ta\u0006\u00148nQ8oM\"A\u0011\u0004\u0001B\u0001B\u0003%!$A\btK\u000e,(/\u001b;z\u001b\u0006t\u0017mZ3s!\t)2$\u0003\u0002\u001d\r\ty1+Z2ve&$\u00180T1oC\u001e,'\u000f\u0003\u0005\u001f\u0001\t\u0015\r\u0011\"\u0011 \u0003!Awn\u001d;OC6,W#\u0001\u0011\u0011\u0005\u0005:cB\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a\u0013A\u0002)sK\u0012,g-\u0003\u0002)S\t11\u000b\u001e:j]\u001eT!AJ\u0012\t\u0011-\u0002!\u0011!Q\u0001\n\u0001\n\u0011\u0002[8ti:\u000bW.\u001a\u0011\t\u00115\u0002!\u0011!Q\u0001\n9\n\u0001B\\;n\u0007>\u0014Xm\u001d\t\u0003E=J!\u0001M\u0012\u0003\u0007%sG\u000fC\u00033\u0001\u0011\u00051'\u0001\u0004=S:LGO\u0010\u000b\u0006iY:\u0004(\u000f\t\u0003k\u0001i\u0011A\u0001\u0005\u0006%E\u0002\r\u0001\u0006\u0005\u00063E\u0002\rA\u0007\u0005\u0006=E\u0002\r\u0001\t\u0005\u0006[E\u0002\rA\f\u0005\bw\u0001\u0011\r\u0011\"\u0003=\u0003)\u0019XM]5bY&TXM]\u000b\u0002{A\u0011a\bQ\u0007\u0002\u007f)\u00111HB\u0005\u0003\u0003~\u0012aBS1wCN+'/[1mSj,'\u000f\u0003\u0004D\u0001\u0001\u0006I!P\u0001\fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\b\u0005C\u0004F\u0001\t\u0007I\u0011\u0002$\u0002\u0017\u0005,H\u000f[#oC\ndW\rZ\u000b\u0002\u000fB\u0011!\u0005S\u0005\u0003\u0013\u000e\u0012qAQ8pY\u0016\fg\u000e\u0003\u0004L\u0001\u0001\u0006IaR\u0001\rCV$\b.\u00128bE2,G\r\t\u0005\b\u001b\u0002\u0011\r\u0011\"\u0003O\u00035!(/\u00198ta>\u0014HoQ8oMV\tq\n\u0005\u0002Q'6\t\u0011K\u0003\u0002S\t\u0005!Q\u000f^5m\u0013\t!\u0016KA\u0007Ue\u0006t7\u000f]8si\u000e{gN\u001a\u0005\u0007-\u0002\u0001\u000b\u0011B(\u0002\u001dQ\u0014\u0018M\\:q_J$8i\u001c8gA!I\u0001\f\u0001a\u0001\u0002\u0003\u0006K!W\u0001\u0011iJ\fgn\u001d9peR\u001cuN\u001c;fqR\u0004\"A\u0004.\n\u0005m#!\u0001\u0005+sC:\u001c\bo\u001c:u\u0007>tG/\u001a=u\u0011%i\u0006\u00011A\u0001B\u0003&a,\u0001\u0004tKJ4XM\u001d\t\u0003?\u0006l\u0011\u0001\u0019\u0006\u0003;\u0012I!A\u00191\u0003\u001fQ\u0013\u0018M\\:q_J$8+\u001a:wKJD\u0011\u0002\u001a\u0001A\u0002\u0003\u0005\u000b\u0015B3\u0002\u001b\rd\u0017.\u001a8u\r\u0006\u001cGo\u001c:z!\t1\u0017.D\u0001h\u0015\tAG!\u0001\u0004dY&,g\u000e^\u0005\u0003U\u001e\u0014a\u0003\u0016:b]N\u0004xN\u001d;DY&,g\u000e\u001e$bGR|'/\u001f\u0005\nY\u0002\u0001\r\u0011!Q!\n\u0001\nQ!\u00199q\u0013\u0012DQA\u001c\u0001\u0005B=\fA!\u001b8jiR\u0011\u0001o\u001d\t\u0003EEL!A]\u0012\u0003\tUs\u0017\u000e\u001e\u0005\u0006i6\u0004\r!^\u0001\u0011E2|7m\u001b#bi\u0006l\u0015M\\1hKJ\u0004\"A\u0004<\n\u0005]$!\u0001\u0005\"m_\u000e\\G)\u0019;b\u001b\u0006t\u0017mZ3s\u0011\u0015I\b\u0001\"\u0003{\u00031\u0019'/Z1uKN+'O^3s)\tq6\u0010C\u0003}q\u0002\u0007Q0\u0001\u0006c_>$8\u000f\u001e:baN\u0004RA`A\u0007\u0003'q1a`A\u0005\u001d\u0011\t\t!a\u0002\u000e\u0005\u0005\r!bAA\u0003'\u00051AH]8pizJ\u0011\u0001J\u0005\u0004\u0003\u0017\u0019\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003\u001f\t\tB\u0001\u0003MSN$(bAA\u0006GA\u0019q,!\u0006\n\u0007\u0005]\u0001M\u0001\rUe\u0006t7\u000f]8siN+'O^3s\u0005>|Go\u001d;sCBDq!a\u0007\u0001\t\u0003\ni\"A\u0006gKR\u001c\u0007N\u00117pG.\u001cHc\u00039\u0002 \u0005\r\u0012qEA\u0016\u0003kAq!!\t\u0002\u001a\u0001\u0007\u0001%\u0001\u0003i_N$\bbBA\u0013\u00033\u0001\rAL\u0001\u0005a>\u0014H\u000fC\u0004\u0002*\u0005e\u0001\u0019\u0001\u0011\u0002\r\u0015DXmY%e\u0011!\ti#!\u0007A\u0002\u0005=\u0012\u0001\u00032m_\u000e\\\u0017\nZ:\u0011\t\t\n\t\u0004I\u0005\u0004\u0003g\u0019#!B!se\u0006L\b\u0002CA\u001c\u00033\u0001\r!!\u000f\u0002\u00111L7\u000f^3oKJ\u0004B!a\u000f\u0002B5\u0011\u0011Q\b\u0006\u0004\u0003\u007f!\u0011aB:ik\u001a4G.Z\u0005\u0005\u0003\u0007\niDA\u000bCY>\u001c7NR3uG\"Lgn\u001a'jgR,g.\u001a:\t\u000f\u0005\u0015\u0002\u0001\"\u0011\u0002HU\ta\u0006C\u0004\u0002L\u0001!\t%!\u0014\u0002\u0017U\u0004Hn\\1e\u00052|7m\u001b\u000b\u0011\u0003\u001f\nY&a\u0018\u0002b\u0005\r\u00141OAB\u0003\u001b\u0003R!!\u0015\u0002XAl!!a\u0015\u000b\u0007\u0005U3%\u0001\u0006d_:\u001cWO\u001d:f]RLA!!\u0017\u0002T\t1a)\u001e;ve\u0016Dq!!\u0018\u0002J\u0001\u0007\u0001%\u0001\u0005i_N$h.Y7f\u0011\u001d\t)#!\u0013A\u00029Bq!!\u000b\u0002J\u0001\u0007\u0001\u0005\u0003\u0005\u0002f\u0005%\u0003\u0019AA4\u0003\u001d\u0011Gn\\2l\u0013\u0012\u0004B!!\u001b\u0002p5\u0011\u00111\u000e\u0006\u0004\u0003[2\u0011aB:u_J\fw-Z\u0005\u0005\u0003c\nYGA\u0004CY>\u001c7.\u00133\t\u0011\u0005U\u0014\u0011\na\u0001\u0003o\n\u0011B\u00197pG.$\u0015\r^1\u0011\t\u0005e\u0014qP\u0007\u0003\u0003wR1!! \u0005\u0003\u0019\u0011WO\u001a4fe&!\u0011\u0011QA>\u00055i\u0015M\\1hK\u0012\u0014UO\u001a4fe\"A\u0011QQA%\u0001\u0004\t9)A\u0003mKZ,G\u000e\u0005\u0003\u0002j\u0005%\u0015\u0002BAF\u0003W\u0012Ab\u0015;pe\u0006<W\rT3wK2D\u0001\"a$\u0002J\u0001\u0007\u0011\u0011S\u0001\tG2\f7o\u001d+bOB\"\u00111SAR!\u0019\t)*a'\u0002 6\u0011\u0011q\u0013\u0006\u0004\u00033\u001b\u0013a\u0002:fM2,7\r^\u0005\u0005\u0003;\u000b9J\u0001\u0005DY\u0006\u001c8\u000fV1h!\u0011\t\t+a)\r\u0001\u0011a\u0011QUAG\u0003\u0003\u0005\tQ!\u0001\u0002(\n\u0019q\fJ\u0019\u0012\t\u0005%\u0016q\u0016\t\u0004E\u0005-\u0016bAAWG\t9aj\u001c;iS:<\u0007c\u0001\u0012\u00022&\u0019\u00111W\u0012\u0003\u0007\u0005s\u0017\u0010C\u0004\u00028\u0002!\t%!/\u0002\u000b\rdwn]3\u0015\u0003A\u0004")
public class NettyBlockTransferService
extends BlockTransferService {
    private final SparkConf conf;
    private final SecurityManager securityManager;
    private final String hostName;
    private final JavaSerializer serializer;
    private final boolean authEnabled;
    private final TransportConf transportConf;
    private TransportContext transportContext;
    public TransportServer org$apache$spark$network$netty$NettyBlockTransferService$$server;
    public TransportClientFactory org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory;
    public String org$apache$spark$network$netty$NettyBlockTransferService$$appId;

    @Override
    public String hostName() {
        return this.hostName;
    }

    private JavaSerializer serializer() {
        return this.serializer;
    }

    private boolean authEnabled() {
        return this.authEnabled;
    }

    private TransportConf transportConf() {
        return this.transportConf;
    }

    @Override
    public void init(BlockDataManager blockDataManager) {
        NettyBlockRpcServer rpcHandler = new NettyBlockRpcServer(this.conf.getAppId(), this.serializer(), blockDataManager);
        None$ serverBootstrap = None$.MODULE$;
        None$ clientBootstrap = None$.MODULE$;
        if (this.authEnabled()) {
            serverBootstrap = new Some((Object)new SaslServerBootstrap(this.transportConf(), (SecretKeyHolder)this.securityManager));
            clientBootstrap = new Some((Object)new SaslClientBootstrap(this.transportConf(), this.conf.getAppId(), (SecretKeyHolder)this.securityManager, this.securityManager.isSaslEncryptionEnabled()));
        }
        this.transportContext = new TransportContext(this.transportConf(), (RpcHandler)rpcHandler);
        this.org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory = this.transportContext.createClientFactory((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(Option$.MODULE$.option2Iterable((Option)clientBootstrap).toSeq()).asJava());
        this.org$apache$spark$network$netty$NettyBlockTransferService$$server = this.createServer((List<TransportServerBootstrap>)serverBootstrap.toList());
        this.org$apache$spark$network$netty$NettyBlockTransferService$$appId = this.conf.getAppId();
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NettyBlockTransferService $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Server created on ", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.hostName(), BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$network$netty$NettyBlockTransferService$$server.getPort())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    private TransportServer createServer(List<TransportServerBootstrap> bootstraps) {
        int portToTry = this.conf.getInt("spark.blockManager.port", 0);
        return (TransportServer)Utils$.MODULE$.startServiceOnPort(portToTry, new Serializable(this, bootstraps){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NettyBlockTransferService $outer;
            private final List bootstraps$1;

            public final Tuple2<TransportServer, Object> apply(int port) {
                return this.$outer.org$apache$spark$network$netty$NettyBlockTransferService$$startService$1(port, this.bootstraps$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.bootstraps$1 = bootstraps$1;
            }
        }, this.conf, this.getClass().getName())._1();
    }

    @Override
    public void fetchBlocks(String host, int port, String execId, String[] blockIds, BlockFetchingListener listener) {
        this.logTrace((Function0<String>)new Serializable(this, host, port, execId){
            public static final long serialVersionUID = 0L;
            private final String host$1;
            private final int port$1;
            private final String execId$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fetch blocks from ", ":", " (executor id ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.host$1, BoxesRunTime.boxToInteger((int)this.port$1), this.execId$1}));
            }
            {
                this.host$1 = host$1;
                this.port$1 = port$1;
                this.execId$1 = execId$1;
            }
        });
        try {
            RetryingBlockFetcher.BlockFetchStarter blockFetchStarter = new RetryingBlockFetcher.BlockFetchStarter(this, host, port, execId){
                private final /* synthetic */ NettyBlockTransferService $outer;
                private final String host$1;
                private final int port$1;
                private final String execId$1;

                public void createAndStart(String[] blockIds, BlockFetchingListener listener) {
                    TransportClient client = this.$outer.org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory.createClient(this.host$1, this.port$1);
                    new OneForOneBlockFetcher(client, this.$outer.org$apache$spark$network$netty$NettyBlockTransferService$$appId, this.execId$1, (String[])Predef$.MODULE$.refArrayOps((Object[])blockIds).toArray(ClassTag$.MODULE$.apply(String.class)), listener).start();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.host$1 = host$1;
                    this.port$1 = port$1;
                    this.execId$1 = execId$1;
                }
            };
            int maxRetries = this.transportConf().maxIORetries();
            if (maxRetries > 0) {
                new RetryingBlockFetcher(this.transportConf(), blockFetchStarter, blockIds, listener).start();
            } else {
                blockFetchStarter.createAndStart(blockIds, listener);
            }
        }
        catch (Exception exception2) {
            this.logError((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Exception while beginning fetchBlocks";
                }
            }, exception2);
            Predef$.MODULE$.refArrayOps((Object[])blockIds).foreach((Function1)new Serializable(this, listener, exception2){
                public static final long serialVersionUID = 0L;
                private final BlockFetchingListener listener$1;
                private final Exception e$1;

                public final void apply(String x$1) {
                    this.listener$1.onBlockFetchFailure(x$1, (Throwable)this.e$1);
                }
                {
                    this.listener$1 = listener$1;
                    this.e$1 = e$1;
                }
            });
        }
    }

    @Override
    public int port() {
        return this.org$apache$spark$network$netty$NettyBlockTransferService$$server.getPort();
    }

    @Override
    public Future<BoxedUnit> uploadBlock(String hostname, int port, String execId, BlockId blockId, ManagedBuffer blockData, StorageLevel level, ClassTag<?> classTag) {
        Promise result2 = Promise$.MODULE$.apply();
        TransportClient client = this.org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory.createClient(hostname, port);
        byte[] metadata = JavaUtils.bufferToArray((ByteBuffer)this.serializer().newInstance().serialize(new Tuple2((Object)level, classTag), ClassTag$.MODULE$.apply(Tuple2.class)));
        byte[] array = JavaUtils.bufferToArray((ByteBuffer)blockData.nioByteBuffer());
        client.sendRpc(new UploadBlock(this.org$apache$spark$network$netty$NettyBlockTransferService$$appId, execId, blockId.toString(), metadata, array).toByteBuffer(), new RpcResponseCallback(this, blockId, result2){
            private final /* synthetic */ NettyBlockTransferService $outer;
            public final BlockId blockId$1;
            private final Promise result$1;

            public void onSuccess(ByteBuffer response) {
                this.$outer.logTrace((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$2 $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Successfully uploaded block ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.blockId$1}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.result$1.success((Object)BoxedUnit.UNIT);
            }

            public void onFailure(Throwable e) {
                this.$outer.logError((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$2 $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while uploading block ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.blockId$1}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, e);
                this.result$1.failure(e);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.blockId$1 = blockId$1;
                this.result$1 = result$1;
            }
        });
        return result2.future();
    }

    @Override
    public void close() {
        if (this.org$apache$spark$network$netty$NettyBlockTransferService$$server != null) {
            this.org$apache$spark$network$netty$NettyBlockTransferService$$server.close();
        }
        if (this.org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory != null) {
            this.org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory.close();
        }
    }

    public final Tuple2 org$apache$spark$network$netty$NettyBlockTransferService$$startService$1(int port, List bootstraps$1) {
        TransportServer server = this.transportContext.createServer(this.hostName(), port, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)bootstraps$1).asJava());
        return new Tuple2((Object)server, (Object)BoxesRunTime.boxToInteger((int)server.getPort()));
    }

    public NettyBlockTransferService(SparkConf conf, SecurityManager securityManager, String hostName, int numCores) {
        this.conf = conf;
        this.securityManager = securityManager;
        this.hostName = hostName;
        this.serializer = new JavaSerializer(conf);
        this.authEnabled = securityManager.isAuthenticationEnabled();
        this.transportConf = SparkTransportConf$.MODULE$.fromSparkConf(conf, "shuffle", numCores);
    }
}

