/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.memory;

import org.apache.spark.SparkConf;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.memory.StaticMemoryManager$;
import org.apache.spark.storage.BlockId;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001E4Q!\u0001\u0002\u0001\t)\u00111c\u0015;bi&\u001cW*Z7pefl\u0015M\\1hKJT!a\u0001\u0003\u0002\r5,Wn\u001c:z\u0015\t)a!A\u0003ta\u0006\u00148N\u0003\u0002\b\u0011\u00051\u0011\r]1dQ\u0016T\u0011!C\u0001\u0004_J<7C\u0001\u0001\f!\taQ\"D\u0001\u0003\u0013\tq!AA\u0007NK6|'/_'b]\u0006<WM\u001d\u0005\t!\u0001\u0011\t\u0011)A\u0005%\u0005!1m\u001c8g\u0007\u0001\u0001\"a\u0005\u000b\u000e\u0003\u0011I!!\u0006\u0003\u0003\u0013M\u0003\u0018M]6D_:4\u0007\u0002C\f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\r\u000215\f\u0007p\u00148IK\u0006\u0004X\t_3dkRLwN\\'f[>\u0014\u0018\u0010\u0005\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"D\u0001\u0003M_:<\u0007\u0002C\u0010\u0001\u0005\u000b\u0007I\u0011\t\u0011\u0002-5\f\u0007p\u00148IK\u0006\u00048\u000b^8sC\u001e,W*Z7pef,\u0012\u0001\u0007\u0005\tE\u0001\u0011\t\u0011)A\u00051\u00059R.\u0019=P]\"+\u0017\r]*u_J\fw-Z'f[>\u0014\u0018\u0010\t\u0005\tI\u0001\u0011\t\u0011)A\u0005K\u0005Aa.^7D_J,7\u000f\u0005\u0002\u001aM%\u0011qE\u0007\u0002\u0004\u0013:$\b\"B\u0015\u0001\t\u0003Q\u0013A\u0002\u001fj]&$h\bF\u0003,Y5rs\u0006\u0005\u0002\r\u0001!)\u0001\u0003\u000ba\u0001%!)q\u0003\u000ba\u00011!)q\u0004\u000ba\u00011!)A\u0005\u000ba\u0001K!)\u0011\u0006\u0001C\u0001cQ\u00191FM\u001a\t\u000bA\u0001\u0004\u0019\u0001\n\t\u000b\u0011\u0002\u0004\u0019A\u0013\t\u000fU\u0002!\u0019!C\u0005A\u0005yQ.\u0019=V]J|G\u000e\\'f[>\u0014\u0018\u0010\u0003\u00048\u0001\u0001\u0006I\u0001G\u0001\u0011[\u0006DXK\u001c:pY2lU-\\8ss\u0002BQ!\u000f\u0001\u0005Bi\nA#Y2rk&\u0014Xm\u0015;pe\u0006<W-T3n_JLH\u0003B\u001e?\r\"\u0003\"!\u0007\u001f\n\u0005uR\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u007fa\u0002\r\u0001Q\u0001\bE2|7m[%e!\t\tE)D\u0001C\u0015\t\u0019E!A\u0004ti>\u0014\u0018mZ3\n\u0005\u0015\u0013%a\u0002\"m_\u000e\\\u0017\n\u001a\u0005\u0006\u000fb\u0002\r\u0001G\u0001\t]Vl')\u001f;fg\")\u0011\n\u000fa\u0001\u0015\u0006QQ.Z7peflu\u000eZ3\u0011\u00051Y\u0015B\u0001'\u0003\u0005)iU-\\8ss6{G-\u001a\u0005\u0006\u001d\u0002!\teT\u0001\u0014C\u000e\fX/\u001b:f+:\u0014x\u000e\u001c7NK6|'/\u001f\u000b\u0005wA\u000b&\u000bC\u0003@\u001b\u0002\u0007\u0001\tC\u0003H\u001b\u0002\u0007\u0001\u0004C\u0003J\u001b\u0002\u0007!\n\u0003\u0004U\u0001\u0011\u0005#!V\u0001\u0017C\u000e\fX/\u001b:f\u000bb,7-\u001e;j_:lU-\\8ssR!\u0001DV,Z\u0011\u001595\u000b1\u0001\u0019\u0011\u0015A6\u000b1\u0001\u0019\u00035!\u0018m]6BiR,W\u000e\u001d;JI\")\u0011j\u0015a\u0001\u0015\u001e11L\u0001E\u0001\tq\u000b1c\u0015;bi&\u001cW*Z7pefl\u0015M\\1hKJ\u0004\"\u0001D/\u0007\r\u0005\u0011\u0001\u0012\u0001\u0003_'\tiv\f\u0005\u0002\u001aA&\u0011\u0011M\u0007\u0002\u0007\u0003:L(+\u001a4\t\u000b%jF\u0011A2\u0015\u0003qCq!Z/C\u0002\u0013%a-\u0001\tN\u0013:{V*R'P%f{&)\u0017+F'V\tQ\u0005\u0003\u0004i;\u0002\u0006I!J\u0001\u0012\u001b&su,T#N\u001fJKvLQ-U\u000bN\u0003\u0003\"\u00026^\t\u0013Y\u0017aE4fi6\u000b\u0007p\u0015;pe\u0006<W-T3n_JLHC\u0001\rm\u0011\u0015\u0001\u0012\u000e1\u0001\u0013\u0011\u0015qW\f\"\u0003p\u0003U9W\r^'bq\u0016CXmY;uS>tW*Z7pef$\"\u0001\u00079\t\u000bAi\u0007\u0019\u0001\n")
public class StaticMemoryManager
extends MemoryManager {
    private final long maxOnHeapStorageMemory;
    private final long maxUnrollMemory;

    @Override
    public long maxOnHeapStorageMemory() {
        return this.maxOnHeapStorageMemory;
    }

    private long maxUnrollMemory() {
        return this.maxUnrollMemory;
    }

    @Override
    public synchronized boolean acquireStorageMemory(BlockId blockId, long numBytes, MemoryMode memoryMode) {
        boolean bl;
        MemoryMode memoryMode2 = memoryMode;
        MemoryMode memoryMode3 = MemoryMode.OFF_HEAP;
        Predef$.MODULE$.require(memoryMode2 != null ? !((Object)((Object)memoryMode2)).equals((Object)memoryMode3) : memoryMode3 != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "StaticMemoryManager does not support off-heap storage memory";
            }
        });
        if (numBytes > this.maxOnHeapStorageMemory()) {
            this.logInfo((Function0<String>)new Serializable(this, blockId, numBytes){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ StaticMemoryManager $outer;
                private final BlockId blockId$1;
                private final long numBytes$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Will not store ", " as the required space (", " bytes) exceeds our "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$1, BoxesRunTime.boxToLong((long)this.numBytes$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"memory limit (", " bytes)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.maxOnHeapStorageMemory())}))).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.blockId$1 = blockId$1;
                    this.numBytes$1 = numBytes$1;
                }
            });
            bl = false;
        } else {
            bl = this.onHeapStorageMemoryPool().acquireMemory(blockId, numBytes);
        }
        return bl;
    }

    @Override
    public synchronized boolean acquireUnrollMemory(BlockId blockId, long numBytes, MemoryMode memoryMode) {
        MemoryMode memoryMode2 = memoryMode;
        MemoryMode memoryMode3 = MemoryMode.OFF_HEAP;
        Predef$.MODULE$.require(memoryMode2 != null ? !((Object)((Object)memoryMode2)).equals((Object)memoryMode3) : memoryMode3 != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "StaticMemoryManager does not support off-heap unroll memory";
            }
        });
        long currentUnrollMemory = this.onHeapStorageMemoryPool().memoryStore().currentUnrollMemory();
        long freeMemory = this.onHeapStorageMemoryPool().memoryFree();
        long maxNumBytesToFree = package$.MODULE$.max(0L, this.maxUnrollMemory() - currentUnrollMemory - freeMemory);
        long numBytesToFree = package$.MODULE$.max(0L, package$.MODULE$.min(maxNumBytesToFree, numBytes - freeMemory));
        return this.onHeapStorageMemoryPool().acquireMemory(blockId, numBytes, numBytesToFree);
    }

    @Override
    public synchronized long acquireExecutionMemory(long numBytes, long taskAttemptId, MemoryMode memoryMode) {
        MemoryMode memoryMode2;
        block4: {
            long l;
            block3: {
                block2: {
                    memoryMode2 = memoryMode;
                    MemoryMode memoryMode3 = MemoryMode.ON_HEAP;
                    MemoryMode memoryMode4 = memoryMode2;
                    if (memoryMode3 != null ? !((Object)((Object)memoryMode3)).equals((Object)memoryMode4) : memoryMode4 != null) break block2;
                    l = this.onHeapExecutionMemoryPool().acquireMemory(numBytes, taskAttemptId, this.onHeapExecutionMemoryPool().acquireMemory$default$3(), this.onHeapExecutionMemoryPool().acquireMemory$default$4());
                    break block3;
                }
                MemoryMode memoryMode5 = MemoryMode.OFF_HEAP;
                MemoryMode memoryMode6 = memoryMode2;
                if (memoryMode5 != null ? !((Object)((Object)memoryMode5)).equals((Object)memoryMode6) : memoryMode6 != null) break block4;
                l = this.offHeapExecutionMemoryPool().acquireMemory(numBytes, taskAttemptId, this.offHeapExecutionMemoryPool().acquireMemory$default$3(), this.offHeapExecutionMemoryPool().acquireMemory$default$4());
            }
            return l;
        }
        throw new MatchError((Object)memoryMode2);
    }

    public StaticMemoryManager(SparkConf conf, long maxOnHeapExecutionMemory, long maxOnHeapStorageMemory, int numCores) {
        this.maxOnHeapStorageMemory = maxOnHeapStorageMemory;
        super(conf, numCores, maxOnHeapStorageMemory, maxOnHeapExecutionMemory);
        this.offHeapExecutionMemoryPool().incrementPoolSize(this.offHeapStorageMemoryPool().poolSize());
        this.offHeapStorageMemoryPool().decrementPoolSize(this.offHeapStorageMemoryPool().poolSize());
        this.maxUnrollMemory = (long)((double)maxOnHeapStorageMemory * conf.getDouble("spark.storage.unrollFraction", 0.2));
    }

    public StaticMemoryManager(SparkConf conf, int numCores) {
        this(conf, StaticMemoryManager$.MODULE$.org$apache$spark$memory$StaticMemoryManager$$getMaxExecutionMemory(conf), StaticMemoryManager$.MODULE$.org$apache$spark$memory$StaticMemoryManager$$getMaxStorageMemory(conf), numCores);
    }
}

