/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.history;

import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.deploy.history.ApplicationHistoryProvider;
import org.apache.spark.deploy.history.FsHistoryProvider;
import org.apache.spark.deploy.history.HistoryServer;
import org.apache.spark.deploy.history.HistoryServerArguments;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.util.ShutdownHookManager$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;

public final class HistoryServer$
implements Logging {
    public static final HistoryServer$ MODULE$;
    private final SparkConf conf;
    private final String UI_PATH_PREFIX;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new HistoryServer$();
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    private SparkConf conf() {
        return this.conf;
    }

    public String UI_PATH_PREFIX() {
        return this.UI_PATH_PREFIX;
    }

    public void main(String[] argStrings) {
        Utils$.MODULE$.initDaemon(this.log());
        new HistoryServerArguments(this.conf(), argStrings);
        this.initSecurity();
        SecurityManager securityManager = new SecurityManager(this.conf());
        String providerName = (String)this.conf().getOption("spark.history.provider").getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return FsHistoryProvider.class.getName();
            }
        });
        ApplicationHistoryProvider provider = (ApplicationHistoryProvider)Utils$.MODULE$.classForName(providerName).getConstructor(SparkConf.class).newInstance(this.conf());
        int port = this.conf().getInt("spark.history.ui.port", 18080);
        HistoryServer server = new HistoryServer(this.conf(), provider, securityManager, port);
        server.bind();
        ShutdownHookManager$.MODULE$.addShutdownHook((Function0<BoxedUnit>)new Serializable(server){
            public static final long serialVersionUID = 0L;
            private final HistoryServer server$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.server$1.stop();
            }
            {
                this.server$1 = server$1;
            }
        });
        while (true) {
            Thread.sleep(Integer.MAX_VALUE);
        }
    }

    public void initSecurity() {
        if (this.conf().getBoolean("spark.history.kerberos.enabled", false)) {
            String principalName = this.conf().get("spark.history.kerberos.principal");
            String keytabFilename = this.conf().get("spark.history.kerberos.keytab");
            SparkHadoopUtil$.MODULE$.get().loginUserFromKeytab(principalName, keytabFilename);
        }
    }

    public String getAttemptURI(String appId, Option<String> attemptId) {
        String attemptSuffix = (String)attemptId.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String id) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id}));
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.UI_PATH_PREFIX(), appId, attemptSuffix}));
    }

    private HistoryServer$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.conf = new SparkConf();
        this.UI_PATH_PREFIX = "/history";
    }
}

