/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy;

import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.spark.SparkException;
import org.apache.spark.SparkUserAppException;
import org.apache.spark.api.r.RUtils$;
import org.apache.spark.deploy.OptionAssigner;
import org.apache.spark.deploy.OptionAssigner$;
import org.apache.spark.deploy.PythonRunner$;
import org.apache.spark.deploy.RPackageUtils$;
import org.apache.spark.deploy.SparkSubmit$;
import org.apache.spark.deploy.SparkSubmitAction$;
import org.apache.spark.deploy.SparkSubmitArguments;
import org.apache.spark.deploy.SparkSubmitArguments$;
import org.apache.spark.deploy.SparkSubmitUtils$;
import org.apache.spark.deploy.rest.RestSubmissionClient;
import org.apache.spark.deploy.rest.SubmitRestConnectionException;
import org.apache.spark.package$;
import org.apache.spark.util.ChildFirstURLClassLoader;
import org.apache.spark.util.MutableURLClassLoader;
import org.apache.spark.util.Utils$;
import scala.App;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;

public final class SparkSubmit$ {
    public static final SparkSubmit$ MODULE$;
    private final int YARN;
    private final int STANDALONE;
    private final int MESOS;
    private final int LOCAL;
    private final int ALL_CLUSTER_MGRS;
    private final int CLIENT;
    private final int CLUSTER;
    private final int ALL_DEPLOY_MODES;
    private final String SPARK_SHELL;
    private final String PYSPARK_SHELL;
    private final String SPARKR_SHELL;
    private final String SPARKR_PACKAGE_ARCHIVE;
    private final String R_PACKAGE_ARCHIVE;
    private final int CLASS_NOT_FOUND_EXIT_STATUS;
    private Function1<Object, BoxedUnit> exitFn;
    private PrintStream printStream;

    static {
        new SparkSubmit$();
    }

    private int YARN() {
        return this.YARN;
    }

    private int STANDALONE() {
        return this.STANDALONE;
    }

    private int MESOS() {
        return this.MESOS;
    }

    private int LOCAL() {
        return this.LOCAL;
    }

    private int ALL_CLUSTER_MGRS() {
        return this.ALL_CLUSTER_MGRS;
    }

    private int CLIENT() {
        return this.CLIENT;
    }

    private int CLUSTER() {
        return this.CLUSTER;
    }

    private int ALL_DEPLOY_MODES() {
        return this.ALL_DEPLOY_MODES;
    }

    private String SPARK_SHELL() {
        return this.SPARK_SHELL;
    }

    private String PYSPARK_SHELL() {
        return this.PYSPARK_SHELL;
    }

    private String SPARKR_SHELL() {
        return this.SPARKR_SHELL;
    }

    private String SPARKR_PACKAGE_ARCHIVE() {
        return this.SPARKR_PACKAGE_ARCHIVE;
    }

    private String R_PACKAGE_ARCHIVE() {
        return this.R_PACKAGE_ARCHIVE;
    }

    private int CLASS_NOT_FOUND_EXIT_STATUS() {
        return this.CLASS_NOT_FOUND_EXIT_STATUS;
    }

    public Function1<Object, BoxedUnit> exitFn() {
        return this.exitFn;
    }

    public void exitFn_$eq(Function1<Object, BoxedUnit> x$1) {
        this.exitFn = x$1;
    }

    public PrintStream printStream() {
        return this.printStream;
    }

    public void printStream_$eq(PrintStream x$1) {
        this.printStream = x$1;
    }

    public void printWarning(String str) {
        this.printStream().println(new StringBuilder().append((Object)"Warning: ").append((Object)str).toString());
    }

    public void printErrorAndExit(String str) {
        this.printStream().println(new StringBuilder().append((Object)"Error: ").append((Object)str).toString());
        this.printStream().println("Run with --help for usage help or --verbose for debug output");
        this.exitFn().apply$mcVI$sp(1);
    }

    public void printVersionAndExit() {
        this.printStream().println(new StringOps(Predef$.MODULE$.augmentString("Welcome to\n      ____              __\n     / __/__  ___ _____/ /__\n    _\\ \\/ _ \\/ _ `/ __/  '_/\n   /___/ .__/\\_,_/_/ /_/\\_\\   version %s\n      /_/\n                        ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.SPARK_VERSION()})));
        this.printStream().println(new StringOps(Predef$.MODULE$.augmentString("Branch %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.SPARK_BRANCH()})));
        this.printStream().println(new StringOps(Predef$.MODULE$.augmentString("Compiled by user %s on %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.SPARK_BUILD_USER(), package$.MODULE$.SPARK_BUILD_DATE()})));
        this.printStream().println(new StringOps(Predef$.MODULE$.augmentString("Revision %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.SPARK_REVISION()})));
        this.printStream().println(new StringOps(Predef$.MODULE$.augmentString("Url %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.SPARK_REPO_URL()})));
        this.printStream().println("Type --help for more information.");
        this.exitFn().apply$mcVI$sp(0);
    }

    public void main(String[] args) {
        Enumeration.Value value2;
        block7: {
            block5: {
                SparkSubmitArguments appArgs;
                block6: {
                    block4: {
                        appArgs = new SparkSubmitArguments((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args), SparkSubmitArguments$.MODULE$.$lessinit$greater$default$2());
                        if (appArgs.verbose()) {
                            this.printStream().println((Object)appArgs);
                        }
                        value2 = appArgs.action();
                        Enumeration.Value value3 = SparkSubmitAction$.MODULE$.SUBMIT();
                        Enumeration.Value value4 = value2;
                        if (value3 != null ? !value3.equals(value4) : value4 != null) break block4;
                        this.submit(appArgs);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block5;
                    }
                    Enumeration.Value value5 = SparkSubmitAction$.MODULE$.KILL();
                    Enumeration.Value value6 = value2;
                    if (value5 != null ? !value5.equals(value6) : value6 != null) break block6;
                    this.kill(appArgs);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                Enumeration.Value value7 = SparkSubmitAction$.MODULE$.REQUEST_STATUS();
                Enumeration.Value value8 = value2;
                if (value7 != null ? !value7.equals(value8) : value8 != null) break block7;
                this.requestStatus(appArgs);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)value2);
    }

    private void kill(SparkSubmitArguments args) {
        new RestSubmissionClient(args.master()).killSubmission(args.submissionToKill());
    }

    private void requestStatus(SparkSubmitArguments args) {
        RestSubmissionClient qual$1 = new RestSubmissionClient(args.master());
        String x$5 = args.submissionToRequestStatusFor();
        boolean x$6 = qual$1.requestSubmissionStatus$default$2();
        qual$1.requestSubmissionStatus(x$5, x$6);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void submit(SparkSubmitArguments args) {
        BoxedUnit boxedUnit;
        String childMainClass;
        Map sysProps;
        Seq childClasspath;
        Seq childArgs;
        while (true) {
            Tuple4 tuple4;
            Tuple4<Seq<String>, Seq<String>, Map<String, String>, String> tuple42 = this.prepareSubmitEnvironment(args);
            if (tuple42 == null) throw new MatchError(tuple42);
            Seq childArgs2 = (Seq)tuple42._1();
            Seq childClasspath2 = (Seq)tuple42._2();
            Map sysProps2 = (Map)tuple42._3();
            String childMainClass2 = (String)tuple42._4();
            Tuple4 tuple43 = tuple4 = new Tuple4((Object)childArgs2, (Object)childClasspath2, (Object)sysProps2, (Object)childMainClass2);
            childArgs = (Seq)tuple43._1();
            childClasspath = (Seq)tuple43._2();
            sysProps = (Map)tuple43._3();
            childMainClass = (String)tuple43._4();
            if (!args.isStandaloneCluster() || !args.useRest()) break;
            try {
                this.printStream().println("Running Spark using the REST application submission protocol.");
                this.doRunMain$1(args, childArgs, childClasspath, sysProps, childMainClass);
                boxedUnit = BoxedUnit.UNIT;
                return;
            }
            catch (SubmitRestConnectionException submitRestConnectionException) {
                this.printWarning(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Master endpoint ", " was not a REST server. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{args.master()}))).append((Object)"Falling back to legacy submission gateway instead.").toString());
                args.useRest_$eq(false);
                continue;
            }
            break;
        }
        this.doRunMain$1(args, childArgs, childClasspath, sysProps, childMainClass);
        boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Tuple4<Seq<String>, Seq<String>, Map<String, String>, String> prepareSubmitEnvironment(SparkSubmitArguments args) {
        block81: {
            block86: {
                block85: {
                    block84: {
                        block83: {
                            block82: {
                                block80: {
                                    block79: {
                                        block78: {
                                            block74: {
                                                block76: {
                                                    block77: {
                                                        block75: {
                                                            childArgs = new ArrayBuffer();
                                                            childClasspath = new ArrayBuffer();
                                                            sysProps = new HashMap();
                                                            childMainClass = "";
                                                            var7_7 = var6_6 = args.master();
                                                            if (!("yarn" != null ? "yarn".equals(var7_7) == false : var7_7 != null)) {
                                                                var8_8 = this.YARN();
                                                            } else {
                                                                var9_9 = var6_6;
                                                                if (!("yarn-client" != null ? "yarn-client".equals(var9_9) == false : var9_9 != null)) {
                                                                    var10_10 = true;
                                                                } else {
                                                                    var11_11 = var6_6;
                                                                    var10_10 = !("yarn-cluster" != null ? "yarn-cluster".equals(var11_11) == false : var11_11 != null);
                                                                }
                                                                if (var10_10) {
                                                                    this.printWarning(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Master ", " is deprecated since 2.0."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{args.master()}))).append((Object)" Please use master \"yarn\" with specified deploy mode instead.").toString());
                                                                    var8_8 = this.YARN();
                                                                } else if (var6_6.startsWith("spark")) {
                                                                    var8_8 = this.STANDALONE();
                                                                } else if (var6_6.startsWith("mesos")) {
                                                                    var8_8 = this.MESOS();
                                                                } else if (var6_6.startsWith("local")) {
                                                                    var8_8 = this.LOCAL();
                                                                } else {
                                                                    this.printErrorAndExit("Master must either be yarn or start with spark, mesos, local");
                                                                    var8_8 = -1;
                                                                }
                                                            }
                                                            clusterManager = var8_8;
                                                            var14_14 = var13_13 = args.deployMode();
                                                            var15_15 = !("client" != null ? "client".equals(var14_14) == false : var14_14 != null) ? true : var13_13 == null;
                                                            if (var15_15) {
                                                                var16_16 = this.CLIENT();
                                                            } else {
                                                                var17_17 = var13_13;
                                                                if (!("cluster" != null ? "cluster".equals(var17_17) == false : var17_17 != null)) {
                                                                    var16_16 = this.CLUSTER();
                                                                } else {
                                                                    this.printErrorAndExit("Deploy mode must be either client or cluster");
                                                                    var16_16 = -1;
                                                                }
                                                            }
                                                            temp1 = var16_16;
                                                            deployMode = new IntRef(temp1);
                                                            if (clusterManager != this.YARN()) break block74;
                                                            var20_20 = new Tuple2((Object)args.master(), (Object)args.deployMode());
                                                            if (var20_20 == null) break block75;
                                                            var21_21 = (String)var20_20._1();
                                                            var22_22 = (String)var20_20._2();
                                                            var23_23 = var21_21;
                                                            if (("yarn-cluster" != null ? "yarn-cluster".equals(var23_23) == false : var23_23 != null) || var22_22 != null) break block75;
                                                            deployMode.elem = this.CLUSTER();
                                                            args.master_$eq("yarn");
                                                            var24_24 = BoxedUnit.UNIT;
                                                            break block76;
                                                        }
                                                        if (var20_20 == null) break block77;
                                                        var25_28 = (String)var20_20._1();
                                                        var26_29 = (String)var20_20._2();
                                                        var27_30 = var25_28;
                                                        if ("yarn-cluster" != null ? "yarn-cluster".equals(var27_30) == false : var27_30 != null) break block77;
                                                        var28_31 = var26_29;
                                                        if ("client" != null ? "client".equals(var28_31) == false : var28_31 != null) break block77;
                                                        this.printErrorAndExit("Client deploy mode is not compatible with master \"yarn-cluster\"");
                                                        var24_25 = BoxedUnit.UNIT;
                                                        break block76;
                                                    }
                                                    if (var20_20 == null) ** GOTO lbl-1000
                                                    var29_32 = (String)var20_20._1();
                                                    var30_33 = (String)var20_20._2();
                                                    var31_34 = var29_32;
                                                    if ("yarn-client" != null ? "yarn-client".equals(var31_34) == false : var31_34 != null) ** GOTO lbl-1000
                                                    var32_35 = var30_33;
                                                    if (!("cluster" != null ? "cluster".equals(var32_35) == false : var32_35 != null)) {
                                                        this.printErrorAndExit("Cluster deploy mode is not compatible with master \"yarn-client\"");
                                                        var24_26 = BoxedUnit.UNIT;
                                                    } else lbl-1000:
                                                    // 3 sources

                                                    {
                                                        if (var20_20 == null) {
                                                            throw new MatchError((Object)var20_20);
                                                        }
                                                        args.master_$eq("yarn");
                                                        var24_27 = BoxedUnit.UNIT;
                                                    }
                                                }
                                                if (!Utils$.MODULE$.classIsLoadable("org.apache.spark.deploy.yarn.Client") && !Utils$.MODULE$.isTesting()) {
                                                    this.printErrorAndExit("Could not load YARN classes. This copy of Spark may not have been compiled with YARN support.");
                                                }
                                            }
                                            if ((var33_36 = new Tuple2((Object)args.deployMode(), (Object)BoxesRunTime.boxToInteger((int)deployMode.elem))) == null) break block78;
                                            var34_37 = (String)var33_36._1();
                                            var35_38 = var33_36._2$mcI$sp();
                                            if (var34_37 != null || this.CLIENT() != var35_38) break block78;
                                            args.deployMode_$eq("client");
                                            var36_39 = BoxedUnit.UNIT;
                                            break block79;
                                        }
                                        if (var33_36 == null) ** GOTO lbl-1000
                                        var37_42 = (String)var33_36._1();
                                        var38_43 = var33_36._2$mcI$sp();
                                        if (var37_42 == null && this.CLUSTER() == var38_43) {
                                            args.deployMode_$eq("cluster");
                                            var36_40 = BoxedUnit.UNIT;
                                        } else lbl-1000:
                                        // 2 sources

                                        {
                                            var36_41 = BoxedUnit.UNIT;
                                        }
                                    }
                                    isYarnCluster = clusterManager == this.YARN() && deployMode.elem == this.CLUSTER();
                                    isMesosCluster = clusterManager == this.MESOS() && deployMode.elem == this.CLUSTER();
                                    exclusions = StringUtils.isBlank((CharSequence)args.packagesExclusions()) != false ? Nil$.MODULE$ : Predef$.MODULE$.wrapRefArray((Object[])args.packagesExclusions().split(","));
                                    resolvedMavenCoordinates = SparkSubmitUtils$.MODULE$.resolveMavenCoordinates(args.packages(), (Option<String>)Option$.MODULE$.apply((Object)args.repositories()), (Option<String>)Option$.MODULE$.apply((Object)args.ivyRepoPath()), (Seq<String>)exclusions, SparkSubmitUtils$.MODULE$.resolveMavenCoordinates$default$5());
                                    if (!StringUtils.isBlank((CharSequence)resolvedMavenCoordinates)) {
                                        args.jars_$eq(this.mergeFileLists((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{args.jars(), resolvedMavenCoordinates})));
                                        if (args.isPython()) {
                                            args.pyFiles_$eq(this.mergeFileLists((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{args.pyFiles(), resolvedMavenCoordinates})));
                                        }
                                    }
                                    if (args.isR() && !StringUtils.isBlank((CharSequence)args.jars())) {
                                        RPackageUtils$.MODULE$.checkAndBuildRPackage(args.jars(), this.printStream(), args.verbose());
                                    }
                                    if (args.isPython() && !isYarnCluster && !isMesosCluster) {
                                        if (Predef$.MODULE$.refArrayOps((Object[])Utils$.MODULE$.nonLocalPaths(args.primaryResource(), Utils$.MODULE$.nonLocalPaths$default$2())).nonEmpty()) {
                                            this.printErrorAndExit(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Only local python files are supported: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{args.primaryResource()})));
                                        }
                                        if (new StringOps(Predef$.MODULE$.augmentString(nonLocalPyFiles = Predef$.MODULE$.refArrayOps((Object[])Utils$.MODULE$.nonLocalPaths(args.pyFiles(), Utils$.MODULE$.nonLocalPaths$default$2())).mkString(","))).nonEmpty()) {
                                            this.printErrorAndExit(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Only local additional python files are supported: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{nonLocalPyFiles})));
                                        }
                                    }
                                    if (args.isR() && !isYarnCluster && Predef$.MODULE$.refArrayOps((Object[])Utils$.MODULE$.nonLocalPaths(args.primaryResource(), Utils$.MODULE$.nonLocalPaths$default$2())).nonEmpty()) {
                                        this.printErrorAndExit(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Only local R files are supported: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{args.primaryResource()})));
                                    }
                                    if ((var44_49 = new Tuple2.mcII.sp(clusterManager, deployMode.elem)) == null) break block80;
                                    var45_50 = var44_49._1$mcI$sp();
                                    var46_51 = var44_49._2$mcI$sp();
                                    if (this.MESOS() != var45_50 || this.CLUSTER() != var46_51 || !args.isR()) break block80;
                                    this.printErrorAndExit("Cluster deploy mode is currently not supported for R applications on Mesos clusters.");
                                    var47_52 = BoxedUnit.UNIT;
                                    break block81;
                                }
                                if (var44_49 == null) break block82;
                                var48_60 = var44_49._1$mcI$sp();
                                var49_61 = var44_49._2$mcI$sp();
                                if (this.STANDALONE() != var48_60 || this.CLUSTER() != var49_61 || !args.isPython()) break block82;
                                this.printErrorAndExit("Cluster deploy mode is currently not supported for python applications on standalone clusters.");
                                var47_53 = BoxedUnit.UNIT;
                                break block81;
                            }
                            if (var44_49 == null) break block83;
                            var50_62 = var44_49._1$mcI$sp();
                            var51_63 = var44_49._2$mcI$sp();
                            if (this.STANDALONE() != var50_62 || this.CLUSTER() != var51_63 || !args.isR()) break block83;
                            this.printErrorAndExit("Cluster deploy mode is currently not supported for R applications on standalone clusters.");
                            var47_54 = BoxedUnit.UNIT;
                            break block81;
                        }
                        if (var44_49 == null) break block84;
                        var52_64 = var44_49._1$mcI$sp();
                        var53_65 = var44_49._2$mcI$sp();
                        if (this.LOCAL() != var52_64 || this.CLUSTER() != var53_65) break block84;
                        this.printErrorAndExit("Cluster deploy mode is not compatible with master \"local\"");
                        var47_55 = BoxedUnit.UNIT;
                        break block81;
                    }
                    if (var44_49 == null) break block85;
                    var54_66 = var44_49._2$mcI$sp();
                    if (this.CLUSTER() != var54_66 || !this.isShell(args.primaryResource())) break block85;
                    this.printErrorAndExit("Cluster deploy mode is not applicable to Spark shells.");
                    var47_56 = BoxedUnit.UNIT;
                    break block81;
                }
                if (var44_49 == null) break block86;
                var55_67 = var44_49._2$mcI$sp();
                if (this.CLUSTER() != var55_67 || !this.isSqlShell(args.mainClass())) break block86;
                this.printErrorAndExit("Cluster deploy mode is not applicable to Spark SQL shell.");
                var47_57 = BoxedUnit.UNIT;
                break block81;
            }
            if (var44_49 == null) ** GOTO lbl-1000
            var56_68 = var44_49._2$mcI$sp();
            if (this.CLUSTER() == var56_68 && this.isThriftServer(args.mainClass())) {
                this.printErrorAndExit("Cluster deploy mode is not applicable to Spark Thrift server.");
                var47_58 = BoxedUnit.UNIT;
            } else lbl-1000:
            // 2 sources

            {
                var47_59 = BoxedUnit.UNIT;
            }
        }
        if (args.isPython() && deployMode.elem == this.CLIENT()) {
            v0 = args.primaryResource();
            var57_69 = this.PYSPARK_SHELL();
            if (!(v0 != null ? v0.equals(var57_69) == false : var57_69 != null)) {
                args.mainClass_$eq("org.apache.spark.api.python.PythonGatewayServer");
            } else {
                args.mainClass_$eq("org.apache.spark.deploy.PythonRunner");
                args.childArgs_$eq((ArrayBuffer<String>)((ArrayBuffer)((BufferLike)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{args.primaryResource(), args.pyFiles()}))).$plus$plus(args.childArgs())));
                if (clusterManager != this.YARN()) {
                    args.files_$eq(this.mergeFileLists((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{args.files(), args.primaryResource()})));
                }
            }
            if (clusterManager != this.YARN()) {
                args.files_$eq(this.mergeFileLists((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{args.files(), args.pyFiles()})));
            }
            if (args.pyFiles() != null) {
                sysProps.update((Object)"spark.submit.pyFiles", (Object)args.pyFiles());
            }
        }
        if (args.isR() && clusterManager == this.YARN()) {
            sparkRPackagePath = RUtils$.MODULE$.localSparkRPackagePath();
            if (sparkRPackagePath.isEmpty()) {
                this.printErrorAndExit("SPARK_HOME does not exist for R application in YARN mode.");
            }
            if (!(sparkRPackageFile = new File((String)sparkRPackagePath.get(), this.SPARKR_PACKAGE_ARCHIVE())).exists()) {
                this.printErrorAndExit(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " does not exist for R application in YARN mode."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.SPARKR_PACKAGE_ARCHIVE()})));
            }
            sparkRPackageURI = Utils$.MODULE$.resolveURI(sparkRPackageFile.getAbsolutePath()).toString();
            args.archives_$eq(this.mergeFileLists((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{args.archives(), new StringBuilder().append((Object)sparkRPackageURI).append((Object)"#sparkr").toString()})));
            if (!RUtils$.MODULE$.rPackages().isEmpty()) {
                rPackageFile = RPackageUtils$.MODULE$.zipRLibraries(new File((String)RUtils$.MODULE$.rPackages().get()), this.R_PACKAGE_ARCHIVE());
                if (!rPackageFile.exists()) {
                    this.printErrorAndExit("Failed to zip all the built R packages.");
                }
                rPackageURI = Utils$.MODULE$.resolveURI(rPackageFile.getAbsolutePath()).toString();
                args.archives_$eq(this.mergeFileLists((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{args.archives(), new StringBuilder().append((Object)rPackageURI).append((Object)"#rpkg").toString()})));
            }
        }
        if (args.isR() && clusterManager == this.STANDALONE() && !RUtils$.MODULE$.rPackages().isEmpty()) {
            this.printErrorAndExit("Distributing R packages with standalone cluster is not supported.");
        }
        if (args.isR() && clusterManager == this.MESOS()) {
            this.printErrorAndExit("SparkR is not supported for Mesos cluster.");
        }
        if (args.isR() && deployMode.elem == this.CLIENT()) {
            v1 = args.primaryResource();
            var63_75 = this.SPARKR_SHELL();
            if (!(v1 != null ? v1.equals(var63_75) == false : var63_75 != null)) {
                args.mainClass_$eq("org.apache.spark.api.r.RBackend");
            } else {
                args.mainClass_$eq("org.apache.spark.deploy.RRunner");
                args.childArgs_$eq((ArrayBuffer<String>)((ArrayBuffer)((BufferLike)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{args.primaryResource()}))).$plus$plus(args.childArgs())));
                args.files_$eq(this.mergeFileLists((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{args.files(), args.primaryResource()})));
            }
        }
        if (isYarnCluster && args.isR()) {
            args.files_$eq(this.mergeFileLists((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{args.files(), args.primaryResource()})));
        }
        sysProps.update((Object)"SPARK_SUBMIT", (Object)"true");
        v2 = new OptionAssigner[25];
        x$7 = args.master();
        x$8 = this.ALL_CLUSTER_MGRS();
        x$9 = this.ALL_DEPLOY_MODES();
        x$10 = "spark.master";
        x$11 = OptionAssigner$.MODULE$.apply$default$4();
        v2[0] = new OptionAssigner(x$7, x$8, x$9, x$11, x$10);
        x$12 = args.deployMode();
        x$13 = this.ALL_CLUSTER_MGRS();
        x$14 = this.ALL_DEPLOY_MODES();
        x$15 = "spark.submit.deployMode";
        x$16 = OptionAssigner$.MODULE$.apply$default$4();
        v2[1] = new OptionAssigner(x$12, x$13, x$14, x$16, x$15);
        x$17 = args.name();
        x$18 = this.ALL_CLUSTER_MGRS();
        x$19 = this.ALL_DEPLOY_MODES();
        x$20 = "spark.app.name";
        x$21 = OptionAssigner$.MODULE$.apply$default$4();
        v2[2] = new OptionAssigner(x$17, x$18, x$19, x$21, x$20);
        x$22 = args.ivyRepoPath();
        x$23 = this.ALL_CLUSTER_MGRS();
        x$24 = this.CLIENT();
        x$25 = "spark.jars.ivy";
        x$26 = OptionAssigner$.MODULE$.apply$default$4();
        v2[3] = new OptionAssigner(x$22, x$23, x$24, x$26, x$25);
        x$27 = args.driverMemory();
        x$28 = this.ALL_CLUSTER_MGRS();
        x$29 = this.CLIENT();
        x$30 = "spark.driver.memory";
        x$31 = OptionAssigner$.MODULE$.apply$default$4();
        v2[4] = new OptionAssigner(x$27, x$28, x$29, x$31, x$30);
        x$32 = args.driverExtraClassPath();
        x$33 = this.ALL_CLUSTER_MGRS();
        x$34 = this.ALL_DEPLOY_MODES();
        x$35 = "spark.driver.extraClassPath";
        x$36 = OptionAssigner$.MODULE$.apply$default$4();
        v2[5] = new OptionAssigner(x$32, x$33, x$34, x$36, x$35);
        x$37 = args.driverExtraJavaOptions();
        x$38 = this.ALL_CLUSTER_MGRS();
        x$39 = this.ALL_DEPLOY_MODES();
        x$40 = "spark.driver.extraJavaOptions";
        x$41 = OptionAssigner$.MODULE$.apply$default$4();
        v2[6] = new OptionAssigner(x$37, x$38, x$39, x$41, x$40);
        x$42 = args.driverExtraLibraryPath();
        x$43 = this.ALL_CLUSTER_MGRS();
        x$44 = this.ALL_DEPLOY_MODES();
        x$45 = "spark.driver.extraLibraryPath";
        x$46 = OptionAssigner$.MODULE$.apply$default$4();
        v2[7] = new OptionAssigner(x$42, x$43, x$44, x$46, x$45);
        x$47 = args.queue();
        x$48 = this.YARN();
        x$49 = this.ALL_DEPLOY_MODES();
        x$50 = "spark.yarn.queue";
        x$51 = OptionAssigner$.MODULE$.apply$default$4();
        v2[8] = new OptionAssigner(x$47, x$48, x$49, x$51, x$50);
        x$52 = args.numExecutors();
        x$53 = this.YARN();
        x$54 = this.ALL_DEPLOY_MODES();
        x$55 = "spark.executor.instances";
        x$56 = OptionAssigner$.MODULE$.apply$default$4();
        v2[9] = new OptionAssigner(x$52, x$53, x$54, x$56, x$55);
        x$57 = args.jars();
        x$58 = this.YARN();
        x$59 = this.ALL_DEPLOY_MODES();
        x$60 = "spark.yarn.dist.jars";
        x$61 = OptionAssigner$.MODULE$.apply$default$4();
        v2[10] = new OptionAssigner(x$57, x$58, x$59, x$61, x$60);
        x$62 = args.files();
        x$63 = this.YARN();
        x$64 = this.ALL_DEPLOY_MODES();
        x$65 = "spark.yarn.dist.files";
        x$66 = OptionAssigner$.MODULE$.apply$default$4();
        v2[11] = new OptionAssigner(x$62, x$63, x$64, x$66, x$65);
        x$67 = args.archives();
        x$68 = this.YARN();
        x$69 = this.ALL_DEPLOY_MODES();
        x$70 = "spark.yarn.dist.archives";
        x$71 = OptionAssigner$.MODULE$.apply$default$4();
        v2[12] = new OptionAssigner(x$67, x$68, x$69, x$71, x$70);
        x$72 = args.principal();
        x$73 = this.YARN();
        x$74 = this.ALL_DEPLOY_MODES();
        x$75 = "spark.yarn.principal";
        x$76 = OptionAssigner$.MODULE$.apply$default$4();
        v2[13] = new OptionAssigner(x$72, x$73, x$74, x$76, x$75);
        x$77 = args.keytab();
        x$78 = this.YARN();
        x$79 = this.ALL_DEPLOY_MODES();
        x$80 = "spark.yarn.keytab";
        x$81 = OptionAssigner$.MODULE$.apply$default$4();
        v2[14] = new OptionAssigner(x$77, x$78, x$79, x$81, x$80);
        x$82 = args.executorCores();
        x$83 = this.STANDALONE() | this.YARN();
        x$84 = this.ALL_DEPLOY_MODES();
        x$85 = "spark.executor.cores";
        x$86 = OptionAssigner$.MODULE$.apply$default$4();
        v2[15] = new OptionAssigner(x$82, x$83, x$84, x$86, x$85);
        x$87 = args.executorMemory();
        x$88 = this.STANDALONE() | this.MESOS() | this.YARN();
        x$89 = this.ALL_DEPLOY_MODES();
        x$90 = "spark.executor.memory";
        x$91 = OptionAssigner$.MODULE$.apply$default$4();
        v2[16] = new OptionAssigner(x$87, x$88, x$89, x$91, x$90);
        x$92 = args.totalExecutorCores();
        x$93 = this.STANDALONE() | this.MESOS();
        x$94 = this.ALL_DEPLOY_MODES();
        x$95 = "spark.cores.max";
        x$96 = OptionAssigner$.MODULE$.apply$default$4();
        v2[17] = new OptionAssigner(x$92, x$93, x$94, x$96, x$95);
        x$97 = args.files();
        x$98 = this.LOCAL() | this.STANDALONE() | this.MESOS();
        x$99 = this.ALL_DEPLOY_MODES();
        x$100 = "spark.files";
        x$101 = OptionAssigner$.MODULE$.apply$default$4();
        v2[18] = new OptionAssigner(x$97, x$98, x$99, x$101, x$100);
        x$102 = args.jars();
        x$103 = this.LOCAL();
        x$104 = this.CLIENT();
        x$105 = "spark.jars";
        x$106 = OptionAssigner$.MODULE$.apply$default$4();
        v2[19] = new OptionAssigner(x$102, x$103, x$104, x$106, x$105);
        x$107 = args.jars();
        x$108 = this.STANDALONE() | this.MESOS();
        x$109 = this.ALL_DEPLOY_MODES();
        x$110 = "spark.jars";
        x$111 = OptionAssigner$.MODULE$.apply$default$4();
        v2[20] = new OptionAssigner(x$107, x$108, x$109, x$111, x$110);
        x$112 = args.driverMemory();
        x$113 = this.STANDALONE() | this.MESOS() | this.YARN();
        x$114 = this.CLUSTER();
        x$115 = "spark.driver.memory";
        x$116 = OptionAssigner$.MODULE$.apply$default$4();
        v2[21] = new OptionAssigner(x$112, x$113, x$114, x$116, x$115);
        x$117 = args.driverCores();
        x$118 = this.STANDALONE() | this.MESOS() | this.YARN();
        x$119 = this.CLUSTER();
        x$120 = "spark.driver.cores";
        x$121 = OptionAssigner$.MODULE$.apply$default$4();
        v2[22] = new OptionAssigner(x$117, x$118, x$119, x$121, x$120);
        x$122 = BoxesRunTime.boxToBoolean((boolean)args.supervise()).toString();
        x$123 = this.STANDALONE() | this.MESOS();
        x$124 = this.CLUSTER();
        x$125 = "spark.driver.supervise";
        x$126 = OptionAssigner$.MODULE$.apply$default$4();
        v2[23] = new OptionAssigner(x$122, x$123, x$124, x$126, x$125);
        x$127 = args.ivyRepoPath();
        x$128 = this.STANDALONE();
        x$129 = this.CLUSTER();
        x$130 = "spark.jars.ivy";
        x$131 = OptionAssigner$.MODULE$.apply$default$4();
        v2[24] = new OptionAssigner(x$127, x$128, x$129, x$131, x$130);
        options = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])v2));
        if (deployMode.elem == this.CLIENT()) {
            childMainClass = args.mainClass();
            v3 /* !! */  = this.isUserJar(args.primaryResource()) != false ? childClasspath.$plus$eq((Object)args.primaryResource()) : BoxedUnit.UNIT;
            v4 /* !! */  = args.jars() == null ? BoxedUnit.UNIT : childClasspath.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])args.jars().split(",")));
            v5 /* !! */  = args.childArgs() == null ? BoxedUnit.UNIT : childArgs.$plus$plus$eq(args.childArgs());
        } else {
            v5 /* !! */  = BoxedUnit.UNIT;
        }
        options.foreach((Function1)new Serializable(childArgs, sysProps, clusterManager, deployMode){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer childArgs$2;
            private final HashMap sysProps$2;
            private final int clusterManager$1;
            private final IntRef deployMode$1;

            public final Object apply(OptionAssigner opt) {
                Object object;
                if (opt.value() != null && (this.deployMode$1.elem & opt.deployMode()) != 0 && (this.clusterManager$1 & opt.clusterManager()) != 0) {
                    Object object2 = opt.clOption() == null ? BoxedUnit.UNIT : this.childArgs$2.$plus$eq((Object)opt.clOption(), (Object)opt.value(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                    object = opt.sysProp() == null ? BoxedUnit.UNIT : this.sysProps$2.put((Object)opt.sysProp(), (Object)opt.value());
                } else {
                    object = BoxedUnit.UNIT;
                }
                return object;
            }
            {
                this.childArgs$2 = childArgs$2;
                this.sysProps$2 = sysProps$2;
                this.clusterManager$1 = clusterManager$1;
                this.deployMode$1 = deployMode$1;
            }
        });
        if (isYarnCluster || args.isPython() || args.isR()) {
            v6 = BoxedUnit.UNIT;
        } else {
            jars = (Seq)sysProps.get((Object)"spark.jars").map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Seq<String> apply(String x) {
                    return Predef$.MODULE$.refArrayOps((Object[])x.split(",")).toSeq();
                }
            }).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Seq<Nothing$> apply() {
                    return (Seq)Seq$.MODULE$.empty();
                }
            });
            if (this.isUserJar(args.primaryResource())) {
                jars = (Seq)jars.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{args.primaryResource()})), Seq$.MODULE$.canBuildFrom());
            }
            v6 = sysProps.put((Object)"spark.jars", (Object)jars.mkString(","));
        }
        if (args.isStandaloneCluster()) {
            if (args.useRest()) {
                childMainClass = "org.apache.spark.deploy.rest.RestSubmissionClient";
                v7 = childArgs.$plus$eq((Object)args.primaryResource(), (Object)args.mainClass(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            } else {
                childMainClass = "org.apache.spark.deploy.Client";
                v8 /* !! */  = args.supervise() != false ? childArgs.$plus$eq((Object)"--supervise") : BoxedUnit.UNIT;
                Option$.MODULE$.apply((Object)args.driverMemory()).foreach((Function1)new Serializable(childArgs){
                    public static final long serialVersionUID = 0L;
                    private final ArrayBuffer childArgs$2;

                    public final ArrayBuffer<String> apply(String m) {
                        return (ArrayBuffer)this.childArgs$2.$plus$eq((Object)"--memory", (Object)m, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                    }
                    {
                        this.childArgs$2 = childArgs$2;
                    }
                });
                Option$.MODULE$.apply((Object)args.driverCores()).foreach((Function1)new Serializable(childArgs){
                    public static final long serialVersionUID = 0L;
                    private final ArrayBuffer childArgs$2;

                    public final ArrayBuffer<String> apply(String c) {
                        return (ArrayBuffer)this.childArgs$2.$plus$eq((Object)"--cores", (Object)c, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                    }
                    {
                        this.childArgs$2 = childArgs$2;
                    }
                });
                childArgs.$plus$eq((Object)"launch");
                v7 = childArgs.$plus$eq((Object)args.master(), (Object)args.primaryResource(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{args.mainClass()}));
            }
            v9 /* !! */  = args.childArgs() == null ? BoxedUnit.UNIT : childArgs.$plus$plus$eq(args.childArgs());
        } else {
            v9 /* !! */  = BoxedUnit.UNIT;
        }
        if (clusterManager == this.YARN()) {
            v10 /* !! */  = args.isPython() != false ? sysProps.put((Object)"spark.yarn.isPython", (Object)"true") : BoxedUnit.UNIT;
            if (args.pyFiles() != null) {
                sysProps.update((Object)"spark.submit.pyFiles", (Object)args.pyFiles());
            }
        }
        if ((clusterManager == this.YARN() || clusterManager == this.LOCAL()) && args.principal() != null) {
            Predef$.MODULE$.require(args.keytab() != null, (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Keytab must be specified when principal is specified";
                }
            });
            if (new File(args.keytab()).exists()) {
                sysProps.put((Object)"spark.yarn.keytab", (Object)args.keytab());
                sysProps.put((Object)"spark.yarn.principal", (Object)args.principal());
                UserGroupInformation.loginUserFromKeytab((String)args.principal(), (String)args.keytab());
            } else {
                throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Keytab file: ", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{args.keytab()})));
            }
        }
        if (isYarnCluster) {
            childMainClass = "org.apache.spark.deploy.yarn.Client";
            if (args.isPython()) {
                childArgs.$plus$eq((Object)"--primary-py-file", (Object)args.primaryResource(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                v11 = childArgs.$plus$eq((Object)"--class", (Object)"org.apache.spark.deploy.PythonRunner", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            } else if (args.isR()) {
                mainFile = new Path(args.primaryResource()).getName();
                childArgs.$plus$eq((Object)"--primary-r-file", (Object)mainFile, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                v11 = childArgs.$plus$eq((Object)"--class", (Object)"org.apache.spark.deploy.RRunner", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            } else {
                v12 = args.primaryResource();
                var192_204 = "spark-internal";
                v13 /* !! */  = !(v12 != null ? v12.equals(var192_204) == false : var192_204 != null) ? BoxedUnit.UNIT : childArgs.$plus$eq((Object)"--jar", (Object)args.primaryResource(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                v11 = childArgs.$plus$eq((Object)"--class", (Object)args.mainClass(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            }
            if (args.childArgs() != null) {
                args.childArgs().foreach((Function1)new Serializable(childArgs){
                    public static final long serialVersionUID = 0L;
                    private final ArrayBuffer childArgs$2;

                    public final ArrayBuffer<String> apply(String arg) {
                        return (ArrayBuffer)this.childArgs$2.$plus$eq((Object)"--arg", (Object)arg, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                    }
                    {
                        this.childArgs$2 = childArgs$2;
                    }
                });
            }
        }
        if (isMesosCluster) {
            Predef$.MODULE$.assert(args.useRest(), (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Mesos cluster mode is only supported through the REST submission API";
                }
            });
            childMainClass = "org.apache.spark.deploy.rest.RestSubmissionClient";
            if (args.isPython()) {
                childArgs.$plus$eq((Object)args.primaryResource(), (Object)"", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                if (args.pyFiles() != null) {
                    sysProps.update((Object)"spark.submit.pyFiles", (Object)args.pyFiles());
                }
                v14 = BoxedUnit.UNIT;
            } else {
                v14 = childArgs.$plus$eq((Object)args.primaryResource(), (Object)args.mainClass(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            }
            v15 /* !! */  = args.childArgs() == null ? BoxedUnit.UNIT : childArgs.$plus$plus$eq(args.childArgs());
        } else {
            v15 /* !! */  = BoxedUnit.UNIT;
        }
        args.sparkProperties().withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> check$ifrefutable$1) {
                Tuple2<String, String> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(sysProps){
            public static final long serialVersionUID = 0L;
            private final HashMap sysProps$2;

            public final String apply(Tuple2<String, String> x$2) {
                Tuple2<String, String> tuple2 = x$2;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    String string = (String)this.sysProps$2.getOrElseUpdate((Object)k, (Function0)new Serializable(this, v){
                        public static final long serialVersionUID = 0L;
                        private final String v$1;

                        public final String apply() {
                            return this.v$1;
                        }
                        {
                            this.v$1 = v$1;
                        }
                    });
                    return string;
                }
                throw new MatchError(tuple2);
            }
            {
                this.sysProps$2 = sysProps$2;
            }
        });
        v16 /* !! */  = deployMode.elem == this.CLUSTER() ? sysProps.$minus$eq((Object)"spark.driver.host") : BoxedUnit.UNIT;
        pathConfigs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark.jars", "spark.files", "spark.yarn.dist.files", "spark.yarn.dist.archives", "spark.yarn.dist.jars"}));
        pathConfigs.foreach((Function1)new Serializable(sysProps){
            public static final long serialVersionUID = 0L;
            public final HashMap sysProps$2;

            public final void apply(String config) {
                this.sysProps$2.get((Object)config).foreach((Function1)new Serializable(this, config){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.prepareSubmitEnvironment.9 $outer;
                    private final String config$1;

                    public final void apply(String oldValue) {
                        this.$outer.sysProps$2.update((Object)this.config$1, (Object)Utils$.MODULE$.resolveURIs(oldValue));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.config$1 = config$1;
                    }
                });
            }
            {
                this.sysProps$2 = sysProps$2;
            }
        });
        sysProps.get((Object)"spark.submit.pyFiles").foreach((Function1)new Serializable(sysProps, isYarnCluster, isMesosCluster){
            public static final long serialVersionUID = 0L;
            private final HashMap sysProps$2;
            private final boolean isYarnCluster$1;
            private final boolean isMesosCluster$1;

            public final void apply(String pyFiles) {
                String resolvedPyFiles = Utils$.MODULE$.resolveURIs(pyFiles);
                String formattedPyFiles = this.isYarnCluster$1 || this.isMesosCluster$1 ? resolvedPyFiles : Predef$.MODULE$.refArrayOps((Object[])PythonRunner$.MODULE$.formatPaths(resolvedPyFiles, PythonRunner$.MODULE$.formatPaths$default$2())).mkString(",");
                this.sysProps$2.update((Object)"spark.submit.pyFiles", (Object)formattedPyFiles);
            }
            {
                this.sysProps$2 = sysProps$2;
                this.isYarnCluster$1 = isYarnCluster$1;
                this.isMesosCluster$1 = isMesosCluster$1;
            }
        });
        return new Tuple4((Object)childArgs, (Object)childClasspath, (Object)sysProps, (Object)childMainClass);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void org$apache$spark$deploy$SparkSubmit$$runMain(Seq<String> childArgs, Seq<String> childClasspath, Map<String, String> sysProps, String childMainClass, boolean verbose) {
        Throwable throwable;
        block9: {
            Method mainMethod;
            if (verbose) {
                this.printStream().println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Main class:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childMainClass})));
                this.printStream().println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Arguments:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childArgs.mkString("\n")})));
                this.printStream().println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"System properties:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sysProps.mkString("\n")})));
                this.printStream().println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Classpath elements:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childClasspath.mkString("\n")})));
                this.printStream().println("\n");
            }
            MutableURLClassLoader loader = new StringOps(Predef$.MODULE$.augmentString((String)sysProps.getOrElse((Object)"spark.driver.userClassPathFirst", (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "false";
                }
            }))).toBoolean() ? new ChildFirstURLClassLoader(new URL[0], Thread.currentThread().getContextClassLoader()) : new MutableURLClassLoader(new URL[0], Thread.currentThread().getContextClassLoader());
            Thread.currentThread().setContextClassLoader(loader);
            childClasspath.foreach((Function1)new Serializable(loader){
                public static final long serialVersionUID = 0L;
                private final MutableURLClassLoader loader$1;

                public final void apply(String jar) {
                    SparkSubmit$.MODULE$.org$apache$spark$deploy$SparkSubmit$$addJarToClasspath(jar, this.loader$1);
                }
                {
                    this.loader$1 = loader$1;
                }
            });
            sysProps.withFilter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<String, String> check$ifrefutable$2) {
                    Tuple2<String, String> tuple2 = check$ifrefutable$2;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<String, String> x$3) {
                    Tuple2<String, String> tuple2 = x$3;
                    if (tuple2 != null) {
                        String key = (String)tuple2._1();
                        String value2 = (String)tuple2._2();
                        String string = System.setProperty(key, value2);
                        return string;
                    }
                    throw new MatchError(tuple2);
                }
            });
            Class<?> mainClass = null;
            try {
                mainClass = Utils$.MODULE$.classForName(childMainClass);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                noClassDefFoundError.printStackTrace(this.printStream());
                if (noClassDefFoundError.getMessage().contains("org/apache/hadoop/hive")) {
                    this.printStream().println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to load hive class."})).s((Seq)Nil$.MODULE$));
                    this.printStream().println("You need to build Spark with -Phive and -Phive-thriftserver.");
                }
                System.exit(this.CLASS_NOT_FOUND_EXIT_STATUS());
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace(this.printStream());
                if (childMainClass.contains("thriftserver")) {
                    this.printStream().println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to load main class ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childMainClass})));
                    this.printStream().println("You need to build Spark with -Phive and -Phive-thriftserver.");
                }
                System.exit(this.CLASS_NOT_FOUND_EXIT_STATUS());
            }
            if (App.class.isAssignableFrom(mainClass)) {
                this.printWarning("Subclasses of scala.App may not work correctly. Use a main() method instead.");
            }
            if (!Modifier.isStatic((mainMethod = mainClass.getMethod("main", new String[0].getClass())).getModifiers())) throw new IllegalStateException("The main method in the given main class must be static");
            try {
                mainMethod.invoke(null, childArgs.toArray(ClassTag$.MODULE$.apply(String.class)));
                return;
            }
            catch (Throwable throwable2) {
                throwable = this.findCause$1(throwable2);
                if (!(throwable instanceof SparkUserAppException)) break block9;
                SparkUserAppException sparkUserAppException = (SparkUserAppException)throwable;
                int exitCode = sparkUserAppException.exitCode();
                System.exit(exitCode);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        if (throwable == null) throw new MatchError((Object)throwable);
        Throwable throwable3 = throwable;
        throw throwable3;
    }

    public void org$apache$spark$deploy$SparkSubmit$$addJarToClasspath(String localJar, MutableURLClassLoader loader) {
        boolean bl;
        String string;
        URI uri = Utils$.MODULE$.resolveURI(localJar);
        String string2 = string = uri.getScheme();
        if (!("file" != null ? !"file".equals(string2) : string2 != null)) {
            bl = true;
        } else {
            String string3 = string;
            bl = !("local" != null ? !"local".equals(string3) : string3 != null);
        }
        if (bl) {
            BoxedUnit boxedUnit;
            File file = new File(uri.getPath());
            if (file.exists()) {
                loader.addURL(file.toURI().toURL());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.printWarning(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Local jar ", " does not exist, skipping."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file})));
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            this.printWarning(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Skip remote jar ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public boolean isUserJar(String res) {
        return !this.isShell(res) && !this.isPython(res) && !this.isInternal(res) && !this.isR(res);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isShell(String res) {
        String string = res;
        String string2 = this.SPARK_SHELL();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = res;
        String string4 = this.PYSPARK_SHELL();
        if (string3 == null) {
            if (string4 == null) return true;
        } else if (string3.equals(string4)) return true;
        String string5 = res;
        String string6 = this.SPARKR_SHELL();
        if (string5 != null) {
            if (!string5.equals(string6)) return false;
            return true;
        }
        if (string6 == null) return true;
        return false;
    }

    public boolean isSqlShell(String mainClass) {
        String string = mainClass;
        String string2 = "org.apache.spark.sql.hive.thriftserver.SparkSQLCLIDriver";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private boolean isThriftServer(String mainClass) {
        String string = mainClass;
        String string2 = "org.apache.spark.sql.hive.thriftserver.HiveThriftServer2";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isPython(String res) {
        if (res != null) {
            if (res.endsWith(".py")) return true;
        }
        String string = res;
        String string2 = this.PYSPARK_SHELL();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isR(String res) {
        if (res != null) {
            if (res.endsWith(".R")) return true;
        }
        String string = res;
        String string2 = this.SPARKR_SHELL();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public boolean isInternal(String res) {
        String string = res;
        String string2 = "spark-internal";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private String mergeFileLists(Seq<String> lists) {
        String merged;
        String string = merged = ((TraversableOnce)((TraversableLike)lists.filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(CharSequence x$1) {
                return StringUtils.isBlank((CharSequence)x$1);
            }
        })).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<String> apply(String x$4) {
                return Predef$.MODULE$.refArrayOps((Object[])x$4.split(","));
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(",");
        String string2 = "";
        return !(string != null ? !string.equals(string2) : string2 != null) ? null : merged;
    }

    private final void doRunMain$1(SparkSubmitArguments args$1, Seq childArgs$1, Seq childClasspath$1, Map sysProps$1, String childMainClass$1) {
        Exception exception22;
        block4: {
            if (args$1.proxyUser() == null) {
                this.org$apache$spark$deploy$SparkSubmit$$runMain((Seq<String>)childArgs$1, (Seq<String>)childClasspath$1, (Map<String, String>)sysProps$1, childMainClass$1, args$1.verbose());
            } else {
                UserGroupInformation proxyUser = UserGroupInformation.createProxyUser((String)args$1.proxyUser(), (UserGroupInformation)UserGroupInformation.getCurrentUser());
                try {
                    proxyUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<BoxedUnit>(args$1, childArgs$1, childClasspath$1, sysProps$1, childMainClass$1){
                        private final SparkSubmitArguments args$1;
                        private final Seq childArgs$1;
                        private final Seq childClasspath$1;
                        private final Map sysProps$1;
                        private final String childMainClass$1;

                        public void run() {
                            SparkSubmit$.MODULE$.org$apache$spark$deploy$SparkSubmit$$runMain((Seq<String>)this.childArgs$1, (Seq<String>)this.childClasspath$1, (Map<String, String>)this.sysProps$1, this.childMainClass$1, this.args$1.verbose());
                        }
                        {
                            this.args$1 = args$1;
                            this.childArgs$1 = childArgs$1;
                            this.childClasspath$1 = childClasspath$1;
                            this.sysProps$1 = sysProps$1;
                            this.childMainClass$1 = childMainClass$1;
                        }
                    });
                }
                catch (Exception exception22) {
                    if (exception22.getStackTrace().length != 0) break block4;
                    this.printStream().println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ERROR: ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{exception22.getClass().getName(), exception22.getMessage()})));
                    this.exitFn().apply$mcVI$sp(1);
                }
            }
            return;
        }
        throw exception22;
    }

    private final Throwable findCause$1(Throwable t) {
        Throwable throwable;
        block8: {
            Throwable throwable2;
            block7: {
                while (true) {
                    if ((throwable = t) instanceof UndeclaredThrowableException) {
                        UndeclaredThrowableException undeclaredThrowableException = (UndeclaredThrowableException)throwable;
                        if (undeclaredThrowableException.getCause() == null) {
                            throwable2 = undeclaredThrowableException;
                            break block7;
                        }
                        t = undeclaredThrowableException.getCause();
                        continue;
                    }
                    if (!(throwable instanceof InvocationTargetException)) break;
                    InvocationTargetException invocationTargetException = (InvocationTargetException)throwable;
                    if (invocationTargetException.getCause() == null) {
                        throwable2 = invocationTargetException;
                        break block7;
                    }
                    t = invocationTargetException.getCause();
                }
                if (throwable == null) break block8;
                Throwable throwable3 = throwable;
                throwable2 = throwable3;
            }
            return throwable2;
        }
        throw new MatchError((Object)throwable);
    }

    private SparkSubmit$() {
        MODULE$ = this;
        this.YARN = 1;
        this.STANDALONE = 2;
        this.MESOS = 4;
        this.LOCAL = 8;
        this.ALL_CLUSTER_MGRS = this.YARN() | this.STANDALONE() | this.MESOS() | this.LOCAL();
        this.CLIENT = 1;
        this.CLUSTER = 2;
        this.ALL_DEPLOY_MODES = this.CLIENT() | this.CLUSTER();
        this.SPARK_SHELL = "spark-shell";
        this.PYSPARK_SHELL = "pyspark-shell";
        this.SPARKR_SHELL = "sparkr-shell";
        this.SPARKR_PACKAGE_ARCHIVE = "sparkr.zip";
        this.R_PACKAGE_ARCHIVE = "rpkg.zip";
        this.CLASS_NOT_FOUND_EXIT_STATUS = 101;
        this.exitFn = new anonfun.1();
        this.printStream = System.err;
    }
}

