/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.api.python;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.apache.spark.AccumulatorParam;
import org.apache.spark.AccumulatorParam$class;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.util.Utils$;
import scala.Function1;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001)4A!\u0001\u0002\u0005\u001b\t1\u0002+\u001f;i_:\f5mY;nk2\fGo\u001c:QCJ\fWN\u0003\u0002\u0004\t\u00051\u0001/\u001f;i_:T!!\u0002\u0004\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0015!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0019QC\u0006\r\u000e\u0003\u0019I!a\u0006\u0004\u0003!\u0005\u001b7-^7vY\u0006$xN\u001d)be\u0006l\u0007cA\r\u001fA5\t!D\u0003\u0002\u001c9\u0005!Q\u000f^5m\u0015\u0005i\u0012\u0001\u00026bm\u0006L!a\b\u000e\u0003\t1K7\u000f\u001e\t\u0004\u001f\u0005\u001a\u0013B\u0001\u0012\u0011\u0005\u0015\t%O]1z!\tyA%\u0003\u0002&!\t!!)\u001f;f\u0011!9\u0003A!b\u0001\n\u0013A\u0013AC:feZ,'\u000fS8tiV\t\u0011\u0006\u0005\u0002+[9\u0011qbK\u0005\u0003YA\ta\u0001\u0015:fI\u00164\u0017B\u0001\u00180\u0005\u0019\u0019FO]5oO*\u0011A\u0006\u0005\u0005\tc\u0001\u0011\t\u0011)A\u0005S\u0005Y1/\u001a:wKJDun\u001d;!Q\t\u00014\u0007\u0005\u0002\u0010i%\u0011Q\u0007\u0005\u0002\niJ\fgn]5f]RD\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001O\u0001\u000bg\u0016\u0014h/\u001a:Q_J$\bCA\b:\u0013\tQ\u0004CA\u0002J]RDQ\u0001\u0010\u0001\u0005\u0002u\na\u0001P5oSRtDc\u0001 A\u0003B\u0011q\bA\u0007\u0002\u0005!)qe\u000fa\u0001S!)qg\u000fa\u0001q!91\t\u0001b\u0001\n\u0003!\u0015A\u00032vM\u001a,'oU5{KV\t\u0001\b\u0003\u0004G\u0001\u0001\u0006I\u0001O\u0001\fEV4g-\u001a:TSj,\u0007\u0005C\u0005I\u0001\u0001\u0007\t\u0019!C\u0001\u0013\u000611o\\2lKR,\u0012A\u0013\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001br\t1A\\3u\u0013\tyEJ\u0001\u0004T_\u000e\\W\r\u001e\u0005\n#\u0002\u0001\r\u00111A\u0005\u0002I\u000b!b]8dW\u0016$x\fJ3r)\t\u0019f\u000b\u0005\u0002\u0010)&\u0011Q\u000b\u0005\u0002\u0005+:LG\u000fC\u0004X!\u0006\u0005\t\u0019\u0001&\u0002\u0007a$\u0013\u0007\u0003\u0004Z\u0001\u0001\u0006KAS\u0001\bg>\u001c7.\u001a;!Q\tA6\u0007C\u0003]\u0001\u0011\u0005Q,\u0001\u0006pa\u0016t7k\\2lKR$\u0012A\u0013\u0005\u0006?\u0002!\t\u0005Y\u0001\u0005u\u0016\u0014x\u000e\u0006\u0002\u0019C\")!M\u0018a\u00011\u0005)a/\u00197vK\")A\r\u0001C!K\u0006Q\u0011\r\u001a3J]Bc\u0017mY3\u0015\u0007a1\u0007\u000eC\u0003hG\u0002\u0007\u0001$\u0001\u0003wC2\f\u0004\"B5d\u0001\u0004A\u0012\u0001\u0002<bYJ\u0002")
public class PythonAccumulatorParam
implements AccumulatorParam<List<byte[]>> {
    private final transient String serverHost;
    private final int serverPort;
    private final int bufferSize;
    private transient Socket socket;

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    @Override
    public Object addAccumulator(Object t1, Object t2) {
        return AccumulatorParam$class.addAccumulator(this, t1, t2);
    }

    private String serverHost() {
        return this.serverHost;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public Socket socket() {
        return this.socket;
    }

    public void socket_$eq(Socket x$1) {
        this.socket = x$1;
    }

    public synchronized Socket openSocket() {
        if (this.socket() == null || this.socket().isClosed()) {
            this.socket_$eq(new Socket(this.serverHost(), this.serverPort));
        }
        return this.socket();
    }

    @Override
    public List<byte[]> zero(List<byte[]> value2) {
        return new ArrayList<byte[]>();
    }

    @Override
    public synchronized List<byte[]> addInPlace(List<byte[]> val1, List<byte[]> val2) {
        List<byte[]> list;
        if (this.serverHost() == null) {
            val1.addAll(val2);
            list = val1;
        } else {
            Socket socket = this.openSocket();
            InputStream in = socket.getInputStream();
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream(), this.bufferSize()));
            out.writeInt(val2.size());
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(val2).asScala()).foreach((Function1)new Serializable(this, out){
                public static final long serialVersionUID = 0L;
                private final DataOutputStream out$2;

                public final void apply(byte[] array) {
                    this.out$2.writeInt(array.length);
                    this.out$2.write(array);
                }
                {
                    this.out$2 = out$2;
                }
            });
            out.flush();
            int byteRead = in.read();
            if (byteRead == -1) {
                throw new SparkException("EOF reached before Python server acknowledged");
            }
            list = null;
        }
        return list;
    }

    public PythonAccumulatorParam(String serverHost, int serverPort) {
        this.serverHost = serverHost;
        this.serverPort = serverPort;
        AccumulatorParam$class.$init$(this);
        Utils$.MODULE$.checkHost(serverHost, "Expected hostname");
        this.bufferSize = SparkEnv$.MODULE$.get().conf().getInt("spark.buffer.size", 65536);
    }
}

