/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common.processor;

import com.univocity.parsers.common.ArgumentUtils;
import com.univocity.parsers.common.ParsingContext;
import com.univocity.parsers.common.processor.MultiBeanRowProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MultiBeanListProcessor
extends MultiBeanRowProcessor {
    private final Class[] beanTypes;
    private final List[] beans;
    private String[] headers;

    public MultiBeanListProcessor(Class ... beanTypes) {
        super(beanTypes);
        this.beanTypes = beanTypes;
        this.beans = new List[beanTypes.length];
        for (int i = 0; i < beanTypes.length; ++i) {
            this.beans[i] = new ArrayList(1000);
        }
    }

    @Override
    public final void processStarted(ParsingContext context) {
        super.processStarted(context);
        for (int i = 0; i < this.beanTypes.length; ++i) {
            this.beans[i] = new ArrayList(1000);
        }
    }

    @Override
    protected final void rowProcessed(Map<Class<?>, Object> row, ParsingContext context) {
        for (int i = 0; i < this.beanTypes.length; ++i) {
            Object bean = row.get(this.beanTypes[i]);
            this.beans[i].add(bean);
        }
    }

    @Override
    public final void processEnded(ParsingContext context) {
        this.headers = context.headers();
        super.processEnded(context);
    }

    public final String[] getHeaders() {
        return this.headers;
    }

    public <T> List<T> getBeans(Class<T> beanType) {
        int index = ArgumentUtils.indexOf(this.beanTypes, beanType);
        if (index == -1) {
            throw new IllegalArgumentException("Unknown bean type '" + beanType.getSimpleName() + "'. Available types are: " + Arrays.toString(this.beanTypes));
        }
        return this.beans[index];
    }

    public Map<Class<?>, List<?>> getBeans() {
        LinkedHashMap out = new LinkedHashMap();
        for (int i = 0; i < this.beanTypes.length; ++i) {
            out.put(this.beanTypes[i], this.beans[i]);
        }
        return out;
    }
}

