/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import java.util.function.Supplier;

public abstract class Lazy<E> {
    private E implOrNull = null;

    public synchronized E get() {
        if (this.implOrNull == null) {
            this.implOrNull = this.compute();
        }
        return this.implOrNull;
    }

    protected abstract E compute();

    public E getIfDefined() {
        return this.implOrNull;
    }

    public static <E> Lazy<E> from(final E definedElement) {
        return new Lazy<E>(){

            @Override
            protected E compute() {
                return definedElement;
            }
        };
    }

    public static <E> Lazy<E> of(final Supplier<E> fn) {
        return new Lazy<E>(){

            @Override
            protected E compute() {
                return fn.get();
            }
        };
    }
}

