/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.Timing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;

public class QuoteAnnotator
implements Annotator {
    private final boolean VERBOSE;
    private final boolean DEBUG = false;
    public boolean USE_SINGLE = false;
    public int MAX_LENGTH = -1;
    public boolean ASCII_QUOTES = false;
    public static final Map<String, String> DIRECTED_QUOTES;
    private static final Pattern asciiSingleQuote;
    private static final Pattern asciiDoubleQuote;

    public QuoteAnnotator(String s, Properties props) {
        this(props, false);
    }

    public QuoteAnnotator(Properties props) {
        this(props, false);
    }

    public QuoteAnnotator(Properties props, boolean verbose) {
        this.USE_SINGLE = Boolean.parseBoolean(props.getProperty("singleQuotes", "false"));
        this.MAX_LENGTH = Integer.parseInt(props.getProperty("maxLength", "-1"));
        this.ASCII_QUOTES = Boolean.parseBoolean(props.getProperty("asciiQuotes", "false"));
        this.VERBOSE = verbose;
        Timing timer = null;
        if (this.VERBOSE) {
            timer = new Timing();
            System.err.print("Preparing quote annotator...");
        }
        if (this.VERBOSE) {
            timer.stop("done.");
        }
    }

    @Override
    public void annotate(Annotation annotation) {
        String text = (String)annotation.get(CoreAnnotations.TextAnnotation.class);
        List tokens = (List)annotation.get(CoreAnnotations.TokensAnnotation.class);
        List sentences = (List)annotation.get(CoreAnnotations.SentencesAnnotation.class);
        String quotesFrom = text;
        if (this.ASCII_QUOTES) {
            quotesFrom = QuoteAnnotator.replaceUnicode(text);
        }
        List<Pair<Integer, Integer>> overall = this.getQuotes(quotesFrom);
        String docID = (String)annotation.get(CoreAnnotations.DocIDAnnotation.class);
        List<CoreMap> cmQuotes = QuoteAnnotator.getCoreMapQuotes(overall, tokens, sentences, text, docID);
        annotation.set(CoreAnnotations.QuotationsAnnotation.class, cmQuotes);
    }

    private static String asciiQuotes(String in) {
        String s1 = in;
        s1 = asciiSingleQuote.matcher(s1).replaceAll("'");
        s1 = asciiDoubleQuote.matcher(s1).replaceAll("\"");
        return s1;
    }

    public static String replaceUnicode(String text) {
        return QuoteAnnotator.asciiQuotes(text);
    }

    public static Comparator<CoreMap> getQuoteComparator() {
        return new Comparator<CoreMap>(){

            @Override
            public int compare(CoreMap o1, CoreMap o2) {
                int s1 = (Integer)o1.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
                int s2 = (Integer)o2.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
                return s1 - s2;
            }
        };
    }

    public static List<CoreMap> getCoreMapQuotes(List<Pair<Integer, Integer>> quotes, List<CoreLabel> tokens, List<CoreMap> sentences, String text, String docID) {
        ArrayList<CoreMap> cmQuotes = Generics.newArrayList();
        for (Pair<Integer, Integer> p : quotes) {
            int begin = p.first();
            int end = p.second();
            ArrayList<CoreLabel> quoteTokens = new ArrayList<CoreLabel>();
            int tokenOffset = -1;
            if (tokens != null) {
                int i;
                int currTok;
                for (currTok = 0; currTok < tokens.size() && tokens.get(currTok).beginPosition() < begin; ++currTok) {
                }
                tokenOffset = i = currTok;
                while (i < tokens.size() && tokens.get(i).endPosition() <= end) {
                    quoteTokens.add(tokens.get(i));
                    ++i;
                }
            }
            int beginSentence = -1;
            int endSentence = -1;
            if (sentences != null) {
                for (CoreMap sentence : sentences) {
                    int sentBegin = (Integer)sentence.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
                    int sentEnd = (Integer)sentence.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
                    int sentIndex = (Integer)sentence.get(CoreAnnotations.SentenceIndexAnnotation.class);
                    if (sentBegin <= begin) {
                        beginSentence = sentIndex;
                    }
                    if (sentEnd < end || endSentence >= 0) continue;
                    endSentence = sentIndex;
                }
            }
            Annotation quote = QuoteAnnotator.makeQuote(text.substring(begin, end), begin, end, quoteTokens, tokenOffset, beginSentence, endSentence, docID);
            cmQuotes.add(quote);
        }
        Comparator<CoreMap> quoteComparator = QuoteAnnotator.getQuoteComparator();
        Collections.sort(cmQuotes, quoteComparator);
        ArrayList<CoreMap> toRemove = new ArrayList<CoreMap>();
        for (CoreMap cmQuote : cmQuotes) {
            int start = (Integer)cmQuote.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
            int end = (Integer)cmQuote.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
            ArrayList<CoreMap> embeddedQuotes = new ArrayList<CoreMap>();
            for (CoreMap cmQuoteComp : cmQuotes) {
                int startComp = (Integer)cmQuoteComp.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
                int endComp = (Integer)cmQuoteComp.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
                if (start >= startComp || end < endComp) continue;
                embeddedQuotes.add(cmQuoteComp);
                toRemove.add(cmQuoteComp);
            }
            cmQuote.set(CoreAnnotations.QuotationsAnnotation.class, embeddedQuotes);
        }
        for (CoreMap r : toRemove) {
            cmQuotes.remove(r);
        }
        QuoteAnnotator.setQuoteIndices(cmQuotes);
        return cmQuotes;
    }

    private static void setQuoteIndices(List<CoreMap> topLevel) {
        List<CoreMap> level = topLevel;
        int index = 0;
        while (!level.isEmpty()) {
            ArrayList<CoreMap> nextLevel = Generics.newArrayList();
            for (CoreMap quote : level) {
                quote.set(CoreAnnotations.QuotationIndexAnnotation.class, index);
                List quoteTokens = (List)quote.get(CoreAnnotations.TokensAnnotation.class);
                if (quoteTokens != null) {
                    for (CoreLabel qt : quoteTokens) {
                        qt.set(CoreAnnotations.QuotationIndexAnnotation.class, index);
                    }
                }
                ++index;
                if (quote.get(CoreAnnotations.QuotationsAnnotation.class) == null) continue;
                nextLevel.addAll((Collection)quote.get(CoreAnnotations.QuotationsAnnotation.class));
            }
            level = nextLevel;
        }
    }

    public static Annotation makeQuote(String surfaceForm, int begin, int end, List<CoreLabel> quoteTokens, int tokenOffset, int sentenceBeginIndex, int sentenceEndIndex, String docID) {
        Annotation quote = new Annotation(surfaceForm);
        quote.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, begin);
        quote.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, end);
        if (docID != null) {
            quote.set(CoreAnnotations.DocIDAnnotation.class, docID);
        }
        if (quoteTokens != null) {
            quote.set(CoreAnnotations.TokensAnnotation.class, quoteTokens);
            quote.set(CoreAnnotations.TokenBeginAnnotation.class, tokenOffset);
            quote.set(CoreAnnotations.TokenEndAnnotation.class, tokenOffset + quoteTokens.size() - 1);
        }
        quote.set(CoreAnnotations.SentenceBeginAnnotation.class, sentenceBeginIndex);
        quote.set(CoreAnnotations.SentenceEndAnnotation.class, sentenceEndIndex);
        return quote;
    }

    public List<Pair<Integer, Integer>> getQuotes(String text) {
        return this.recursiveQuotes(text, 0, null);
    }

    public List<Pair<Integer, Integer>> recursiveQuotes(String text, int offset, String prevQuote) {
        HashMap quotesMap = new HashMap();
        int start = -1;
        int end = -1;
        String quote = null;
        int directed = 0;
        for (int i = 0; i < text.length(); ++i) {
            String c = text.substring(i, i + 1);
            if (c.equals("`") && i < text.length() - 1 && text.charAt(i + 1) == '`') {
                c = c + text.charAt(i + 1);
            } else if (c.equals("'") && quote != null && (quote.equals("``") || quote.equals("`"))) {
                int curr;
                for (curr = i; curr < text.length() && text.charAt(curr) == '\''; ++curr) {
                }
                if (i != curr - quote.length() && (directed <= 0 || i != curr - directed * quote.length())) continue;
                for (int a = i + 1; a < i + quote.length(); ++a) {
                    c = c + text.charAt(a);
                }
            }
            if (DIRECTED_QUOTES.containsKey(quote) && DIRECTED_QUOTES.get(quote).equals(c)) {
                --directed;
            }
            if (start < 0 && !QuoteAnnotator.matchesPrevQuote(c, prevQuote) && ((this.isSingleQuoteWithUse(c) || c.equals("`")) && QuoteAnnotator.isSingleQuoteStart(text, i) || c.equals("\"") || DIRECTED_QUOTES.containsKey(c))) {
                start = i;
                quote = c;
            } else if (start >= 0 && end < 0 && (c.equals(quote) && ((c.equals("'") || c.equals("`")) && QuoteAnnotator.isSingleQuoteEnd(text, i) || c.equals("\"") && QuoteAnnotator.isDoubleQuoteEnd(text, i)) || c.equals("'") && quote.equals("`") && QuoteAnnotator.isSingleQuoteEnd(text, i) || DIRECTED_QUOTES.containsKey(quote) && DIRECTED_QUOTES.get(quote).equals(c) && directed == 0)) {
                end = i + c.length();
            }
            if (DIRECTED_QUOTES.containsKey(c) && c.equals(quote)) {
                ++directed;
            }
            if (start >= 0 && end > 0) {
                if (!quotesMap.containsKey(quote)) {
                    quotesMap.put(quote, new ArrayList());
                }
                ((List)quotesMap.get(quote)).add(new Pair<Integer, Integer>(start, end));
                start = -1;
                end = -1;
                quote = null;
            }
            if (c.length() > 1) {
                i += c.length() - 1;
            }
            if (this.MAX_LENGTH <= 0 || start < 0 || i - start <= this.MAX_LENGTH) continue;
            i = start + quote.length();
            start = -1;
            end = -1;
            quote = null;
        }
        if (start >= 0 && start < text.length() - 3) {
            String warning = text;
            if (text.length() > 150) {
                warning = text.substring(0, 150) + "...";
            }
            System.err.println("WARNING: unmatched quote of type " + quote + " found at index " + start + " in text segment: " + warning);
        }
        ArrayList<Pair<Integer, Integer>> quotes = Generics.newArrayList();
        if (quotesMap.isEmpty() && start >= 0 && start < text.length() - 3) {
            String toPass = text.substring(start + quote.length(), text.length());
            List<Pair<Integer, Integer>> embedded = this.recursiveQuotes(toPass, offset, null);
            for (Pair<Integer, Integer> e : embedded) {
                quotes.add(new Pair<Integer, Integer>(e.first() + start + quote.length(), e.second() + start + 1));
            }
        } else {
            for (String qKind : quotesMap.keySet()) {
                for (Pair q : (List)quotesMap.get(qKind)) {
                    if ((Integer)q.first() < (Integer)q.second() - qKind.length() * 2) {
                        String toPass = text.substring((Integer)q.first() + qKind.length(), (Integer)q.second() - qKind.length());
                        String qKindToPass = DIRECTED_QUOTES.containsKey(qKind) || qKind.equals("`") ? null : qKind;
                        List<Pair<Integer, Integer>> embedded = this.recursiveQuotes(toPass, (Integer)q.first() + qKind.length() + offset, qKindToPass);
                        for (Pair<Integer, Integer> e : embedded) {
                            quotes.add(new Pair<Integer, Integer>(e.first(), e.second()));
                        }
                    }
                    quotes.add(new Pair<Integer, Integer>((Integer)q.first() + offset, (Integer)q.second() + offset));
                }
            }
        }
        return quotes;
    }

    private boolean isSingleQuoteWithUse(String c) {
        return c.equals("'") && this.USE_SINGLE;
    }

    private static boolean matchesPrevQuote(String c, String prev) {
        return prev != null && prev.equals(c);
    }

    private static boolean isSingleQuoteStart(String text, int i) {
        if (i == 0) {
            return true;
        }
        String prev = text.substring(i - 1, i);
        return QuoteAnnotator.isWhitespaceOrPunct(prev);
    }

    private static boolean isSingleQuoteEnd(String text, int i) {
        if (i == text.length() - 1) {
            return true;
        }
        String next = text.substring(i + 1, i + 2);
        return QuoteAnnotator.isWhitespaceOrPunct(next);
    }

    private static boolean isDoubleQuoteEnd(String text, int i) {
        if (i == text.length() - 1) {
            return true;
        }
        String next = text.substring(i + 1, i + 2);
        if (i == text.length() - 2 && QuoteAnnotator.isWhitespaceOrPunct(next)) {
            return true;
        }
        String nextNext = text.substring(i + 2, i + 3);
        return QuoteAnnotator.isWhitespaceOrPunct(next) && !QuoteAnnotator.isSingleQuote(next) || QuoteAnnotator.isSingleQuote(next) && QuoteAnnotator.isWhitespaceOrPunct(nextNext);
    }

    public static boolean isWhitespaceOrPunct(String c) {
        return c.matches("[\\s\\p{Punct}]");
    }

    public static boolean isSingleQuote(String c) {
        return c.equals("'");
    }

    @Override
    public Set<Annotator.Requirement> requires() {
        return Collections.emptySet();
    }

    @Override
    public Set<Annotator.Requirement> requirementsSatisfied() {
        return Collections.singleton(QUOTE_REQUIREMENT);
    }

    static {
        Map<String, String> tmp = Generics.newHashMap();
        tmp.put("\u201c", "\u201d");
        tmp.put("\u2018", "\u2019");
        tmp.put("\u00ab", "\u00bb");
        tmp.put("\u2039", "\u203a");
        tmp.put("\u300c", "\u300d");
        tmp.put("\u300e", "\u300f");
        tmp.put("\u201e", "\u201d");
        tmp.put("\u201a", "\u2019");
        tmp.put("``", "''");
        DIRECTED_QUOTES = Collections.unmodifiableMap(tmp);
        asciiSingleQuote = Pattern.compile("&apos;|[\u0091\u2018\u0092\u2019\u201a\u201b\u2039\u203a']");
        asciiDoubleQuote = Pattern.compile("&quot;|[\u0093\u201c\u0094\u201d\u201e\u00ab\u00bb\"]");
    }
}

