/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ie.NERClassifierCombiner;
import edu.stanford.nlp.ie.regexp.NumberSequenceClassifier;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.SentenceAnnotator;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.RuntimeInterruptedException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class NERCombinerAnnotator
extends SentenceAnnotator {
    private final NERClassifierCombiner ner;
    private final boolean VERBOSE;
    private final long maxTime;
    private final int nThreads;
    private final int maxSentenceLength;

    public NERCombinerAnnotator() throws IOException, ClassNotFoundException {
        this(true);
    }

    public NERCombinerAnnotator(boolean verbose) throws IOException, ClassNotFoundException {
        this(new NERClassifierCombiner(new Properties()), verbose);
    }

    public NERCombinerAnnotator(boolean verbose, String ... classifiers) throws IOException, ClassNotFoundException {
        this(new NERClassifierCombiner(classifiers), verbose);
    }

    public NERCombinerAnnotator(NERClassifierCombiner ner, boolean verbose) {
        this(ner, verbose, 1, 0L, Integer.MAX_VALUE);
    }

    public NERCombinerAnnotator(NERClassifierCombiner ner, boolean verbose, int nThreads, long maxTime) {
        this(ner, verbose, nThreads, maxTime, Integer.MAX_VALUE);
    }

    public NERCombinerAnnotator(NERClassifierCombiner ner, boolean verbose, int nThreads, long maxTime, int maxSentenceLength) {
        this.VERBOSE = verbose;
        this.ner = ner;
        this.maxTime = maxTime;
        this.nThreads = nThreads;
        this.maxSentenceLength = maxSentenceLength;
    }

    public NERCombinerAnnotator(String name, Properties properties) {
        this(NERClassifierCombiner.createNERClassifierCombiner(name, properties), false, PropertiesUtils.getInt(properties, name + ".nthreads", PropertiesUtils.getInt(properties, "nthreads", 1)), PropertiesUtils.getLong(properties, name + ".maxtime", -1L), PropertiesUtils.getInt(properties, name + ".maxlength", Integer.MAX_VALUE));
    }

    @Override
    protected int nThreads() {
        return this.nThreads;
    }

    @Override
    protected long maxTime() {
        return this.maxTime;
    }

    @Override
    public void annotate(Annotation annotation) {
        if (this.VERBOSE) {
            System.err.print("Adding NER Combiner annotation ... ");
        }
        super.annotate(annotation);
        this.ner.finalizeAnnotation(annotation);
        if (this.VERBOSE) {
            System.err.println("done.");
        }
    }

    @Override
    public void doOneSentence(Annotation annotation, CoreMap sentence) {
        int i;
        boolean first;
        List output;
        List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
        try {
            output = this.ner.classifySentenceWithGlobalInformation(tokens, annotation, sentence);
        }
        catch (RuntimeInterruptedException e) {
            this.doOneFailedSentence(annotation, sentence);
            return;
        }
        if (this.VERBOSE) {
            first = true;
            System.err.print("NERCombinerAnnotator direct output: [");
            for (CoreLabel w : output) {
                if (first) {
                    first = false;
                } else {
                    System.err.print(", ");
                }
                System.err.print(w.toString());
            }
        }
        if (output != null) {
            if (this.VERBOSE) {
                first = true;
                System.err.print("NERCombinerAnnotator direct output: [");
                for (CoreLabel w : output) {
                    if (first) {
                        first = false;
                    } else {
                        System.err.print(", ");
                    }
                    System.err.print(w.toString());
                }
                System.err.println(']');
            }
            for (i = 0; i < tokens.size(); ++i) {
                String neTag = (String)((CoreLabel)output.get(i)).get(CoreAnnotations.NamedEntityTagAnnotation.class);
                String normNeTag = (String)((CoreLabel)output.get(i)).get(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class);
                ((CoreLabel)tokens.get(i)).setNER(neTag);
                if (normNeTag != null) {
                    ((CoreLabel)tokens.get(i)).set(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class, normNeTag);
                }
                NumberSequenceClassifier.transferAnnotations((CoreLabel)output.get(i), (CoreLabel)tokens.get(i));
            }
            if (this.VERBOSE) {
                first = true;
                System.err.print("NERCombinerAnnotator output: [");
                for (CoreLabel w : tokens) {
                    if (first) {
                        first = false;
                    } else {
                        System.err.print(", ");
                    }
                    System.err.print(w.toShorterString("Word", "NamedEntityTag", "NormalizedNamedEntityTag"));
                }
                System.err.println(']');
            }
        } else {
            for (i = 0; i < tokens.size(); ++i) {
                ((CoreLabel)tokens.get(i)).setNER("O");
            }
        }
    }

    @Override
    public void doOneFailedSentence(Annotation annotation, CoreMap sentence) {
        List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
        for (CoreLabel token : tokens) {
            if (token.ner() != null) continue;
            token.setNER(this.ner.backgroundSymbol());
        }
    }

    @Override
    public Set<Annotator.Requirement> requires() {
        if (this.ner.usesSUTime() || this.ner.appliesNumericClassifiers()) {
            return TOKENIZE_SSPLIT_POS_LEMMA;
        }
        return TOKENIZE_AND_SSPLIT;
    }

    @Override
    public Set<Annotator.Requirement> requirementsSatisfied() {
        return Collections.singleton(NER_REQUIREMENT);
    }
}

