/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.trees.TreePrint;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class AnnotationOutputter {
    private static final TreePrint DEFAULT_CONSTITUENT_TREE_PRINTER = new TreePrint("penn");
    private static final Options DEFAULT_OPTIONS = new Options();

    public abstract void print(Annotation var1, OutputStream var2, Options var3) throws IOException;

    public void print(Annotation annotation, OutputStream os) throws IOException {
        this.print(annotation, os, DEFAULT_OPTIONS);
    }

    public void print(Annotation annotation, OutputStream os, StanfordCoreNLP pipeline) throws IOException {
        this.print(annotation, os, AnnotationOutputter.getOptions(pipeline));
    }

    public String print(Annotation ann, Options options) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.print(ann, (OutputStream)os, options);
        os.close();
        return new String(os.toByteArray());
    }

    public String print(Annotation ann) throws IOException {
        return this.print(ann, DEFAULT_OPTIONS);
    }

    public String print(Annotation ann, StanfordCoreNLP pipeline) throws IOException {
        return this.print(ann, AnnotationOutputter.getOptions(pipeline));
    }

    public static Options getOptions(StanfordCoreNLP pipeline) {
        Options options = new Options();
        options.relationsBeam = pipeline.getBeamPrintingOption();
        options.constituentTreePrinter = pipeline.getConstituentTreePrinter();
        options.encoding = pipeline.getEncoding();
        options.printSingletons = pipeline.getPrintSingletons();
        options.beamPrintingOption = pipeline.getBeamPrintingOption();
        return options;
    }

    static /* synthetic */ TreePrint access$000() {
        return DEFAULT_CONSTITUENT_TREE_PRINTER;
    }

    public static class Options {
        public boolean includeText = false;
        public int coreferenceContextSize = 0;
        public double relationsBeam = 0.0;
        public String encoding = "UTF-8";
        public TreePrint constituentTreePrinter = AnnotationOutputter.access$000();
        public boolean printSingletons = false;
        public double beamPrintingOption = 0.0;
    }
}

