/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationCreator;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public abstract class AbstractTextAnnotationCreator
implements AnnotationCreator {
    @Override
    public Annotation createFromFile(String filename) throws IOException {
        BufferedReader r = IOUtils.getBufferedFileReader(filename);
        Annotation anno = this.create(r);
        IOUtils.closeIgnoringExceptions(r);
        return anno;
    }

    @Override
    public Annotation createFromFile(File file) throws IOException {
        return this.createFromFile(file.getAbsolutePath());
    }

    @Override
    public Annotation create(InputStream stream) throws IOException {
        return this.create(new InputStreamReader(stream));
    }

    @Override
    public Annotation create(InputStream stream, String encoding) throws IOException {
        return this.create(new InputStreamReader(stream, encoding));
    }

    @Override
    public Annotation create(Reader reader) throws IOException {
        String text = IOUtils.slurpReader(reader);
        return this.createFromText(text);
    }
}

