/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.common.ParserConstraint;
import edu.stanford.nlp.parser.lexparser.BinaryGrammar;
import edu.stanford.nlp.parser.lexparser.BinaryRule;
import edu.stanford.nlp.parser.lexparser.ExhaustivePCFGParser;
import edu.stanford.nlp.parser.lexparser.Lexicon;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.UnaryGrammar;
import edu.stanford.nlp.parser.lexparser.UnaryRule;
import edu.stanford.nlp.util.Index;
import java.util.regex.Matcher;

public class IterativeCKYPCFGParser
extends ExhaustivePCFGParser {
    private static final float STEP_SIZE = -11.0f;

    public IterativeCKYPCFGParser(BinaryGrammar bg, UnaryGrammar ug, Lexicon lex, Options op, Index<String> stateIndex, Index<String> wordIndex, Index<String> tagIndex) {
        super(bg, ug, lex, op, stateIndex, wordIndex, tagIndex);
    }

    @Override
    void doInsideScores() {
        float threshold = -11.0f;
        while (!this.doInsideScoresHelper(threshold)) {
            threshold += -11.0f;
        }
    }

    private boolean doInsideScoresHelper(float threshold) {
        boolean prunedSomething = false;
        for (int diff = 2; diff <= this.length; ++diff) {
            for (int start = 0; start < (diff == this.length ? 1 : this.length - diff); ++start) {
                int newWordsInSpan;
                float tot;
                float normTot;
                int bestWordsInSpan;
                boolean foundBetter;
                int split;
                float bestIScore;
                float oldIScore;
                int parentState;
                float pS;
                int max;
                int max2;
                int max1;
                int min;
                int min2;
                int min1;
                BinaryRule r;
                int i;
                int end = start + diff;
                if (this.getConstraints() != null) {
                    boolean skip = false;
                    for (ParserConstraint c : this.getConstraints()) {
                        if ((start <= c.start || start >= c.end || end <= c.end) && (end <= c.start || end >= c.end || start >= c.start)) continue;
                        skip = true;
                        break;
                    }
                    if (skip) continue;
                }
                for (int leftState = 0; leftState < this.numStates; ++leftState) {
                    boolean iPossibleL;
                    int narrowR = this.narrowRExtent[start][leftState];
                    boolean bl = iPossibleL = narrowR < end;
                    if (!iPossibleL) continue;
                    BinaryRule[] leftRules = this.bg.splitRulesWithLC(leftState);
                    for (i = 0; i < leftRules.length; ++i) {
                        boolean iPossibleR;
                        r = leftRules[i];
                        int narrowL = this.narrowLExtent[end][r.rightChild];
                        boolean bl2 = iPossibleR = narrowL >= narrowR;
                        if (!iPossibleR) continue;
                        min1 = narrowR;
                        min2 = this.wideLExtent[end][r.rightChild];
                        int n = min = min1 > min2 ? min1 : min2;
                        if (min > narrowL) continue;
                        max1 = this.wideRExtent[start][leftState];
                        max2 = narrowL;
                        int n2 = max = max1 < max2 ? max1 : max2;
                        if (min > max) continue;
                        pS = r.score;
                        parentState = r.parent;
                        bestIScore = oldIScore = this.iScore[start][end][parentState];
                        if (!this.op.testOptions.lengthNormalization) {
                            for (split = min; split <= max; ++split) {
                                float tot2;
                                float rS;
                                float lS;
                                if (this.getConstraints() != null) {
                                    boolean skip = false;
                                    for (ParserConstraint c : this.getConstraints()) {
                                        String tag;
                                        Matcher m;
                                        if ((start < c.start && end >= c.end || start <= c.start && end > c.end) && split > c.start && split < c.end) {
                                            skip = true;
                                            break;
                                        }
                                        if (start == c.start && split == c.end && !(m = c.state.matcher(tag = (String)this.stateIndex.get(leftState))).matches()) {
                                            skip = true;
                                            break;
                                        }
                                        if (split != c.start || end != c.end || (m = c.state.matcher(tag = (String)this.stateIndex.get(r.rightChild))).matches()) continue;
                                        skip = true;
                                        break;
                                    }
                                    if (skip) continue;
                                }
                                if ((lS = this.iScore[start][split][leftState]) == Float.NEGATIVE_INFINITY || (rS = this.iScore[split][end][r.rightChild]) == Float.NEGATIVE_INFINITY || !((tot2 = pS + lS + rS) > bestIScore)) continue;
                                bestIScore = tot2;
                            }
                            foundBetter = bestIScore > oldIScore;
                        } else {
                            float oldNormIScore;
                            bestWordsInSpan = this.wordsInSpan[start][end][parentState];
                            float bestNormIScore = oldNormIScore = oldIScore / (float)bestWordsInSpan;
                            for (int split2 = min; split2 <= max; ++split2) {
                                float rS;
                                float lS = this.iScore[start][split2][leftState];
                                if (lS == Float.NEGATIVE_INFINITY || (rS = this.iScore[split2][end][r.rightChild]) == Float.NEGATIVE_INFINITY || !((normTot = (tot = pS + lS + rS) / (float)(newWordsInSpan = this.wordsInSpan[start][split2][leftState] + this.wordsInSpan[split2][end][r.rightChild])) > bestNormIScore)) continue;
                                bestIScore = tot;
                                bestNormIScore = normTot;
                                bestWordsInSpan = newWordsInSpan;
                            }
                            boolean bl3 = foundBetter = bestNormIScore > oldNormIScore;
                            if (foundBetter && bestIScore > threshold) {
                                this.wordsInSpan[start][end][parentState] = bestWordsInSpan;
                            }
                        }
                        if (!foundBetter) continue;
                        if (bestIScore > threshold) {
                            this.iScore[start][end][parentState] = bestIScore;
                            if (oldIScore != Float.NEGATIVE_INFINITY) continue;
                            if (start > this.narrowLExtent[end][parentState]) {
                                this.narrowLExtent[end][parentState] = start;
                                this.wideLExtent[end][parentState] = start;
                            } else if (start < this.wideLExtent[end][parentState]) {
                                this.wideLExtent[end][parentState] = start;
                            }
                            if (end < this.narrowRExtent[start][parentState]) {
                                this.narrowRExtent[start][parentState] = end;
                                this.wideRExtent[start][parentState] = end;
                                continue;
                            }
                            if (end <= this.wideRExtent[start][parentState]) continue;
                            this.wideRExtent[start][parentState] = end;
                            continue;
                        }
                        prunedSomething = true;
                    }
                }
                for (int rightState = 0; rightState < this.numStates; ++rightState) {
                    boolean iPossibleR;
                    int narrowL = this.narrowLExtent[end][rightState];
                    boolean bl = iPossibleR = narrowL > start;
                    if (!iPossibleR) continue;
                    BinaryRule[] rightRules = this.bg.splitRulesWithRC(rightState);
                    for (i = 0; i < rightRules.length; ++i) {
                        boolean iPossibleL;
                        r = rightRules[i];
                        int narrowR = this.narrowRExtent[start][r.leftChild];
                        boolean bl4 = iPossibleL = narrowR <= narrowL;
                        if (!iPossibleL) continue;
                        min1 = narrowR;
                        min2 = this.wideLExtent[end][rightState];
                        int n = min = min1 > min2 ? min1 : min2;
                        if (min > narrowL) continue;
                        max1 = this.wideRExtent[start][r.leftChild];
                        max2 = narrowL;
                        int n3 = max = max1 < max2 ? max1 : max2;
                        if (min > max) continue;
                        pS = r.score;
                        parentState = r.parent;
                        bestIScore = oldIScore = this.iScore[start][end][parentState];
                        if (!this.op.testOptions.lengthNormalization) {
                            for (split = min; split <= max; ++split) {
                                float tot3;
                                float rS;
                                float lS;
                                if (this.getConstraints() != null) {
                                    boolean skip = false;
                                    for (ParserConstraint c : this.getConstraints()) {
                                        String tag;
                                        Matcher m;
                                        if ((start < c.start && end >= c.end || start <= c.start && end > c.end) && split > c.start && split < c.end) {
                                            skip = true;
                                            break;
                                        }
                                        if (start == c.start && split == c.end && !(m = c.state.matcher(tag = (String)this.stateIndex.get(r.leftChild))).matches()) {
                                            skip = true;
                                            break;
                                        }
                                        if (split != c.start || end != c.end || (m = c.state.matcher(tag = (String)this.stateIndex.get(rightState))).matches()) continue;
                                        skip = true;
                                        break;
                                    }
                                    if (skip) continue;
                                }
                                if ((lS = this.iScore[start][split][r.leftChild]) == Float.NEGATIVE_INFINITY || (rS = this.iScore[split][end][rightState]) == Float.NEGATIVE_INFINITY || !((tot3 = pS + lS + rS) > bestIScore)) continue;
                                bestIScore = tot3;
                            }
                            foundBetter = bestIScore > oldIScore;
                        } else {
                            float oldNormIScore;
                            bestWordsInSpan = this.wordsInSpan[start][end][parentState];
                            float bestNormIScore = oldNormIScore = oldIScore / (float)bestWordsInSpan;
                            for (int split3 = min; split3 <= max; ++split3) {
                                float rS;
                                float lS = this.iScore[start][split3][r.leftChild];
                                if (lS == Float.NEGATIVE_INFINITY || (rS = this.iScore[split3][end][rightState]) == Float.NEGATIVE_INFINITY || !((normTot = (tot = pS + lS + rS) / (float)(newWordsInSpan = this.wordsInSpan[start][split3][r.leftChild] + this.wordsInSpan[split3][end][rightState])) > bestNormIScore)) continue;
                                bestIScore = tot;
                                bestNormIScore = normTot;
                                bestWordsInSpan = newWordsInSpan;
                            }
                            boolean bl5 = foundBetter = bestNormIScore > oldNormIScore;
                            if (foundBetter) {
                                this.wordsInSpan[start][end][parentState] = bestWordsInSpan;
                            }
                        }
                        if (!foundBetter) continue;
                        if (bestIScore > threshold) {
                            this.iScore[start][end][parentState] = bestIScore;
                            if (oldIScore != Float.NEGATIVE_INFINITY) continue;
                            if (start > this.narrowLExtent[end][parentState]) {
                                this.narrowLExtent[end][parentState] = start;
                                this.wideLExtent[end][parentState] = start;
                            } else if (start < this.wideLExtent[end][parentState]) {
                                this.wideLExtent[end][parentState] = start;
                            }
                            if (end < this.narrowRExtent[start][parentState]) {
                                this.narrowRExtent[start][parentState] = end;
                                this.wideRExtent[start][parentState] = end;
                                continue;
                            }
                            if (end <= this.wideRExtent[start][parentState]) continue;
                            this.wideRExtent[start][parentState] = end;
                            continue;
                        }
                        prunedSomething = true;
                    }
                }
                for (int state = 0; state < this.numStates; ++state) {
                    float iS = this.iScore[start][end][state];
                    if (iS == Float.NEGATIVE_INFINITY) continue;
                    UnaryRule[] unaries = this.ug.closedRulesByChild(state);
                    for (int r2 = 0; r2 < unaries.length; ++r2) {
                        boolean foundBetter2;
                        UnaryRule ur = unaries[r2];
                        if (this.getConstraints() != null) {
                            boolean skip = false;
                            for (ParserConstraint c : this.getConstraints()) {
                                String tag;
                                Matcher m;
                                if (start != c.start || end != c.end || (m = c.state.matcher(tag = (String)this.stateIndex.get(ur.parent))).matches()) continue;
                                skip = true;
                                break;
                            }
                            if (skip) continue;
                        }
                        int parentState2 = ur.parent;
                        float pS2 = ur.score;
                        float tot4 = iS + pS2;
                        float cur = this.iScore[start][end][parentState2];
                        if (this.op.testOptions.lengthNormalization) {
                            int totWordsInSpan = this.wordsInSpan[start][end][state];
                            float normTot2 = tot4 / (float)totWordsInSpan;
                            int curWordsInSpan = this.wordsInSpan[start][end][parentState2];
                            float normCur = cur / (float)curWordsInSpan;
                            boolean bl = foundBetter2 = normTot2 > normCur;
                            if (foundBetter2 && tot4 > threshold) {
                                this.wordsInSpan[start][end][parentState2] = this.wordsInSpan[start][end][state];
                            }
                        } else {
                            boolean bl = foundBetter2 = tot4 > cur;
                        }
                        if (!foundBetter2) continue;
                        if (tot4 > threshold) {
                            this.iScore[start][end][parentState2] = tot4;
                            if (cur != Float.NEGATIVE_INFINITY) continue;
                            if (start > this.narrowLExtent[end][parentState2]) {
                                this.narrowLExtent[end][parentState2] = start;
                                this.wideLExtent[end][parentState2] = start;
                            } else if (start < this.wideLExtent[end][parentState2]) {
                                this.wideLExtent[end][parentState2] = start;
                            }
                            if (end < this.narrowRExtent[start][parentState2]) {
                                this.narrowRExtent[start][parentState2] = end;
                                this.wideRExtent[start][parentState2] = end;
                                continue;
                            }
                            if (end <= this.wideRExtent[start][parentState2]) continue;
                            this.wideRExtent[start][parentState2] = end;
                            continue;
                        }
                        prunedSomething = true;
                    }
                }
            }
        }
        int goal = this.stateIndex.indexOf(this.goalStr);
        return this.iScore[0][this.length][goal] > Float.NEGATIVE_INFINITY || !prunedSomething;
    }
}

