/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.international.french.FrenchUnknownWordSignatures;
import edu.stanford.nlp.parser.lexparser.BaseUnknownWordModel;
import edu.stanford.nlp.parser.lexparser.IntTaggedWord;
import edu.stanford.nlp.parser.lexparser.Lexicon;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.util.Index;

public class FrenchUnknownWordModel
extends BaseUnknownWordModel {
    private static final long serialVersionUID = -776564693549194424L;
    protected final boolean smartMutation;
    protected final int unknownSuffixSize;
    protected final int unknownPrefixSize;

    public FrenchUnknownWordModel(Options op, Lexicon lex, Index<String> wordIndex, Index<String> tagIndex, ClassicCounter<IntTaggedWord> unSeenCounter) {
        super(op, lex, wordIndex, tagIndex, unSeenCounter, null, null, null);
        this.smartMutation = op.lexOptions.smartMutation;
        this.unknownSuffixSize = op.lexOptions.unknownSuffixSize;
        this.unknownPrefixSize = op.lexOptions.unknownPrefixSize;
    }

    public FrenchUnknownWordModel(Options op, Lexicon lex, Index<String> wordIndex, Index<String> tagIndex) {
        this(op, lex, wordIndex, tagIndex, new ClassicCounter<IntTaggedWord>());
    }

    @Override
    public float score(IntTaggedWord iTW, int loc, double c_Tseen, double total, double smooth, String word) {
        int wordSig = this.getSignatureIndex(iTW.word, loc, word);
        IntTaggedWord temp = new IntTaggedWord(wordSig, iTW.tag);
        double c_TS = this.unSeenCounter.getCount(temp);
        temp = new IntTaggedWord(wordSig, -1);
        double c_S = this.unSeenCounter.getCount(temp);
        double c_U = this.unSeenCounter.getCount(NULL_ITW);
        temp = new IntTaggedWord(-1, iTW.tag);
        double c_T = this.unSeenCounter.getCount(temp);
        double p_T_U = c_T / c_U;
        if (this.unknownLevel == 0) {
            c_TS = 0.0;
            c_S = 0.0;
        }
        double pb_T_S = (c_TS + smooth * p_T_U) / (c_S + smooth);
        double p_T = c_Tseen / total;
        double p_W = 1.0 / total;
        double pb_W_T = Math.log(pb_T_S * p_W / p_T);
        return (float)pb_W_T;
    }

    @Override
    public int getSignatureIndex(int index, int sentencePosition, String word) {
        String uwSig = this.getSignature(word, sentencePosition);
        int sig = this.wordIndex.addToIndex(uwSig);
        return sig;
    }

    @Override
    public String getSignature(String word, int loc) {
        String BASE_LABEL = "UNK";
        StringBuilder sb = new StringBuilder("UNK");
        switch (this.unknownLevel) {
            case 1: {
                sb.append(FrenchUnknownWordSignatures.nounSuffix(word));
                if (sb.toString().equals("UNK")) {
                    sb.append(FrenchUnknownWordSignatures.adjSuffix(word));
                    if (sb.toString().equals("UNK")) {
                        sb.append(FrenchUnknownWordSignatures.verbSuffix(word));
                        if (sb.toString().equals("UNK")) {
                            sb.append(FrenchUnknownWordSignatures.advSuffix(word));
                        }
                    }
                }
                sb.append(FrenchUnknownWordSignatures.possiblePlural(word));
                String hasDigit = FrenchUnknownWordSignatures.hasDigit(word);
                String isDigit = FrenchUnknownWordSignatures.isDigit(word);
                if (!hasDigit.equals("")) {
                    if (isDigit.equals("")) {
                        sb.append(hasDigit);
                    } else {
                        sb.append(isDigit);
                    }
                }
                sb.append(FrenchUnknownWordSignatures.hasPunc(word));
                sb.append(FrenchUnknownWordSignatures.isAllCaps(word));
                if (loc > 0 && FrenchUnknownWordSignatures.isAllCaps(word).equals("")) {
                    sb.append(FrenchUnknownWordSignatures.isCapitalized(word));
                }
                if (this.unknownSuffixSize <= 0 || !sb.toString().equals("UNK")) break;
                int min = word.length() < this.unknownSuffixSize ? word.length() : this.unknownSuffixSize;
                sb.append('-').append(word.substring(word.length() - min));
                break;
            }
            default: {
                System.err.printf("%s: Invalid unknown word signature! (%d)%n", this.getClass().getName(), this.unknownLevel);
            }
        }
        return sb.toString();
    }
}

