/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.common;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.parser.common.ParserQuery;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.TreebankLangParserParams;
import edu.stanford.nlp.parser.metrics.Eval;
import edu.stanford.nlp.parser.metrics.ParserQueryEval;
import edu.stanford.nlp.process.Morphology;
import edu.stanford.nlp.process.Tokenizer;
import edu.stanford.nlp.process.TokenizerFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.ReflectionLoading;
import edu.stanford.nlp.util.Timing;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public abstract class ParserGrammar
implements Function<List<? extends HasWord>, Tree> {
    private transient Function<List<? extends HasWord>, List<TaggedWord>> tagger;
    private transient String taggerPath;

    public abstract ParserQuery parserQuery();

    @Override
    public Tree apply(List<? extends HasWord> words) {
        return this.parse(words);
    }

    public List<? extends HasWord> tokenize(String sentence) {
        TokenizerFactory<? extends HasWord> tf = this.treebankLanguagePack().getTokenizerFactory();
        Tokenizer<? extends HasWord> tokenizer = tf.getTokenizer(new StringReader(sentence));
        List<? extends HasWord> tokens = tokenizer.tokenize();
        return tokens;
    }

    public Tree parse(String sentence) {
        List<? extends HasWord> tokens = this.tokenize(sentence);
        if (this.getOp().testOptions.preTag) {
            Function<List<? extends HasWord>, List<TaggedWord>> tagger = this.loadTagger();
            tokens = tagger.apply(tokens);
        }
        return this.parse(tokens);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Function<List<? extends HasWord>, List<TaggedWord>> loadTagger() {
        Options op = this.getOp();
        if (op.testOptions.preTag) {
            ParserGrammar parserGrammar = this;
            synchronized (parserGrammar) {
                if (!op.testOptions.taggerSerializedFile.equals(this.taggerPath)) {
                    this.taggerPath = op.testOptions.taggerSerializedFile;
                    this.tagger = (Function)ReflectionLoading.loadByReflection("edu.stanford.nlp.tagger.maxent.MaxentTagger", this.taggerPath);
                }
                return this.tagger;
            }
        }
        return null;
    }

    public List<CoreLabel> lemmatize(String sentence) {
        List<? extends HasWord> tokens = this.tokenize(sentence);
        return this.lemmatize(tokens);
    }

    public List<CoreLabel> lemmatize(List<? extends HasWord> tokens) {
        List<TaggedWord> tagged;
        if (this.getOp().testOptions.preTag) {
            Function<List<? extends HasWord>, List<TaggedWord>> tagger = this.loadTagger();
            tagged = tagger.apply(tokens);
        } else {
            Tree tree = this.parse(tokens);
            tagged = tree.taggedYield();
        }
        Morphology morpha = new Morphology();
        ArrayList<CoreLabel> lemmas = Generics.newArrayList();
        for (TaggedWord token : tagged) {
            CoreLabel label = new CoreLabel();
            label.setWord(token.word());
            label.setTag(token.tag());
            morpha.stem(label);
            lemmas.add(label);
        }
        return lemmas;
    }

    public abstract Tree parse(List<? extends HasWord> var1);

    public abstract List<Eval> getExtraEvals();

    public abstract List<ParserQueryEval> getParserQueryEvals();

    public abstract Options getOp();

    public abstract TreebankLangParserParams getTLPParams();

    public abstract TreebankLanguagePack treebankLanguagePack();

    public abstract String[] defaultCoreNLPFlags();

    public abstract void setOptionFlags(String ... var1);

    public abstract boolean requiresTags();

    public static ParserGrammar loadModel(String path, String ... extraFlags) {
        ParserGrammar parser;
        try {
            Timing timing = new Timing();
            System.err.print("Loading parser from serialized file " + path + " ... ");
            parser = (ParserGrammar)IOUtils.readObjectFromURLOrClasspathOrFileSystem(path);
            timing.done();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeIOException(e);
        }
        if (extraFlags.length > 0) {
            parser.setOptionFlags(extraFlags);
        }
        return parser;
    }
}

