/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.naturalli;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum NaturalLogicRelation {
    EQUIVALENT(0, true, false),
    FORWARD_ENTAILMENT(1, true, false),
    REVERSE_ENTAILMENT(2, false, false),
    NEGATION(3, false, true),
    ALTERNATION(4, false, true),
    COVER(5, false, false),
    INDEPENDENCE(6, false, false);

    public final int fixedIndex;
    public final boolean isEntailed;
    public final boolean isNegated;
    private static final Map<String, NaturalLogicRelation> insertArcToNaturalLogicRelation;

    private NaturalLogicRelation(int fixedIndex, boolean isEntailed, boolean isNegated) {
        this.fixedIndex = fixedIndex;
        this.isEntailed = isEntailed;
        this.isNegated = isNegated;
    }

    protected static NaturalLogicRelation byFixedIndex(int index) {
        switch (index) {
            case 0: {
                return EQUIVALENT;
            }
            case 1: {
                return FORWARD_ENTAILMENT;
            }
            case 2: {
                return REVERSE_ENTAILMENT;
            }
            case 3: {
                return NEGATION;
            }
            case 4: {
                return ALTERNATION;
            }
            case 5: {
                return COVER;
            }
            case 6: {
                return INDEPENDENCE;
            }
        }
        throw new IllegalArgumentException("Unknown index for Natural Logic relation: " + index);
    }

    public NaturalLogicRelation join(NaturalLogicRelation other) {
        switch (this) {
            case EQUIVALENT: {
                return other;
            }
            case FORWARD_ENTAILMENT: {
                switch (other) {
                    case EQUIVALENT: 
                    case FORWARD_ENTAILMENT: {
                        return FORWARD_ENTAILMENT;
                    }
                    case NEGATION: 
                    case ALTERNATION: {
                        return COVER;
                    }
                    case REVERSE_ENTAILMENT: 
                    case COVER: 
                    case INDEPENDENCE: {
                        return INDEPENDENCE;
                    }
                }
            }
            case REVERSE_ENTAILMENT: {
                switch (other) {
                    case EQUIVALENT: 
                    case REVERSE_ENTAILMENT: {
                        return REVERSE_ENTAILMENT;
                    }
                    case NEGATION: 
                    case COVER: {
                        return COVER;
                    }
                    case FORWARD_ENTAILMENT: 
                    case ALTERNATION: 
                    case INDEPENDENCE: {
                        return INDEPENDENCE;
                    }
                }
            }
            case NEGATION: {
                switch (other) {
                    case EQUIVALENT: {
                        return NEGATION;
                    }
                    case FORWARD_ENTAILMENT: {
                        return COVER;
                    }
                    case REVERSE_ENTAILMENT: {
                        return ALTERNATION;
                    }
                    case NEGATION: {
                        return EQUIVALENT;
                    }
                    case ALTERNATION: {
                        return REVERSE_ENTAILMENT;
                    }
                    case COVER: {
                        return FORWARD_ENTAILMENT;
                    }
                    case INDEPENDENCE: {
                        return INDEPENDENCE;
                    }
                }
            }
            case ALTERNATION: {
                switch (other) {
                    case EQUIVALENT: 
                    case REVERSE_ENTAILMENT: {
                        return ALTERNATION;
                    }
                    case NEGATION: 
                    case COVER: {
                        return FORWARD_ENTAILMENT;
                    }
                    case FORWARD_ENTAILMENT: 
                    case ALTERNATION: 
                    case INDEPENDENCE: {
                        return INDEPENDENCE;
                    }
                }
            }
            case COVER: {
                switch (other) {
                    case EQUIVALENT: 
                    case FORWARD_ENTAILMENT: {
                        return COVER;
                    }
                    case NEGATION: 
                    case ALTERNATION: {
                        return REVERSE_ENTAILMENT;
                    }
                    case REVERSE_ENTAILMENT: 
                    case COVER: 
                    case INDEPENDENCE: {
                        return INDEPENDENCE;
                    }
                }
            }
            case INDEPENDENCE: {
                return INDEPENDENCE;
            }
        }
        throw new IllegalStateException("[should be impossible]: Incomplete join table for " + (Object)((Object)this) + " joined with " + (Object)((Object)other));
    }

    public static boolean knownDependencyArc(String dependencyLabel) {
        return insertArcToNaturalLogicRelation.containsKey(dependencyLabel.toLowerCase());
    }

    public static NaturalLogicRelation forDependencyInsertion(String dependencyLabel) {
        return NaturalLogicRelation.forDependencyInsertion(dependencyLabel, true);
    }

    public static NaturalLogicRelation forDependencyInsertion(String dependencyLabel, boolean isSubject) {
        NaturalLogicRelation rel;
        if (!isSubject) {
            switch (dependencyLabel) {
                case "conj_or": 
                case "conj_nor": {
                    return NaturalLogicRelation.forDependencyInsertion("conj_and", false);
                }
            }
        }
        if ((rel = insertArcToNaturalLogicRelation.get(dependencyLabel.toLowerCase())) != null) {
            return rel;
        }
        if (dependencyLabel.startsWith("prep_")) {
            return REVERSE_ENTAILMENT;
        }
        if (dependencyLabel.startsWith("conj_")) {
            return REVERSE_ENTAILMENT;
        }
        return INDEPENDENCE;
    }

    private static NaturalLogicRelation insertionToDeletion(NaturalLogicRelation insertionRel) {
        switch (insertionRel) {
            case EQUIVALENT: {
                return EQUIVALENT;
            }
            case FORWARD_ENTAILMENT: {
                return REVERSE_ENTAILMENT;
            }
            case REVERSE_ENTAILMENT: {
                return FORWARD_ENTAILMENT;
            }
            case NEGATION: {
                return NEGATION;
            }
            case ALTERNATION: {
                return COVER;
            }
            case COVER: {
                return ALTERNATION;
            }
            case INDEPENDENCE: {
                return INDEPENDENCE;
            }
        }
        throw new IllegalStateException("Unhandled natural logic relation: " + (Object)((Object)insertionRel));
    }

    public static NaturalLogicRelation forDependencyDeletion(String dependencyLabel) {
        return NaturalLogicRelation.forDependencyDeletion(dependencyLabel, true);
    }

    public static NaturalLogicRelation forDependencyDeletion(String dependencyLabel, boolean isSubject) {
        NaturalLogicRelation rel = NaturalLogicRelation.forDependencyInsertion(dependencyLabel, isSubject);
        return NaturalLogicRelation.insertionToDeletion(rel);
    }

    static {
        insertArcToNaturalLogicRelation = Collections.unmodifiableMap(new HashMap<String, NaturalLogicRelation>(){
            {
                this.put("acomp", REVERSE_ENTAILMENT);
                this.put("advcl", REVERSE_ENTAILMENT);
                this.put("advmod", REVERSE_ENTAILMENT);
                this.put("agent", INDEPENDENCE);
                this.put("amod", REVERSE_ENTAILMENT);
                this.put("appos", REVERSE_ENTAILMENT);
                this.put("aux", INDEPENDENCE);
                this.put("auxpass", INDEPENDENCE);
                this.put("ccomp", INDEPENDENCE);
                this.put("cc", REVERSE_ENTAILMENT);
                this.put("conj_and\\/or", REVERSE_ENTAILMENT);
                this.put("conj_and", REVERSE_ENTAILMENT);
                this.put("conj_both", REVERSE_ENTAILMENT);
                this.put("conj_but", REVERSE_ENTAILMENT);
                this.put("conj_nor", FORWARD_ENTAILMENT);
                this.put("conj_or", FORWARD_ENTAILMENT);
                this.put("conj_plus", FORWARD_ENTAILMENT);
                this.put("conj", REVERSE_ENTAILMENT);
                this.put("conj_x", REVERSE_ENTAILMENT);
                this.put("cop", INDEPENDENCE);
                this.put("csubj", INDEPENDENCE);
                this.put("csubjpass", INDEPENDENCE);
                this.put("dep", INDEPENDENCE);
                this.put("det", FORWARD_ENTAILMENT);
                this.put("discourse", EQUIVALENT);
                this.put("dobj", REVERSE_ENTAILMENT);
                this.put("expl", EQUIVALENT);
                this.put("goeswith", EQUIVALENT);
                this.put("infmod", REVERSE_ENTAILMENT);
                this.put("iobj", REVERSE_ENTAILMENT);
                this.put("mark", REVERSE_ENTAILMENT);
                this.put("mwe", INDEPENDENCE);
                this.put("neg", NEGATION);
                this.put("nn", INDEPENDENCE);
                this.put("npadvmod", REVERSE_ENTAILMENT);
                this.put("nsubj", INDEPENDENCE);
                this.put("nsubjpass", INDEPENDENCE);
                this.put("number", INDEPENDENCE);
                this.put("num", INDEPENDENCE);
                this.put("op", INDEPENDENCE);
                this.put("parataxis", INDEPENDENCE);
                this.put("partmod", REVERSE_ENTAILMENT);
                this.put("pcomp", INDEPENDENCE);
                this.put("pobj", INDEPENDENCE);
                this.put("possessive", INDEPENDENCE);
                this.put("poss", REVERSE_ENTAILMENT);
                this.put("preconj", INDEPENDENCE);
                this.put("predet", INDEPENDENCE);
                this.put("prep_aboard", REVERSE_ENTAILMENT);
                this.put("prep_about", REVERSE_ENTAILMENT);
                this.put("prep_above", REVERSE_ENTAILMENT);
                this.put("prep_according_to", REVERSE_ENTAILMENT);
                this.put("prep_across_from", REVERSE_ENTAILMENT);
                this.put("prep_across", REVERSE_ENTAILMENT);
                this.put("prep_after", REVERSE_ENTAILMENT);
                this.put("prep_against", REVERSE_ENTAILMENT);
                this.put("prep_ahead_of", REVERSE_ENTAILMENT);
                this.put("prep_along", REVERSE_ENTAILMENT);
                this.put("prep_alongside_of", REVERSE_ENTAILMENT);
                this.put("prep_alongside", REVERSE_ENTAILMENT);
                this.put("prep_along_with", REVERSE_ENTAILMENT);
                this.put("prep_amid", REVERSE_ENTAILMENT);
                this.put("prep_among", REVERSE_ENTAILMENT);
                this.put("prep_anti", REVERSE_ENTAILMENT);
                this.put("prep_apart_from", REVERSE_ENTAILMENT);
                this.put("prep_around", REVERSE_ENTAILMENT);
                this.put("prep_as_for", REVERSE_ENTAILMENT);
                this.put("prep_as_from", REVERSE_ENTAILMENT);
                this.put("prep_aside_from", REVERSE_ENTAILMENT);
                this.put("prep_as_of", REVERSE_ENTAILMENT);
                this.put("prep_as_per", REVERSE_ENTAILMENT);
                this.put("prep_as", REVERSE_ENTAILMENT);
                this.put("prep_as_to", REVERSE_ENTAILMENT);
                this.put("prep_at", REVERSE_ENTAILMENT);
                this.put("prep_away_from", REVERSE_ENTAILMENT);
                this.put("prep_based_on", REVERSE_ENTAILMENT);
                this.put("prep_because_of", REVERSE_ENTAILMENT);
                this.put("prep_before", REVERSE_ENTAILMENT);
                this.put("prep_behind", REVERSE_ENTAILMENT);
                this.put("prep_below", REVERSE_ENTAILMENT);
                this.put("prep_beneath", REVERSE_ENTAILMENT);
                this.put("prep_beside", REVERSE_ENTAILMENT);
                this.put("prep_besides", REVERSE_ENTAILMENT);
                this.put("prep_between", REVERSE_ENTAILMENT);
                this.put("prep_beyond", REVERSE_ENTAILMENT);
                this.put("prep_but", REVERSE_ENTAILMENT);
                this.put("prep_by_means_of", REVERSE_ENTAILMENT);
                this.put("prep_by", REVERSE_ENTAILMENT);
                this.put("prepc_aboard", REVERSE_ENTAILMENT);
                this.put("prepc_about", REVERSE_ENTAILMENT);
                this.put("prepc_above", REVERSE_ENTAILMENT);
                this.put("prepc_according_to", REVERSE_ENTAILMENT);
                this.put("prepc_across_from", REVERSE_ENTAILMENT);
                this.put("prepc_across", REVERSE_ENTAILMENT);
                this.put("prepc_after", REVERSE_ENTAILMENT);
                this.put("prepc_against", REVERSE_ENTAILMENT);
                this.put("prepc_ahead_of", REVERSE_ENTAILMENT);
                this.put("prepc_along", REVERSE_ENTAILMENT);
                this.put("prepc_alongside_of", REVERSE_ENTAILMENT);
                this.put("prepc_along_with", REVERSE_ENTAILMENT);
                this.put("prepc_amid", REVERSE_ENTAILMENT);
                this.put("prepc_among", REVERSE_ENTAILMENT);
                this.put("prepc_anti", REVERSE_ENTAILMENT);
                this.put("prepc_apart_from", REVERSE_ENTAILMENT);
                this.put("prepc_around", REVERSE_ENTAILMENT);
                this.put("prepc_as_for", REVERSE_ENTAILMENT);
                this.put("prepc_as_from", REVERSE_ENTAILMENT);
                this.put("prepc_aside_from", REVERSE_ENTAILMENT);
                this.put("prepc_as_of", REVERSE_ENTAILMENT);
                this.put("prepc_as_per", REVERSE_ENTAILMENT);
                this.put("prepc_as", REVERSE_ENTAILMENT);
                this.put("prepc_as_to", REVERSE_ENTAILMENT);
                this.put("prepc_at", REVERSE_ENTAILMENT);
                this.put("prepc_away_from", REVERSE_ENTAILMENT);
                this.put("prepc_based_on", REVERSE_ENTAILMENT);
                this.put("prepc_because_of", REVERSE_ENTAILMENT);
                this.put("prepc_before", REVERSE_ENTAILMENT);
                this.put("prepc_behind", REVERSE_ENTAILMENT);
                this.put("prepc_below", REVERSE_ENTAILMENT);
                this.put("prepc_beneath", REVERSE_ENTAILMENT);
                this.put("prepc_beside", REVERSE_ENTAILMENT);
                this.put("prepc_besides", REVERSE_ENTAILMENT);
                this.put("prepc_between", REVERSE_ENTAILMENT);
                this.put("prepc_beyond", REVERSE_ENTAILMENT);
                this.put("prepc_but", REVERSE_ENTAILMENT);
                this.put("prepc_by_means_of", REVERSE_ENTAILMENT);
                this.put("prepc_by", REVERSE_ENTAILMENT);
                this.put("prepc_close_by", REVERSE_ENTAILMENT);
                this.put("prepc_close_to", REVERSE_ENTAILMENT);
                this.put("prepc_compared_to", REVERSE_ENTAILMENT);
                this.put("prepc_compared_with", REVERSE_ENTAILMENT);
                this.put("prepc_concerning", REVERSE_ENTAILMENT);
                this.put("prepc_considering", REVERSE_ENTAILMENT);
                this.put("prepc_contrary_to", REVERSE_ENTAILMENT);
                this.put("prepc_depending_on", REVERSE_ENTAILMENT);
                this.put("prepc_despite", REVERSE_ENTAILMENT);
                this.put("prepc_down", REVERSE_ENTAILMENT);
                this.put("prepc_due_to", REVERSE_ENTAILMENT);
                this.put("prepc_during", REVERSE_ENTAILMENT);
                this.put("prepc_except_for", REVERSE_ENTAILMENT);
                this.put("prepc_excepting", REVERSE_ENTAILMENT);
                this.put("prepc_except", REVERSE_ENTAILMENT);
                this.put("prepc_excluding", REVERSE_ENTAILMENT);
                this.put("prepc_exclusive_of", REVERSE_ENTAILMENT);
                this.put("prepc_far_from", REVERSE_ENTAILMENT);
                this.put("prepc_followed_by", REVERSE_ENTAILMENT);
                this.put("prepc_following", REVERSE_ENTAILMENT);
                this.put("prepc_for", REVERSE_ENTAILMENT);
                this.put("prepc_from", REVERSE_ENTAILMENT);
                this.put("prepc_in_accordance_with", REVERSE_ENTAILMENT);
                this.put("prepc_in_addition_to", REVERSE_ENTAILMENT);
                this.put("prepc_in_case_of", REVERSE_ENTAILMENT);
                this.put("prepc_in_front_of", REVERSE_ENTAILMENT);
                this.put("prepc_in_lieu_of", REVERSE_ENTAILMENT);
                this.put("prepc_in_place_of", REVERSE_ENTAILMENT);
                this.put("prepc_in", REVERSE_ENTAILMENT);
                this.put("prepc_inside_of", REVERSE_ENTAILMENT);
                this.put("prepc_inside", REVERSE_ENTAILMENT);
                this.put("prepc_in_spite_of", REVERSE_ENTAILMENT);
                this.put("prepc_instead_of", REVERSE_ENTAILMENT);
                this.put("prepc_into", REVERSE_ENTAILMENT);
                this.put("prepc_irrespective_of", REVERSE_ENTAILMENT);
                this.put("prepc_like", REVERSE_ENTAILMENT);
                this.put("prep_close_by", REVERSE_ENTAILMENT);
                this.put("prep_close_to", REVERSE_ENTAILMENT);
                this.put("prepc_minus", REVERSE_ENTAILMENT);
                this.put("prepc_near", REVERSE_ENTAILMENT);
                this.put("prepc_near_to", REVERSE_ENTAILMENT);
                this.put("prepc_next_to", REVERSE_ENTAILMENT);
                this.put("prepc_off_of", REVERSE_ENTAILMENT);
                this.put("prepc_off", REVERSE_ENTAILMENT);
                this.put("prepc_of", REVERSE_ENTAILMENT);
                this.put("prep_compared_to", REVERSE_ENTAILMENT);
                this.put("prep_compared_with", REVERSE_ENTAILMENT);
                this.put("prepc_on_account_of", REVERSE_ENTAILMENT);
                this.put("prepc_on_behalf_of", REVERSE_ENTAILMENT);
                this.put("prep_concerning", REVERSE_ENTAILMENT);
                this.put("prepc_on", REVERSE_ENTAILMENT);
                this.put("prep_considering", REVERSE_ENTAILMENT);
                this.put("prepc_on_top_of", REVERSE_ENTAILMENT);
                this.put("prepc_onto", REVERSE_ENTAILMENT);
                this.put("prep_contrary_to", REVERSE_ENTAILMENT);
                this.put("prepc_opposite", REVERSE_ENTAILMENT);
                this.put("prepc_out_of", REVERSE_ENTAILMENT);
                this.put("prepc_outside_of", REVERSE_ENTAILMENT);
                this.put("prepc_outside", REVERSE_ENTAILMENT);
                this.put("prepc_over", REVERSE_ENTAILMENT);
                this.put("prepc_owing_to", REVERSE_ENTAILMENT);
                this.put("prepc_past", REVERSE_ENTAILMENT);
                this.put("prepc_per", REVERSE_ENTAILMENT);
                this.put("prepc_plus", REVERSE_ENTAILMENT);
                this.put("prepc_preliminary_to", REVERSE_ENTAILMENT);
                this.put("prepc_preparatory_to", REVERSE_ENTAILMENT);
                this.put("prepc_previous_to", REVERSE_ENTAILMENT);
                this.put("prepc_prior_to", REVERSE_ENTAILMENT);
                this.put("prepc_pursuant_to", REVERSE_ENTAILMENT);
                this.put("prepc_regarding", REVERSE_ENTAILMENT);
                this.put("prepc_regardless_of", REVERSE_ENTAILMENT);
                this.put("prepc_round", REVERSE_ENTAILMENT);
                this.put("prepc_save", REVERSE_ENTAILMENT);
                this.put("prepc_since", REVERSE_ENTAILMENT);
                this.put("prepc_subsequent_to", REVERSE_ENTAILMENT);
                this.put("prepc_such_as", REVERSE_ENTAILMENT);
                this.put("prepc_thanks_to", REVERSE_ENTAILMENT);
                this.put("prepc_than", REVERSE_ENTAILMENT);
                this.put("prepc_through", REVERSE_ENTAILMENT);
                this.put("prepc_together_with", REVERSE_ENTAILMENT);
                this.put("prepc_to", REVERSE_ENTAILMENT);
                this.put("prepc_toward", REVERSE_ENTAILMENT);
                this.put("prepc_towards", REVERSE_ENTAILMENT);
                this.put("prepc_underneath", REVERSE_ENTAILMENT);
                this.put("prepc_under", REVERSE_ENTAILMENT);
                this.put("prepc_unlike", REVERSE_ENTAILMENT);
                this.put("prepc_until", REVERSE_ENTAILMENT);
                this.put("prepc_upon", REVERSE_ENTAILMENT);
                this.put("prepc_up", REVERSE_ENTAILMENT);
                this.put("prepc_versus", REVERSE_ENTAILMENT);
                this.put("prepc_via", REVERSE_ENTAILMENT);
                this.put("prepc_within", REVERSE_ENTAILMENT);
                this.put("prepc_without", REVERSE_ENTAILMENT);
                this.put("prepc_with_regard_to", REVERSE_ENTAILMENT);
                this.put("prepc_with_respect_to", REVERSE_ENTAILMENT);
                this.put("prepc_with", REVERSE_ENTAILMENT);
                this.put("prep_depending_on", REVERSE_ENTAILMENT);
                this.put("prep_dep", REVERSE_ENTAILMENT);
                this.put("prep_despite", REVERSE_ENTAILMENT);
                this.put("prep_down", REVERSE_ENTAILMENT);
                this.put("prep_due_to", REVERSE_ENTAILMENT);
                this.put("prep_during", REVERSE_ENTAILMENT);
                this.put("prep_en", REVERSE_ENTAILMENT);
                this.put("prep_except_for", REVERSE_ENTAILMENT);
                this.put("prep_excepting", REVERSE_ENTAILMENT);
                this.put("prep_except", REVERSE_ENTAILMENT);
                this.put("prep_excluding", REVERSE_ENTAILMENT);
                this.put("prep_exclusive_of", REVERSE_ENTAILMENT);
                this.put("prep_followed_by", REVERSE_ENTAILMENT);
                this.put("prep_following", REVERSE_ENTAILMENT);
                this.put("prep_for", REVERSE_ENTAILMENT);
                this.put("prep_from", REVERSE_ENTAILMENT);
                this.put("prep_if", REVERSE_ENTAILMENT);
                this.put("prep_in_accordance_with", REVERSE_ENTAILMENT);
                this.put("prep_in_addition_to", REVERSE_ENTAILMENT);
                this.put("prep_in_case_of", REVERSE_ENTAILMENT);
                this.put("prep_including", REVERSE_ENTAILMENT);
                this.put("prep_in_front_of", REVERSE_ENTAILMENT);
                this.put("prep_in_lieu_of", REVERSE_ENTAILMENT);
                this.put("prep_in_place_of", REVERSE_ENTAILMENT);
                this.put("prep_in", REVERSE_ENTAILMENT);
                this.put("prep_inside_of", REVERSE_ENTAILMENT);
                this.put("prep_inside", REVERSE_ENTAILMENT);
                this.put("prep_in_spite_of", REVERSE_ENTAILMENT);
                this.put("prep_instead_of", REVERSE_ENTAILMENT);
                this.put("prep_into", REVERSE_ENTAILMENT);
                this.put("prep_irrespective_of", REVERSE_ENTAILMENT);
                this.put("prep_like", REVERSE_ENTAILMENT);
                this.put("prep_minus", REVERSE_ENTAILMENT);
                this.put("prep_near", REVERSE_ENTAILMENT);
                this.put("prep_near_to", REVERSE_ENTAILMENT);
                this.put("prep_next_to", REVERSE_ENTAILMENT);
                this.put("prep_off_of", REVERSE_ENTAILMENT);
                this.put("prep_off", REVERSE_ENTAILMENT);
                this.put("prep_of", REVERSE_ENTAILMENT);
                this.put("prep_on_account_of", REVERSE_ENTAILMENT);
                this.put("prep_on_behalf_of", REVERSE_ENTAILMENT);
                this.put("prep_on", REVERSE_ENTAILMENT);
                this.put("prep_on_top_of", REVERSE_ENTAILMENT);
                this.put("prep_onto", REVERSE_ENTAILMENT);
                this.put("prep_opposite", REVERSE_ENTAILMENT);
                this.put("prep_out_of", REVERSE_ENTAILMENT);
                this.put("prep_out", REVERSE_ENTAILMENT);
                this.put("prep_outside_of", REVERSE_ENTAILMENT);
                this.put("prep_outside", REVERSE_ENTAILMENT);
                this.put("prep_over", REVERSE_ENTAILMENT);
                this.put("prep_owing_to", REVERSE_ENTAILMENT);
                this.put("prep_past", REVERSE_ENTAILMENT);
                this.put("prep_per", REVERSE_ENTAILMENT);
                this.put("prep_plus", REVERSE_ENTAILMENT);
                this.put("prep_preliminary_to", REVERSE_ENTAILMENT);
                this.put("prep_preparatory_to", REVERSE_ENTAILMENT);
                this.put("prep_previous_to", REVERSE_ENTAILMENT);
                this.put("prep_prior_to", REVERSE_ENTAILMENT);
                this.put("prep_pursuant_to", REVERSE_ENTAILMENT);
                this.put("prep_regarding", REVERSE_ENTAILMENT);
                this.put("prep_regardless_of", REVERSE_ENTAILMENT);
                this.put("prep", REVERSE_ENTAILMENT);
                this.put("prep_round", REVERSE_ENTAILMENT);
                this.put("prep_save", REVERSE_ENTAILMENT);
                this.put("prep_since", REVERSE_ENTAILMENT);
                this.put("prep_subsequent_to", REVERSE_ENTAILMENT);
                this.put("prep_such_as", REVERSE_ENTAILMENT);
                this.put("prep_thanks_to", REVERSE_ENTAILMENT);
                this.put("prep_than", REVERSE_ENTAILMENT);
                this.put("prep_throughout", REVERSE_ENTAILMENT);
                this.put("prep_through", REVERSE_ENTAILMENT);
                this.put("prep_together_with", REVERSE_ENTAILMENT);
                this.put("prep_to", REVERSE_ENTAILMENT);
                this.put("prep_toward", REVERSE_ENTAILMENT);
                this.put("prep_towards", REVERSE_ENTAILMENT);
                this.put("prep_underneath", REVERSE_ENTAILMENT);
                this.put("prep_under", REVERSE_ENTAILMENT);
                this.put("prep_unlike", REVERSE_ENTAILMENT);
                this.put("prep_until", REVERSE_ENTAILMENT);
                this.put("prep_upon", REVERSE_ENTAILMENT);
                this.put("prep_up", REVERSE_ENTAILMENT);
                this.put("prep_versus", REVERSE_ENTAILMENT);
                this.put("prep_via", REVERSE_ENTAILMENT);
                this.put("prep_vs.", REVERSE_ENTAILMENT);
                this.put("prep_whether", REVERSE_ENTAILMENT);
                this.put("prep_within", REVERSE_ENTAILMENT);
                this.put("prep_without", REVERSE_ENTAILMENT);
                this.put("prep_with_regard_to", REVERSE_ENTAILMENT);
                this.put("prep_with_respect_to", REVERSE_ENTAILMENT);
                this.put("prep_with", REVERSE_ENTAILMENT);
                this.put("prt", INDEPENDENCE);
                this.put("punct", EQUIVALENT);
                this.put("purpcl", REVERSE_ENTAILMENT);
                this.put("quantmod", FORWARD_ENTAILMENT);
                this.put("rcmod", REVERSE_ENTAILMENT);
                this.put("root", INDEPENDENCE);
                this.put("tmod", REVERSE_ENTAILMENT);
                this.put("vmod", REVERSE_ENTAILMENT);
                this.put("xcomp", REVERSE_ENTAILMENT);
            }
        });
    }
}

