/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.naturalli;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.naturalli.ForwardEntailerSearchProblem;
import edu.stanford.nlp.naturalli.NaturalLogicAnnotations;
import edu.stanford.nlp.naturalli.NaturalLogicAnnotator;
import edu.stanford.nlp.naturalli.NaturalLogicWeights;
import edu.stanford.nlp.semgraph.SemanticGraph;
import java.util.function.Function;

public class ForwardEntailer
implements Function<SemanticGraph, ForwardEntailerSearchProblem> {
    public final int maxTicks;
    public final int maxResults;
    public final NaturalLogicWeights weights;

    public ForwardEntailer(int maxResults, int maxTicks, NaturalLogicWeights weights) {
        this.maxResults = maxResults;
        this.maxTicks = maxTicks;
        this.weights = weights;
    }

    public ForwardEntailer(int maxResults, NaturalLogicWeights weights) {
        this(maxResults, maxResults * 25, weights);
    }

    public ForwardEntailer(NaturalLogicWeights weights) {
        this(Integer.MAX_VALUE, Integer.MAX_VALUE, weights);
    }

    @Override
    public ForwardEntailerSearchProblem apply(SemanticGraph parseTree) {
        for (IndexedWord vertex : parseTree.vertexSet()) {
            CoreLabel token = vertex.backingLabel();
            if (token == null || token.containsKey(NaturalLogicAnnotations.PolarityAnnotation.class)) continue;
            throw new IllegalArgumentException("Cannot run Natural Logic forward entailment without polarity annotations set. See " + NaturalLogicAnnotator.class.getSimpleName());
        }
        return new ForwardEntailerSearchProblem(parseTree, this.maxResults, this.maxTicks, this.weights);
    }
}

