/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.util;

import edu.stanford.nlp.ie.machinereading.structure.Span;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.ling.tokensregex.TokenSequenceMatcher;
import edu.stanford.nlp.ling.tokensregex.TokenSequencePattern;
import edu.stanford.nlp.naturalli.NaturalLogicAnnotations;
import edu.stanford.nlp.naturalli.Polarity;
import edu.stanford.nlp.naturalli.Util;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.SemgrexPattern;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.FixedPrioritiesPriorityQueue;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.Triple;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class RelationTriple
implements Comparable<RelationTriple>,
Iterable<CoreLabel> {
    public final List<CoreLabel> subject;
    public final List<CoreLabel> relation;
    public final List<CoreLabel> object;
    public final double confidence;
    private static List<SemgrexPattern> VERB_PATTERNS = Collections.unmodifiableList(new ArrayList<SemgrexPattern>(){
        {
            this.add(SemgrexPattern.compile("{$}=verb ?>/cop|aux(pass)?/ {}=be >/.subj(pass)?/ {}=subject >/(nmod|acl|advcl):.*/=prepEdge ( {}=object ?>appos {} = appos ) ?>dobj {pos:/N.*/}=relObj"));
            this.add(SemgrexPattern.compile("{$}=verb >/.subj(pass)?/ {}=subject >xcomp ( {}=object ?>appos {}=appos )"));
            this.add(SemgrexPattern.compile("{$}=verb ?>/aux(pass)?/ {}=be >/.subj(pass)?/ {}=subject >/[di]obj|xcomp/ ( {}=object ?>appos {}=appos )"));
            this.add(SemgrexPattern.compile("{$}=object >/.subj(pass)?/ {}=subject >/cop|aux(pass)?/ {}=verb"));
            this.add(SemgrexPattern.compile("{$}=verb >nsubjpass ( {}=subject >/conj:and/=subjIgnored {}=object )"));
            this.add(SemgrexPattern.compile("{lemma:be}=verb ?>expl {} >/.subj(pass)?/ ( {}=subject >/(nmod|acl|advcl):.*/=prepEdge ( {}=object ?>appos {} = appos ) ?>dobj {pos:/N.*/}=relObj )"));
        }
    });
    private static List<TokenSequencePattern> NOUN_TOKEN_PATTERNS = Collections.unmodifiableList(new ArrayList<TokenSequencePattern>(){
        {
            this.add(TokenSequencePattern.compile("(?$object [ner:/PERSON|ORGANIZATION|LOCATION+/]+ ) (?$beof_comp [ {tag:/NN.*/} & !{ner:/PERSON|ORGANIZATION|LOCATION/} ]+ ) (?$subject [ner:/PERSON|ORGANIZATION|LOCATION/]+ )"));
            this.add(TokenSequencePattern.compile("(?$object [ner:/PERSON|ORGANIZATION|LOCATION+/]+ ) /'s/ (?$beof_comp [ {tag:/NN.*/} & !{ner:/PERSON|ORGANIZATION|LOCATION/} ]+ ) /,/? (?$subject [ner:/PERSON|ORGANIZATION|LOCATION/]+ )"));
            this.add(TokenSequencePattern.compile("(?$subject [ner:/PERSON|ORGANIZATION|LOCATION/]+ ) /,/ (?$object [ner:/NUMBER|DURATION|PERSON|ORGANIZATION/]+ ) /,/"));
            this.add(TokenSequencePattern.compile("(?$subject [ner:/PERSON|ORGANIZATION|LOCATION/]+ ) /\\(/ (?$object [ner:/NUMBER|DURATION|PERSON|ORGANIZATION/]+ ) /\\)/"));
        }
    });
    private static List<SemgrexPattern> NOUN_DEPENDENCY_PATTERNS = Collections.unmodifiableList(new ArrayList<SemgrexPattern>(){
        {
            this.add(SemgrexPattern.compile("{}=subject >appos ( {}=relation >/nmod:.*/=relaux {}=object)"));
            this.add(SemgrexPattern.compile("{}=relation >/nmod:.*/=relaux {}=subject >appos {}=object"));
            this.add(SemgrexPattern.compile("{ner:/PERSON|ORGANIZATION|LOCATION/}=subject >/amod|compound/=arc {ner:/..+/}=object"));
            this.add(SemgrexPattern.compile("{ner:/PERSON|ORGANIZATION|LOCATION/}=subject >/nmod:.*/=relation {ner:/..+/}=object"));
        }
    });
    private static final Counter<SemgrexPattern> VERB_PATTERN_HITS = new ClassicCounter<SemgrexPattern>();
    public static final Set<String> VALID_SUBJECT_ARCS = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add("amod");
            this.add("compound");
            this.add("aux");
            this.add("nummod");
            this.add("nmod:poss");
            this.add("nmod:tmod");
            this.add("expl");
        }
    });
    public static final Set<String> VALID_OBJECT_ARCS = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add("amod");
            this.add("compound");
            this.add("aux");
            this.add("nummod");
            this.add("nmod");
            this.add("nsubj");
            this.add("nmod:*");
            this.add("nmod:poss");
            this.add("nmod:tmod");
            this.add("conj:and");
            this.add("advmod");
            this.add("acl");
            this.add("advcl");
        }
    });
    public static final Set<String> VALID_ADVERB_ARCS = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add("amod");
            this.add("advmod");
            this.add("conj");
            this.add("cc");
            this.add("conj:and");
            this.add("conj:or");
            this.add("auxpass");
        }
    });

    public RelationTriple(List<CoreLabel> subject, List<CoreLabel> relation, List<CoreLabel> object, double confidence) {
        this.subject = subject;
        this.relation = relation;
        this.object = object;
        this.confidence = confidence;
    }

    public RelationTriple(List<CoreLabel> subject, List<CoreLabel> relation, List<CoreLabel> object) {
        this(subject, relation, object, 1.0);
    }

    public List<CoreLabel> allTokens() {
        ArrayList<CoreLabel> allTokens = new ArrayList<CoreLabel>();
        allTokens.addAll(this.subject);
        allTokens.addAll(this.relation);
        allTokens.addAll(this.object);
        return allTokens;
    }

    public String subjectGloss() {
        return StringUtils.join(this.subject.stream().map(CoreLabel::word), " ");
    }

    public CoreLabel subjectHead() {
        return this.subject.get(this.subject.size() - 1);
    }

    public String subjectLemmaGloss() {
        return StringUtils.join(this.subject.stream().filter(x -> !x.tag().matches("[\\.\\?,:;'\"!]")).map(CoreLabel::lemma), " ");
    }

    public String objectGloss() {
        return StringUtils.join(this.object.stream().map(CoreLabel::word), " ");
    }

    public CoreLabel objectHead() {
        return this.object.get(this.object.size() - 1);
    }

    public String objectLemmaGloss() {
        return StringUtils.join(this.object.stream().filter(x -> !x.tag().matches("[\\.\\?,:;'\"!]")).map(CoreLabel::lemma), " ");
    }

    public String relationGloss() {
        return StringUtils.join(this.relation.stream().map(CoreLabel::word), " ");
    }

    public String relationLemmaGloss() {
        return StringUtils.join(this.relation.stream().filter(x -> !x.tag().matches("[\\.\\?,:;'\"!]") && !x.lemma().matches("[\\.,;'\"\\?!]")).map(CoreLabel::lemma), " ").toLowerCase();
    }

    public String confidenceGloss() {
        return new DecimalFormat("0.000").format(this.confidence);
    }

    protected Pair<Integer, Integer> getSpan(List<CoreLabel> tokens, Function<CoreLabel, Integer> toMin, Function<CoreLabel, Integer> toMax) {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (CoreLabel token : tokens) {
            min = Math.min(min, toMin.apply(token));
            max = Math.max(max, toMax.apply(token) + 1);
        }
        return Pair.makePair(min, max);
    }

    public Pair<Integer, Integer> subjectTokenSpan() {
        return this.getSpan(this.subject, x -> x.index() - 1, x -> x.index() - 1);
    }

    public Pair<Integer, Integer> objectTokenSpan() {
        return this.getSpan(this.object, x -> x.index() - 1, x -> x.index() - 1);
    }

    public Optional<SemanticGraph> asDependencyTree() {
        return Optional.empty();
    }

    public List<CoreLabel> asSentence() {
        FixedPrioritiesPriorityQueue<CoreLabel> orderedSentence = new FixedPrioritiesPriorityQueue<CoreLabel>();
        double defaultIndex = 0.0;
        for (CoreLabel token : this.subject) {
            orderedSentence.add(token, token.index() >= 0 ? (double)(-token.index()) : -defaultIndex);
            defaultIndex += 1.0;
        }
        for (CoreLabel token : this.relation) {
            orderedSentence.add(token, token.index() >= 0 ? (double)(-token.index()) : -defaultIndex);
            defaultIndex += 1.0;
        }
        for (CoreLabel token : this.object) {
            orderedSentence.add(token, token.index() >= 0 ? (double)(-token.index()) : -defaultIndex);
            defaultIndex += 1.0;
        }
        return orderedSentence.toSortedList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RelationTriple)) {
            return false;
        }
        RelationTriple that = (RelationTriple)o;
        return this.object.equals(that.object) && this.relation.equals(that.relation) && this.subject.equals(that.subject);
    }

    public int hashCode() {
        int result = this.subject.hashCode();
        result = 31 * result + this.relation.hashCode();
        result = 31 * result + this.object.hashCode();
        return result;
    }

    public String toString() {
        return "" + this.confidence + "\t" + this.subjectGloss() + "\t" + this.relationGloss() + "\t" + this.objectGloss();
    }

    @Override
    public int compareTo(RelationTriple o) {
        if (this.confidence < o.confidence) {
            return -1;
        }
        if (this.confidence > o.confidence) {
            return 1;
        }
        return 0;
    }

    @Override
    public Iterator<CoreLabel> iterator() {
        return CollectionUtils.concatIterators(this.subject.iterator(), this.relation.iterator(), this.object.iterator());
    }

    public static List<RelationTriple> extract(SemanticGraph parse, List<CoreLabel> tokens) {
        ArrayList<RelationTriple> extractions = new ArrayList<RelationTriple>();
        HashSet<Triple<Span, String, Span>> alreadyExtracted = new HashSet<Triple<Span, String, Span>>();
        for (TokenSequencePattern tokenPattern : NOUN_TOKEN_PATTERNS) {
            Object relationTokens;
            TokenSequenceMatcher tokenMatcher = tokenPattern.matcher(tokens);
            while (tokenMatcher.find()) {
                String relationGloss;
                List subject = tokenMatcher.groupNodes("$subject");
                Span subjectSpan = Util.extractNER(tokens, Span.fromValues(((CoreLabel)subject.get(0)).index() - 1, ((CoreLabel)subject.get(subject.size() - 1)).index()));
                final ArrayList<CoreLabel> subjectTokens = new ArrayList<CoreLabel>();
                for (int i : subjectSpan) {
                    subjectTokens.add(tokens.get(i));
                }
                List object = tokenMatcher.groupNodes("$object");
                Span objectSpan = Util.extractNER(tokens, Span.fromValues(((CoreLabel)object.get(0)).index() - 1, ((CoreLabel)object.get(object.size() - 1)).index()));
                if (Span.overlaps(subjectSpan, objectSpan)) continue;
                final ArrayList<CoreLabel> objectTokens = new ArrayList<CoreLabel>();
                for (int i : objectSpan) {
                    objectTokens.add(tokens.get(i));
                }
                if (subjectTokens.size() <= 0 || objectTokens.size() <= 0) continue;
                relationTokens = new ArrayList();
                relationTokens.add(new CoreLabel(){
                    {
                        this.setWord("is");
                        this.setLemma("be");
                        this.setTag("VBZ");
                        this.setNER("O");
                        this.setBeginPosition(((CoreLabel)subjectTokens.get(subjectTokens.size() - 1)).endPosition());
                        this.setEndPosition(((CoreLabel)subjectTokens.get(subjectTokens.size() - 1)).endPosition());
                        this.setSentIndex(((CoreLabel)subjectTokens.get(subjectTokens.size() - 1)).sentIndex());
                        this.setIndex(-1);
                    }
                });
                List beofComp = tokenMatcher.groupNodes("$beof_comp");
                if (beofComp != null) {
                    for (Object token : beofComp) {
                        if (token instanceof CoreLabel) {
                            relationTokens.add((CoreLabel)token);
                            continue;
                        }
                        relationTokens.add(new CoreLabel((CoreMap)token));
                    }
                    relationTokens.add(new CoreLabel(){
                        {
                            this.setWord("of");
                            this.setLemma("of");
                            this.setTag("IN");
                            this.setNER("O");
                            this.setBeginPosition(((CoreLabel)objectTokens.get(0)).beginPosition());
                            this.setEndPosition(((CoreLabel)objectTokens.get(0)).beginPosition());
                            this.setSentIndex(((CoreLabel)objectTokens.get(0)).sentIndex());
                            this.setIndex(-1);
                        }
                    });
                }
                if (alreadyExtracted.contains(Triple.makeTriple(subjectSpan, relationGloss = StringUtils.join(relationTokens.stream().map(CoreLabel::word), " "), objectSpan))) continue;
                extractions.add(new RelationTriple(subjectTokens, (List<CoreLabel>)relationTokens, objectTokens));
                alreadyExtracted.add(Triple.makeTriple(subjectSpan, relationGloss, objectSpan));
            }
            for (SemgrexPattern semgrex : NOUN_DEPENDENCY_PATTERNS) {
                SemgrexMatcher matcher = semgrex.matcher(parse);
                while (matcher.find()) {
                    String relationGloss;
                    Object token;
                    IndexedWord subject = matcher.getNode("subject");
                    Span subjectSpan = Util.extractNER(tokens, Span.fromValues(subject.index() - 1, subject.index()));
                    final ArrayList<CoreLabel> subjectTokens = new ArrayList<CoreLabel>();
                    relationTokens = subjectSpan.iterator();
                    while (relationTokens.hasNext()) {
                        int i = relationTokens.next();
                        subjectTokens.add(tokens.get(i));
                    }
                    IndexedWord object = matcher.getNode("object");
                    Span objectSpan = Util.extractNER(tokens, Span.fromValues(object.index() - 1, object.index()));
                    ArrayList<CoreLabel> objectTokens = new ArrayList<CoreLabel>();
                    token = objectSpan.iterator();
                    while (token.hasNext()) {
                        int i = token.next();
                        objectTokens.add(tokens.get(i));
                    }
                    if (Span.overlaps(subjectSpan, objectSpan) || subjectSpan.end() == objectSpan.start() - 1 && (tokens.get(subjectSpan.end()).word().matches("[\\.,:;\\('\"]") || "CC".equals(tokens.get(subjectSpan.end()).tag())) || objectSpan.end() == subjectSpan.start() - 1 && (tokens.get(objectSpan.end()).word().matches("[\\.,:;\\('\"]") || "CC".equals(tokens.get(objectSpan.end()).tag())) || subjectTokens.size() <= 0 || objectTokens.size() <= 0) continue;
                    LinkedList<CoreLabel> relationTokens2 = new LinkedList<CoreLabel>();
                    IndexedWord relNode = matcher.getNode("relation");
                    if (relNode != null) {
                        relationTokens2.add(relNode.backingLabel());
                        final String relaux = matcher.getRelnString("relaux");
                        if (relaux != null && relaux.startsWith("nmod:") && !"nmod:poss".equals(relaux)) {
                            relationTokens2.add(new CoreLabel(){
                                {
                                    this.setWord(relaux.substring("nmod:".length()));
                                    this.setLemma(relaux.substring("nmod:".length()));
                                    this.setTag("PP");
                                    this.setNER("O");
                                    this.setBeginPosition(((CoreLabel)subjectTokens.get(subjectTokens.size() - 1)).endPosition());
                                    this.setEndPosition(((CoreLabel)subjectTokens.get(subjectTokens.size() - 1)).endPosition());
                                    this.setSentIndex(((CoreLabel)subjectTokens.get(subjectTokens.size() - 1)).sentIndex());
                                    this.setIndex(-1);
                                }
                            });
                        } else if (relaux != null && "nmod:poss".equals(relaux)) {
                            relationTokens2.addFirst(new CoreLabel(){
                                {
                                    this.setWord("'s");
                                    this.setLemma("'s");
                                    this.setTag("PP");
                                    this.setNER("O");
                                    this.setBeginPosition(((CoreLabel)subjectTokens.get(subjectTokens.size() - 1)).endPosition());
                                    this.setEndPosition(((CoreLabel)subjectTokens.get(subjectTokens.size() - 1)).endPosition());
                                    this.setSentIndex(((CoreLabel)subjectTokens.get(subjectTokens.size() - 1)).sentIndex());
                                    this.setIndex(-1);
                                }
                            });
                            relationTokens2.addLast(new CoreLabel(){
                                {
                                    this.setWord("is");
                                    this.setLemma("be");
                                    this.setTag("VBZ");
                                    this.setNER("O");
                                    this.setBeginPosition(((CoreLabel)subjectTokens.get(subjectTokens.size() - 1)).endPosition());
                                    this.setEndPosition(((CoreLabel)subjectTokens.get(subjectTokens.size() - 1)).endPosition());
                                    this.setSentIndex(((CoreLabel)subjectTokens.get(subjectTokens.size() - 1)).sentIndex());
                                    this.setIndex(-1);
                                }
                            });
                        }
                    } else {
                        relationTokens2.add(new CoreLabel(){
                            {
                                this.setWord("is");
                                this.setLemma("be");
                                this.setTag("VBZ");
                                this.setNER("O");
                                this.setBeginPosition(((CoreLabel)subjectTokens.get(subjectTokens.size() - 1)).endPosition());
                                this.setEndPosition(((CoreLabel)subjectTokens.get(subjectTokens.size() - 1)).endPosition());
                                this.setSentIndex(((CoreLabel)subjectTokens.get(subjectTokens.size() - 1)).sentIndex());
                                this.setIndex(-1);
                            }
                        });
                        String rel = matcher.getRelnString("relation");
                        String prep = null;
                        if (rel != null && rel.startsWith("nmod:") && !"nmod:poss".equals(rel)) {
                            prep = rel.substring("nmod:".length());
                        } else if (rel != null && (rel.startsWith("acl:") || rel.startsWith("advcl:"))) {
                            prep = rel.substring(rel.indexOf(":"));
                        } else if (rel != null && rel.equals("nmod:poss")) {
                            relationTokens2.clear();
                            prep = "'s";
                        }
                        if (prep != null) {
                            final String p = prep;
                            relationTokens2.add(new CoreLabel(){
                                {
                                    this.setWord(p);
                                    this.setLemma(p);
                                    this.setTag("PP");
                                    this.setNER("O");
                                    this.setBeginPosition(((CoreLabel)subjectTokens.get(subjectTokens.size() - 1)).endPosition());
                                    this.setEndPosition(((CoreLabel)subjectTokens.get(subjectTokens.size() - 1)).endPosition());
                                    this.setSentIndex(((CoreLabel)subjectTokens.get(subjectTokens.size() - 1)).sentIndex());
                                    this.setIndex(-1);
                                }
                            });
                        }
                    }
                    if (alreadyExtracted.contains(Triple.makeTriple(subjectSpan, relationGloss = StringUtils.join(relationTokens2.stream().map(CoreLabel::word), " "), objectSpan))) continue;
                    extractions.add(new RelationTriple(subjectTokens, relationTokens2, objectTokens));
                    alreadyExtracted.add(Triple.makeTriple(subjectSpan, relationGloss, objectSpan));
                }
            }
        }
        Iterator iter = extractions.iterator();
        while (iter.hasNext()) {
            RelationTriple term = (RelationTriple)iter.next();
            boolean shouldRemove = false;
            for (CoreLabel token : term) {
                if (token.get(NaturalLogicAnnotations.PolarityAnnotation.class) == null || !((Polarity)token.get(NaturalLogicAnnotations.PolarityAnnotation.class)).isDownwards()) continue;
                shouldRemove = true;
            }
            if (!shouldRemove) continue;
            iter.remove();
        }
        return extractions;
    }

    private static CoreLabel mockNode(CoreLabel toCopy, int offset, String word, String POS) {
        CoreLabel mock = new CoreLabel(toCopy);
        mock.setWord(word);
        mock.setLemma(word);
        mock.setValue(word);
        mock.setNER("O");
        mock.setTag(POS);
        mock.setIndex(toCopy.index() + offset);
        return mock;
    }

    private static Optional<List<CoreLabel>> getValidChunk(SemanticGraph parse, IndexedWord originalRoot, Set<String> validArcs, Optional<String> ignoredArc) {
        String shortName;
        FixedPrioritiesPriorityQueue<CoreLabel> chunk = new FixedPrioritiesPriorityQueue<CoreLabel>();
        LinkedList<IndexedWord> fringe = new LinkedList<IndexedWord>();
        IndexedWord root = originalRoot;
        fringe.add(root);
        boolean isCopula = false;
        for (SemanticGraphEdge edge : parse.outgoingEdgeIterable(originalRoot)) {
            shortName = edge.getRelation().getShortName();
            if (!shortName.equals("cop") && !shortName.equals("auxpass")) continue;
            isCopula = true;
        }
        while (!fringe.isEmpty()) {
            root = (IndexedWord)fringe.poll();
            chunk.add(root.backingLabel(), -root.index());
            for (SemanticGraphEdge edge : parse.incomingEdgeIterable(root)) {
                if (edge.getDependent() == originalRoot) continue;
                String relStr = edge.getRelation().toString();
                if (relStr.startsWith("nmod:") && !"nmod:poss".equals(relStr) || relStr.startsWith("acl:") || relStr.startsWith("advcl:")) {
                    chunk.add(RelationTriple.mockNode(edge.getGovernor().backingLabel(), 1, edge.getRelation().toString().substring(edge.getRelation().toString().indexOf(":") + 1), "PP"), -((double)edge.getGovernor().index() + 0.9));
                }
                if (!edge.getRelation().getShortName().equals("conj")) continue;
                chunk.add(RelationTriple.mockNode(root.backingLabel(), -1, edge.getRelation().getSpecific(), "CC"), -((double)root.index() - 0.9));
            }
            for (SemanticGraphEdge edge : parse.getOutEdgesSorted(root)) {
                shortName = edge.getRelation().getShortName();
                String name = edge.getRelation().toString();
                if (isCopula && (shortName.equals("cop") || shortName.contains("subj") || shortName.equals("auxpass")) || ignoredArc.isPresent() && ignoredArc.get().equals(name)) continue;
                if (!validArcs.contains(edge.getRelation().getShortName().replaceAll(":.*", ":*"))) {
                    return Optional.empty();
                }
                fringe.add(edge.getDependent());
            }
        }
        return Optional.of(chunk.toSortedList());
    }

    private static Optional<List<CoreLabel>> getValidSubjectChunk(SemanticGraph parse, IndexedWord root, Optional<String> noopArc) {
        return RelationTriple.getValidChunk(parse, root, VALID_SUBJECT_ARCS, noopArc);
    }

    private static Optional<List<CoreLabel>> getValidObjectChunk(SemanticGraph parse, IndexedWord root, Optional<String> noopArc) {
        return RelationTriple.getValidChunk(parse, root, VALID_OBJECT_ARCS, noopArc);
    }

    private static Optional<List<CoreLabel>> getValidAdverbChunk(SemanticGraph parse, IndexedWord root, Optional<String> noopArc) {
        return RelationTriple.getValidChunk(parse, root, VALID_ADVERB_ARCS, noopArc);
    }

    public static Optional<RelationTriple> segment(SemanticGraph parse, Optional<Double> confidence, boolean consumeAll) {
        block0: for (SemgrexPattern pattern : VERB_PATTERNS) {
            IndexedWord be;
            SemgrexMatcher m = pattern.matcher(parse);
            if (!m.matches() || "nmod:poss".equals(m.getRelnString("prepEdge"))) continue;
            VERB_PATTERN_HITS.incrementCount(pattern);
            if ((int)VERB_PATTERN_HITS.totalCount() % 1000 == 0) {
                ArrayList<SemgrexPattern> newPatterns = new ArrayList<SemgrexPattern>(VERB_PATTERNS);
                Collections.sort(newPatterns, (x, y) -> (int)(VERB_PATTERN_HITS.getCount(y) - VERB_PATTERN_HITS.getCount(x)));
                VERB_PATTERNS = newPatterns;
            }
            int numKnownDependents = 2;
            IndexedWord object = m.getNode("appos");
            if (object == null) {
                object = m.getNode("object");
            }
            assert (object != null);
            FixedPrioritiesPriorityQueue<CoreLabel> verbChunk = new FixedPrioritiesPriorityQueue<CoreLabel>();
            IndexedWord verb = m.getNode("verb");
            ArrayList<IndexedWord> adverbs = new ArrayList<IndexedWord>();
            Optional<Object> subjNoopArc = Optional.empty();
            Optional<Object> objNoopArc = Optional.empty();
            if (verb != null) {
                IndexedWord relObj = m.getNode("relObj");
                for (SemanticGraphEdge edge : parse.outgoingEdgeIterable(verb)) {
                    if ("advmod".equals(edge.getRelation().toString()) || "amod".equals(edge.getRelation().toString())) {
                        String tag = edge.getDependent().backingLabel().tag();
                        if (tag != null && (tag.startsWith("W") || edge.getDependent().backingLabel().word().equalsIgnoreCase("then"))) continue;
                        adverbs.add(edge.getDependent());
                        continue;
                    }
                    if (!edge.getDependent().equals(relObj)) continue;
                    Optional<List<CoreLabel>> relObjSpan = RelationTriple.getValidChunk(parse, relObj, Collections.singleton("compound"), Optional.empty());
                    if (!relObjSpan.isPresent()) continue block0;
                    for (CoreLabel token : relObjSpan.get()) {
                        verbChunk.add(token, -token.index());
                    }
                    ++numKnownDependents;
                }
                if ("nmod:poss".equals(m.getRelnString("verb"))) {
                    verbChunk.add(RelationTriple.mockNode(verb.backingLabel(), -1, "'s", "POS"), (double)verb.backingLabel().index() - 0.9);
                }
            } else {
                IndexedWord subject;
                String verbName = m.getRelnString("verb");
                if ("nmod:poss".equals(verbName)) {
                    subject = m.getNode("subject");
                    verb = new IndexedWord(RelationTriple.mockNode(subject.backingLabel(), 1, "'s", "POS"));
                    objNoopArc = Optional.of("nmod:poss");
                } else if (verbName != null && verbName.startsWith("nmod:")) {
                    verbName = verbName.substring("nmod:".length()).replace("_", " ");
                    subject = m.getNode("subject");
                    verb = new IndexedWord(RelationTriple.mockNode(subject.backingLabel(), 1, verbName, "IN"));
                    subjNoopArc = Optional.of("nmod:" + verbName);
                } else {
                    throw new IllegalStateException("Pattern matched without a verb!");
                }
            }
            verbChunk.add(verb.backingLabel(), -verb.index());
            IndexedWord prep = m.getNode("prep");
            String prepEdge = m.getRelnString("prepEdge");
            if (prep != null) {
                verbChunk.add(prep.backingLabel(), -prep.index());
                ++numKnownDependents;
            }
            if ((be = m.getNode("be")) != null) {
                verbChunk.add(be.backingLabel(), -be.index());
                ++numKnownDependents;
            }
            if (!adverbs.isEmpty()) {
                HashSet adverbialModifiers = new HashSet();
                for (IndexedWord adv : adverbs) {
                    Optional<List<CoreLabel>> adverbChunk = RelationTriple.getValidAdverbChunk(parse, adv, Optional.empty());
                    if (!adverbChunk.isPresent()) continue block0;
                    adverbialModifiers.addAll(adverbChunk.get().stream().collect(Collectors.toList()));
                    ++numKnownDependents;
                }
                for (CoreLabel adverbToken : adverbialModifiers) {
                    verbChunk.add(adverbToken, -adverbToken.index());
                }
            }
            if (prepEdge != null) {
                verbChunk.add(RelationTriple.mockNode(verb.backingLabel(), 1, prepEdge.substring(prepEdge.indexOf(":") + 1).replace("_", " "), "PP"), -(verb.index() + 10));
            }
            if (consumeAll && parse.outDegree(verb) > numKnownDependents) continue;
            List<CoreLabel> relation = verbChunk.toSortedList();
            if (!subjNoopArc.isPresent() && !(subjNoopArc = Optional.ofNullable(m.getRelnString("subjIgnored"))).isPresent()) {
                subjNoopArc = Optional.ofNullable(m.getRelnString("prepEdge"));
            }
            if (!objNoopArc.isPresent()) {
                objNoopArc = Optional.ofNullable(m.getRelnString("objIgnored"));
            }
            Optional<List<CoreLabel>> subjectSpan = RelationTriple.getValidSubjectChunk(parse, m.getNode("subject"), subjNoopArc);
            Optional<List<CoreLabel>> objectSpan = RelationTriple.getValidObjectChunk(parse, object, objNoopArc);
            if (!subjectSpan.isPresent() || !objectSpan.isPresent() || !CollectionUtils.intersection(new HashSet(subjectSpan.get()), new HashSet(objectSpan.get())).isEmpty()) continue;
            WithTree extraction = new WithTree(subjectSpan.get(), relation, objectSpan.get(), parse, confidence.orElse(1.0));
            return Optional.of(extraction);
        }
        return Optional.empty();
    }

    public static Optional<RelationTriple> segment(SemanticGraph parse, Optional<Double> confidence) {
        return RelationTriple.segment(parse, confidence, true);
    }

    public static Optional<RelationTriple> optimizeForKB(RelationTriple input, Optional<CoreMap> sentence, Map<CoreLabel, List<CoreLabel>> canonicalMentions) {
        Integer sentenceIndex;
        String docid;
        String string = docid = sentence.isPresent() ? (String)sentence.get().get(CoreAnnotations.DocIDAnnotation.class) : null;
        if (docid == null) {
            docid = "no_doc_id";
        }
        Integer n = sentenceIndex = sentence.isPresent() ? (Integer)sentence.get().get(CoreAnnotations.SentenceIndexAnnotation.class) : null;
        if (sentenceIndex == null) {
            sentenceIndex = -1;
        }
        List<CoreLabel> subject = null;
        for (int i = input.subject.size() - 1; i >= 0 && (subject = canonicalMentions.get(input.subject.get(i))) == null; --i) {
        }
        if (subject == null) {
            subject = input.subject;
        }
        List<CoreLabel> object = null;
        for (int i = input.object.size() - 1; i >= 0 && (object = canonicalMentions.get(input.object.get(i))) == null; --i) {
        }
        if (object == null) {
            object = input.object;
        }
        for (CoreLabel subjToken : subject) {
            if (!"PRP".equals(subjToken.tag())) continue;
            return Optional.empty();
        }
        for (CoreLabel objToken : object) {
            if (!"PRP".equals(objToken.tag())) continue;
            return Optional.empty();
        }
        boolean hasNER = false;
        for (CoreLabel subjToken : subject) {
            if ("O".equals(subjToken.ner())) continue;
            hasNER = true;
        }
        if (!hasNER) {
            return Optional.empty();
        }
        return Optional.of(new AsKBEntry(subject, input.relation, object, input.confidence, docid, sentenceIndex, subject == input.subject ? Optional.empty() : Optional.of(input.subject), object == input.object ? Optional.empty() : Optional.of(input.object)));
    }

    public static class AsKBEntry
    extends RelationTriple {
        public final String docid;
        public final int sentenceIndex;
        private final Optional<List<CoreLabel>> originalSubject;
        private final Optional<List<CoreLabel>> originalObject;

        public AsKBEntry(List<CoreLabel> subject, List<CoreLabel> relation, List<CoreLabel> object, double confidence, String docid, int sentenceIndex, Optional<List<CoreLabel>> originalSubject, Optional<List<CoreLabel>> originalObject) {
            super(subject, relation, object, confidence);
            this.docid = docid;
            this.sentenceIndex = sentenceIndex;
            this.originalSubject = originalSubject;
            this.originalObject = originalObject;
        }

        public AsKBEntry(RelationTriple source, String docid, int sentenceIndex) {
            this(source.subject, source.relation, source.object, source.confidence, docid, sentenceIndex, Optional.empty(), Optional.empty());
        }

        @Override
        public String subjectGloss() {
            if (((CoreLabel)this.subject.get(0)).lemma() != null) {
                return StringUtils.join(this.subject.stream().map(CoreLabel::lemma), " ");
            }
            return super.relationGloss();
        }

        @Override
        public String objectGloss() {
            if (((CoreLabel)this.object.get(0)).lemma() != null) {
                return StringUtils.join(this.object.stream().map(CoreLabel::lemma), " ");
            }
            return super.objectGloss();
        }

        @Override
        public String relationGloss() {
            if (((CoreLabel)this.relation.get(0)).lemma() != null) {
                return StringUtils.join(this.relation.stream().map(CoreLabel::lemma), " ");
            }
            return super.relationGloss();
        }

        public Optional<Pair<Integer, Integer>> originalSubjectTokenSpan() {
            return this.originalSubject.map(x -> this.getSpan((List<CoreLabel>)x, CoreLabel::index, CoreLabel::index));
        }

        public Optional<Pair<Integer, Integer>> originalObjectTokenSpan() {
            return this.originalObject.map(x -> this.getSpan((List<CoreLabel>)x, CoreLabel::index, CoreLabel::index));
        }

        public Pair<Integer, Integer> extractionTokenSpan() {
            return this.getSpan(this.allTokens(), CoreLabel::index, CoreLabel::index);
        }

        public Pair<Integer, Integer> subjectCharacterSpan() {
            return this.getSpan(this.subject, CoreLabel::beginPosition, CoreLabel::endPosition);
        }

        public Pair<Integer, Integer> objectCharacterSpan() {
            return this.getSpan(this.subject, CoreLabel::beginPosition, CoreLabel::endPosition);
        }

        public Optional<Pair<Integer, Integer>> originalSubjectCharacterSpan() {
            return this.originalSubject.map(x -> this.getSpan((List<CoreLabel>)x, CoreLabel::beginPosition, CoreLabel::endPosition));
        }

        public Optional<Pair<Integer, Integer>> originalObjectCharacterSpan() {
            return this.originalObject.map(x -> this.getSpan((List<CoreLabel>)x, CoreLabel::beginPosition, CoreLabel::endPosition));
        }

        public Pair<Integer, Integer> extractionCharacterSpan() {
            return this.getSpan(this.allTokens(), CoreLabel::beginPosition, CoreLabel::endPosition);
        }

        private static String gloss(Pair<Integer, Integer> pair) {
            return "" + pair.first + "\t" + pair.second;
        }

        private static String gloss(Optional<Pair<Integer, Integer>> pair) {
            if (pair.isPresent()) {
                return "" + pair.get().first + "\t" + pair.get().second;
            }
            return "0\t0";
        }

        @Override
        public String toString() {
            return this.confidenceGloss() + "\t" + this.subjectGloss().replace('\t', ' ') + "\t" + this.relationGloss().replace('\t', ' ') + "\t" + this.objectGloss().replace('\t', ' ') + "\t" + this.docid.replace('\t', ' ') + "\t" + this.sentenceIndex + "\t" + AsKBEntry.gloss(this.subjectTokenSpan()) + "\t" + AsKBEntry.gloss(this.objectTokenSpan()) + "\t" + AsKBEntry.gloss(this.extractionTokenSpan()) + "\t" + AsKBEntry.gloss(this.subjectCharacterSpan()) + "\t" + AsKBEntry.gloss(this.objectCharacterSpan()) + "\t" + AsKBEntry.gloss(this.extractionCharacterSpan()) + "\t" + AsKBEntry.gloss(this.originalSubjectTokenSpan()) + "\t" + AsKBEntry.gloss(this.originalObjectTokenSpan()) + "\t" + AsKBEntry.gloss(this.originalSubjectTokenSpan()) + "\t" + AsKBEntry.gloss(this.originalObjectTokenSpan()) + "\t";
        }
    }

    public static class WithTree
    extends RelationTriple {
        public final SemanticGraph sourceTree;

        public WithTree(List<CoreLabel> subject, List<CoreLabel> relation, List<CoreLabel> object, SemanticGraph tree, double confidence) {
            super(subject, relation, object, confidence);
            this.sourceTree = new SemanticGraph(tree);
        }

        @Override
        public CoreLabel subjectHead() {
            if (this.subject.size() == 1) {
                return (CoreLabel)this.subject.get(0);
            }
            Span subjectSpan = Span.fromValues(((CoreLabel)this.subject.get(0)).index(), ((CoreLabel)this.subject.get(this.subject.size() - 1)).index());
            for (int i = this.subject.size() - 1; i >= 0; --i) {
                for (SemanticGraphEdge edge : this.sourceTree.incomingEdgeIterable(new IndexedWord((CoreLabel)this.subject.get(i)))) {
                    if (edge.getGovernor().index() >= subjectSpan.start() && edge.getGovernor().index() < subjectSpan.end()) continue;
                    return (CoreLabel)this.subject.get(i);
                }
            }
            return (CoreLabel)this.subject.get(this.subject.size() - 1);
        }

        @Override
        public CoreLabel objectHead() {
            if (this.object.size() == 1) {
                return (CoreLabel)this.object.get(0);
            }
            Span objectSpan = Span.fromValues(((CoreLabel)this.object.get(0)).index(), ((CoreLabel)this.object.get(this.object.size() - 1)).index());
            for (int i = this.object.size() - 1; i >= 0; --i) {
                for (SemanticGraphEdge edge : this.sourceTree.incomingEdgeIterable(new IndexedWord((CoreLabel)this.object.get(i)))) {
                    if (edge.getGovernor().index() >= objectSpan.start() && edge.getGovernor().index() < objectSpan.end()) continue;
                    return (CoreLabel)this.object.get(i);
                }
            }
            return (CoreLabel)this.object.get(this.object.size() - 1);
        }

        @Override
        public Optional<SemanticGraph> asDependencyTree() {
            return Optional.of(this.sourceTree);
        }
    }
}

