/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.machinereading;

import edu.stanford.nlp.ie.machinereading.RelationFeatureFactory;
import edu.stanford.nlp.ie.machinereading.structure.EntityMention;
import edu.stanford.nlp.ie.machinereading.structure.MachineReadingAnnotations;
import edu.stanford.nlp.ie.machinereading.structure.RelationMention;
import edu.stanford.nlp.ie.machinereading.structure.Span;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.Datum;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.ling.RVFDatum;
import edu.stanford.nlp.process.Morphology;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.semgraph.SemanticGraphFactory;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.trees.EnglishGrammaticalRelations;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.StringUtils;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BasicRelationFeatureFactory
extends RelationFeatureFactory
implements Serializable {
    private static final long serialVersionUID = -7376668998622546620L;
    private static final Logger logger = Logger.getLogger(BasicRelationFeatureFactory.class.getName());
    protected static final List<String> dependencyFeatures = Collections.unmodifiableList(Arrays.asList("dependency_path_lowlevel", "dependency_path_length", "dependency_path_length_binary", "verb_in_dependency_path", "dependency_path", "dependency_path_words", "dependency_paths_to_verb", "dependency_path_stubs_to_verb", "dependency_path_POS_unigrams", "dependency_path_word_n_grams", "dependency_path_POS_n_grams", "dependency_path_edge_n_grams", "dependency_path_edge_lowlevel_n_grams", "dependency_path_edge-node-edge-grams", "dependency_path_edge-node-edge-grams_lowlevel", "dependency_path_node-edge-node-grams", "dependency_path_node-edge-node-grams_lowlevel", "dependency_path_directed_bigrams", "dependency_path_edge_unigrams", "dependency_path_trigger"));
    protected List<String> featureList;

    public BasicRelationFeatureFactory(String ... featureList) {
        this.doNotLexicalizeFirstArg = false;
        this.dependencyType = RelationFeatureFactory.DEPENDENCY_TYPE.COLLAPSED_CCPROCESSED;
        this.featureList = Collections.unmodifiableList(Arrays.asList(featureList));
    }

    @Override
    public Datum<String, String> createDatum(RelationMention rel) {
        return this.createDatum(rel, (Logger)null);
    }

    public Datum<String, String> createDatum(RelationMention rel, Logger logger) {
        ClassicCounter<String> features = new ClassicCounter<String>();
        if (rel.getArgs().size() != 2) {
            return null;
        }
        this.addFeatures(features, rel, this.featureList, logger);
        String labelString = rel.getType();
        return new RVFDatum<String, String>(features, labelString);
    }

    @Override
    public Datum<String, String> createTestDatum(RelationMention rel, Logger logger) {
        return this.createDatum(rel, logger);
    }

    @Override
    public Datum<String, String> createDatum(RelationMention rel, String positiveLabel) {
        ClassicCounter<String> features = new ClassicCounter<String>();
        if (rel.getArgs().size() != 2) {
            return null;
        }
        this.addFeatures(features, rel, this.featureList);
        String labelString = rel.getType();
        if (!labelString.equals(positiveLabel)) {
            labelString = "_NR";
        }
        return new RVFDatum<String, String>(features, labelString);
    }

    public boolean addFeatures(Counter<String> features, RelationMention rel, List<String> types) {
        return this.addFeatures(features, rel, types, null);
    }

    public boolean addFeatures(Counter<String> features, RelationMention rel, List<String> types, Logger logger) {
        ArrayList<String> tempDepFeatures;
        int swEnd;
        int swStart;
        if (rel.getArgs().size() != 2) {
            return false;
        }
        if (!(rel.getArg(0) instanceof EntityMention)) {
            return false;
        }
        if (!(rel.getArg(1) instanceof EntityMention)) {
            return false;
        }
        EntityMention arg0 = (EntityMention)rel.getArg(0);
        EntityMention arg1 = (EntityMention)rel.getArg(1);
        Tree tree = (Tree)rel.getSentence().get(TreeCoreAnnotations.TreeAnnotation.class);
        if (tree == null) {
            throw new RuntimeException("ERROR: Relation extraction requires full syntactic analysis!");
        }
        List leaves = tree.getLeaves();
        List tokens = (List)rel.getSentence().get(CoreAnnotations.TokensAnnotation.class);
        CoreMap relSentence = rel.getSentence();
        CoreMap arg0Sentence = arg0.getSentence();
        CoreMap arg1Sentence = arg1.getSentence();
        if (arg0Sentence != relSentence) {
            System.err.println("WARNING: Found relation with arg0 in a different sentence: " + rel);
            System.err.println("Relation sentence: " + (String)relSentence.get(CoreAnnotations.TextAnnotation.class));
            System.err.println("Arg0 sentence: " + (String)arg0Sentence.get(CoreAnnotations.TextAnnotation.class));
            return false;
        }
        if (arg1Sentence != relSentence) {
            System.err.println("WARNING: Found relation with arg1 in a different sentence: " + rel);
            System.err.println("Relation sentence: " + (String)relSentence.get(CoreAnnotations.TextAnnotation.class));
            System.err.println("Arg1 sentence: " + (String)arg1Sentence.get(CoreAnnotations.TextAnnotation.class));
            return false;
        }
        ArrayList<String> checklist = new ArrayList<String>(types);
        if (BasicRelationFeatureFactory.usingFeature(types, checklist, "arg_type")) {
            features.setCount("arg1type=" + arg0.getType() + "_and_arg2type=" + arg1.getType(), 1.0);
        }
        if (BasicRelationFeatureFactory.usingFeature(types, checklist, "arg_subtype")) {
            features.setCount("arg1subtype=" + arg0.getSubType() + "_and_arg2subtype=" + arg1.getSubType(), 1.0);
        }
        if (BasicRelationFeatureFactory.usingFeature(types, checklist, "arg_order") && arg0.getSyntacticHeadTokenPosition() < arg1.getSyntacticHeadTokenPosition()) {
            features.setCount("arg1BeforeArg2", 1.0);
        }
        if (BasicRelationFeatureFactory.usingFeature(types, checklist, "same_head") && arg0.getSyntacticHeadTokenPosition() == arg1.getSyntacticHeadTokenPosition()) {
            features.setCount("arguments_have_same_head", 1.0);
        }
        if (BasicRelationFeatureFactory.usingFeature(types, checklist, "full_tree_path")) {
            if (arg0.getSyntacticHeadTokenPosition() < leaves.size() && arg1.getSyntacticHeadTokenPosition() < leaves.size()) {
                Tree arg0preterm = ((Tree)leaves.get(arg0.getSyntacticHeadTokenPosition())).parent(tree);
                Tree arg1preterm = ((Tree)leaves.get(arg1.getSyntacticHeadTokenPosition())).parent(tree);
                Tree join = tree.joinNode(arg0preterm, arg1preterm);
                StringBuilder pathStringBuilder = new StringBuilder();
                List<Tree> pathUp = join.dominationPath(arg0preterm);
                Collections.reverse(pathUp);
                for (Tree node : pathUp) {
                    if (node == join) continue;
                    pathStringBuilder.append(node.label().value() + " <- ");
                }
                for (Tree node : join.dominationPath(arg1preterm)) {
                    pathStringBuilder.append((node == join ? "" : " -> ") + node.label().value());
                }
                String pathString = pathStringBuilder.toString();
                if (logger != null && !rel.getType().equals("_NR")) {
                    logger.info("full_tree_path: " + pathString);
                }
                features.setCount("treepath:" + pathString, 1.0);
            } else {
                System.err.println("WARNING: found weird argument offsets. Most likely because arguments appear in different sentences than the relation:");
                System.err.println("ARG0: " + arg0);
                System.err.println("ARG0 HEAD: " + arg0.getSyntacticHeadTokenPosition());
                System.err.println("ARG0 SENTENCE: " + this.sentToString(arg0.getSentence()));
                System.err.println("ARG1: " + arg1);
                System.err.println("ARG1 HEAD: " + arg1.getSyntacticHeadTokenPosition());
                System.err.println("ARG1 SENTENCE: " + this.sentToString(arg1.getSentence()));
                System.err.println("RELATION TREE: " + tree);
            }
        }
        int pathLength = tree.pathNodeToNode((Tree)tree.getLeaves().get(arg0.getSyntacticHeadTokenPosition()), (Tree)tree.getLeaves().get(arg1.getSyntacticHeadTokenPosition())).size();
        if (BasicRelationFeatureFactory.usingFeature(types, checklist, "path_length")) {
            features.setCount("path_length", pathLength);
        }
        if (BasicRelationFeatureFactory.usingFeature(types, checklist, "path_length_binary")) {
            features.setCount("path_length_" + pathLength, 1.0);
        }
        if (BasicRelationFeatureFactory.usingFeature(types, checklist, "entity_order")) {
            for (int i = 0; i < rel.getArgs().size(); ++i) {
                EntityMention arg = (EntityMention)rel.getArgs().get(i);
                if (rel.getSentence().get(MachineReadingAnnotations.EntityMentionsAnnotation.class) == null) continue;
                for (EntityMention otherArg : (List)rel.getSentence().get(MachineReadingAnnotations.EntityMentionsAnnotation.class)) {
                    String feature;
                    if (otherArg.getSyntacticHeadTokenPosition() > arg.getSyntacticHeadTokenPosition()) {
                        feature = "arg" + i + "_before_" + otherArg.getType();
                        features.setCount(feature, 1.0);
                    }
                    if (otherArg.getSyntacticHeadTokenPosition() >= arg.getSyntacticHeadTokenPosition()) continue;
                    feature = "arg" + i + "_after_" + otherArg.getType();
                    features.setCount(feature, 1.0);
                }
            }
        }
        int surfaceDistance = Math.abs(arg0.getSyntacticHeadTokenPosition() - arg1.getSyntacticHeadTokenPosition());
        if (BasicRelationFeatureFactory.usingFeature(types, checklist, "surface_distance")) {
            features.setCount("surface_distance", surfaceDistance);
        }
        if (BasicRelationFeatureFactory.usingFeature(types, checklist, "surface_distance_binary")) {
            features.setCount("surface_distance_" + surfaceDistance, 1.0);
        }
        if (BasicRelationFeatureFactory.usingFeature(types, checklist, "surface_distance_bins")) {
            if (surfaceDistance < 4) {
                features.setCount("surface_distance_bin" + surfaceDistance, 1.0);
            } else if (surfaceDistance < 6) {
                features.setCount("surface_distance_bin_lt6", 1.0);
            } else if (surfaceDistance < 10) {
                features.setCount("surface_distance_bin_lt10", 1.0);
            } else {
                features.setCount("surface_distance_bin_ge10", 1.0);
            }
        }
        ArrayList<EntityMention> args = new ArrayList<EntityMention>();
        args.add(arg0);
        args.add(arg1);
        for (int windowSize = 1; windowSize <= 3; ++windowSize) {
            String[] leftWindow = new String[2];
            String[] rightWindow = new String[2];
            String[] leftWindowPOS = new String[2];
            String[] rightWindowPOS = new String[2];
            for (int argn = 0; argn <= 1; ++argn) {
                int ind = ((EntityMention)args.get(argn)).getSyntacticHeadTokenPosition();
                for (int winnum = 1; winnum <= windowSize; ++winnum) {
                    int windex = ind - winnum;
                    if (windex > 0) {
                        leftWindow[argn] = ((Tree)leaves.get(windex)).label().value() + "_" + leftWindow[argn];
                        leftWindowPOS[argn] = ((Tree)leaves.get(windex)).parent(tree).label().value() + "_" + leftWindowPOS[argn];
                    } else {
                        leftWindow[argn] = "NULL_" + leftWindow[argn];
                        leftWindowPOS[argn] = "NULL_" + leftWindowPOS[argn];
                    }
                    windex = ind + winnum;
                    if (windex < leaves.size()) {
                        rightWindow[argn] = rightWindow[argn] + "_" + ((Tree)leaves.get(windex)).label().value();
                        rightWindowPOS[argn] = rightWindowPOS[argn] + "_" + ((Tree)leaves.get(windex)).parent(tree).label().value();
                        continue;
                    }
                    rightWindow[argn] = rightWindow[argn] + "_NULL";
                    rightWindowPOS[argn] = rightWindowPOS[argn] + "_NULL";
                }
                if (BasicRelationFeatureFactory.usingFeature(types, checklist, "separate_surface_windows")) {
                    features.setCount("left_window_" + windowSize + "_arg_" + argn + ": " + leftWindow[argn], 1.0);
                    features.setCount("left_window_" + windowSize + "_POS_arg_" + argn + ": " + leftWindowPOS[argn], 1.0);
                }
                if (!BasicRelationFeatureFactory.usingFeature(types, checklist, "separate_surface_windows_POS")) continue;
                features.setCount("right_window_" + windowSize + "_arg_" + argn + ": " + rightWindow[argn], 1.0);
                features.setCount("right_window_" + windowSize + "_POS_arg_" + argn + ": " + rightWindowPOS[argn], 1.0);
            }
            if (BasicRelationFeatureFactory.usingFeature(types, checklist, "conjunction_surface_windows")) {
                features.setCount("left_windows_" + windowSize + ": " + leftWindow[0] + "__" + leftWindow[1], 1.0);
                features.setCount("right_windows_" + windowSize + ": " + rightWindow[0] + "__" + rightWindow[1], 1.0);
            }
            if (!BasicRelationFeatureFactory.usingFeature(types, checklist, "conjunction_surface_windows_POS")) continue;
            features.setCount("left_windows_" + windowSize + "_POS: " + leftWindowPOS[0] + "__" + leftWindowPOS[1], 1.0);
            features.setCount("right_windows_" + windowSize + "_POS: " + rightWindowPOS[0] + "__" + rightWindowPOS[1], 1.0);
        }
        String word0 = ((Tree)leaves.get(arg0.getSyntacticHeadTokenPosition())).label().value();
        String word1 = ((Tree)leaves.get(arg1.getSyntacticHeadTokenPosition())).label().value();
        if (BasicRelationFeatureFactory.usingFeature(types, checklist, "arg_words")) {
            if (!this.doNotLexicalizeFirstArg) {
                features.setCount("word_arg0: " + word0, 1.0);
            }
            features.setCount("word_arg1: " + word1, 1.0);
            if (!this.doNotLexicalizeFirstArg) {
                features.setCount("words: " + word0 + "__" + word1, 1.0);
            }
        }
        String pos0 = ((Tree)leaves.get(arg0.getSyntacticHeadTokenPosition())).parent(tree).label().value();
        String pos1 = ((Tree)leaves.get(arg1.getSyntacticHeadTokenPosition())).parent(tree).label().value();
        if (BasicRelationFeatureFactory.usingFeature(types, checklist, "arg_POS")) {
            features.setCount("POS_arg0: " + pos0, 1.0);
            features.setCount("POS_arg1: " + pos1, 1.0);
            features.setCount("POSs: " + pos0 + "__" + pos1, 1.0);
        }
        if (BasicRelationFeatureFactory.usingFeature(types, checklist, "adjacent_words")) {
            for (int i = 0; i < rel.getArgs().size(); ++i) {
                String v;
                Span s = ((EntityMention)rel.getArg(i)).getHead();
                if (s.start() > 0) {
                    v = ((CoreLabel)tokens.get(s.start() - 1)).word();
                    features.setCount("leftarg" + i + "-" + v, 1.0);
                }
                if (s.end() >= tokens.size()) continue;
                v = ((CoreLabel)tokens.get(s.end())).word();
                features.setCount("rightarg" + i + "-" + v, 1.0);
            }
        }
        if (BasicRelationFeatureFactory.usingFeature(types, checklist, "entities_between_args")) {
            CoreMap sent = rel.getSentence();
            if (sent == null) {
                throw new RuntimeException("NULL sentence for relation " + rel);
            }
            List relArgs = (List)sent.get(MachineReadingAnnotations.EntityMentionsAnnotation.class);
            if (relArgs != null) {
                for (EntityMention arg : relArgs) {
                    if ((arg.getSyntacticHeadTokenPosition() <= arg0.getSyntacticHeadTokenPosition() || arg.getSyntacticHeadTokenPosition() >= arg1.getSyntacticHeadTokenPosition()) && (arg.getSyntacticHeadTokenPosition() <= arg1.getSyntacticHeadTokenPosition() || arg.getSyntacticHeadTokenPosition() >= arg0.getSyntacticHeadTokenPosition())) continue;
                    features.setCount("entity_between_args: " + arg.getType(), 1.0);
                }
            }
        }
        ClassicCounter<String> typeCounts = new ClassicCounter<String>();
        if (rel.getSentence().get(MachineReadingAnnotations.EntityMentionsAnnotation.class) != null) {
            for (EntityMention arg : (List)rel.getSentence().get(MachineReadingAnnotations.EntityMentionsAnnotation.class)) {
                typeCounts.incrementCount(arg.getType());
            }
            for (String type : typeCounts.keySet()) {
                if (BasicRelationFeatureFactory.usingFeature(types, checklist, "entity_counts")) {
                    features.setCount("entity_counts_" + type, typeCounts.getCount(type));
                }
                if (!BasicRelationFeatureFactory.usingFeature(types, checklist, "entity_counts_binary")) continue;
                features.setCount("entity_counts_" + type + ": " + typeCounts.getCount(type), 1.0);
            }
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder sbPOS = new StringBuilder();
        StringBuilder sbSelective = new StringBuilder();
        for (int i = Math.min(arg0.getSyntacticHeadTokenPosition(), arg1.getSyntacticHeadTokenPosition()) + 1; i < Math.max(arg0.getSyntacticHeadTokenPosition(), arg1.getSyntacticHeadTokenPosition()); ++i) {
            String word = ((Tree)leaves.get(i)).label().value();
            sb.append(word + "_");
            String pos = ((Tree)leaves.get(i)).parent(tree).label().value();
            sbPOS.append(pos + "_");
            if (!pos.equals("NN") && !pos.equals("NNS") && !pos.equals("NNP") && !pos.equals("NNPS") && !pos.equals("VB") && !pos.equals("VBN") && !pos.equals("VBD") && !pos.equals("VBG") && !pos.equals("VBP") && !pos.equals("VBZ")) continue;
            sbSelective.append(word + "_");
        }
        if (BasicRelationFeatureFactory.usingFeature(types, checklist, "surface_path")) {
            features.setCount("surface_path: " + sb, 1.0);
        }
        if (BasicRelationFeatureFactory.usingFeature(types, checklist, "surface_path_POS")) {
            features.setCount("surface_path_POS: " + sbPOS, 1.0);
        }
        if (BasicRelationFeatureFactory.usingFeature(types, checklist, "surface_path_selective")) {
            features.setCount("surface_path_selective: " + sbSelective, 1.0);
        }
        if (arg0.getSyntacticHeadTokenPosition() < arg1.getSyntacticHeadTokenPosition()) {
            swStart = arg0.getExtentTokenEnd();
            swEnd = arg1.getExtentTokenStart();
        } else {
            swStart = arg1.getExtentTokenEnd();
            swEnd = arg0.getExtentTokenStart();
        }
        if (BasicRelationFeatureFactory.usingFeature(types, checklist, "span_words_unigrams")) {
            for (int i = swStart; i < swEnd; ++i) {
                features.setCount("span_word:" + ((CoreLabel)tokens.get(i)).word(), 1.0);
            }
        }
        if (BasicRelationFeatureFactory.usingFeature(types, checklist, "span_words_bigrams")) {
            for (int i = swStart; i < swEnd - 1; ++i) {
                features.setCount("span_bigram:" + ((CoreLabel)tokens.get(i)).word() + "-" + ((CoreLabel)tokens.get(i + 1)).word(), 1.0);
            }
        }
        if (BasicRelationFeatureFactory.usingFeature(types, checklist, "span_words_trigger")) {
            for (int i = swStart; i < swEnd; ++i) {
                String trigger = (String)((CoreLabel)tokens.get(i)).get(MachineReadingAnnotations.TriggerAnnotation.class);
                if (trigger == null || !trigger.startsWith("B-")) continue;
                features.incrementCount("span_words_trigger=" + trigger.substring(2));
            }
        }
        if (BasicRelationFeatureFactory.usingFeature(types, checklist, "arg2_number") && arg1.getType().equals("NUMBER")) {
            try {
                int value = Integer.parseInt(arg1.getValue());
                if (2 <= value && value <= 100) {
                    features.setCount("arg2_number", 1.0);
                }
                if (2 <= value && value <= 19) {
                    features.setCount("arg2_number_2", 1.0);
                }
                if (20 <= value && value <= 59) {
                    features.setCount("arg2_number_20", 1.0);
                }
                if (60 <= value && value <= 100) {
                    features.setCount("arg2_number_60", 1.0);
                }
                if (value >= 100) {
                    features.setCount("arg2_number_100", 1.0);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (BasicRelationFeatureFactory.usingFeature(types, checklist, "arg2_date") && arg1.getType().equals("DATE")) {
            try {
                int value = Integer.parseInt(arg1.getValue());
                if (0 <= value && value <= 2010) {
                    features.setCount("arg2_date", 1.0);
                }
                if (0 <= value && value <= 999) {
                    features.setCount("arg2_date_0", 1.0);
                }
                if (1000 <= value && value <= 1599) {
                    features.setCount("arg2_date_1000", 1.0);
                }
                if (1600 <= value && value <= 1799) {
                    features.setCount("arg2_date_1600", 1.0);
                }
                if (1800 <= value && value <= 1899) {
                    features.setCount("arg2_date_1800", 1.0);
                }
                if (1900 <= value && value <= 1999) {
                    features.setCount("arg2_date_1900", 1.0);
                }
                if (value >= 2000) {
                    features.setCount("arg2_date_2000", 1.0);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (BasicRelationFeatureFactory.usingFeature(types, checklist, "arg_gender")) {
            boolean arg0Male = false;
            boolean arg0Female = false;
            boolean arg1Male = false;
            boolean arg1Female = false;
            System.out.println("Adding gender annotations!");
            int index = arg0.getExtentTokenStart();
            String gender = (String)((CoreLabel)tokens.get(index)).get(MachineReadingAnnotations.GenderAnnotation.class);
            System.out.println(((CoreLabel)tokens.get(index)).word() + " -- " + gender);
            if (gender.equals("MALE")) {
                arg0Male = true;
            } else if (gender.equals("FEMALE")) {
                arg0Female = true;
            }
            index = arg1.getExtentTokenStart();
            gender = (String)((CoreLabel)tokens.get(index)).get(MachineReadingAnnotations.GenderAnnotation.class);
            if (gender.equals("MALE")) {
                arg1Male = true;
            } else if (gender.equals("FEMALE")) {
                arg1Female = true;
            }
            if (arg0Male) {
                features.setCount("arg1_male", 1.0);
            }
            if (arg0Female) {
                features.setCount("arg1_female", 1.0);
            }
            if (arg1Male) {
                features.setCount("arg2_male", 1.0);
            }
            if (arg1Female) {
                features.setCount("arg2_female", 1.0);
            }
            if (arg0Male && arg1Male || arg0Female && arg1Female) {
                features.setCount("arg_same_gender", 1.0);
            }
            if (arg0Male && arg1Female || arg0Female && arg1Male) {
                features.setCount("arg_different_gender", 1.0);
            }
        }
        if ((tempDepFeatures = new ArrayList<String>(dependencyFeatures)).removeAll(types) || types.contains("all")) {
            this.addDependencyPathFeatures(features, rel, arg0, arg1, types, checklist, logger);
        }
        if (!checklist.isEmpty() && !checklist.contains("all")) {
            throw new AssertionError((Object)("RelationFeatureFactory: features not handled: " + checklist));
        }
        ArrayList<String> featureList = new ArrayList<String>(features.keySet());
        Collections.sort(featureList);
        return true;
    }

    String sentToString(CoreMap sentence) {
        StringBuffer os = new StringBuffer();
        List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
        if (tokens != null) {
            boolean first = true;
            for (CoreLabel token : tokens) {
                if (!first) {
                    os.append(" ");
                }
                os.append(token.word());
                first = false;
            }
        }
        return os.toString();
    }

    protected void addDependencyPathFeatures(Counter<String> features, RelationMention rel, EntityMention arg0, EntityMention arg1, List<String> types, List<String> checklist, Logger logger) {
        int i;
        SemanticGraph graph = null;
        if (this.dependencyType == null) {
            this.dependencyType = RelationFeatureFactory.DEPENDENCY_TYPE.COLLAPSED_CCPROCESSED;
        }
        if (this.dependencyType == RelationFeatureFactory.DEPENDENCY_TYPE.COLLAPSED_CCPROCESSED) {
            graph = (SemanticGraph)rel.getSentence().get(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class);
        } else if (this.dependencyType == RelationFeatureFactory.DEPENDENCY_TYPE.COLLAPSED) {
            graph = (SemanticGraph)rel.getSentence().get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class);
        } else if (this.dependencyType == RelationFeatureFactory.DEPENDENCY_TYPE.BASIC) {
            graph = (SemanticGraph)rel.getSentence().get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
        } else {
            throw new RuntimeException("ERROR: unknown dependency type: " + (Object)((Object)this.dependencyType));
        }
        if (graph == null) {
            Tree tree = (Tree)rel.getSentence().get(TreeCoreAnnotations.TreeAnnotation.class);
            if (tree == null) {
                System.err.println("WARNING: found sentence without TreeAnnotation. Skipped dependency-path features.");
                return;
            }
            try {
                graph = SemanticGraphFactory.makeFromTree(tree, SemanticGraphFactory.Mode.COLLAPSED, GrammaticalStructure.Extras.NONE, true, null, true);
            }
            catch (Exception e) {
                System.err.println("WARNING: failed to generate dependencies from tree " + tree.toString());
                e.printStackTrace();
                System.err.println("Skipped dependency-path features.");
                return;
            }
        }
        IndexedWord node0 = graph.getNodeByIndexSafe(arg0.getSyntacticHeadTokenPosition() + 1);
        IndexedWord node1 = graph.getNodeByIndexSafe(arg1.getSyntacticHeadTokenPosition() + 1);
        if (node0 == null) {
            checklist.removeAll(dependencyFeatures);
            return;
        }
        if (node1 == null) {
            checklist.removeAll(dependencyFeatures);
            return;
        }
        List<SemanticGraphEdge> edgePath = graph.getShortestUndirectedPathEdges(node0, node1);
        List<IndexedWord> pathNodes = graph.getShortestUndirectedPathNodes(node0, node1);
        if (edgePath == null) {
            checklist.removeAll(dependencyFeatures);
            return;
        }
        if (pathNodes == null || pathNodes.size() <= 1) {
            checklist.removeAll(dependencyFeatures);
            return;
        }
        if (BasicRelationFeatureFactory.usingFeature(types, checklist, "dependency_path")) {
            features.setCount("dependency_path:" + BasicRelationFeatureFactory.generalizedDependencyPath(edgePath, node0), 1.0);
        }
        if (BasicRelationFeatureFactory.usingFeature(types, checklist, "dependency_path_lowlevel")) {
            String depLowLevel = BasicRelationFeatureFactory.dependencyPath(edgePath, node0);
            if (logger != null && !rel.getType().equals("_NR")) {
                logger.info("dependency_path_lowlevel: " + depLowLevel);
            }
            features.setCount("dependency_path_lowlevel:" + depLowLevel, 1.0);
        }
        ArrayList<String> pathLemmas = new ArrayList<String>();
        ArrayList<String> noArgPathLemmas = new ArrayList<String>();
        HashSet<Integer> indecesToSkip = new HashSet<Integer>();
        for (i = arg0.getExtentTokenStart(); i < arg0.getExtentTokenEnd(); ++i) {
            indecesToSkip.add(i + 1);
        }
        for (i = arg1.getExtentTokenStart(); i < arg1.getExtentTokenEnd(); ++i) {
            indecesToSkip.add(i + 1);
        }
        for (IndexedWord node : pathNodes) {
            pathLemmas.add(Morphology.lemmaStatic(node.value(), node.tag(), true));
            if (indecesToSkip.contains(node.index())) continue;
            noArgPathLemmas.add(Morphology.lemmaStatic(node.value(), node.tag(), true));
        }
        if (BasicRelationFeatureFactory.usingFeature(types, checklist, "dependency_paths_to_verb")) {
            for (IndexedWord node : pathNodes) {
                if (!node.tag().contains("VB") || node.equals(node0) || node.equals(node1)) continue;
                String lemma = Morphology.lemmaStatic(node.value(), node.tag(), true);
                String node1Path = BasicRelationFeatureFactory.generalizedDependencyPath(graph.getShortestUndirectedPathEdges(node, node1), node);
                String node0Path = BasicRelationFeatureFactory.generalizedDependencyPath(graph.getShortestUndirectedPathEdges(node0, node), node0);
                features.setCount("dependency_paths_to_verb:" + node0Path + " " + lemma, 1.0);
                features.setCount("dependency_paths_to_verb:" + lemma + " " + node1Path, 1.0);
                features.setCount("dependency_paths_to_verb:" + node0Path + " " + lemma + " " + node1Path, 1.0);
            }
        }
        if (BasicRelationFeatureFactory.usingFeature(types, checklist, "dependency_path_stubs_to_verb")) {
            for (IndexedWord node : pathNodes) {
                SemanticGraphEdge edge0 = edgePath.get(0);
                SemanticGraphEdge edge1 = edgePath.get(edgePath.size() - 1);
                if (!node.tag().contains("VB") || node.equals(node0) || node.equals(node1)) continue;
                String lemma = Morphology.lemmaStatic(node.value(), node.tag(), true);
                String edge0str = node0.equals(edge0.getGovernor()) ? "<-" + BasicRelationFeatureFactory.generalizeRelation(edge0.getRelation()) : BasicRelationFeatureFactory.generalizeRelation(edge0.getRelation()) + "->";
                String edge1str = node1.equals(edge1.getGovernor()) ? BasicRelationFeatureFactory.generalizeRelation(edge1.getRelation()) + "->" : "<-" + BasicRelationFeatureFactory.generalizeRelation(edge1.getRelation());
                features.setCount("stub: " + edge0str + " " + lemma, 1.0);
                features.setCount("stub: " + lemma + edge1str, 1.0);
                features.setCount("stub: " + edge0str + " " + lemma + " " + edge1str, 1.0);
            }
        }
        if (BasicRelationFeatureFactory.usingFeature(types, checklist, "verb_in_dependency_path")) {
            for (IndexedWord node : pathNodes) {
                String leftRelation;
                String rightRelation;
                if (!node.tag().contains("VB") || node.equals(node0) || node.equals(node1)) continue;
                SemanticGraphEdge rightEdge = graph.getShortestUndirectedPathEdges(node, node1).get(0);
                SemanticGraphEdge leftEdge = graph.getShortestUndirectedPathEdges(node, node0).get(0);
                boolean governsLeft = false;
                boolean governsRight = false;
                if (node.equals(rightEdge.getGovernor())) {
                    rightRelation = " <-" + BasicRelationFeatureFactory.generalizeRelation(rightEdge.getRelation());
                    governsRight = true;
                } else {
                    rightRelation = BasicRelationFeatureFactory.generalizeRelation(rightEdge.getRelation()) + "-> ";
                }
                if (node.equals(leftEdge.getGovernor())) {
                    leftRelation = BasicRelationFeatureFactory.generalizeRelation(leftEdge.getRelation()) + "-> ";
                    governsLeft = true;
                } else {
                    leftRelation = " <-" + BasicRelationFeatureFactory.generalizeRelation(leftEdge.getRelation());
                }
                String lemma = Morphology.lemmaStatic(node.value(), node.tag(), true);
                if (governsLeft || governsRight) {
                    // empty if block
                }
                if (governsLeft) {
                    features.setCount("verb: " + leftRelation + lemma, 1.0);
                }
                if (governsRight) {
                    features.setCount("verb: " + lemma + rightRelation, 1.0);
                }
                if (!governsLeft || !governsRight) continue;
                features.setCount("verb: " + leftRelation + lemma + rightRelation, 1.0);
            }
        }
        if (BasicRelationFeatureFactory.usingFeature(types, checklist, "dependency_path_words")) {
            for (String lemma : noArgPathLemmas) {
                features.setCount("word_in_dependency_path:" + lemma, 1.0);
            }
        }
        if (BasicRelationFeatureFactory.usingFeature(types, checklist, "dependency_path_POS_unigrams")) {
            for (IndexedWord node : pathNodes) {
                if (node.equals(node0) || node.equals(node1)) continue;
                features.setCount("POS_in_dependency_path: " + node.tag(), 1.0);
            }
        }
        for (int node = 0; node < pathNodes.size(); ++node) {
            for (int n = 2; n <= 4 && node + n <= pathNodes.size(); ++n) {
                StringBuilder sb = new StringBuilder();
                StringBuilder sbPOS = new StringBuilder();
                for (int elt = node; elt < node + n; ++elt) {
                    sb.append((String)pathLemmas.get(elt));
                    sb.append("_");
                    sbPOS.append(pathNodes.get(elt).tag());
                    sbPOS.append("_");
                }
                if (BasicRelationFeatureFactory.usingFeature(types, checklist, "dependency_path_word_n_grams")) {
                    features.setCount("dependency_path_" + n + "-gram: " + sb, 1.0);
                }
                if (!BasicRelationFeatureFactory.usingFeature(types, checklist, "dependency_path_POS_n_grams")) continue;
                features.setCount("dependency_path_POS_" + n + "-gram: " + sbPOS, 1.0);
            }
        }
        for (int edge = 0; edge < edgePath.size(); ++edge) {
            String dir;
            if (BasicRelationFeatureFactory.usingFeature(types, checklist, "dependency_path_edge_n_grams") || BasicRelationFeatureFactory.usingFeature(types, checklist, "dependency_path_edge_lowlevel_n_grams")) {
                for (int n = 2; n <= 4 && edge + n <= edgePath.size(); ++n) {
                    StringBuilder sbRelsHi = new StringBuilder();
                    StringBuilder sbRelsLo = new StringBuilder();
                    for (int elt = edge; elt < edge + n; ++elt) {
                        GrammaticalRelation gr = edgePath.get(elt).getRelation();
                        sbRelsHi.append(BasicRelationFeatureFactory.generalizeRelation(gr));
                        sbRelsHi.append("_");
                        sbRelsLo.append(gr);
                        sbRelsLo.append("_");
                    }
                    if (BasicRelationFeatureFactory.usingFeature(types, checklist, "dependency_path_edge_n_grams")) {
                        features.setCount("dependency_path_edge_" + n + "-gram: " + sbRelsHi, 1.0);
                    }
                    if (!BasicRelationFeatureFactory.usingFeature(types, checklist, "dependency_path_edge_lowlevel_n_grams")) continue;
                    features.setCount("dependency_path_edge_lowlevel_" + n + "-gram: " + sbRelsLo, 1.0);
                }
            }
            if (BasicRelationFeatureFactory.usingFeature(types, checklist, "dependency_path_node-edge-node-grams")) {
                features.setCount("dependency_path_node-edge-node-gram: " + (String)pathLemmas.get(edge) + " -- " + BasicRelationFeatureFactory.generalizeRelation(edgePath.get(edge).getRelation()) + " -- " + (String)pathLemmas.get(edge + 1), 1.0);
            }
            if (BasicRelationFeatureFactory.usingFeature(types, checklist, "dependency_path_node-edge-node-grams_lowlevel")) {
                features.setCount("dependency_path_node-edge-node-gram_lowlevel: " + (String)pathLemmas.get(edge) + " -- " + edgePath.get(edge).getRelation() + " -- " + (String)pathLemmas.get(edge + 1), 1.0);
            }
            if (BasicRelationFeatureFactory.usingFeature(types, checklist, "dependency_path_edge-node-edge-grams") && edge > 0) {
                features.setCount("dependency_path_edge-node-edge-gram: " + BasicRelationFeatureFactory.generalizeRelation(edgePath.get(edge - 1).getRelation()) + " -- " + (String)pathLemmas.get(edge) + " -- " + BasicRelationFeatureFactory.generalizeRelation(edgePath.get(edge).getRelation()), 1.0);
            }
            if (BasicRelationFeatureFactory.usingFeature(types, checklist, "dependency_path_edge-node-edge-grams_lowlevel") && edge > 0) {
                features.setCount("dependency_path_edge-node-edge-gram_lowlevel: " + edgePath.get(edge - 1).getRelation() + " -- " + (String)pathLemmas.get(edge) + " -- " + edgePath.get(edge).getRelation(), 1.0);
            }
            String string = dir = pathNodes.get(edge).equals(edgePath.get(edge).getDependent()) ? " -> " : " <- ";
            if (BasicRelationFeatureFactory.usingFeature(types, checklist, "dependency_path_directed_bigrams")) {
                features.setCount("dependency_path_directed_bigram: " + (String)pathLemmas.get(edge) + dir + (String)pathLemmas.get(edge + 1), 1.0);
            }
            if (!BasicRelationFeatureFactory.usingFeature(types, checklist, "dependency_path_edge_unigrams")) continue;
            features.setCount("dependency_path_edge_unigram: " + edgePath.get(edge).getRelation() + dir + (edge == 0 ? " - leftmost" : (edge == edgePath.size() - 1 ? " - rightmost" : " - interior")), 1.0);
        }
        if (BasicRelationFeatureFactory.usingFeature(types, checklist, "dependency_path_length")) {
            features.setCount("dependency_path_length", edgePath.size());
        }
        if (BasicRelationFeatureFactory.usingFeature(types, checklist, "dependency_path_length_binary")) {
            features.setCount("dependency_path_length_" + new DecimalFormat("00").format(edgePath.size()), 1.0);
        }
        if (BasicRelationFeatureFactory.usingFeature(types, checklist, "dependency_path_trigger")) {
            List tokens = (List)rel.getSentence().get(CoreAnnotations.TokensAnnotation.class);
            for (IndexedWord node : pathNodes) {
                String trigger;
                int index = node.index();
                if (indecesToSkip.contains(index) || (trigger = (String)((CoreLabel)tokens.get(index - 1)).get(MachineReadingAnnotations.TriggerAnnotation.class)) == null || !trigger.startsWith("B-")) continue;
                features.incrementCount("dependency_path_trigger=" + trigger.substring(2));
            }
        }
    }

    protected static boolean usingFeature(List<String> types, List<String> checklist, String type) {
        checklist.remove(type);
        return types.contains(type) || types.contains("all");
    }

    protected static GrammaticalRelation generalizeRelation(GrammaticalRelation gr) {
        GrammaticalRelation[] GENERAL_RELATIONS;
        for (GrammaticalRelation generalGR : GENERAL_RELATIONS = new GrammaticalRelation[]{EnglishGrammaticalRelations.SUBJECT, EnglishGrammaticalRelations.COMPLEMENT, EnglishGrammaticalRelations.CONJUNCT, EnglishGrammaticalRelations.MODIFIER}) {
            if (!generalGR.isAncestor(gr)) continue;
            return generalGR;
        }
        return gr;
    }

    public static List<String> dependencyPathAsList(List<SemanticGraphEdge> edgePath, IndexedWord node, boolean generalize) {
        if (edgePath == null) {
            return null;
        }
        ArrayList<String> path = new ArrayList<String>();
        for (SemanticGraphEdge edge : edgePath) {
            IndexedWord nextNode;
            String v;
            GrammaticalRelation relation = generalize ? BasicRelationFeatureFactory.generalizeRelation(edge.getRelation()) : edge.getRelation();
            if (node.equals(edge.getDependent())) {
                v = (relation + "->").intern();
                path.add(v);
                nextNode = edge.getGovernor();
            } else {
                v = ("<-" + relation).intern();
                path.add(v);
                nextNode = edge.getDependent();
            }
            node = nextNode;
        }
        return path;
    }

    public static String dependencyPath(List<SemanticGraphEdge> edgePath, IndexedWord node) {
        return " " + StringUtils.join(BasicRelationFeatureFactory.dependencyPathAsList(edgePath, node, false), "  ") + " ";
    }

    public static String generalizedDependencyPath(List<SemanticGraphEdge> edgePath, IndexedWord node) {
        return " " + StringUtils.join(BasicRelationFeatureFactory.dependencyPathAsList(edgePath, node, true), "  ") + " ";
    }

    @Override
    public Set<String> getFeatures(RelationMention rel, String featureType) {
        ClassicCounter<String> features = new ClassicCounter<String>();
        ArrayList<String> singleton = new ArrayList<String>();
        singleton.add(featureType);
        this.addFeatures(features, rel, singleton);
        return features.keySet();
    }

    @Override
    public String getFeature(RelationMention rel, String featureType) {
        Set<String> features = this.getFeatures(rel, featureType);
        if (features.size() == 0) {
            return "";
        }
        return features.iterator().next();
    }

    static {
        logger.setLevel(Level.INFO);
    }
}

