/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.hcoref.md;

import edu.stanford.nlp.hcoref.data.Dictionaries;
import edu.stanford.nlp.hcoref.data.Mention;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.MultiTokenTag;
import edu.stanford.nlp.parser.common.ParserAnnotations;
import edu.stanford.nlp.parser.common.ParserConstraint;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.trees.Trees;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.IntPair;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;

public abstract class CorefMentionFinder {
    Locale lang;
    public HeadFinder headFinder;
    protected Annotator parserProcessor;
    protected boolean allowReparsing;
    protected static final TregexPattern npOrPrpMentionPattern = TregexPattern.compile("/^(?:NP|PN|PRP)/");
    protected static final TregexPattern enumerationsMentionPattern = TregexPattern.compile("NP < (/^(?:NP|NNP|NML)/=m1 $.. (/^CC|,/ $.. /^(?:NP|NNP|NML)/=m2))");
    private static final TregexPattern[] pleonasticPatterns = CorefMentionFinder.getPleonasticPatterns();

    public abstract List<List<Mention>> findMentions(Annotation var1, Dictionaries var2, Properties var3);

    protected static void extractPremarkedEntityMentions(CoreMap s, List<Mention> mentions, Set<IntPair> mentionSpanSet, Set<IntPair> namedEntitySpanSet) {
        List sent = (List)s.get(CoreAnnotations.TokensAnnotation.class);
        SemanticGraph basicDependency = (SemanticGraph)s.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
        SemanticGraph collapsedDependency = (SemanticGraph)s.get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class);
        int beginIndex = -1;
        for (CoreLabel w : sent) {
            MultiTokenTag t = (MultiTokenTag)w.get(CoreAnnotations.MentionTokenAnnotation.class);
            if (t == null) continue;
            if (t.isStart()) {
                beginIndex = (Integer)w.get(CoreAnnotations.IndexAnnotation.class) - 1;
            }
            if (!t.isEnd()) continue;
            int endIndex = (Integer)w.get(CoreAnnotations.IndexAnnotation.class);
            if (beginIndex >= 0) {
                IntPair mSpan = new IntPair(beginIndex, endIndex);
                int dummyMentionId = -1;
                Mention m = new Mention(dummyMentionId, beginIndex, endIndex, sent, basicDependency, collapsedDependency, new ArrayList<CoreLabel>(sent.subList(beginIndex, endIndex)));
                mentions.add(m);
                mentionSpanSet.add(mSpan);
                beginIndex = -1;
                continue;
            }
            Redwood.log("Start of marked mention not found in sentence: " + t + " at tokenIndex=" + ((Integer)w.get(CoreAnnotations.IndexAnnotation.class) - 1) + " for " + (String)s.get(CoreAnnotations.TextAnnotation.class));
        }
    }

    protected static void extractEnumerations(CoreMap s, List<Mention> mentions, Set<IntPair> mentionSpanSet, Set<IntPair> namedEntitySpanSet) {
        List sent = (List)s.get(CoreAnnotations.TokensAnnotation.class);
        Tree tree = (Tree)s.get(TreeCoreAnnotations.TreeAnnotation.class);
        SemanticGraph basicDependency = (SemanticGraph)s.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
        SemanticGraph collapsedDependency = (SemanticGraph)s.get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class);
        TregexPattern tgrepPattern = enumerationsMentionPattern;
        TregexMatcher matcher = tgrepPattern.matcher(tree);
        Map<IntPair, Tree> spanToMentionSubTree = Generics.newHashMap();
        while (matcher.find()) {
            matcher.getMatch();
            Tree m1 = matcher.getNode("m1");
            Tree m2 = matcher.getNode("m2");
            List mLeaves = m1.getLeaves();
            int beginIdx = (Integer)((CoreLabel)((Tree)mLeaves.get(0)).label()).get(CoreAnnotations.IndexAnnotation.class) - 1;
            int endIdx = (Integer)((CoreLabel)((Tree)mLeaves.get(mLeaves.size() - 1)).label()).get(CoreAnnotations.IndexAnnotation.class);
            spanToMentionSubTree.put(new IntPair(beginIdx, endIdx), m1);
            mLeaves = m2.getLeaves();
            beginIdx = (Integer)((CoreLabel)((Tree)mLeaves.get(0)).label()).get(CoreAnnotations.IndexAnnotation.class) - 1;
            endIdx = (Integer)((CoreLabel)((Tree)mLeaves.get(mLeaves.size() - 1)).label()).get(CoreAnnotations.IndexAnnotation.class);
            spanToMentionSubTree.put(new IntPair(beginIdx, endIdx), m2);
        }
        for (IntPair mSpan : spanToMentionSubTree.keySet()) {
            if (mentionSpanSet.contains(mSpan) || CorefMentionFinder.insideNE(mSpan, namedEntitySpanSet)) continue;
            int dummyMentionId = -1;
            Mention m = new Mention(dummyMentionId, mSpan.get(0), mSpan.get(1), sent, basicDependency, collapsedDependency, new ArrayList<CoreLabel>(sent.subList(mSpan.get(0), mSpan.get(1))), (Tree)spanToMentionSubTree.get(mSpan));
            mentions.add(m);
            mentionSpanSet.add(mSpan);
        }
    }

    protected static boolean insideNE(IntPair mSpan, Set<IntPair> namedEntitySpanSet) {
        for (IntPair span : namedEntitySpanSet) {
            if (span.get(0) > mSpan.get(0) || mSpan.get(1) > span.get(1)) continue;
            return true;
        }
        return false;
    }

    public static boolean inStopList(Mention m) {
        String mentionSpan = m.spanToString().toLowerCase(Locale.ENGLISH);
        if (mentionSpan.equals("u.s.") || mentionSpan.equals("u.k.") || mentionSpan.equals("u.s.s.r")) {
            return true;
        }
        if (mentionSpan.equals("there") || mentionSpan.startsWith("etc.") || mentionSpan.equals("ltd.")) {
            return true;
        }
        return mentionSpan.startsWith("'s ");
    }

    protected void removeSpuriousMentions(Annotation doc, List<List<Mention>> predictedMentions, Dictionaries dict, boolean removeNested, Locale lang) {
        if (lang == Locale.ENGLISH) {
            this.removeSpuriousMentionsEn(doc, predictedMentions, dict);
        } else if (lang == Locale.CHINESE) {
            this.removeSpuriousMentionsZh(doc, predictedMentions, dict, removeNested);
        }
    }

    protected abstract void removeSpuriousMentionsEn(Annotation var1, List<List<Mention>> var2, Dictionaries var3);

    protected void removeSpuriousMentionsZh(Annotation doc, List<List<Mention>> predictedMentions, Dictionaries dict, boolean removeNested) {
        List sentences = (List)doc.get(CoreAnnotations.SentencesAnnotation.class);
        for (int i = 0; i < predictedMentions.size(); ++i) {
            List<Mention> mentions = predictedMentions.get(i);
            List sent = (List)((CoreMap)sentences.get(i)).get(CoreAnnotations.TokensAnnotation.class);
            Set<Mention> remove = Generics.newHashSet();
            for (Mention m : mentions) {
                Object priorWord;
                String lastWord;
                if (m.headWord.ner().matches("PERCENT|MONEY|QUANTITY|CARDINAL")) {
                    remove.add(m);
                }
                if (m.originalSpan.size() == 1 && m.headWord.tag().equals("CD")) {
                    remove.add(m);
                }
                if (dict.removeWords.contains(m.spanToString())) {
                    remove.add(m);
                }
                for (String ch : dict.removeChars) {
                    if (!m.spanToString().contains(ch)) continue;
                    remove.add(m);
                }
                if (m.spanToString().contains("\uff51\uff55\uff4f\uff54")) {
                    remove.add(m);
                    System.err.println("MENTION FILTERING Removed formatting error: " + m.spanToString());
                }
                if ((lastWord = m.originalSpan.get(m.originalSpan.size() - 1).word()).length() > 0 && m.spanToString().endsWith("\u4eba") && dict.countries.contains(lastWord.substring(0, lastWord.length() - 1))) {
                    remove.add(m);
                    System.err.println("MENTION FILTERING Removed demonym: " + m.spanToString());
                }
                if (m.spanToString().equals("\u95ee\u9898") && m.startIndex > 0 && ((CoreLabel)sent.get(m.startIndex - 1)).word().endsWith("\u6ca1")) {
                    remove.add(m);
                    System.err.println("MENTION FILTERING Removed meiyou: " + m.spanToString());
                }
                if (m.spanToString().equals("\u4eba") && m.startIndex > 0 && (((String)(priorWord = ((CoreLabel)sent.get(m.startIndex - 1)).word())).endsWith("\u8ba9") || ((String)priorWord).endsWith("\u4ee4") || ((String)priorWord).endsWith(""))) {
                    remove.add(m);
                    System.err.println("MENTION FILTERING Removed rangren: " + m.spanToString());
                }
                if (m.spanToString().equals("\u4f60") && m.startIndex < sent.size() - 1 && ((CoreLabel)sent.get(m.startIndex + 1)).word().startsWith("\u77e5\u9053")) {
                    remove.add(m);
                    System.err.println("MENTION FILTERING Removed nizhidao: " + m.spanToString());
                }
                if (m.spanToString().contains("\u4ec0\u4e48") || m.spanToString().contains("\u591a\u5c11")) {
                    remove.add(m);
                }
                if (m.spanToString().endsWith("\u7684")) {
                    remove.add(m);
                    System.err.println("MENTION FILTERING Removed de ending: " + m.spanToString());
                }
                priorWord = dict.interrogativePronouns.iterator();
                while (priorWord.hasNext()) {
                    String interrogative = (String)priorWord.next();
                    for (CoreLabel cl : m.originalSpan) {
                        if (!cl.word().equals(interrogative)) continue;
                        remove.add(m);
                    }
                }
            }
            if (removeNested) {
                for (Mention m1 : mentions) {
                    for (Mention m2 : mentions) {
                        if (m1 == m2 || remove.contains(m1) || remove.contains(m2) || m1.sentNum != m2.sentNum || m1.headWord != m2.headWord || !m2.insideIn(m1) || m2.endIndex < sent.size() && (((String)((CoreLabel)sent.get(m2.endIndex)).get(CoreAnnotations.PartOfSpeechAnnotation.class)).equals(",") || ((String)((CoreLabel)sent.get(m2.endIndex)).get(CoreAnnotations.PartOfSpeechAnnotation.class)).equals("CC"))) continue;
                        remove.add(m2);
                    }
                }
            }
            mentions.removeAll(remove);
        }
    }

    protected void extractNamedEntityModifiers(List<CoreMap> sentences, List<Set<IntPair>> mentionSpanSetList, List<List<Mention>> predictedMentions, Set<String> neStrings) {
        for (int i = 0; i < sentences.size(); ++i) {
            List<Mention> mentions = predictedMentions.get(i);
            CoreMap sent = sentences.get(i);
            List tokens = (List)sent.get(CoreAnnotations.TokensAnnotation.class);
            Set<IntPair> mentionSpanSet = mentionSpanSetList.get(i);
            for (int j = 0; j < tokens.size(); ++j) {
                for (String ne : neStrings) {
                    Tree eJoin;
                    Tree sJoin;
                    Tree join;
                    Tree eToken;
                    Tree sToken;
                    Tree tree;
                    int len = ne.split(" ").length;
                    if (j + len > tokens.size()) continue;
                    StringBuilder sb = new StringBuilder();
                    for (int k = 0; k < len; ++k) {
                        sb.append(((CoreLabel)tokens.get(k + j)).word()).append(" ");
                    }
                    String phrase = sb.toString().trim();
                    int beginIndex = j;
                    int endIndex = j + len;
                    if (endIndex < tokens.size() && ((CoreLabel)tokens.get(endIndex)).word().equals("'s") && ((CoreLabel)tokens.get(endIndex)).tag().equals("POS")) {
                        tree = (Tree)sent.get(TreeCoreAnnotations.TreeAnnotation.class);
                        sToken = (Tree)tree.getLeaves().get(beginIndex);
                        eToken = (Tree)tree.getLeaves().get(endIndex);
                        join = tree.joinNode(sToken, eToken);
                        sJoin = (Tree)join.getLeaves().get(0);
                        eJoin = (Tree)join.getLeaves().get(join.getLeaves().size() - 1);
                        if (sToken == sJoin && eToken == eJoin) {
                            ++endIndex;
                        }
                    }
                    if (beginIndex > 0 && ((CoreLabel)tokens.get(beginIndex - 1)).tag().equals("DT")) {
                        tree = (Tree)sent.get(TreeCoreAnnotations.TreeAnnotation.class);
                        sToken = (Tree)tree.getLeaves().get(beginIndex - 1);
                        eToken = (Tree)tree.getLeaves().get(endIndex - 1);
                        join = tree.joinNode(sToken, eToken);
                        sJoin = (Tree)join.getLeaves().get(0);
                        eJoin = (Tree)join.getLeaves().get(join.getLeaves().size() - 1);
                        if (sToken == sJoin && eToken == eJoin) {
                            --beginIndex;
                        }
                    }
                    IntPair span = new IntPair(beginIndex, endIndex);
                    if (!phrase.equalsIgnoreCase(ne) || mentionSpanSet.contains(span)) continue;
                    int dummyMentionId = -1;
                    Mention m = new Mention(dummyMentionId, beginIndex, endIndex, tokens, (SemanticGraph)sent.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class), (SemanticGraph)sent.get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class), new ArrayList<CoreLabel>(tokens.subList(beginIndex, endIndex)));
                    mentions.add(m);
                    mentionSpanSet.add(span);
                }
            }
        }
    }

    protected static void addNamedEntityStrings(CoreMap s, Set<String> neStrings, Set<IntPair> namedEntitySpanSet) {
        List tokens = (List)s.get(CoreAnnotations.TokensAnnotation.class);
        for (IntPair p : namedEntitySpanSet) {
            StringBuilder sb = new StringBuilder();
            for (int idx = p.get(0); idx < p.get(1); ++idx) {
                sb.append(((CoreLabel)tokens.get(idx)).word()).append(" ");
            }
            String str = sb.toString().trim();
            if (str.endsWith(" 's")) {
                str = str.substring(0, str.length() - 3);
            }
            neStrings.add(str);
        }
    }

    protected void addGoldMentions(List<CoreMap> sentences, List<Set<IntPair>> mentionSpanSetList, List<List<Mention>> predictedMentions, List<List<Mention>> allGoldMentions) {
        for (int i = 0; i < sentences.size(); ++i) {
            List<Mention> mentions = predictedMentions.get(i);
            CoreMap sent = sentences.get(i);
            List tokens = (List)sent.get(CoreAnnotations.TokensAnnotation.class);
            Set<IntPair> mentionSpanSet = mentionSpanSetList.get(i);
            List<Mention> golds = allGoldMentions.get(i);
            for (Mention g : golds) {
                IntPair pair = new IntPair(g.startIndex, g.endIndex);
                if (mentionSpanSet.contains(pair)) continue;
                int dummyMentionId = -1;
                Mention m = new Mention(dummyMentionId, g.startIndex, g.endIndex, tokens, (SemanticGraph)sent.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class), (SemanticGraph)sent.get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class), new ArrayList<CoreLabel>(tokens.subList(g.startIndex, g.endIndex)));
                mentions.add(m);
                mentionSpanSet.add(pair);
            }
        }
    }

    public void findHead(CoreMap s, List<Mention> mentions) {
        Tree tree = (Tree)s.get(TreeCoreAnnotations.TreeAnnotation.class);
        List sent = (List)s.get(CoreAnnotations.TokensAnnotation.class);
        tree.indexSpans(0);
        for (Mention m : mentions) {
            int start;
            if (this.lang == Locale.CHINESE) {
                this.findHeadChinese(sent, m);
            } else {
                CoreLabel head = (CoreLabel)this.findSyntacticHead(m, tree, sent).label();
                m.headIndex = (Integer)head.get(CoreAnnotations.IndexAnnotation.class) - 1;
                m.headWord = (CoreLabel)sent.get(m.headIndex);
                m.headString = ((String)m.headWord.get(CoreAnnotations.TextAnnotation.class)).toLowerCase(Locale.ENGLISH);
            }
            if ((start = m.headIndex - m.startIndex) >= 0 && start < m.originalSpan.size()) continue;
            Redwood.log("Invalid index for head " + start + "=" + m.headIndex + "-" + m.startIndex + ": originalSpan=[" + StringUtils.joinWords(m.originalSpan, " ") + "], head=" + m.headWord);
            Redwood.log("Setting head string to entire mention");
            m.headIndex = m.startIndex;
            m.headWord = m.originalSpan.size() > 0 ? m.originalSpan.get(0) : (CoreLabel)sent.get(m.startIndex);
            m.headString = m.originalSpan.toString();
        }
    }

    protected void findHeadChinese(List<CoreLabel> sent, Mention m) {
        int headPos;
        for (headPos = m.endIndex - 1; ((String)sent.get(headPos).get(CoreAnnotations.PartOfSpeechAnnotation.class)).equals("PU") && headPos >= m.startIndex; --headPos) {
        }
        if (headPos < m.startIndex) {
            headPos = m.endIndex - 1;
        }
        if (sent.get(headPos).originalText().equals("\u81ea\u5df1") && m.endIndex != m.startIndex) {
            --headPos;
        }
        m.headIndex = headPos;
        m.headWord = sent.get(headPos);
        m.headString = (String)m.headWord.get(CoreAnnotations.TextAnnotation.class);
    }

    public Tree findSyntacticHead(Mention m, Tree root, List<CoreLabel> tokens) {
        int index;
        Tree head;
        Tree exactMatch;
        String lastWord;
        int endIdx = m.endIndex;
        if (m.originalSpan.size() > 0 && ((lastWord = (String)m.originalSpan.get(m.originalSpan.size() - 1).get(CoreAnnotations.TextAnnotation.class)).equals("'s") || lastWord.equals("'")) && m.originalSpan.size() != 1) {
            --endIdx;
        }
        if ((exactMatch = CorefMentionFinder.findTreeWithSpan(root, m.startIndex, endIdx)) != null) {
            return this.safeHead(exactMatch, endIdx);
        }
        if (this.allowReparsing) {
            int approximateness = 0;
            ArrayList<CoreLabel> extentTokens = new ArrayList<CoreLabel>();
            extentTokens.add(CorefMentionFinder.initCoreLabel("It"));
            extentTokens.add(CorefMentionFinder.initCoreLabel("was"));
            int ADDED_WORDS = 2;
            for (int i = m.startIndex; i < endIdx; ++i) {
                CoreLabel label = tokens.get(i);
                if (!"-".equals(label.word())) {
                    extentTokens.add(tokens.get(i));
                    continue;
                }
                ++approximateness;
            }
            extentTokens.add(CorefMentionFinder.initCoreLabel("."));
            ParserConstraint constraint = new ParserConstraint(2, extentTokens.size() - 1, Pattern.compile(".*"));
            List<ParserConstraint> constraints = Collections.singletonList(constraint);
            Tree tree = this.parse(extentTokens, constraints);
            CorefMentionFinder.convertToCoreLabels(tree);
            tree.indexSpans(m.startIndex - 2);
            Tree subtree = CorefMentionFinder.findPartialSpan(tree, m.startIndex);
            Tree extentHead = this.safeHead(subtree, endIdx);
            assert (extentHead != null);
            CoreLabel l = (CoreLabel)extentHead.label();
            Tree realHead = CorefMentionFinder.funkyFindLeafWithApproximateSpan(root, l.value(), (Integer)l.get(CoreAnnotations.BeginIndexAnnotation.class), approximateness);
            assert (realHead != null);
            return realHead;
        }
        Tree wordMatch = CorefMentionFinder.findTreeWithSmallestSpan(root, m.startIndex, endIdx);
        if (wordMatch != null && (head = this.safeHead(wordMatch, endIdx)) != null && (index = (Integer)((CoreLabel)head.label()).get(CoreAnnotations.IndexAnnotation.class) - 1) >= m.startIndex && index < endIdx) {
            return head;
        }
        int lastNounIdx = endIdx - 1;
        for (int i = m.startIndex; i < m.endIndex; ++i) {
            if (tokens.get(i).tag().startsWith("N")) {
                lastNounIdx = i;
                continue;
            }
            if (tokens.get(i).tag().startsWith("W")) break;
        }
        List leaves = root.getLeaves();
        Tree endLeaf = (Tree)leaves.get(lastNounIdx);
        return endLeaf;
    }

    private static Tree findPartialSpan(Tree root, int start) {
        CoreLabel label = (CoreLabel)root.label();
        int startIndex = (Integer)label.get(CoreAnnotations.BeginIndexAnnotation.class);
        if (startIndex == start) {
            return root;
        }
        for (Tree kid : root.children()) {
            CoreLabel kidLabel = (CoreLabel)kid.label();
            int kidStart = (Integer)kidLabel.get(CoreAnnotations.BeginIndexAnnotation.class);
            int kidEnd = (Integer)kidLabel.get(CoreAnnotations.EndIndexAnnotation.class);
            if (kidStart > start || kidEnd <= start) continue;
            return CorefMentionFinder.findPartialSpan(kid, start);
        }
        throw new RuntimeException("Shouldn't happen: " + start + " " + root);
    }

    private static Tree funkyFindLeafWithApproximateSpan(Tree root, String token, int index, int approximateness) {
        List leaves = root.getLeaves();
        for (Tree leaf : leaves) {
            CoreLabel label = (CoreLabel)CoreLabel.class.cast(leaf.label());
            Integer indexInteger = (Integer)label.get(CoreAnnotations.IndexAnnotation.class);
            if (indexInteger == null) continue;
            int ind = indexInteger - 1;
            if (!token.equals(leaf.value()) || ind < index || ind > index + approximateness) continue;
            return leaf;
        }
        Redwood.log("RuleBasedCorefMentionFinder: Failed to find head token:\nTree is: " + root + "\n" + "token = |" + token + "|" + index + "|, approx=" + approximateness);
        for (Tree leaf : leaves) {
            if (!token.equals(leaf.value())) continue;
            return leaf;
        }
        int fallback = Math.max(0, leaves.size() - 2);
        Redwood.log("RuleBasedCorefMentionFinder: Last resort: returning as head: " + leaves.get(fallback));
        return (Tree)leaves.get(fallback);
    }

    private static CoreLabel initCoreLabel(String token) {
        CoreLabel label = new CoreLabel();
        label.set(CoreAnnotations.TextAnnotation.class, token);
        label.set(CoreAnnotations.ValueAnnotation.class, token);
        return label;
    }

    private Tree parse(List<CoreLabel> tokens) {
        return this.parse(tokens, null);
    }

    private Tree parse(List<CoreLabel> tokens, List<ParserConstraint> constraints) {
        Annotation sent = new Annotation("");
        sent.set(CoreAnnotations.TokensAnnotation.class, tokens);
        sent.set(ParserAnnotations.ConstraintAnnotation.class, constraints);
        Annotation doc = new Annotation("");
        List sents = new ArrayList<Annotation>(1);
        sents.add(sent);
        doc.set(CoreAnnotations.SentencesAnnotation.class, sents);
        this.getParser().annotate(doc);
        sents = (List)doc.get(CoreAnnotations.SentencesAnnotation.class);
        return (Tree)((CoreMap)sents.get(0)).get(TreeCoreAnnotations.TreeAnnotation.class);
    }

    private Annotator getParser() {
        if (this.parserProcessor == null) {
            this.parserProcessor = StanfordCoreNLP.getExistingAnnotator("parse");
            assert (this.parserProcessor != null);
        }
        return this.parserProcessor;
    }

    private static void convertToCoreLabels(Tree tree) {
        Label l = tree.label();
        if (!(l instanceof CoreLabel)) {
            CoreLabel cl = new CoreLabel();
            cl.setValue(l.value());
            tree.setLabel(cl);
        }
        for (Tree kid : tree.children()) {
            CorefMentionFinder.convertToCoreLabels(kid);
        }
    }

    private Tree safeHead(Tree top, int endIndex) {
        int headIndex;
        Integer headIndexInteger;
        Tree head = top.headTerminal(this.headFinder);
        if (head != null && (headIndexInteger = (Integer)((CoreLabel)head.label()).get(CoreAnnotations.IndexAnnotation.class)) != null && (headIndex = headIndexInteger - 1) < endIndex) {
            return head;
        }
        List leaves = top.getLeaves();
        for (int candidate = leaves.size() - 1; candidate >= 0; --candidate) {
            int headIndex2;
            head = (Tree)leaves.get(candidate);
            Integer headIndexInteger2 = (Integer)((CoreLabel)head.label()).get(CoreAnnotations.IndexAnnotation.class);
            if (headIndexInteger2 == null || (headIndex2 = headIndexInteger2 - 1) >= endIndex) continue;
            return head;
        }
        return top;
    }

    static Tree findTreeWithSmallestSpan(Tree tree, int start, int end) {
        List leaves = tree.getLeaves();
        Tree startLeaf = (Tree)leaves.get(start);
        Tree endLeaf = (Tree)leaves.get(end - 1);
        return Trees.getLowestCommonAncestor(Arrays.asList(startLeaf, endLeaf), tree);
    }

    private static Tree findTreeWithSpan(Tree tree, int start, int end) {
        CoreLabel l = (CoreLabel)tree.label();
        if (l != null && l.has(CoreAnnotations.BeginIndexAnnotation.class) && l.has(CoreAnnotations.EndIndexAnnotation.class)) {
            int myStart = (Integer)l.get(CoreAnnotations.BeginIndexAnnotation.class);
            int myEnd = (Integer)l.get(CoreAnnotations.EndIndexAnnotation.class);
            if (start == myStart && end == myEnd) {
                return tree;
            }
            if (end < myStart) {
                return null;
            }
            if (start >= myEnd) {
                return null;
            }
        }
        for (Tree kid : tree.children()) {
            Tree ret;
            if (kid == null || (ret = CorefMentionFinder.findTreeWithSpan(kid, start, end)) == null) continue;
            return ret;
        }
        return null;
    }

    public static boolean partitiveRule(Mention m, List<CoreLabel> sent, Dictionaries dict) {
        return m.startIndex >= 2 && ((String)sent.get(m.startIndex - 1).get(CoreAnnotations.TextAnnotation.class)).equalsIgnoreCase("of") && dict.parts.contains(((String)sent.get(m.startIndex - 2).get(CoreAnnotations.TextAnnotation.class)).toLowerCase(Locale.ENGLISH));
    }

    public static boolean isPleonastic(Mention m, Tree tree) {
        if (!m.spanToString().equalsIgnoreCase("it")) {
            return false;
        }
        for (TregexPattern p : pleonasticPatterns) {
            if (!CorefMentionFinder.checkPleonastic(m, tree, p)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPleonasticDebug(Mention m, Tree tree, StringBuilder sbLog) {
        if (!m.spanToString().equalsIgnoreCase("it")) {
            return false;
        }
        boolean isPleonastic = false;
        int patternIdx = -1;
        int matchedPattern = -1;
        for (TregexPattern p : pleonasticPatterns) {
            ++patternIdx;
            if (!CorefMentionFinder.checkPleonastic(m, tree, p)) continue;
            isPleonastic = true;
            matchedPattern = patternIdx;
        }
        sbLog.append("PLEONASTIC IT: mention ID: " + m.mentionID + "\thastwin: " + m.hasTwin + "\tpleonastic it? " + isPleonastic + "\tcorrect? " + (m.hasTwin != isPleonastic) + "\tmatched pattern: " + matchedPattern + "\n");
        sbLog.append(m.contextParseTree.pennString()).append("\n");
        sbLog.append("PLEONASTIC IT END\n");
        return isPleonastic;
    }

    private static TregexPattern[] getPleonasticPatterns() {
        String[] patterns = new String[]{"@NP < (PRP=m1 < it|IT|It) $.. (@VP < (/^V.*/ < /^(?i:is|was|be|becomes|become|became)$/ $.. (@VP < (VBN $.. @S|SBAR))))", "NP < (PRP=m1) $.. (VP < ((/^V.*/ < /^(?:is|was|become|became)/) $.. (ADJP $.. (/S|SBAR/))))", "NP < (PRP=m1) $.. (VP < ((/^V.*/ < /^(?:is|was|become|became)/) $.. (ADJP < (/S|SBAR/))))", "NP < (PRP=m1) $.. (VP < ((/^V.*/ < /^(?:is|was|become|became)/) $.. (NP < /S|SBAR/)))", "NP < (PRP=m1) $.. (VP < ((/^V.*/ < /^(?:is|was|become|became)/) $.. (NP $.. ADVP $.. /S|SBAR/)))", "NP < (PRP=m1) $.. (VP < (MD $.. (VP < ((/^V.*/ < /^(?:be|become)/) $.. (VP < (VBN $.. /S|SBAR/))))))", "NP < (PRP=m1) $.. (VP < (MD $.. (VP < ((/^V.*/ < /^(?:be|become)/) $.. (ADJP $.. (/S|SBAR/))))))", "NP < (PRP=m1) $.. (VP < (MD $.. (VP < ((/^V.*/ < /^(?:be|become)/) $.. (ADJP < (/S|SBAR/))))))", "NP < (PRP=m1) $.. (VP < (MD $.. (VP < ((/^V.*/ < /^(?:be|become)/) $.. (NP < /S|SBAR/)))))", "NP < (PRP=m1) $.. (VP < (MD $.. (VP < ((/^V.*/ < /^(?:be|become)/) $.. (NP $.. ADVP $.. /S|SBAR/)))))", "NP < (PRP=m1) $.. (VP < ((/^V.*/ < /^(?:seems|appears|means|follows)/) $.. /S|SBAR/))", "NP < (PRP=m1) $.. (VP < ((/^V.*/ < /^(?:turns|turned)/) $.. PRT $.. /S|SBAR/))"};
        TregexPattern[] tgrepPatterns = new TregexPattern[patterns.length];
        for (int i = 0; i < tgrepPatterns.length; ++i) {
            tgrepPatterns[i] = TregexPattern.compile(patterns[i]);
        }
        return tgrepPatterns;
    }

    private static boolean checkPleonastic(Mention m, Tree tree, TregexPattern tgrepPattern) {
        try {
            TregexMatcher matcher = tgrepPattern.matcher(tree);
            while (matcher.find()) {
                Tree np1 = matcher.getNode("m1");
                if ((Integer)((CoreLabel)np1.label()).get(CoreAnnotations.BeginIndexAnnotation.class) + 1 != (Integer)m.headWord.get(CoreAnnotations.IndexAnnotation.class)) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

