/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.hcoref;

import edu.stanford.nlp.classify.Classifier;
import edu.stanford.nlp.classify.Dataset;
import edu.stanford.nlp.classify.GeneralDataset;
import edu.stanford.nlp.classify.LogisticClassifier;
import edu.stanford.nlp.classify.LogisticClassifierFactory;
import edu.stanford.nlp.hcoref.CorefDocMaker;
import edu.stanford.nlp.hcoref.CorefProperties;
import edu.stanford.nlp.hcoref.data.CorefCluster;
import edu.stanford.nlp.hcoref.data.Dictionaries;
import edu.stanford.nlp.hcoref.data.Document;
import edu.stanford.nlp.hcoref.data.Mention;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.BasicDatum;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.StringUtils;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class SingletonPredictor {
    public static void setTokenIndices(Document doc) {
        int token_index = 0;
        for (CoreMap sent : (List)doc.annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreLabel token : (List)sent.get(CoreAnnotations.TokensAnnotation.class)) {
                token.set(CoreAnnotations.TokenBeginAnnotation.class, token_index++);
            }
        }
    }

    public GeneralDataset<String, String> generateFeatureVectors(Properties props) throws Exception {
        Document document;
        Dataset<String, String> dataset = new Dataset<String, String>();
        Dictionaries dict = new Dictionaries(props);
        CorefDocMaker docMaker = new CorefDocMaker(props, dict);
        while ((document = docMaker.nextDoc()) != null) {
            IndexedWord head;
            SingletonPredictor.setTokenIndices(document);
            document.extractGoldCorefClusters();
            Map<Integer, CorefCluster> entities = document.goldCorefClusters;
            for (CorefCluster entity : entities.values()) {
                for (Mention mention : entity.getCorefMentions()) {
                    if (mention.headWord.tag().startsWith("V") || (head = mention.collapsedDependency.getNodeByIndexSafe(mention.headWord.index())) == null) continue;
                    ArrayList<String> feats = mention.getSingletonFeatures(dict);
                    ((GeneralDataset)dataset).add(new BasicDatum<String, String>(feats, "1"));
                }
            }
            ArrayList<CoreLabel> gold_heads = new ArrayList<CoreLabel>();
            for (Mention gold_men : document.goldMentionsByID.values()) {
                gold_heads.add(gold_men.headWord);
            }
            for (Mention predicted_men : document.predictedMentionsByID.values()) {
                SemanticGraph dep = predicted_men.collapsedDependency;
                head = dep.getNodeByIndexSafe(predicted_men.headWord.index());
                if (head == null || !dep.vertexSet().contains(head) || predicted_men.headWord.tag().startsWith("V") || gold_heads.contains(predicted_men.headWord)) continue;
                ((GeneralDataset)dataset).add(new BasicDatum<String, String>(predicted_men.getSingletonFeatures(dict), "0"));
            }
        }
        ((GeneralDataset)dataset).summaryStatistics();
        return dataset;
    }

    public LogisticClassifier<String, String> train(GeneralDataset<String, String> pDataset) {
        LogisticClassifierFactory lcf = new LogisticClassifierFactory();
        Classifier classifier = lcf.trainClassifier((GeneralDataset)pDataset);
        return classifier;
    }

    public void saveToSerialized(LogisticClassifier<String, String> predictor, String filename) {
        try {
            System.err.print("Writing singleton predictor in serialized format to file " + filename + ' ');
            ObjectOutputStream out2 = IOUtils.writeStreamFromString(filename);
            out2.writeObject(predictor);
            out2.close();
            System.err.println("done.");
        }
        catch (IOException ioe) {
            throw new RuntimeIOException(ioe);
        }
    }

    public static void main(String[] args) throws Exception {
        Properties props = null;
        if (args.length > 0) {
            props = StringUtils.argsToProperties(args);
        }
        if (!props.containsKey("dcoref.conll2011")) {
            System.err.println("-dcoref.conll2011 [input_CoNLL_corpus]: was not specified");
            return;
        }
        if (!props.containsKey("singleton.predictor.output")) {
            System.err.println("-singleton.predictor.output [output_model_file]: was not specified");
            return;
        }
        SingletonPredictor predictor = new SingletonPredictor();
        GeneralDataset<String, String> data = predictor.generateFeatureVectors(props);
        LogisticClassifier<String, String> classifier = predictor.train(data);
        predictor.saveToSerialized(classifier, CorefProperties.getPathSingletonPredictor(props));
    }
}

