/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.hcoref;

import edu.stanford.nlp.classify.LogisticClassifier;
import edu.stanford.nlp.hcoref.CorefProperties;
import edu.stanford.nlp.hcoref.Preprocessor;
import edu.stanford.nlp.hcoref.data.Dictionaries;
import edu.stanford.nlp.hcoref.data.Document;
import edu.stanford.nlp.hcoref.data.InputDoc;
import edu.stanford.nlp.hcoref.data.Mention;
import edu.stanford.nlp.hcoref.docreader.CoNLLDocumentReader;
import edu.stanford.nlp.hcoref.docreader.DocReader;
import edu.stanford.nlp.hcoref.md.CorefMentionFinder;
import edu.stanford.nlp.hcoref.md.DependencyCorefMentionFinder;
import edu.stanford.nlp.hcoref.md.HybridCorefMentionFinder;
import edu.stanford.nlp.hcoref.md.RuleBasedCorefMentionFinder;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.SemanticHeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.trees.TreeLemmatizer;
import edu.stanford.nlp.trees.international.pennchinese.ChineseSemanticHeadFinder;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

public class CorefDocMaker {
    Properties props;
    DocReader reader;
    final HeadFinder headFinder;
    CorefMentionFinder md;
    Dictionaries dict;
    StanfordCoreNLP corenlp;
    final TreeLemmatizer treeLemmatizer;
    LogisticClassifier<String, String> singletonPredictor;

    public CorefDocMaker(Properties props, Dictionaries dictionaries) throws ClassNotFoundException, IOException {
        this.props = props;
        this.dict = dictionaries;
        this.reader = CorefDocMaker.getDocumentReader(props);
        this.headFinder = CorefDocMaker.getHeadFinder(props);
        this.md = CorefDocMaker.getMentionFinder(props, dictionaries, this.headFinder);
        this.corenlp = this.loadStanfordProcessor(props);
        this.treeLemmatizer = new TreeLemmatizer();
        this.singletonPredictor = CorefProperties.useSingletonPredictor(props) ? CorefDocMaker.getSingletonPredictorFromSerializedFile(CorefProperties.getPathSingletonPredictor(props)) : null;
    }

    protected StanfordCoreNLP loadStanfordProcessor(Properties props) {
        Properties pipelineProps = new Properties(props);
        StringBuilder annoSb = new StringBuilder("");
        if (!CorefProperties.useGoldPOS(props)) {
            annoSb.append("pos, lemma");
        } else {
            annoSb.append("lemma");
        }
        if (!CorefProperties.useGoldNE(props) || CorefProperties.getLanguage(props) == Locale.CHINESE) {
            annoSb.append(", ner");
        }
        if (!CorefProperties.useGoldParse(props)) {
            if (CorefProperties.useConstituencyTree(props)) {
                annoSb.append(", parse");
            } else {
                annoSb.append(", depparse");
            }
        }
        String annoStr = annoSb.toString();
        Redwood.log("MentionExtractor ignores specified annotators, using annotators=" + annoStr);
        pipelineProps.put("annotators", annoStr);
        return new StanfordCoreNLP(pipelineProps, false);
    }

    private static DocReader getDocumentReader(Properties props) {
        switch (CorefProperties.getInputType(props)) {
            case CONLL: {
                String corpusPath = CorefProperties.getPathInput(props);
                CoNLLDocumentReader.Options options = new CoNLLDocumentReader.Options();
                options.annotateTokenCoref = false;
                if (CorefProperties.useCoNLLAuto(props)) {
                    options.setFilter(".*_auto_conll$");
                }
                options.lang = CorefProperties.getLanguage(props);
                return new CoNLLDocumentReader(corpusPath, options);
            }
            case ACE: {
                return null;
            }
            case MUC: {
                return null;
            }
        }
        return null;
    }

    private static HeadFinder getHeadFinder(Properties props) {
        Locale lang = CorefProperties.getLanguage(props);
        if (lang == Locale.ENGLISH) {
            return new SemanticHeadFinder();
        }
        if (lang == Locale.CHINESE) {
            return new ChineseSemanticHeadFinder();
        }
        throw new RuntimeException("Invalid language setting: cannot load HeadFinder");
    }

    private static CorefMentionFinder getMentionFinder(Properties props, Dictionaries dictionaries, HeadFinder headFinder) throws ClassNotFoundException, IOException {
        switch (CorefProperties.getMDType(props)) {
            case RULE: {
                return new RuleBasedCorefMentionFinder(headFinder, props);
            }
            case HYBRID: {
                return new HybridCorefMentionFinder(headFinder, props);
            }
        }
        return new DependencyCorefMentionFinder(props);
    }

    public Document makeDocument(Annotation anno) throws Exception {
        return this.makeDocument(new InputDoc(anno, null, null));
    }

    public Document makeDocument(InputDoc input) throws Exception {
        if (input == null) {
            return null;
        }
        Annotation anno = input.annotation;
        this.addMissingAnnotation(anno);
        if (input.conllDoc != null && CorefProperties.getLanguage(this.props) == Locale.CHINESE) {
            CorefProperties.setRemoveNested(this.props, !input.conllDoc.documentID.contains("nw"));
        }
        List<List<Mention>> mentions = this.md.findMentions(anno, this.dict, this.props);
        Document doc = new Document(input, mentions);
        if (input.goldMentions != null) {
            this.findGoldMentionHeads(doc);
        }
        Preprocessor.preprocess(doc, this.dict, this.singletonPredictor, this.headFinder);
        return doc;
    }

    private void findGoldMentionHeads(Document doc) {
        List sentences = (List)doc.annotation.get(CoreAnnotations.SentencesAnnotation.class);
        for (int i = 0; i < sentences.size(); ++i) {
            DependencyCorefMentionFinder.findHeadInDependency((CoreMap)sentences.get(i), doc.goldMentions.get(i));
        }
    }

    private void addMissingAnnotation(Annotation anno) {
        boolean useConstituency = CorefProperties.useConstituencyTree(this.props);
        boolean LEMMATIZE = true;
        List sentences = (List)anno.get(CoreAnnotations.SentencesAnnotation.class);
        for (CoreMap sentence : sentences) {
            boolean hasTree = sentence.containsKey(TreeCoreAnnotations.TreeAnnotation.class);
            Tree tree = (Tree)sentence.get(TreeCoreAnnotations.TreeAnnotation.class);
            if (!useConstituency) {
                sentence.remove(TreeCoreAnnotations.TreeAnnotation.class);
            }
            if (!hasTree || !useConstituency) continue;
            this.treeLemmatizer.transformTree(tree);
        }
        this.corenlp.annotate(anno);
    }

    public void resetDocs() {
        this.reader.reset();
    }

    public Document nextDoc() throws Exception {
        InputDoc input = this.reader.nextDoc();
        return input == null ? null : this.makeDocument(input);
    }

    public static LogisticClassifier<String, String> getSingletonPredictorFromSerializedFile(String serializedFile) {
        try {
            ObjectInputStream ois = IOUtils.readStreamFromString(serializedFile);
            Object o = ois.readObject();
            if (o instanceof LogisticClassifier) {
                return (LogisticClassifier)o;
            }
            throw new ClassCastException("Wanted SingletonPredictor, got " + o.getClass());
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

