/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2.internal.hpack;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.internal.hpack.DynamicTable;
import io.netty.handler.codec.http2.internal.hpack.HeaderField;
import io.netty.handler.codec.http2.internal.hpack.HpackUtil;
import io.netty.handler.codec.http2.internal.hpack.HuffmanDecoder;
import io.netty.handler.codec.http2.internal.hpack.StaticTable;
import io.netty.util.AsciiString;
import io.netty.util.internal.ThrowableUtil;

public final class Decoder {
    private static final Http2Exception DECODE_DECOMPRESSION_EXCEPTION = ThrowableUtil.unknownStackTrace(Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, "HPACK - decompression failure", new Object[0]), Decoder.class, "decode(...)");
    private static final Http2Exception DECODE_ULE_128_DECOMPRESSION_EXCEPTION = ThrowableUtil.unknownStackTrace(Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, "HPACK - decompression failure", new Object[0]), Decoder.class, "decodeULE128(...)");
    private static final Http2Exception DECODE_ILLEGAL_INDEX_VALUE = ThrowableUtil.unknownStackTrace(Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, "HPACK - illegal index value", new Object[0]), Decoder.class, "decode(...)");
    private static final Http2Exception INDEX_HEADER_ILLEGAL_INDEX_VALUE = ThrowableUtil.unknownStackTrace(Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, "HPACK - illegal index value", new Object[0]), Decoder.class, "indexHeader(...)");
    private static final Http2Exception READ_NAME_ILLEGAL_INDEX_VALUE = ThrowableUtil.unknownStackTrace(Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, "HPACK - illegal index value", new Object[0]), Decoder.class, "readName(...)");
    private static final Http2Exception INVALID_MAX_DYNAMIC_TABLE_SIZE = ThrowableUtil.unknownStackTrace(Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, "HPACK - invalid max dynamic table size", new Object[0]), Decoder.class, "setDynamicTableSize(...)");
    private static final Http2Exception MAX_DYNAMIC_TABLE_SIZE_CHANGE_REQUIRED = ThrowableUtil.unknownStackTrace(Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, "HPACK - max dynamic table size change required", new Object[0]), Decoder.class, "decode(...)");
    private static final byte READ_HEADER_REPRESENTATION = 0;
    private static final byte READ_MAX_DYNAMIC_TABLE_SIZE = 1;
    private static final byte READ_INDEXED_HEADER = 2;
    private static final byte READ_INDEXED_HEADER_NAME = 3;
    private static final byte READ_LITERAL_HEADER_NAME_LENGTH_PREFIX = 4;
    private static final byte READ_LITERAL_HEADER_NAME_LENGTH = 5;
    private static final byte READ_LITERAL_HEADER_NAME = 6;
    private static final byte READ_LITERAL_HEADER_VALUE_LENGTH_PREFIX = 7;
    private static final byte READ_LITERAL_HEADER_VALUE_LENGTH = 8;
    private static final byte READ_LITERAL_HEADER_VALUE = 9;
    private final DynamicTable dynamicTable;
    private final HuffmanDecoder huffmanDecoder;
    private long maxHeaderListSize = 8192L;
    private long maxDynamicTableSize;
    private long encoderMaxDynamicTableSize;
    private boolean maxDynamicTableSizeChangeRequired;

    public Decoder() {
        this(32);
    }

    public Decoder(int initialHuffmanDecodeCapacity) {
        this(initialHuffmanDecodeCapacity, 4096);
    }

    Decoder(int initialHuffmanDecodeCapacity, int maxHeaderTableSize) {
        this.maxDynamicTableSize = this.encoderMaxDynamicTableSize = (long)maxHeaderTableSize;
        this.maxDynamicTableSizeChangeRequired = false;
        this.dynamicTable = new DynamicTable(maxHeaderTableSize);
        this.huffmanDecoder = new HuffmanDecoder(initialHuffmanDecodeCapacity);
    }

    public void decode(int streamId, ByteBuf in, Http2Headers headers) throws Http2Exception {
        int index = 0;
        long headersLength = 0L;
        int nameLength = 0;
        int valueLength = 0;
        int state = 0;
        boolean huffmanEncoded = false;
        CharSequence name = null;
        HpackUtil.IndexType indexType = HpackUtil.IndexType.NONE;
        block28: while (in.isReadable()) {
            switch (state) {
                case 0: {
                    byte b = in.readByte();
                    if (this.maxDynamicTableSizeChangeRequired && (b & 0xE0) != 32) {
                        throw MAX_DYNAMIC_TABLE_SIZE_CHANGE_REQUIRED;
                    }
                    if (b < 0) {
                        index = b & 0x7F;
                        switch (index) {
                            case 0: {
                                throw DECODE_ILLEGAL_INDEX_VALUE;
                            }
                            case 127: {
                                state = 2;
                                continue block28;
                            }
                        }
                        headersLength = this.indexHeader(streamId, index, headers, headersLength);
                        continue block28;
                    }
                    if ((b & 0x40) == 64) {
                        indexType = HpackUtil.IndexType.INCREMENTAL;
                        index = b & 0x3F;
                        switch (index) {
                            case 0: {
                                state = 4;
                                continue block28;
                            }
                            case 63: {
                                state = 3;
                                continue block28;
                            }
                        }
                        name = this.readName(index);
                        state = 7;
                        continue block28;
                    }
                    if ((b & 0x20) == 32) {
                        index = b & 0x1F;
                        if (index == 31) {
                            state = 1;
                            continue block28;
                        }
                        this.setDynamicTableSize(index);
                        state = 0;
                        continue block28;
                    }
                    indexType = (b & 0x10) == 16 ? HpackUtil.IndexType.NEVER : HpackUtil.IndexType.NONE;
                    index = b & 0xF;
                    switch (index) {
                        case 0: {
                            state = 4;
                            continue block28;
                        }
                        case 15: {
                            state = 3;
                            continue block28;
                        }
                    }
                    name = this.readName(index);
                    state = 7;
                    continue block28;
                }
                case 1: {
                    this.setDynamicTableSize(Decoder.decodeULE128(in, index));
                    state = 0;
                    continue block28;
                }
                case 2: {
                    headersLength = this.indexHeader(streamId, Decoder.decodeULE128(in, index), headers, headersLength);
                    state = 0;
                    continue block28;
                }
                case 3: {
                    name = this.readName(Decoder.decodeULE128(in, index));
                    state = 7;
                    continue block28;
                }
                case 4: {
                    byte b = in.readByte();
                    huffmanEncoded = (b & 0x80) == 128;
                    index = b & 0x7F;
                    if (index == 127) {
                        state = 5;
                        continue block28;
                    }
                    if ((long)index > this.maxHeaderListSize - headersLength) {
                        Http2CodecUtil.headerListSizeExceeded(streamId, this.maxHeaderListSize, true);
                    }
                    nameLength = index;
                    state = 6;
                    continue block28;
                }
                case 5: {
                    nameLength = Decoder.decodeULE128(in, index);
                    if ((long)nameLength > this.maxHeaderListSize - headersLength) {
                        Http2CodecUtil.headerListSizeExceeded(streamId, this.maxHeaderListSize, true);
                    }
                    state = 6;
                    continue block28;
                }
                case 6: {
                    if (in.readableBytes() < nameLength) {
                        throw Decoder.notEnoughDataException(in);
                    }
                    name = this.readStringLiteral(in, nameLength, huffmanEncoded);
                    state = 7;
                    continue block28;
                }
                case 7: {
                    byte b = in.readByte();
                    huffmanEncoded = (b & 0x80) == 128;
                    index = b & 0x7F;
                    switch (index) {
                        case 127: {
                            state = 8;
                            continue block28;
                        }
                        case 0: {
                            headersLength = this.insertHeader(streamId, headers, name, AsciiString.EMPTY_STRING, indexType, headersLength);
                            state = 0;
                            continue block28;
                        }
                    }
                    if ((long)index + (long)nameLength > this.maxHeaderListSize - headersLength) {
                        Http2CodecUtil.headerListSizeExceeded(streamId, this.maxHeaderListSize, true);
                    }
                    valueLength = index;
                    state = 9;
                    continue block28;
                }
                case 8: {
                    valueLength = Decoder.decodeULE128(in, index);
                    if ((long)valueLength + (long)nameLength > this.maxHeaderListSize - headersLength) {
                        Http2CodecUtil.headerListSizeExceeded(streamId, this.maxHeaderListSize, true);
                    }
                    state = 9;
                    continue block28;
                }
                case 9: {
                    if (in.readableBytes() < valueLength) {
                        throw Decoder.notEnoughDataException(in);
                    }
                    CharSequence value = this.readStringLiteral(in, valueLength, huffmanEncoded);
                    headersLength = this.insertHeader(streamId, headers, name, value, indexType, headersLength);
                    state = 0;
                    continue block28;
                }
            }
            throw new Error("should not reach here state: " + state);
        }
    }

    public void setMaxHeaderTableSize(long maxHeaderTableSize) throws Http2Exception {
        if (maxHeaderTableSize < 0L || maxHeaderTableSize > 0xFFFFFFFFL) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Header Table Size must be >= %d and <= %d but was %d", 0L, 0xFFFFFFFFL, maxHeaderTableSize);
        }
        this.maxDynamicTableSize = maxHeaderTableSize;
        if (this.maxDynamicTableSize < this.encoderMaxDynamicTableSize) {
            this.maxDynamicTableSizeChangeRequired = true;
            this.dynamicTable.setCapacity(this.maxDynamicTableSize);
        }
    }

    public void setMaxHeaderListSize(long maxHeaderListSize) throws Http2Exception {
        if (maxHeaderListSize < 0L || maxHeaderListSize > 0xFFFFFFFFL) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Header List Size must be >= %d and <= %d but was %d", 0L, 0xFFFFFFFFL, maxHeaderListSize);
        }
        this.maxHeaderListSize = maxHeaderListSize;
    }

    public long getMaxHeaderListSize() {
        return this.maxHeaderListSize;
    }

    public long getMaxHeaderTableSize() {
        return this.dynamicTable.capacity();
    }

    int length() {
        return this.dynamicTable.length();
    }

    long size() {
        return this.dynamicTable.size();
    }

    HeaderField getHeaderField(int index) {
        return this.dynamicTable.getEntry(index + 1);
    }

    private void setDynamicTableSize(int dynamicTableSize) throws Http2Exception {
        if ((long)dynamicTableSize > this.maxDynamicTableSize) {
            throw INVALID_MAX_DYNAMIC_TABLE_SIZE;
        }
        this.encoderMaxDynamicTableSize = dynamicTableSize;
        this.maxDynamicTableSizeChangeRequired = false;
        this.dynamicTable.setCapacity(dynamicTableSize);
    }

    private CharSequence readName(int index) throws Http2Exception {
        if (index <= StaticTable.length) {
            HeaderField headerField = StaticTable.getEntry(index);
            return headerField.name;
        }
        if (index - StaticTable.length <= this.dynamicTable.length()) {
            HeaderField headerField = this.dynamicTable.getEntry(index - StaticTable.length);
            return headerField.name;
        }
        throw READ_NAME_ILLEGAL_INDEX_VALUE;
    }

    private long indexHeader(int streamId, int index, Http2Headers headers, long headersLength) throws Http2Exception {
        if (index <= StaticTable.length) {
            HeaderField headerField = StaticTable.getEntry(index);
            return this.addHeader(streamId, headers, headerField.name, headerField.value, headersLength);
        }
        if (index - StaticTable.length <= this.dynamicTable.length()) {
            HeaderField headerField = this.dynamicTable.getEntry(index - StaticTable.length);
            return this.addHeader(streamId, headers, headerField.name, headerField.value, headersLength);
        }
        throw INDEX_HEADER_ILLEGAL_INDEX_VALUE;
    }

    private long insertHeader(int streamId, Http2Headers headers, CharSequence name, CharSequence value, HpackUtil.IndexType indexType, long headerSize) throws Http2Exception {
        headerSize = this.addHeader(streamId, headers, name, value, headerSize);
        switch (indexType) {
            case NONE: 
            case NEVER: {
                break;
            }
            case INCREMENTAL: {
                this.dynamicTable.add(new HeaderField(name, value));
                break;
            }
            default: {
                throw new Error("should not reach here");
            }
        }
        return headerSize;
    }

    private long addHeader(int streamId, Http2Headers headers, CharSequence name, CharSequence value, long headersLength) throws Http2Exception {
        if ((headersLength += (long)(name.length() + value.length())) > this.maxHeaderListSize) {
            Http2CodecUtil.headerListSizeExceeded(streamId, this.maxHeaderListSize, true);
        }
        headers.add(name, value);
        return headersLength;
    }

    private CharSequence readStringLiteral(ByteBuf in, int length, boolean huffmanEncoded) throws Http2Exception {
        if (huffmanEncoded) {
            return this.huffmanDecoder.decode(in, length);
        }
        byte[] buf = new byte[length];
        in.readBytes(buf);
        return new AsciiString(buf, false);
    }

    private static IllegalArgumentException notEnoughDataException(ByteBuf in) {
        return new IllegalArgumentException("decode only works with an entire header block! " + in);
    }

    private static int decodeULE128(ByteBuf in, int result) throws Http2Exception {
        assert (result <= 127 && result >= 0);
        int writerIndex = in.writerIndex();
        int readerIndex = in.readerIndex();
        int shift = 0;
        while (readerIndex < writerIndex) {
            byte b = in.getByte(readerIndex);
            if (shift == 28 && ((b & 0x80) != 0 || b > 6)) {
                in.readerIndex(readerIndex + 1);
                break;
            }
            if ((b & 0x80) == 0) {
                in.readerIndex(readerIndex + 1);
                return result + ((b & 0x7F) << shift);
            }
            result += (b & 0x7F) << shift;
            ++readerIndex;
            shift += 7;
        }
        throw DECODE_ULE_128_DECOMPRESSION_EXCEPTION;
    }
}

