/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.esplugins;

import edu.neu.ccs.pyramid.esplugins.TermCountScorer;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public class TermCountQuery
extends Query {
    private final Term term;
    private final TermContext perReaderTermState;

    public TermCountQuery(Term t) {
        this.term = Objects.requireNonNull(t);
        this.perReaderTermState = null;
    }

    public Term getTerm() {
        return this.term;
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        IndexReaderContext context = searcher.getTopReaderContext();
        TermContext termState = this.perReaderTermState == null || !this.perReaderTermState.wasBuiltFor(context) ? (needsScores ? TermContext.build((IndexReaderContext)context, (Term)this.term) : null) : this.perReaderTermState;
        return new TermWeight(searcher, needsScores, termState);
    }

    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        if (!this.term.field().equals(field)) {
            buffer.append(this.term.field());
            buffer.append(":");
        }
        buffer.append(this.term.text());
        return buffer.toString();
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.term.equals((Object)((TermCountQuery)((Object)other)).term);
    }

    public int hashCode() {
        return this.classHash() ^ this.term.hashCode();
    }

    final class TermWeight
    extends Weight {
        private final TermContext termStates;
        private final boolean needsScores;

        public TermWeight(IndexSearcher searcher, boolean needsScores, TermContext termStates) throws IOException {
            super((Query)TermCountQuery.this);
            if (needsScores && termStates == null) {
                throw new IllegalStateException("termStates are required when scores are needed");
            }
            this.needsScores = needsScores;
            this.termStates = termStates;
        }

        public void extractTerms(Set<Term> terms) {
            terms.add(TermCountQuery.this.getTerm());
        }

        public String toString() {
            return "weight(" + (Object)((Object)TermCountQuery.this) + ")";
        }

        public float getValueForNormalization() {
            return 1.0f;
        }

        public void normalize(float queryNorm, float boost) {
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            assert (this.termStates == null || this.termStates.wasBuiltFor(ReaderUtil.getTopLevelContext((IndexReaderContext)context))) : "The top-reader used to create Weight is not the same as the current reader's top-reader (" + ReaderUtil.getTopLevelContext((IndexReaderContext)context);
            TermsEnum termsEnum = this.getTermsEnum(context);
            if (termsEnum == null) {
                return null;
            }
            PostingsEnum docs = termsEnum.postings(null, this.needsScores ? 8 : 0);
            assert (docs != null);
            return new TermCountScorer(this, docs);
        }

        private TermsEnum getTermsEnum(LeafReaderContext context) throws IOException {
            if (this.termStates != null) {
                assert (this.termStates.wasBuiltFor(ReaderUtil.getTopLevelContext((IndexReaderContext)context))) : "The top-reader used to create Weight is not the same as the current reader's top-reader (" + ReaderUtil.getTopLevelContext((IndexReaderContext)context);
                TermState state = this.termStates.get(context.ord);
                if (state == null) {
                    assert (this.termNotInReader(context.reader(), TermCountQuery.this.term)) : "no termstate found but term exists in reader term=" + TermCountQuery.access$000(TermCountQuery.this);
                    return null;
                }
                TermsEnum termsEnum = context.reader().terms(TermCountQuery.this.term.field()).iterator();
                termsEnum.seekExact(TermCountQuery.this.term.bytes(), state);
                return termsEnum;
            }
            Terms terms = context.reader().terms(TermCountQuery.this.term.field());
            if (terms == null) {
                return null;
            }
            TermsEnum termsEnum = terms.iterator();
            if (termsEnum.seekExact(TermCountQuery.this.term.bytes())) {
                return termsEnum;
            }
            return null;
        }

        private boolean termNotInReader(LeafReader reader, Term term) throws IOException {
            return reader.docFreq(term) == 0;
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            int newDoc;
            Scorer scorer = this.scorer(context);
            if (scorer != null && (newDoc = scorer.iterator().advance(doc)) == doc) {
                return Explanation.match((float)scorer.freq(), (String)"term frequency", (Explanation[])new Explanation[0]);
            }
            return Explanation.noMatch((String)"no matching term", (Explanation[])new Explanation[0]);
        }
    }
}

