/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.esplugins;

import edu.neu.ccs.pyramid.esplugins.CustomPhrasePositions;
import edu.neu.ccs.pyramid.esplugins.CustomPhraseQueue;
import edu.neu.ccs.pyramid.esplugins.PhraseCountQuery;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ConjunctionDISI;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.FixedBitSet;

final class PhraseCountScorer
extends Scorer {
    private final DocIdSetIterator conjunction;
    private final CustomPhrasePositions[] customPhrasePositions;
    private float sloppyFreq;
    private final int slop;
    private final int numPostings;
    private final CustomPhraseQueue pq;
    private int end;
    private boolean hasRpts;
    private boolean checkedRpts;
    private boolean hasMultiTermRpts;
    private CustomPhrasePositions[][] rptGroups;
    private CustomPhrasePositions[] rptStack;
    private int numMatches;
    final boolean needsScores;
    private final float matchCost;
    private final boolean weightedCount;

    PhraseCountScorer(Weight weight, PhraseCountQuery.PostingsAndFreq[] postings, int slop, boolean needsScores, boolean weightedCount, float matchCost) {
        super(weight);
        this.needsScores = needsScores;
        this.weightedCount = weightedCount;
        this.slop = slop;
        this.numPostings = postings == null ? 0 : postings.length;
        this.pq = new CustomPhraseQueue(postings.length);
        DocIdSetIterator[] iterators = new DocIdSetIterator[postings.length];
        this.customPhrasePositions = new CustomPhrasePositions[postings.length];
        for (int i = 0; i < postings.length; ++i) {
            iterators[i] = postings[i].postings;
            this.customPhrasePositions[i] = new CustomPhrasePositions(postings[i].postings, postings[i].position, i, postings[i].terms);
        }
        this.conjunction = ConjunctionDISI.intersectIterators(Arrays.asList(iterators));
        assert (TwoPhaseIterator.unwrap((DocIdSetIterator)this.conjunction) == null);
        this.matchCost = matchCost;
    }

    private float phraseFreq() throws IOException {
        if (!this.initPhrasePositions()) {
            return 0.0f;
        }
        float freq = 0.0f;
        this.numMatches = 0;
        CustomPhrasePositions pp = (CustomPhrasePositions)this.pq.pop();
        int matchLength = this.end - pp.position;
        int next = ((CustomPhrasePositions)this.pq.top()).position;
        while (this.advancePP(pp) && (!this.hasRpts || this.advanceRpts(pp))) {
            if (pp.position > next) {
                if (matchLength <= this.slop) {
                    freq += this.computeSlopFactor(matchLength);
                    ++this.numMatches;
                    if (!this.needsScores) {
                        return freq;
                    }
                }
                this.pq.add(pp);
                pp = (CustomPhrasePositions)this.pq.pop();
                next = ((CustomPhrasePositions)this.pq.top()).position;
                matchLength = this.end - pp.position;
                continue;
            }
            int matchLength2 = this.end - pp.position;
            if (matchLength2 >= matchLength) continue;
            matchLength = matchLength2;
        }
        if (matchLength <= this.slop) {
            freq += this.computeSlopFactor(matchLength);
            ++this.numMatches;
        }
        return freq;
    }

    private float computeSlopFactor(int matchLength) {
        return 1.0f / (float)(matchLength + 1);
    }

    private boolean advancePP(CustomPhrasePositions pp) throws IOException {
        if (!pp.nextPosition()) {
            return false;
        }
        if (pp.position > this.end) {
            this.end = pp.position;
        }
        return true;
    }

    private boolean advanceRpts(CustomPhrasePositions pp) throws IOException {
        int k;
        if (pp.rptGroup < 0) {
            return true;
        }
        CustomPhrasePositions[] rg = this.rptGroups[pp.rptGroup];
        FixedBitSet bits = new FixedBitSet(rg.length);
        int k0 = pp.rptInd;
        while ((k = this.collide(pp)) >= 0) {
            if (!this.advancePP(pp = this.lesser(pp, rg[k]))) {
                return false;
            }
            if (k == k0) continue;
            bits = FixedBitSet.ensureCapacity((FixedBitSet)bits, (int)k);
            bits.set(k);
        }
        int n = 0;
        int numBits = bits.length();
        while (bits.cardinality() > 0) {
            CustomPhrasePositions pp2 = (CustomPhrasePositions)this.pq.pop();
            this.rptStack[n++] = pp2;
            if (pp2.rptGroup < 0 || pp2.rptInd >= numBits || !bits.get(pp2.rptInd)) continue;
            bits.clear(pp2.rptInd);
        }
        for (int i = n - 1; i >= 0; --i) {
            this.pq.add(this.rptStack[i]);
        }
        return true;
    }

    private CustomPhrasePositions lesser(CustomPhrasePositions pp, CustomPhrasePositions pp2) {
        if (pp.position < pp2.position || pp.position == pp2.position && pp.offset < pp2.offset) {
            return pp;
        }
        return pp2;
    }

    private int collide(CustomPhrasePositions pp) {
        int tpPos = this.tpPos(pp);
        CustomPhrasePositions[] rg = this.rptGroups[pp.rptGroup];
        for (int i = 0; i < rg.length; ++i) {
            CustomPhrasePositions pp2 = rg[i];
            if (pp2 == pp || this.tpPos(pp2) != tpPos) continue;
            return pp2.rptInd;
        }
        return -1;
    }

    private boolean initPhrasePositions() throws IOException {
        this.end = Integer.MIN_VALUE;
        if (!this.checkedRpts) {
            return this.initFirstTime();
        }
        if (!this.hasRpts) {
            this.initSimple();
            return true;
        }
        return this.initComplex();
    }

    private void initSimple() throws IOException {
        this.pq.clear();
        for (CustomPhrasePositions pp : this.customPhrasePositions) {
            pp.firstPosition();
            if (pp.position > this.end) {
                this.end = pp.position;
            }
            this.pq.add(pp);
        }
    }

    private boolean initComplex() throws IOException {
        this.placeFirstPositions();
        if (!this.advanceRepeatGroups()) {
            return false;
        }
        this.fillQueue();
        return true;
    }

    private void placeFirstPositions() throws IOException {
        for (CustomPhrasePositions pp : this.customPhrasePositions) {
            pp.firstPosition();
        }
    }

    private void fillQueue() {
        this.pq.clear();
        for (CustomPhrasePositions pp : this.customPhrasePositions) {
            if (pp.position > this.end) {
                this.end = pp.position;
            }
            this.pq.add(pp);
        }
    }

    private boolean advanceRepeatGroups() throws IOException {
        for (CustomPhrasePositions[] rg : this.rptGroups) {
            if (this.hasMultiTermRpts) {
                int incr;
                block1: for (int i = 0; i < rg.length; i += incr) {
                    int k;
                    incr = 1;
                    CustomPhrasePositions pp = rg[i];
                    while ((k = this.collide(pp)) >= 0) {
                        CustomPhrasePositions pp2 = this.lesser(pp, rg[k]);
                        if (!this.advancePP(pp2)) {
                            return false;
                        }
                        if (pp2.rptInd >= i) continue;
                        incr = 0;
                        continue block1;
                    }
                }
                continue;
            }
            for (int j = 1; j < rg.length; ++j) {
                for (int k = 0; k < j; ++k) {
                    if (rg[j].nextPosition()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean initFirstTime() throws IOException {
        this.checkedRpts = true;
        this.placeFirstPositions();
        LinkedHashMap<Term, Integer> rptTerms = this.repeatingTerms();
        boolean bl = this.hasRpts = !rptTerms.isEmpty();
        if (this.hasRpts) {
            this.rptStack = new CustomPhrasePositions[this.numPostings];
            ArrayList<ArrayList<CustomPhrasePositions>> rgs = this.gatherRptGroups(rptTerms);
            this.sortRptGroups(rgs);
            if (!this.advanceRepeatGroups()) {
                return false;
            }
        }
        this.fillQueue();
        return true;
    }

    private void sortRptGroups(ArrayList<ArrayList<CustomPhrasePositions>> rgs) {
        this.rptGroups = new CustomPhrasePositions[rgs.size()][];
        Comparator<CustomPhrasePositions> cmprtr = new Comparator<CustomPhrasePositions>(){

            @Override
            public int compare(CustomPhrasePositions pp1, CustomPhrasePositions pp2) {
                return pp1.offset - pp2.offset;
            }
        };
        for (int i = 0; i < this.rptGroups.length; ++i) {
            CustomPhrasePositions[] rg = rgs.get(i).toArray(new CustomPhrasePositions[0]);
            Arrays.sort(rg, cmprtr);
            this.rptGroups[i] = rg;
            for (int j = 0; j < rg.length; ++j) {
                rg[j].rptInd = j;
            }
        }
    }

    private ArrayList<ArrayList<CustomPhrasePositions>> gatherRptGroups(LinkedHashMap<Term, Integer> rptTerms) throws IOException {
        CustomPhrasePositions[] rpp = this.repeatingPPs(rptTerms);
        ArrayList<ArrayList<CustomPhrasePositions>> res = new ArrayList<ArrayList<CustomPhrasePositions>>();
        if (!this.hasMultiTermRpts) {
            for (int i = 0; i < rpp.length; ++i) {
                CustomPhrasePositions pp = rpp[i];
                if (pp.rptGroup >= 0) continue;
                int tpPos = this.tpPos(pp);
                for (int j = i + 1; j < rpp.length; ++j) {
                    CustomPhrasePositions pp2 = rpp[j];
                    if (pp2.rptGroup >= 0 || pp2.offset == pp.offset || this.tpPos(pp2) != tpPos) continue;
                    int n = pp.rptGroup;
                    if (n < 0) {
                        pp.rptGroup = n = res.size();
                        ArrayList<CustomPhrasePositions> rl = new ArrayList<CustomPhrasePositions>(2);
                        rl.add(pp);
                        res.add(rl);
                    }
                    pp2.rptGroup = n;
                    res.get(n).add(pp2);
                }
            }
        } else {
            ArrayList tmp = new ArrayList();
            ArrayList<FixedBitSet> bb = this.ppTermsBitSets(rpp, rptTerms);
            this.unionTermGroups(bb);
            HashMap<Term, Integer> tg = this.termGroups(rptTerms, bb);
            HashSet<Integer> distinctGroupIDs = new HashSet<Integer>(tg.values());
            for (int i = 0; i < distinctGroupIDs.size(); ++i) {
                tmp.add(new HashSet());
            }
            for (CustomPhrasePositions pp : rpp) {
                for (Term t : pp.terms) {
                    if (!rptTerms.containsKey(t)) continue;
                    int g = tg.get(t);
                    ((HashSet)tmp.get(g)).add(pp);
                    assert (pp.rptGroup == -1 || pp.rptGroup == g);
                    pp.rptGroup = g;
                }
            }
            for (HashSet hashSet : tmp) {
                res.add(new ArrayList(hashSet));
            }
        }
        return res;
    }

    private final int tpPos(CustomPhrasePositions pp) {
        return pp.position + pp.offset;
    }

    private LinkedHashMap<Term, Integer> repeatingTerms() {
        LinkedHashMap<Term, Integer> tord = new LinkedHashMap<Term, Integer>();
        HashMap<Term, Integer> tcnt = new HashMap<Term, Integer>();
        for (CustomPhrasePositions pp : this.customPhrasePositions) {
            for (Term t : pp.terms) {
                Integer cnt0 = (Integer)tcnt.get(t);
                Integer cnt = cnt0 == null ? new Integer(1) : new Integer(1 + cnt0);
                tcnt.put(t, cnt);
                if (cnt != 2) continue;
                tord.put(t, tord.size());
            }
        }
        return tord;
    }

    private CustomPhrasePositions[] repeatingPPs(HashMap<Term, Integer> rptTerms) {
        ArrayList<CustomPhrasePositions> rp = new ArrayList<CustomPhrasePositions>();
        block0: for (CustomPhrasePositions pp : this.customPhrasePositions) {
            for (Term t : pp.terms) {
                if (!rptTerms.containsKey(t)) continue;
                rp.add(pp);
                this.hasMultiTermRpts |= pp.terms.length > 1;
                continue block0;
            }
        }
        return rp.toArray(new CustomPhrasePositions[0]);
    }

    private ArrayList<FixedBitSet> ppTermsBitSets(CustomPhrasePositions[] rpp, HashMap<Term, Integer> tord) {
        ArrayList<FixedBitSet> bb = new ArrayList<FixedBitSet>(rpp.length);
        for (CustomPhrasePositions pp : rpp) {
            FixedBitSet b = new FixedBitSet(tord.size());
            for (Term t : pp.terms) {
                Integer ord = tord.get(t);
                if (ord == null) continue;
                b.set(ord.intValue());
            }
            bb.add(b);
        }
        return bb;
    }

    private void unionTermGroups(ArrayList<FixedBitSet> bb) {
        int incr;
        for (int i = 0; i < bb.size() - 1; i += incr) {
            incr = 1;
            int j = i + 1;
            while (j < bb.size()) {
                if (bb.get(i).intersects(bb.get(j))) {
                    bb.get(i).or(bb.get(j));
                    bb.remove(j);
                    incr = 0;
                    continue;
                }
                ++j;
            }
        }
    }

    private HashMap<Term, Integer> termGroups(LinkedHashMap<Term, Integer> tord, ArrayList<FixedBitSet> bb) throws IOException {
        HashMap<Term, Integer> tg = new HashMap<Term, Integer>();
        Term[] t = tord.keySet().toArray(new Term[0]);
        for (int i = 0; i < bb.size(); ++i) {
            FixedBitSet bits = bb.get(i);
            int ord = bits.nextSetBit(0);
            while (ord != Integer.MAX_VALUE) {
                tg.put(t[ord], i);
                ord = ord + 1 >= bits.length() ? Integer.MAX_VALUE : bits.nextSetBit(ord + 1);
            }
        }
        return tg;
    }

    public int freq() {
        return this.numMatches;
    }

    public float sloppyFreq() {
        return this.sloppyFreq;
    }

    public int docID() {
        return this.conjunction.docID();
    }

    public float score() {
        if (this.weightedCount) {
            return this.sloppyFreq();
        }
        return this.freq();
    }

    public String toString() {
        return "scorer(" + this.weight + ")";
    }

    public TwoPhaseIterator twoPhaseIterator() {
        return new TwoPhaseIterator(this.conjunction){

            public boolean matches() throws IOException {
                PhraseCountScorer.this.sloppyFreq = PhraseCountScorer.this.phraseFreq();
                return PhraseCountScorer.this.sloppyFreq != 0.0f;
            }

            public float matchCost() {
                return PhraseCountScorer.this.matchCost;
            }

            public String toString() {
                return "PhraseCountScorer@asTwoPhaseIterator(" + (Object)((Object)PhraseCountScorer.this) + ")";
            }
        };
    }

    public DocIdSetIterator iterator() {
        return TwoPhaseIterator.asDocIdSetIterator((TwoPhaseIterator)this.twoPhaseIterator());
    }
}

