/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.esplugins;

import edu.neu.ccs.pyramid.esplugins.PhraseCountQuery;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CachingTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentLocation;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryShardContext;

public class PhraseCountQueryBuilder
extends AbstractQueryBuilder<PhraseCountQueryBuilder> {
    private String analyzer;
    private int slop = 0;
    private final String fieldName;
    public static final ParseField SLOP_FIELD = new ParseField("slop", new String[]{"phrase_slop"});
    public static final ParseField ANALYZER_FIELD = new ParseField("analyzer", new String[0]);
    public static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
    public static final ParseField WEIGHTED_COUNT_FIELD = new ParseField("weighted_count", new String[0]);
    private final String value;
    private boolean weightedCount = false;
    public static final String NAME = "phrase_count_query";

    public PhraseCountQueryBuilder(String fieldName, Object value) {
        if (Strings.isEmpty((CharSequence)fieldName)) {
            throw new IllegalArgumentException("[phrase_count_query] requires fieldName");
        }
        if (value == null) {
            throw new IllegalArgumentException("[phrase_count_query] requires query value");
        }
        this.fieldName = fieldName;
        this.value = value.toString();
    }

    public PhraseCountQueryBuilder(String fieldName, int slop, boolean weightedCount, String ... terms) {
        if (Strings.isEmpty((CharSequence)fieldName)) {
            throw new IllegalArgumentException("[phrase_count_query] requires fieldName");
        }
        if (terms == null) {
            throw new IllegalArgumentException("[phrase_count_query] requires terms");
        }
        this.fieldName = fieldName;
        this.value = String.join((CharSequence)" ", terms);
        this.weightedCount = weightedCount;
        this.slop = slop;
    }

    public PhraseCountQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        this.value = in.readString();
        this.slop = in.readVInt();
        this.weightedCount = in.readBoolean();
        this.analyzer = in.readOptionalString();
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeString(this.value);
        out.writeVInt(this.slop);
        out.writeBoolean(this.weightedCount);
        out.writeOptionalString(this.analyzer);
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startObject(this.fieldName);
        builder.field(QUERY_FIELD.getPreferredName(), this.value);
        if (this.analyzer != null) {
            builder.field(ANALYZER_FIELD.getPreferredName(), this.analyzer);
        }
        builder.field(SLOP_FIELD.getPreferredName(), this.slop);
        builder.field(WEIGHTED_COUNT_FIELD.getPreferredName(), this.weightedCount);
        this.printBoostAndQueryName(builder);
        builder.endObject();
        builder.endObject();
    }

    protected boolean doEquals(PhraseCountQueryBuilder other) {
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.value, other.value) && Objects.equals(this.analyzer, other.analyzer) && Objects.equals(this.slop, other.slop);
    }

    protected int doHashCode() {
        return Objects.hash(this.fieldName, this.value, this.analyzer, this.slop);
    }

    public String getWriteableName() {
        return NAME;
    }

    public PhraseCountQueryBuilder analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public String analyzer() {
        return this.analyzer;
    }

    public PhraseCountQueryBuilder slop(int slop) {
        if (slop < 0) {
            throw new IllegalArgumentException("No negative slop allowed.");
        }
        this.slop = slop;
        return this;
    }

    public int slop() {
        return this.slop;
    }

    public boolean weightedCount() {
        return this.weightedCount;
    }

    public void weightedCount(boolean weightedCount) {
        this.weightedCount = weightedCount;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Query doToQuery(QueryShardContext context) throws IOException {
        Analyzer analyzer = context.getMapperService().searchAnalyzer();
        try (TokenStream source = analyzer.tokenStream(this.fieldName, this.value.toString());){
            CachingTokenFilter stream = new CachingTokenFilter(source);
            TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)stream.getAttribute(TermToBytesRefAttribute.class);
            if (termAtt == null) {
                Query query = null;
                return query;
            }
            ArrayList<Term> terms = new ArrayList<Term>();
            stream.reset();
            while (stream.incrementToken()) {
                terms.add(new Term(this.fieldName, termAtt.getBytesRef()));
            }
            PhraseCountQuery phraseCountQuery = new PhraseCountQuery(this.slop, this.weightedCount, terms.toArray(new Term[terms.size()]));
            return phraseCountQuery;
        }
        catch (IOException e) {
            throw new RuntimeException("Error analyzing query text", e);
        }
    }

    public static Optional<PhraseCountQueryBuilder> fromXContent(QueryParseContext parseContext) throws IOException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        String fieldName = null;
        Object value = null;
        float boost = 1.0f;
        String analyzer = null;
        int slop = 0;
        boolean weightedCount = false;
        String queryName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (parseContext.isDeprecatedSetting(currentFieldName)) continue;
            if (token == XContentParser.Token.START_OBJECT) {
                PhraseCountQueryBuilder.throwParsingExceptionOnMultipleFields((String)NAME, (XContentLocation)parser.getTokenLocation(), fieldName, (String)currentFieldName);
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (token.isValue()) {
                        if (QUERY_FIELD.match(currentFieldName)) {
                            value = parser.objectText();
                            continue;
                        }
                        if (ANALYZER_FIELD.match(currentFieldName)) {
                            analyzer = parser.text();
                            continue;
                        }
                        if (WEIGHTED_COUNT_FIELD.match(currentFieldName)) {
                            weightedCount = parser.booleanValue();
                            continue;
                        }
                        if (BOOST_FIELD.match(currentFieldName)) {
                            boost = parser.floatValue();
                            continue;
                        }
                        if (SLOP_FIELD.match(currentFieldName)) {
                            slop = parser.intValue();
                            continue;
                        }
                        if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName)) {
                            queryName = parser.text();
                            continue;
                        }
                        throw new ParsingException(parser.getTokenLocation(), "[phrase_count_query] query does not support [" + currentFieldName + "]", new Object[0]);
                    }
                    throw new ParsingException(parser.getTokenLocation(), "[phrase_count_query] unknown token [" + token + "] after [" + currentFieldName + "]", new Object[0]);
                }
                continue;
            }
            PhraseCountQueryBuilder.throwParsingExceptionOnMultipleFields((String)NAME, (XContentLocation)parser.getTokenLocation(), fieldName, (String)parser.currentName());
            fieldName = parser.currentName();
            value = parser.objectText();
        }
        PhraseCountQueryBuilder phraseCountQuery = new PhraseCountQueryBuilder(fieldName, value);
        phraseCountQuery.analyzer(analyzer);
        phraseCountQuery.slop(slop);
        phraseCountQuery.weightedCount(weightedCount);
        phraseCountQuery.queryName(queryName);
        phraseCountQuery.boost(boost);
        return Optional.of(phraseCountQuery);
    }
}

