/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.pyramid.esplugins;

import edu.neu.ccs.pyramid.esplugins.PhraseCountScorer;
import edu.neu.ccs.pyramid.esplugins.TermCountQuery;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ArrayUtil;

public class PhraseCountQuery
extends Query {
    private final int slop;
    private final String field;
    private final Term[] terms;
    private final int[] positions;
    private final boolean weightedCount;
    private static final int TERM_POSNS_SEEK_OPS_PER_DOC = 128;
    private static final int TERM_OPS_PER_POS = 7;

    private PhraseCountQuery(int slop, boolean weightedCount, Term[] terms, int[] positions) {
        if (terms.length != positions.length) {
            throw new IllegalArgumentException("Must have as many terms as positions");
        }
        if (slop < 0) {
            throw new IllegalArgumentException("Slop must be >= 0, got " + slop);
        }
        this.slop = slop;
        this.weightedCount = weightedCount;
        this.terms = terms;
        this.positions = positions;
        this.field = terms.length == 0 ? null : terms[0].field();
    }

    private static int[] incrementalPositions(int length) {
        int[] positions = new int[length];
        for (int i = 0; i < length; ++i) {
            positions[i] = i;
        }
        return positions;
    }

    public PhraseCountQuery(int slop, boolean weightedCount, Term ... terms) {
        this(slop, weightedCount, terms, PhraseCountQuery.incrementalPositions(terms.length));
    }

    public int getSlop() {
        return this.slop;
    }

    public Term[] getTerms() {
        return this.terms;
    }

    public int[] getPositions() {
        return this.positions;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        if (this.terms.length == 0) {
            return new MatchNoDocsQuery("empty PhraseCountQuery");
        }
        if (this.terms.length == 1) {
            return new TermCountQuery(this.terms[0]);
        }
        if (this.positions[0] != 0) {
            int[] newPositions = new int[this.positions.length];
            for (int i = 0; i < this.positions.length; ++i) {
                newPositions[i] = this.positions[i] - this.positions[0];
            }
            return new PhraseCountQuery(this.slop, this.weightedCount, this.terms, newPositions);
        }
        return super.rewrite(reader);
    }

    static float termPositionsCost(TermsEnum termsEnum) throws IOException {
        int docFreq = termsEnum.docFreq();
        assert (docFreq > 0);
        long totalTermFreq = termsEnum.totalTermFreq();
        float expOccurrencesInMatchingDoc = totalTermFreq < (long)docFreq ? 1.0f : (float)totalTermFreq / (float)docFreq;
        return 128.0f + expOccurrencesInMatchingDoc * 7.0f;
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new PhraseWeight(searcher, needsScores);
    }

    public String toString(String f) {
        int i;
        StringBuilder buffer = new StringBuilder();
        if (this.field != null && !this.field.equals(f)) {
            buffer.append(this.field);
            buffer.append(":");
        }
        buffer.append("\"");
        int maxPosition = this.positions.length == 0 ? -1 : this.positions[this.positions.length - 1];
        String[] pieces = new String[maxPosition + 1];
        for (i = 0; i < this.terms.length; ++i) {
            int pos = this.positions[i];
            String s = pieces[pos];
            s = s == null ? this.terms[i].text() : s + "|" + this.terms[i].text();
            pieces[pos] = s;
        }
        for (i = 0; i < pieces.length; ++i) {
            String s;
            if (i > 0) {
                buffer.append(' ');
            }
            if ((s = pieces[i]) == null) {
                buffer.append('?');
                continue;
            }
            buffer.append(s);
        }
        buffer.append("\"");
        if (this.slop != 0) {
            buffer.append("~");
            buffer.append(this.slop);
        }
        return buffer.toString();
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((PhraseCountQuery)((Object)((Object)((Object)this)).getClass().cast(other)));
    }

    private boolean equalsTo(PhraseCountQuery other) {
        return this.slop == other.slop && this.weightedCount == other.weightedCount && Arrays.equals(this.terms, other.terms) && Arrays.equals(this.positions, other.positions);
    }

    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + this.slop;
        h = 31 * h + Arrays.hashCode(this.terms);
        h = 31 * h + Arrays.hashCode(this.positions);
        int t = this.weightedCount ? 1 : 0;
        h = 31 * h + t;
        return h;
    }

    private class PhraseWeight
    extends Weight {
        private final boolean needsScores;
        private transient TermContext[] states;

        public PhraseWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
            super((Query)PhraseCountQuery.this);
            int[] positions = PhraseCountQuery.this.getPositions();
            if (positions.length < 2) {
                throw new IllegalStateException("PhraseWeight does not support less than 2 terms, call rewrite first");
            }
            if (positions[0] != 0) {
                throw new IllegalStateException("PhraseWeight requires that the first position is 0, call rewrite first");
            }
            this.needsScores = needsScores;
            IndexReaderContext context = searcher.getTopReaderContext();
            this.states = new TermContext[PhraseCountQuery.this.terms.length];
            TermStatistics[] termStats = new TermStatistics[PhraseCountQuery.this.terms.length];
            for (int i = 0; i < PhraseCountQuery.this.terms.length; ++i) {
                Term term = PhraseCountQuery.this.terms[i];
                this.states[i] = TermContext.build((IndexReaderContext)context, (Term)term);
                termStats[i] = searcher.termStatistics(term, this.states[i]);
            }
        }

        public void extractTerms(Set<Term> queryTerms) {
            Collections.addAll(queryTerms, PhraseCountQuery.this.terms);
        }

        public String toString() {
            return "weight(" + (Object)((Object)PhraseCountQuery.this) + ")";
        }

        public float getValueForNormalization() {
            return 1.0f;
        }

        public void normalize(float queryNorm, float boost) {
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            assert (PhraseCountQuery.this.terms.length > 0);
            LeafReader reader = context.reader();
            Comparable[] postingsFreqs = new PostingsAndFreq[PhraseCountQuery.this.terms.length];
            Terms fieldTerms = reader.terms(PhraseCountQuery.this.field);
            if (fieldTerms == null) {
                return null;
            }
            if (!fieldTerms.hasPositions()) {
                throw new IllegalStateException("field \"" + PhraseCountQuery.this.field + "\" was indexed without position data; cannot run PhraseCountQuery (phrase=" + this.getQuery() + ")");
            }
            TermsEnum te = fieldTerms.iterator();
            float totalMatchCost = 0.0f;
            for (int i = 0; i < PhraseCountQuery.this.terms.length; ++i) {
                Term t = PhraseCountQuery.this.terms[i];
                TermState state = this.states[i].get(context.ord);
                if (state == null) {
                    assert (this.termNotInReader(reader, t)) : "no termstate found but term exists in reader";
                    return null;
                }
                te.seekExact(t.bytes(), state);
                PostingsEnum postingsEnum = te.postings(null, 24);
                postingsFreqs[i] = new PostingsAndFreq(postingsEnum, PhraseCountQuery.this.positions[i], t);
                totalMatchCost += PhraseCountQuery.termPositionsCost(te);
            }
            if (PhraseCountQuery.this.slop == 0) {
                ArrayUtil.timSort((Comparable[])postingsFreqs);
            }
            return new PhraseCountScorer(this, (PostingsAndFreq[])postingsFreqs, PhraseCountQuery.this.slop, this.needsScores, PhraseCountQuery.this.weightedCount, totalMatchCost);
        }

        private boolean termNotInReader(LeafReader reader, Term term) throws IOException {
            return reader.docFreq(term) == 0;
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            int newDoc;
            Scorer scorer = this.scorer(context);
            if (scorer != null && (newDoc = scorer.iterator().advance(doc)) == doc) {
                if (PhraseCountQuery.this.weightedCount) {
                    return Explanation.match((float)scorer.score(), (String)"sloppy frequency", (Explanation[])new Explanation[0]);
                }
                return Explanation.match((float)scorer.score(), (String)"phrase frequency", (Explanation[])new Explanation[0]);
            }
            return Explanation.noMatch((String)"no matching term", (Explanation[])new Explanation[0]);
        }
    }

    static class PostingsAndFreq
    implements Comparable<PostingsAndFreq> {
        final PostingsEnum postings;
        final int position;
        final Term[] terms;
        final int nTerms;

        public PostingsAndFreq(PostingsEnum postings, int position, Term ... terms) {
            this.postings = postings;
            this.position = position;
            int n = this.nTerms = terms == null ? 0 : terms.length;
            if (this.nTerms > 0) {
                if (terms.length == 1) {
                    this.terms = terms;
                } else {
                    Object[] terms2 = new Term[terms.length];
                    System.arraycopy(terms, 0, terms2, 0, terms.length);
                    Arrays.sort(terms2);
                    this.terms = terms2;
                }
            } else {
                this.terms = null;
            }
        }

        @Override
        public int compareTo(PostingsAndFreq other) {
            if (this.position != other.position) {
                return this.position - other.position;
            }
            if (this.nTerms != other.nTerms) {
                return this.nTerms - other.nTerms;
            }
            if (this.nTerms == 0) {
                return 0;
            }
            for (int i = 0; i < this.terms.length; ++i) {
                int res = this.terms[i].compareTo(other.terms[i]);
                if (res == 0) continue;
                return res;
            }
            return 0;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.position;
            for (int i = 0; i < this.nTerms; ++i) {
                result = 31 * result + this.terms[i].hashCode();
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PostingsAndFreq other = (PostingsAndFreq)obj;
            if (this.position != other.position) {
                return false;
            }
            if (this.terms == null) {
                return other.terms == null;
            }
            return Arrays.equals(this.terms, other.terms);
        }
    }
}

