/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type;

import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.type.CalendarDateDuration;

public enum CalendarDateUnit {
    MILLIS(TimeUnit.MILLISECONDS),
    SECOND(TimeUnit.SECONDS),
    MINUTE(60000L),
    HOUR(3600000L),
    DAY(86400000L),
    WEEK(604800000L),
    MONTH(2629746000L),
    QUARTER(7889238000L),
    YEAR(31556952000L),
    DECADE(315569520000L),
    CENTURY(3155695200000L),
    MILLENIUM(31556952000000L);

    private final TimeUnit myTimeUnit;
    private final long mySize;
    private final long myHalf;

    private CalendarDateUnit(long aMillis) {
        this.myTimeUnit = null;
        this.mySize = aMillis;
        this.myHalf = this.mySize / 2L;
    }

    private CalendarDateUnit(TimeUnit aTimeUnit) {
        this.myTimeUnit = aTimeUnit;
        this.mySize = this.myTimeUnit.toMillis(1L);
        this.myHalf = this.mySize / 2L;
    }

    public CalendarDateDuration convert(CalendarDateDuration aSourceDuration) {
        return aSourceDuration.convertTo(this);
    }

    public double convert(CalendarDateUnit aSourceDurationUnit) {
        return this.convert(PrimitiveMath.ONE, aSourceDurationUnit);
    }

    public double convert(double aSourceDurationMeasure, CalendarDateUnit aSourceDurationUnit) {
        double tmpDestinationSize;
        double tmpSourceSize = aSourceDurationUnit.size();
        if (tmpSourceSize > (tmpDestinationSize = (double)this.mySize)) {
            double tmpScale = tmpSourceSize / tmpDestinationSize;
            return aSourceDurationMeasure * tmpScale;
        }
        if (tmpSourceSize < tmpDestinationSize) {
            double tmpScale = tmpDestinationSize / tmpSourceSize;
            return aSourceDurationMeasure / tmpScale;
        }
        return aSourceDurationMeasure;
    }

    public long convert(long aSourceDuration, CalendarDateUnit aSourceUnit) {
        if (this.myTimeUnit != null && aSourceUnit.getTimeUnit() != null) {
            return this.myTimeUnit.convert(aSourceDuration, aSourceUnit.getTimeUnit());
        }
        return Math.round(this.convert((double)aSourceDuration, aSourceUnit));
    }

    public long count(Calendar aFromValue, Calendar aToValue) {
        return (this.myHalf + this.toTimeInMillis(aToValue) - this.toTimeInMillis(aFromValue)) / this.mySize;
    }

    public long count(Date aFromValue, Date aToValue) {
        return (this.myHalf + this.toTimeInMillis(aToValue) - this.toTimeInMillis(aFromValue)) / this.mySize;
    }

    public long count(long aFromValue, long aToValue) {
        return (this.myHalf + this.toTimeInMillis(aToValue) - this.toTimeInMillis(aFromValue)) / this.mySize;
    }

    public TimeUnit getTimeUnit() {
        return this.myTimeUnit;
    }

    public boolean isCalendarUnit() {
        return DAY.size() <= this.size();
    }

    public void round(Calendar aCalendar) {
        if (MILLIS.size() < this.mySize) {
            aCalendar.set(14, 0);
            if (SECOND.size() < this.mySize) {
                aCalendar.set(13, 0);
                if (MINUTE.size() < this.mySize) {
                    aCalendar.set(12, 0);
                    if (HOUR.size() < this.mySize) {
                        aCalendar.set(11, 12);
                        if (DAY.size() < this.mySize) {
                            if (WEEK.size() == this.mySize) {
                                aCalendar.add(3, 1);
                                aCalendar.set(7, aCalendar.getFirstDayOfWeek());
                                aCalendar.add(7, -1);
                            } else if (MONTH.size() == this.mySize) {
                                aCalendar.add(2, 1);
                                aCalendar.set(5, 1);
                                aCalendar.add(5, -1);
                            } else if (QUARTER.size() == this.mySize) {
                                aCalendar.set(2, 3 * (aCalendar.get(2) / 3 + 1));
                                aCalendar.set(5, 1);
                                aCalendar.add(5, -1);
                            } else if (YEAR.size() == this.mySize) {
                                aCalendar.add(1, 1);
                                aCalendar.set(6, 1);
                                aCalendar.add(6, -1);
                            } else if (DECADE.size() == this.mySize) {
                                aCalendar.set(1, 10 + 10 * (aCalendar.get(1) / 10));
                                aCalendar.set(6, 1);
                                aCalendar.add(6, -1);
                            } else if (CENTURY.size() == this.mySize) {
                                aCalendar.set(1, 100 + 100 * (aCalendar.get(1) / 100));
                                aCalendar.set(6, 1);
                                aCalendar.add(6, -1);
                            } else if (MILLENIUM.size() == this.mySize) {
                                aCalendar.set(1, 1000 + 1000 * (aCalendar.get(1) / 1000));
                                aCalendar.set(6, 1);
                                aCalendar.add(6, -1);
                            }
                        }
                    }
                }
            }
        }
    }

    public void round(Date aDate) {
        aDate.setTime(this.toTimeInMillis(aDate));
    }

    public long size() {
        return this.mySize;
    }

    public Calendar step(Calendar aCalendar) {
        return this.step(aCalendar, 1);
    }

    public Calendar step(Calendar aCalendar, int aStepCount) {
        Calendar retVal = (Calendar)aCalendar.clone();
        switch (this) {
            case MILLENIUM: {
                retVal.set(6, 1);
                retVal.add(1, 1000 * aStepCount + 1);
                retVal.add(6, -1);
                break;
            }
            case CENTURY: {
                retVal.set(6, 1);
                retVal.add(1, 100 * aStepCount + 1);
                retVal.add(6, -1);
                break;
            }
            case DECADE: {
                retVal.set(6, 1);
                retVal.add(1, 10 * aStepCount + 1);
                retVal.add(6, -1);
                break;
            }
            case YEAR: {
                retVal.set(6, 1);
                retVal.add(1, aStepCount + 1);
                retVal.add(6, -1);
                break;
            }
            case QUARTER: {
                retVal.set(5, 1);
                retVal.add(2, 3 * aStepCount + 1);
                retVal.add(5, -1);
                break;
            }
            case MONTH: {
                retVal.set(5, 1);
                retVal.add(2, aStepCount + 1);
                retVal.add(5, -1);
                break;
            }
            case WEEK: {
                retVal.set(7, aCalendar.getFirstDayOfWeek());
                retVal.add(3, aStepCount + 1);
                retVal.add(7, -1);
                break;
            }
            case DAY: {
                retVal.add(5, aStepCount);
                break;
            }
            case HOUR: {
                retVal.add(11, aStepCount);
                break;
            }
            case MINUTE: {
                retVal.add(12, aStepCount);
                break;
            }
            case SECOND: {
                retVal.add(13, aStepCount);
                break;
            }
            case MILLIS: {
                retVal.add(14, aStepCount);
                break;
            }
        }
        this.round(retVal);
        return retVal;
    }

    public Date step(Date aDate) {
        return this.step(aDate, 1);
    }

    public Date step(Date aDate, int aStepCount) {
        return new Date(this.toTimeInMillis(aDate) + (long)aStepCount * this.size());
    }

    public long step(long aTimeInMillis) {
        return this.step(aTimeInMillis, 1);
    }

    public long step(long aTimeInMillis, int aStepCount) {
        return this.toTimeInMillis(aTimeInMillis) + (long)aStepCount * this.size();
    }

    public long toTimeInMillis(Calendar aCalendar) {
        Calendar tmpClone = (Calendar)aCalendar.clone();
        this.round(tmpClone);
        return tmpClone.getTimeInMillis();
    }

    public long toTimeInMillis(Date aDate) {
        return this.toTimeInMillis(aDate.getTime());
    }

    public long toTimeInMillis(long aTimeInMillis) {
        return aTimeInMillis / this.mySize * this.mySize + this.myHalf;
    }
}

