/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.series;

import java.math.BigDecimal;
import java.util.TreeMap;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.series.CalendarDateSeries;
import org.ojalgo.series.CoordinationSet;
import org.ojalgo.type.CalendarDate;
import org.ojalgo.type.TypeUtils;
import org.ojalgo.type.context.NumberContext;

public class SeriesInterpolator {
    private final NumberContext myContext;
    private CoordinationSet<Double> myCoordinatedSet = null;
    private final TreeMap<BigDecimal, String> myKeys = new TreeMap();
    private final CoordinationSet<Double> myOriginalSet = new CoordinationSet();

    public SeriesInterpolator() {
        this(NumberContext.getGeneral(15));
    }

    public SeriesInterpolator(NumberContext context) {
        this.myContext = context;
    }

    public void addSeries(Number key, CalendarDateSeries<Double> series) {
        BigDecimal tmpKey = TypeUtils.toBigDecimal(key, this.myContext);
        this.myKeys.put(tmpKey, series.getName());
        this.myOriginalSet.put(series);
        this.myCoordinatedSet = null;
    }

    public CalendarDateSeries<Double> getCombination(Number inputKey) {
        double[] tmpSeriesValues;
        BigDecimal tmpInputKey = TypeUtils.toBigDecimal(inputKey, this.myContext);
        if (this.myCoordinatedSet == null) {
            this.myCoordinatedSet = this.myOriginalSet.prune();
            this.myCoordinatedSet.complete();
        }
        CalendarDateSeries<Double> retVal = new CalendarDateSeries<Double>(this.myCoordinatedSet.getResolution());
        BigDecimal tmpLowerKey = null;
        BigDecimal tmpUpperKey = null;
        for (BigDecimal tmpIterKey : this.myKeys.keySet()) {
            if (tmpIterKey.compareTo(tmpInputKey) != 1 && (tmpLowerKey == null || tmpIterKey.compareTo(tmpLowerKey) == 1)) {
                tmpLowerKey = tmpIterKey;
            }
            if (tmpIterKey.compareTo(tmpInputKey) == -1 || tmpUpperKey != null && tmpIterKey.compareTo(tmpInputKey) == -1) continue;
            tmpUpperKey = tmpIterKey;
        }
        long[] tmpSeriesKeys = ((CalendarDateSeries)this.myCoordinatedSet.values().toArray()[0]).getPrimitiveKeys();
        if (tmpLowerKey == null && tmpUpperKey != null) {
            double tmpFactor = tmpInputKey.doubleValue() / tmpUpperKey.doubleValue();
            tmpSeriesValues = this.myCoordinatedSet.get(this.myKeys.get(tmpUpperKey)).getPrimitiveValues();
            int i = 0;
            while (i < tmpSeriesValues.length) {
                int n = i++;
                tmpSeriesValues[n] = tmpSeriesValues[n] * tmpFactor;
            }
        } else if (tmpLowerKey != null && tmpUpperKey == null) {
            double tmpFactor = tmpInputKey.doubleValue() / tmpLowerKey.doubleValue();
            tmpSeriesValues = this.myCoordinatedSet.get(this.myKeys.get(tmpLowerKey)).getPrimitiveValues();
            int i = 0;
            while (i < tmpSeriesValues.length) {
                int n = i++;
                tmpSeriesValues[n] = tmpSeriesValues[n] * tmpFactor;
            }
        } else if (tmpLowerKey != null && tmpUpperKey != null) {
            if (tmpLowerKey.equals(tmpUpperKey)) {
                tmpSeriesValues = this.myCoordinatedSet.get(this.myKeys.get(tmpLowerKey)).getPrimitiveValues();
            } else {
                double[] tmpLowerValues = this.myCoordinatedSet.get(this.myKeys.get(tmpLowerKey)).getPrimitiveValues();
                double[] tmpUpperValues = this.myCoordinatedSet.get(this.myKeys.get(tmpUpperKey)).getPrimitiveValues();
                double tmpFactor = (tmpInputKey.doubleValue() - tmpLowerKey.doubleValue()) / (tmpUpperKey.doubleValue() - tmpLowerKey.doubleValue());
                tmpSeriesValues = new double[tmpSeriesKeys.length];
                for (int i = 0; i < tmpSeriesValues.length; ++i) {
                    tmpSeriesValues[i] = tmpFactor * tmpUpperValues[i] + (PrimitiveMath.ONE - tmpFactor) * tmpLowerValues[i];
                }
            }
        } else {
            tmpSeriesValues = new double[tmpSeriesKeys.length];
        }
        for (int i = 0; i < tmpSeriesKeys.length; ++i) {
            retVal.put(new CalendarDate(tmpSeriesKeys[i]), (Double)tmpSeriesValues[i]);
        }
        return retVal;
    }
}

