/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.scalar;

import java.math.BigDecimal;
import java.math.MathContext;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.context.NumberContext;

public final class PrimitiveScalar
extends Number
implements Scalar<Double>,
NumberContext.Enforceable<PrimitiveScalar> {
    public static final Scalar.Factory<Double> FACTORY = new Scalar.Factory<Double>(){

        @Override
        public Double cast(double value) {
            return value;
        }

        @Override
        public Double cast(Number number) {
            return number.doubleValue();
        }

        public PrimitiveScalar convert(double value) {
            return PrimitiveScalar.of(value);
        }

        public PrimitiveScalar convert(Number number) {
            return PrimitiveScalar.valueOf(number);
        }

        public PrimitiveScalar one() {
            return ONE;
        }

        public PrimitiveScalar zero() {
            return ZERO;
        }
    };
    public static final PrimitiveScalar NaN = new PrimitiveScalar(Double.NaN);
    public static final PrimitiveScalar NEGATIVE_INFINITY = new PrimitiveScalar(Double.NEGATIVE_INFINITY);
    public static final PrimitiveScalar ONE = new PrimitiveScalar(PrimitiveMath.ONE);
    public static final PrimitiveScalar POSITIVE_INFINITY = new PrimitiveScalar(Double.POSITIVE_INFINITY);
    public static final PrimitiveScalar ZERO = new PrimitiveScalar(PrimitiveMath.ZERO);
    static final NumberContext CONTEXT = NumberContext.getMath(MathContext.DECIMAL64);
    private final double myValue;

    public static boolean isAbsolute(double value) {
        return value >= PrimitiveMath.ZERO;
    }

    public static boolean isInfinite(double value) {
        return Double.isInfinite(value);
    }

    public static boolean isNaN(double value) {
        return Double.isNaN(value);
    }

    public static boolean isSmall(double comparedTo, double value) {
        return CONTEXT.isSmall(comparedTo, value);
    }

    public static PrimitiveScalar of(double value) {
        return new PrimitiveScalar(value);
    }

    public static PrimitiveScalar valueOf(double value) {
        return PrimitiveScalar.of(value);
    }

    public static PrimitiveScalar valueOf(Number number) {
        if (number != null) {
            if (number instanceof PrimitiveScalar) {
                return (PrimitiveScalar)number;
            }
            return new PrimitiveScalar(number.doubleValue());
        }
        return ZERO;
    }

    private PrimitiveScalar() {
        this.myValue = PrimitiveMath.ZERO;
    }

    private PrimitiveScalar(double value) {
        this.myValue = value;
    }

    @Override
    public PrimitiveScalar add(double arg) {
        return new PrimitiveScalar(this.myValue + arg);
    }

    @Override
    public PrimitiveScalar add(Double arg) {
        return new PrimitiveScalar(this.myValue + arg);
    }

    @Override
    public int compareTo(Double reference) {
        return Double.compare(this.myValue, reference);
    }

    @Override
    public PrimitiveScalar conjugate() {
        return this;
    }

    @Override
    public PrimitiveScalar divide(double arg) {
        return new PrimitiveScalar(this.myValue / arg);
    }

    @Override
    public PrimitiveScalar divide(Double arg) {
        return new PrimitiveScalar(this.myValue / arg);
    }

    @Override
    public double doubleValue() {
        return this.myValue;
    }

    @Override
    public PrimitiveScalar enforce(NumberContext context) {
        return new PrimitiveScalar(context.enforce(this.myValue));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Number)) {
            return false;
        }
        double other = ((Number)obj).doubleValue();
        return Double.doubleToLongBits(this.myValue) == Double.doubleToLongBits(other);
    }

    @Override
    public float floatValue() {
        return (float)this.myValue;
    }

    @Override
    public Double getNumber() {
        return this.myValue;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.myValue);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public int intValue() {
        return (int)this.myValue;
    }

    @Override
    public PrimitiveScalar invert() {
        return new PrimitiveScalar(PrimitiveMath.ONE / this.myValue);
    }

    @Override
    public boolean isAbsolute() {
        return PrimitiveScalar.isAbsolute(this.myValue);
    }

    @Override
    public boolean isSmall(double comparedTo) {
        return PrimitiveScalar.isSmall(comparedTo, this.myValue);
    }

    @Override
    public long longValue() {
        return (long)this.myValue;
    }

    @Override
    public PrimitiveScalar multiply(double arg) {
        return new PrimitiveScalar(this.myValue * arg);
    }

    @Override
    public PrimitiveScalar multiply(Double arg) {
        return new PrimitiveScalar(this.myValue * arg);
    }

    @Override
    public PrimitiveScalar negate() {
        return new PrimitiveScalar(-this.myValue);
    }

    @Override
    public double norm() {
        return Math.abs(this.myValue);
    }

    @Override
    public PrimitiveScalar signum() {
        return new PrimitiveScalar(Math.signum(this.myValue));
    }

    @Override
    public PrimitiveScalar subtract(double arg) {
        return new PrimitiveScalar(this.myValue - arg);
    }

    @Override
    public PrimitiveScalar subtract(Double arg) {
        return new PrimitiveScalar(this.myValue - arg);
    }

    @Override
    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.myValue, CONTEXT.getMathContext());
    }

    public String toString() {
        return Double.toString(this.myValue);
    }

    @Override
    public String toString(NumberContext context) {
        return context.enforce(this.toBigDecimal()).toString();
    }
}

