/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random;

import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.random.RandomNumber;
import org.ojalgo.type.TypeUtils;

public class Gamma
extends RandomNumber {
    private static final long serialVersionUID = 6544837857838057678L;
    private final double myShape;
    private final double myRate;

    public Gamma() {
        this(PrimitiveMath.ONE, PrimitiveMath.ONE);
    }

    public Gamma(double aShape, double aRate) {
        this.myShape = aShape;
        this.myRate = aRate;
    }

    @Override
    public double getExpected() {
        return this.myShape / this.myRate;
    }

    @Override
    public double getVariance() {
        return this.myShape / (this.myRate * this.myRate);
    }

    @Override
    protected double generate() {
        int tmpInteger = (int)this.myShape;
        double tmpFraction = this.myShape - (double)tmpInteger;
        double tmpIntegralPart = PrimitiveMath.ZERO;
        for (int i = 0; i < tmpInteger; ++i) {
            tmpIntegralPart -= Math.log(this.random().nextDouble());
        }
        double tmpFractionalPart = PrimitiveMath.ZERO;
        if (!TypeUtils.isZero(tmpFraction)) {
            double tmpDenom;
            double tmpNumer;
            double tmpFractionMinusOne = tmpFraction - PrimitiveMath.ONE;
            do {
                tmpFractionalPart = -PrimitiveMath.TWO * Math.log(PrimitiveMath.ONE - Math.pow(this.random().nextDouble(), PrimitiveMath.ONE / tmpFraction));
                double tmpNegHalfFraction = -tmpFractionalPart / PrimitiveMath.TWO;
                tmpNumer = Math.pow(tmpFractionalPart, tmpFractionMinusOne) * Math.exp(tmpNegHalfFraction);
                tmpDenom = Math.pow(PrimitiveMath.TWO, tmpFractionMinusOne) * Math.pow(-Math.expm1(tmpNegHalfFraction), tmpFractionMinusOne);
            } while (this.random().nextDouble() > tmpNumer / tmpDenom);
        }
        return (tmpIntegralPart + tmpFractionalPart) / this.myRate;
    }
}

