/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random;

import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.random.AbstractContinuous;

public class Exponential
extends AbstractContinuous {
    private static final long serialVersionUID = -720007692511649669L;
    private final double myRate;

    public Exponential() {
        this(PrimitiveMath.ONE);
    }

    public Exponential(double aRate) {
        this.myRate = aRate;
    }

    @Override
    public double getDistribution(double aValue) {
        if (aValue < PrimitiveMath.ZERO) {
            return PrimitiveMath.ZERO;
        }
        return PrimitiveMath.ONE - Math.exp(-this.myRate * aValue);
    }

    @Override
    public double getExpected() {
        return PrimitiveMath.ONE / this.myRate;
    }

    @Override
    public double getProbability(double aValue) {
        if (aValue < PrimitiveMath.ZERO) {
            return PrimitiveMath.ZERO;
        }
        return this.myRate * Math.exp(-this.myRate * aValue);
    }

    @Override
    public double getQuantile(double aProbality) {
        this.checkProbabilty(aProbality);
        return Math.log(PrimitiveMath.ONE - aProbality) / -this.myRate;
    }

    @Override
    public double getStandardDeviation() {
        return PrimitiveMath.ONE / this.myRate;
    }

    @Override
    protected double generate() {
        return -Math.log(this.random().nextDouble()) / this.myRate;
    }
}

