/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.access.Access1D;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.TransjugatedStore;
import org.ojalgo.scalar.Scalar;

final class TransposedStore<N extends Number>
extends TransjugatedStore<N> {
    TransposedStore(MatrixStore<N> aBase) {
        super(aBase);
    }

    @Override
    public N get(long aRow, long aCol) {
        return this.getBase().get(aCol, aRow);
    }

    @Override
    public MatrixStore<N> multiply(Access1D<N> right) {
        MatrixStore<Access1D<N>> retVal;
        if (right instanceof TransposedStore) {
            retVal = ((TransposedStore)right).getOriginal().multiply(this.getBase());
            retVal = new TransposedStore<Access1D<Access1D<N>>>(retVal);
        } else {
            retVal = super.multiply(right);
        }
        return retVal;
    }

    @Override
    public Scalar<N> toScalar(long row, long column) {
        return this.getBase().toScalar(column, row);
    }

    @Override
    public MatrixStore<N> transpose() {
        return this.getBase();
    }
}

