/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import java.io.Serializable;
import java.util.List;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.array.BasicArray;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.FunctionUtils;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.matrix.store.BigDenseStore;
import org.ojalgo.matrix.store.ComplexDenseStore;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.matrix.store.operation.MultiplyBoth;
import org.ojalgo.matrix.transformation.Householder;
import org.ojalgo.matrix.transformation.Rotation;
import org.ojalgo.scalar.Scalar;

public interface PhysicalStore<N extends Number>
extends MatrixStore<N>,
ElementsConsumer<N>,
Access2D.IndexOf,
Access2D.Special<N> {
    public List<N> asList();

    @Deprecated
    public void caxpy(N var1, int var2, int var3, int var4);

    @Deprecated
    public void maxpy(N var1, MatrixStore<N> var2);

    @Deprecated
    public void raxpy(N var1, int var2, int var3, int var4);

    public void transformLeft(Householder<N> var1, int var2);

    public void transformLeft(Rotation<N> var1);

    public void transformRight(Householder<N> var1, int var2);

    public void transformRight(Rotation<N> var1);

    public static final class TransposedRegion<N extends Number>
    extends ConsumerRegion<N> {
        private final ElementsConsumer<N> myBase;

        TransposedRegion(ElementsConsumer<N> base, FillByMultiplying<N> multiplier) {
            super(multiplier, base.countColumns(), base.countRows());
            this.myBase = base;
        }

        @Override
        public void add(long row, long column, double addend) {
            this.myBase.add(column, row, addend);
        }

        @Override
        public void add(long row, long column, Number addend) {
            this.myBase.add(column, row, addend);
        }

        @Override
        public long countColumns() {
            return this.myBase.countRows();
        }

        @Override
        public long countRows() {
            return this.myBase.countColumns();
        }

        @Override
        public void fillColumn(long row, long column, N value) {
            this.myBase.fillRow(column, row, value);
        }

        @Override
        public void fillColumn(long row, long column, NullaryFunction<N> supplier) {
            this.myBase.fillRow(column, row, supplier);
        }

        @Override
        public void fillDiagonal(long row, long column, N value) {
            this.myBase.fillDiagonal(column, row, value);
        }

        @Override
        public void fillDiagonal(long row, long column, NullaryFunction<N> supplier) {
            this.myBase.fillRow(column, row, supplier);
        }

        @Override
        public void fillOne(long row, long column, N value) {
            this.myBase.fillOne(column, row, value);
        }

        @Override
        public void fillOne(long row, long column, NullaryFunction<N> supplier) {
            this.myBase.fillOne(column, row, supplier);
        }

        @Override
        public void fillOneMatching(long row, long column, Access1D<?> values, long valueIndex) {
            this.myBase.fillOneMatching(column, row, values, valueIndex);
        }

        @Override
        public void fillRow(long row, long column, N value) {
            this.myBase.fillDiagonal(column, row, value);
        }

        @Override
        public void fillRow(long row, long column, NullaryFunction<N> supplier) {
            this.myBase.fillDiagonal(column, row, supplier);
        }

        @Override
        public void modifyColumn(long row, long column, UnaryFunction<N> function) {
            this.myBase.modifyRow(column, row, function);
        }

        @Override
        public void modifyDiagonal(long row, long column, UnaryFunction<N> function) {
            this.myBase.modifyDiagonal(column, row, function);
        }

        @Override
        public void modifyMatching(Access1D<N> left, BinaryFunction<N> function) {
            this.myBase.modifyMatching(left, function);
        }

        @Override
        public void modifyMatching(BinaryFunction<N> function, Access1D<N> right) {
            this.myBase.modifyMatching(function, right);
        }

        @Override
        public void modifyOne(long row, long column, UnaryFunction<N> function) {
            this.myBase.modifyOne(column, row, function);
        }

        @Override
        public void modifyRow(long row, long column, UnaryFunction<N> function) {
            this.myBase.modifyColumn(column, row, function);
        }

        @Override
        public ElementsConsumer<N> regionByTransposing() {
            return this.myBase;
        }

        @Override
        public void set(long row, long column, double value) {
            this.myBase.set(column, row, value);
        }

        @Override
        public void set(long row, long column, Number value) {
            this.myBase.set(column, row, value);
        }
    }

    public static final class RowsRegion<N extends Number>
    extends ConsumerRegion<N> {
        private final ElementsConsumer<N> myBase;
        private final int[] myRows;

        RowsRegion(ElementsConsumer<N> base, FillByMultiplying<N> multiplier, int ... rows) {
            super(multiplier, rows.length, base.countColumns());
            this.myBase = base;
            this.myRows = rows;
        }

        @Override
        public void add(long row, long column, double addend) {
            this.myBase.add((long)this.myRows[(int)row], column, addend);
        }

        @Override
        public void add(long row, long column, Number addend) {
            this.myBase.add((long)this.myRows[(int)row], column, addend);
        }

        @Override
        public long countColumns() {
            return this.myBase.countColumns();
        }

        @Override
        public long countRows() {
            return this.myRows.length;
        }

        @Override
        public void fillOne(long row, long column, N value) {
            this.myBase.fillOne((long)this.myRows[(int)row], column, value);
        }

        @Override
        public void fillOne(long row, long column, NullaryFunction<N> supplier) {
            this.myBase.fillOne((long)this.myRows[(int)row], column, supplier);
        }

        @Override
        public void fillOneMatching(long row, long column, Access1D<?> values, long valueIndex) {
            this.myBase.fillOneMatching(this.myRows[(int)row], column, values, valueIndex);
        }

        @Override
        public void fillRow(long row, long column, Access1D<N> values) {
            this.myBase.fillRow((long)this.myRows[(int)row], column, values);
        }

        @Override
        public void fillRow(long row, long column, N value) {
            this.myBase.fillRow((long)this.myRows[(int)row], column, value);
        }

        @Override
        public void fillRow(long row, long column, NullaryFunction<N> supplier) {
            this.myBase.fillRow((long)this.myRows[(int)row], column, supplier);
        }

        @Override
        public void modifyOne(long row, long column, UnaryFunction<N> function) {
            this.myBase.modifyOne(this.myRows[(int)row], column, function);
        }

        @Override
        public void modifyRow(long row, long column, UnaryFunction<N> function) {
            this.myBase.modifyRow(this.myRows[(int)row], column, function);
        }

        @Override
        public void set(long row, long column, double value) {
            this.myBase.set((long)this.myRows[(int)row], column, value);
        }

        @Override
        public void set(long row, long column, Number value) {
            this.myBase.set((long)this.myRows[(int)row], column, value);
        }
    }

    public static final class OffsetRegion<N extends Number>
    extends ConsumerRegion<N> {
        private final ElementsConsumer<N> myBase;
        private final int myRowOffset;
        private final int myColumnOffset;

        OffsetRegion(ElementsConsumer<N> base, FillByMultiplying<N> multiplier, int rowOffset, int columnOffset) {
            super(multiplier, base.countRows() - (long)rowOffset, base.countColumns() - (long)columnOffset);
            this.myBase = base;
            this.myRowOffset = rowOffset;
            this.myColumnOffset = columnOffset;
        }

        @Override
        public void add(long row, long column, double addend) {
            this.myBase.add((long)this.myRowOffset + row, (long)this.myColumnOffset + column, addend);
        }

        @Override
        public void add(long row, long column, Number addend) {
            this.myBase.add((long)this.myRowOffset + row, (long)this.myColumnOffset + column, addend);
        }

        @Override
        public long countColumns() {
            return this.myBase.countColumns() - (long)this.myColumnOffset;
        }

        @Override
        public long countRows() {
            return this.myBase.countRows() - (long)this.myRowOffset;
        }

        @Override
        public void fillAll(N value) {
            long tmpCountColumns = this.myBase.countColumns();
            for (long j = (long)this.myColumnOffset; j < tmpCountColumns; ++j) {
                this.myBase.fillColumn((long)this.myRowOffset, j, value);
            }
        }

        @Override
        public void fillAll(NullaryFunction<N> supplier) {
            long tmpCountColumns = this.myBase.countColumns();
            for (long j = (long)this.myColumnOffset; j < tmpCountColumns; ++j) {
                this.myBase.fillColumn((long)this.myRowOffset, j, supplier);
            }
        }

        @Override
        public void fillColumn(long row, long column, N value) {
            this.myBase.fillColumn((long)this.myRowOffset + row, (long)this.myColumnOffset + column, value);
        }

        @Override
        public void fillColumn(long row, long column, NullaryFunction<N> supplier) {
            this.myBase.fillColumn((long)this.myRowOffset + row, (long)this.myColumnOffset + column, supplier);
        }

        @Override
        public void fillDiagonal(long row, long column, N value) {
            this.myBase.fillDiagonal((long)this.myRowOffset + row, (long)this.myColumnOffset + column, value);
        }

        @Override
        public void fillDiagonal(long row, long column, NullaryFunction<N> supplier) {
            this.myBase.fillDiagonal((long)this.myRowOffset + row, (long)this.myColumnOffset + column, supplier);
        }

        @Override
        public void fillOne(long row, long column, N value) {
            this.myBase.fillOne((long)this.myRowOffset + row, (long)this.myColumnOffset + column, value);
        }

        @Override
        public void fillOne(long row, long column, NullaryFunction<N> supplier) {
            this.myBase.fillOne((long)this.myRowOffset + row, (long)this.myColumnOffset + column, supplier);
        }

        @Override
        public void fillOneMatching(long row, long column, Access1D<?> values, long valueIndex) {
            this.myBase.fillOneMatching((long)this.myRowOffset + row, (long)this.myColumnOffset + column, values, valueIndex);
        }

        @Override
        public void fillRow(long row, long column, N value) {
            this.myBase.fillRow((long)this.myRowOffset + row, (long)this.myColumnOffset + column, value);
        }

        @Override
        public void fillRow(long row, long column, NullaryFunction<N> supplier) {
            this.myBase.fillRow((long)this.myRowOffset + row, (long)this.myColumnOffset + column, supplier);
        }

        @Override
        public void modifyAll(UnaryFunction<N> function) {
            for (long j = (long)this.myColumnOffset; j < this.myBase.countColumns(); ++j) {
                this.myBase.modifyColumn(this.myRowOffset, j, function);
            }
        }

        @Override
        public void modifyColumn(long row, long column, UnaryFunction<N> function) {
            this.myBase.modifyColumn((long)this.myRowOffset + row, (long)this.myColumnOffset + column, function);
        }

        @Override
        public void modifyDiagonal(long row, long column, UnaryFunction<N> function) {
            this.myBase.modifyDiagonal((long)this.myRowOffset + row, (long)this.myColumnOffset + column, function);
        }

        @Override
        public void modifyOne(long row, long column, UnaryFunction<N> function) {
            this.myBase.modifyOne((long)this.myRowOffset + row, (long)this.myColumnOffset + column, function);
        }

        @Override
        public void modifyRow(long row, long column, UnaryFunction<N> function) {
            this.myBase.modifyRow((long)this.myRowOffset + row, (long)this.myColumnOffset + column, function);
        }

        @Override
        public void set(long row, long column, double value) {
            this.myBase.set((long)this.myRowOffset + row, (long)this.myColumnOffset + column, value);
        }

        @Override
        public void set(long row, long column, Number value) {
            this.myBase.set((long)this.myRowOffset + row, (long)this.myColumnOffset + column, value);
        }
    }

    public static final class LimitRegion<N extends Number>
    extends ConsumerRegion<N> {
        private final ElementsConsumer<N> myBase;
        private final int myRowLimit;
        private final int myColumnLimit;

        LimitRegion(ElementsConsumer<N> base, FillByMultiplying<N> multiplier, int rowLimit, int columnLimit) {
            super(multiplier, rowLimit, columnLimit);
            this.myBase = base;
            this.myRowLimit = rowLimit;
            this.myColumnLimit = columnLimit;
        }

        @Override
        public void add(long row, long column, double addend) {
            this.myBase.add(row, column, addend);
        }

        @Override
        public void add(long row, long column, Number addend) {
            this.myBase.add(row, column, addend);
        }

        @Override
        public long countColumns() {
            return this.myColumnLimit;
        }

        @Override
        public long countRows() {
            return this.myRowLimit;
        }

        @Override
        public void fillOne(long row, long column, N value) {
            this.myBase.fillOne(row, column, value);
        }

        @Override
        public void fillOne(long row, long column, NullaryFunction<N> supplier) {
            this.myBase.fillOne(row, column, supplier);
        }

        @Override
        public void fillOneMatching(long row, long column, Access1D<?> values, long valueIndex) {
            this.myBase.fillOneMatching(row, column, values, valueIndex);
        }

        @Override
        public void modifyOne(long row, long column, UnaryFunction<N> function) {
            this.myBase.modifyOne(row, column, function);
        }

        @Override
        public void set(long row, long column, double value) {
            this.myBase.set(row, column, value);
        }

        @Override
        public void set(long row, long column, Number value) {
            this.myBase.set(row, column, value);
        }
    }

    public static interface FillByMultiplying<N extends Number> {
        public void invoke(ElementsConsumer<N> var1, Access1D<N> var2, int var3, Access1D<N> var4);
    }

    public static interface Factory<N extends Number, I extends PhysicalStore<N>>
    extends Access2D.Factory<I>,
    Serializable {
        public AggregatorSet<N> aggregator();

        public MatrixStore.Factory<N> builder();

        public I conjugate(Access2D<?> var1);

        public FunctionSet<N> function();

        public BasicArray<N> makeArray(int var1);

        public Householder<N> makeHouseholder(int var1);

        public Rotation<N> makeRotation(int var1, int var2, double var3, double var5);

        public Rotation<N> makeRotation(int var1, int var2, N var3, N var4);

        public Scalar.Factory<N> scalar();

        public I transpose(Access2D<?> var1);
    }

    public static abstract class ConsumerRegion<N extends Number>
    implements ElementsConsumer<N> {
        private final FillByMultiplying<N> myMultiplier;

        private ConsumerRegion() {
            this(null, 0L, 0L);
        }

        ConsumerRegion(FillByMultiplying<N> multiplier, long rows, long columns) {
            this.myMultiplier = multiplier instanceof PrimitiveDenseStore.PrimitiveMultiplyBoth ? MultiplyBoth.getPrimitive(rows, columns) : (multiplier instanceof ComplexDenseStore.ComplexMultiplyBoth ? MultiplyBoth.getComplex(rows, columns) : (multiplier instanceof BigDenseStore.BigMultiplyBoth ? MultiplyBoth.getBig(rows, columns) : multiplier));
        }

        @Override
        public final void fillByMultiplying(Access1D<N> left, Access1D<N> right) {
            this.myMultiplier.invoke(this, left, (int)(left.count() / this.countRows()), right);
        }

        @Override
        public void modifyMatching(Access1D<N> left, BinaryFunction<N> function) {
            long tmpLimit = FunctionUtils.min(left.count(), this.count());
            for (long i = 0L; i < tmpLimit; ++i) {
                this.modifyOne(i, function.first(left.get(i)));
            }
        }

        @Override
        public void modifyMatching(BinaryFunction<N> function, Access1D<N> right) {
            long tmpLimit = FunctionUtils.min(this.count(), right.count());
            for (long i = 0L; i < tmpLimit; ++i) {
                this.modifyOne(i, function.second(right.get(i)));
            }
        }

        @Override
        public final ElementsConsumer<N> regionByColumns(int ... columns) {
            return new ColumnsRegion<N>(this, this.myMultiplier, columns);
        }

        @Override
        public final ElementsConsumer<N> regionByLimits(int rowLimit, int columnLimit) {
            return new LimitRegion<N>(this, this.myMultiplier, rowLimit, columnLimit);
        }

        @Override
        public final ElementsConsumer<N> regionByOffsets(int rowOffset, int columnOffset) {
            return new OffsetRegion<N>(this, this.myMultiplier, rowOffset, columnOffset);
        }

        @Override
        public final ElementsConsumer<N> regionByRows(int ... rows) {
            return new RowsRegion<N>(this, this.myMultiplier, rows);
        }

        @Override
        public ElementsConsumer<N> regionByTransposing() {
            return new TransposedRegion<N>(this, this.myMultiplier);
        }

        public String toString() {
            return super.toString() + " " + this.countRows() + " x " + this.countColumns();
        }
    }

    public static final class ColumnsRegion<N extends Number>
    extends ConsumerRegion<N> {
        private final ElementsConsumer<N> myBase;
        private final int[] myColumns;

        ColumnsRegion(ElementsConsumer<N> base, FillByMultiplying<N> multiplier, int ... columns) {
            super(multiplier, base.countRows(), columns.length);
            this.myBase = base;
            this.myColumns = columns;
        }

        @Override
        public void add(long row, long column, double addend) {
            this.myBase.add(row, (long)this.myColumns[(int)column], addend);
        }

        @Override
        public void add(long row, long column, Number addend) {
            this.myBase.add(row, (long)this.myColumns[(int)column], addend);
        }

        @Override
        public long countColumns() {
            return this.myColumns.length;
        }

        @Override
        public long countRows() {
            return this.myBase.countRows();
        }

        @Override
        public void fillColumn(long row, long column, Access1D<N> values) {
            this.myBase.fillColumn(row, (long)this.myColumns[(int)column], values);
        }

        @Override
        public void fillColumn(long row, long column, N value) {
            this.myBase.fillColumn(row, (long)this.myColumns[(int)column], value);
        }

        @Override
        public void fillColumn(long row, long column, NullaryFunction<N> supplier) {
            this.myBase.fillColumn(row, (long)this.myColumns[(int)column], supplier);
        }

        @Override
        public void fillOne(long row, long column, N value) {
            this.myBase.fillOne(row, (long)this.myColumns[(int)column], value);
        }

        @Override
        public void fillOne(long row, long column, NullaryFunction<N> supplier) {
            this.myBase.fillOne(row, (long)this.myColumns[(int)column], supplier);
        }

        @Override
        public void fillOneMatching(long row, long column, Access1D<?> values, long valueIndex) {
            this.myBase.fillOneMatching(row, this.myColumns[(int)column], values, valueIndex);
        }

        @Override
        public void modifyColumn(long row, long column, UnaryFunction<N> function) {
            this.myBase.modifyColumn(row, this.myColumns[(int)column], function);
        }

        @Override
        public void modifyOne(long row, long column, UnaryFunction<N> function) {
            this.myBase.modifyOne(row, this.myColumns[(int)column], function);
        }

        @Override
        public void set(long row, long column, double value) {
            this.myBase.set(row, (long)this.myColumns[(int)column], value);
        }

        @Override
        public void set(long row, long column, Number value) {
            this.myBase.set(row, (long)this.myColumns[(int)column], value);
        }
    }
}

