/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.access.Supplier2D;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.matrix.store.ContextSupplier;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;

public interface ElementsSupplier<N extends Number>
extends Supplier2D<MatrixStore<N>> {
    public PhysicalStore.Factory<N, ?> factory();

    @Override
    default public MatrixStore<N> get() {
        PhysicalStore retVal = (PhysicalStore)this.factory().makeZero(this.countRows(), this.countColumns());
        this.supplyTo(retVal);
        return retVal;
    }

    default public ElementsSupplier<N> operateOnAll(final UnaryFunction<N> operator) {
        return new ContextSupplier<N>(this){

            @Override
            public long count() {
                return ElementsSupplier.this.count();
            }

            @Override
            public long countColumns() {
                return ElementsSupplier.this.countColumns();
            }

            @Override
            public long countRows() {
                return ElementsSupplier.this.countRows();
            }

            @Override
            public void supplyTo(ElementsConsumer<N> consumer) {
                ElementsSupplier.this.supplyTo(consumer);
                consumer.modifyAll(operator);
            }
        };
    }

    default public ElementsSupplier<N> operateOnMatching(final BinaryFunction<N> operator, final MatrixStore<N> right) {
        return new ContextSupplier<N>(this){

            @Override
            public long count() {
                return ElementsSupplier.this.count();
            }

            @Override
            public long countColumns() {
                return ElementsSupplier.this.countColumns();
            }

            @Override
            public long countRows() {
                return ElementsSupplier.this.countRows();
            }

            @Override
            public void supplyTo(ElementsConsumer<N> consumer) {
                ElementsSupplier.this.supplyTo(consumer);
                consumer.modifyMatching(operator, right);
            }
        };
    }

    default public ElementsSupplier<N> operateOnMatching(final MatrixStore<N> left, final BinaryFunction<N> operator) {
        return new ContextSupplier<N>(this){

            @Override
            public long count() {
                return ElementsSupplier.this.count();
            }

            @Override
            public long countColumns() {
                return ElementsSupplier.this.countColumns();
            }

            @Override
            public long countRows() {
                return ElementsSupplier.this.countRows();
            }

            @Override
            public void supplyTo(ElementsConsumer<N> consumer) {
                ElementsSupplier.this.supplyTo(consumer);
                consumer.modifyMatching(left, operator);
            }
        };
    }

    public void supplyTo(ElementsConsumer<N> var1);

    default public ElementsSupplier<N> transpose() {
        return new ContextSupplier<N>(this){

            @Override
            public long count() {
                return ElementsSupplier.this.count();
            }

            @Override
            public long countColumns() {
                return ElementsSupplier.this.countRows();
            }

            @Override
            public long countRows() {
                return ElementsSupplier.this.countColumns();
            }

            @Override
            public MatrixStore<N> get() {
                PhysicalStore retVal = (PhysicalStore)this.factory().makeZero(ElementsSupplier.this.countRows(), ElementsSupplier.this.countColumns());
                this.supplyTo(retVal);
                return retVal;
            }

            @Override
            public ElementsSupplier<N> operateOnAll(UnaryFunction<N> operator) {
                return ElementsSupplier.this.operateOnAll(operator);
            }

            @Override
            public ElementsSupplier<N> operateOnMatching(BinaryFunction<N> operator, MatrixStore<N> right) {
                return ElementsSupplier.this.operateOnMatching(operator, right.transpose());
            }

            @Override
            public ElementsSupplier<N> operateOnMatching(MatrixStore<N> left, BinaryFunction<N> operator) {
                return ElementsSupplier.this.operateOnMatching(left.transpose(), operator);
            }

            @Override
            public void supplyTo(ElementsConsumer<N> consumer) {
                ElementsSupplier.this.supplyTo(consumer.regionByTransposing());
            }

            @Override
            public ElementsSupplier<N> transpose() {
                return ElementsSupplier.this;
            }
        };
    }
}

