/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.ProgrammingError;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.Consumer2D;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.matrix.store.ElementsSupplier;

public interface ElementsConsumer<N extends Number>
extends Consumer2D<Access2D<N>>,
Access2D.Fillable<N>,
Access2D.Modifiable<N> {
    @Override
    default public void accept(Access2D<N> supplied) {
        long tmpCountRows = supplied.countRows();
        long tmpCountColumns = supplied.countColumns();
        for (long j = 0L; j < tmpCountColumns; ++j) {
            for (long i = 0L; i < tmpCountRows; ++i) {
                this.set(i, j, (Number)supplied.get(i, j));
            }
        }
    }

    default public void acceptFrom(ElementsSupplier<N> supplier) {
        if (!this.isAcceptable(supplier)) {
            throw new ProgrammingError("Not acceptable!");
        }
        this.accept((Access2D<N>)supplier.get());
    }

    @Override
    default public void fillAll(N value) {
        long tmpCountRows = this.countRows();
        long tmpCountColumns = this.countColumns();
        for (long j = 0L; j < tmpCountColumns; ++j) {
            for (long i = 0L; i < tmpCountRows; ++i) {
                this.fillOne(i, j, value);
            }
        }
    }

    @Override
    default public void fillAll(NullaryFunction<N> supplier) {
        long tmpCountRows = this.countRows();
        long tmpCountColumns = this.countColumns();
        for (long j = 0L; j < tmpCountColumns; ++j) {
            for (long i = 0L; i < tmpCountRows; ++i) {
                this.fillOne(i, j, supplier);
            }
        }
    }

    public void fillByMultiplying(Access1D<N> var1, Access1D<N> var2);

    @Override
    default public void fillColumn(long row, long column, N value) {
        long tmpCountRows = this.countRows();
        for (long i = row; i < tmpCountRows; ++i) {
            this.fillOne(i, column, value);
        }
    }

    @Override
    default public void fillColumn(long row, long column, NullaryFunction<N> supplier) {
        long tmpCountRows = this.countRows();
        for (long i = row; i < tmpCountRows; ++i) {
            this.fillOne(i, column, supplier);
        }
    }

    @Override
    default public void fillDiagonal(long row, long column, N value) {
        long tmpCountRows = this.countRows();
        long tmpCountColumns = this.countColumns();
        long i = row;
        for (long j = column; i < tmpCountRows && j < tmpCountColumns; ++i, ++j) {
            this.fillOne(i, j, value);
        }
    }

    @Override
    default public void fillDiagonal(long row, long column, NullaryFunction<N> supplier) {
        long tmpCountRows = this.countRows();
        long tmpCountColumns = this.countColumns();
        long i = row;
        for (long j = column; i < tmpCountRows && j < tmpCountColumns; ++i, ++j) {
            this.fillOne(i, j, supplier);
        }
    }

    @Override
    default public void fillRow(long row, long column, N value) {
        long tmpCountColumns = this.countColumns();
        for (long j = column; j < tmpCountColumns; ++j) {
            this.fillOne(row, j, value);
        }
    }

    @Override
    default public void fillRow(long row, long column, NullaryFunction<N> supplier) {
        long tmpCountColumns = this.countColumns();
        for (long j = column; j < tmpCountColumns; ++j) {
            this.fillOne(row, j, supplier);
        }
    }

    @Override
    default public void modifyAll(UnaryFunction<N> function) {
        long tmpCountRows = this.countRows();
        long tmpCountColumns = this.countColumns();
        for (long j = 0L; j < tmpCountColumns; ++j) {
            for (long i = 0L; i < tmpCountRows; ++i) {
                this.modifyOne(i, j, function);
            }
        }
    }

    @Override
    default public void modifyColumn(long row, long column, UnaryFunction<N> function) {
        long tmpCountRows = this.countRows();
        for (long i = row; i < tmpCountRows; ++i) {
            this.modifyOne(i, column, function);
        }
    }

    @Override
    default public void modifyDiagonal(long row, long column, UnaryFunction<N> function) {
        long tmpCountRows = this.countRows();
        long tmpCountColumns = this.countColumns();
        long i = row;
        for (long j = column; i < tmpCountRows && j < tmpCountColumns; ++i, ++j) {
            this.modifyOne(i, j, function);
        }
    }

    @Override
    default public void modifyRow(long row, long column, UnaryFunction<N> function) {
        long tmpCountColumns = this.countColumns();
        for (long j = column; j < tmpCountColumns; ++j) {
            this.modifyOne(row, j, function);
        }
    }

    public ElementsConsumer<N> regionByColumns(int ... var1);

    public ElementsConsumer<N> regionByLimits(int var1, int var2);

    public ElementsConsumer<N> regionByOffsets(int var1, int var2);

    public ElementsConsumer<N> regionByRows(int ... var1);

    public ElementsConsumer<N> regionByTransposing();
}

