/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import java.math.BigDecimal;
import org.ojalgo.access.Access2D;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.MatrixDecomposition;
import org.ojalgo.matrix.decomposition.TridiagonalDecomposition;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.scalar.ComplexNumber;

public interface Tridiagonal<N extends Number>
extends MatrixDecomposition<N> {
    public static <N extends Number> Tridiagonal<N> make(Access2D<N> typical) {
        N tmpNumber = typical.get(0L, 0L);
        if (tmpNumber instanceof BigDecimal) {
            return Tridiagonal.makeBig();
        }
        if (tmpNumber instanceof ComplexNumber) {
            return Tridiagonal.makeComplex();
        }
        if (tmpNumber instanceof Double) {
            return Tridiagonal.makePrimitive();
        }
        throw new IllegalArgumentException();
    }

    public static Tridiagonal<BigDecimal> makeBig() {
        return new TridiagonalDecomposition.Big();
    }

    public static Tridiagonal<ComplexNumber> makeComplex() {
        return new TridiagonalDecomposition.Complex();
    }

    public static Tridiagonal<Double> makePrimitive() {
        return new TridiagonalDecomposition.Primitive();
    }

    public MatrixStore<N> getD();

    public MatrixStore<N> getQ();

    @Override
    default public MatrixStore<N> reconstruct() {
        return MatrixUtils.reconstruct(this);
    }
}

