/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.access.Access2D;
import org.ojalgo.array.Array1D;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.MatrixDecomposition;
import org.ojalgo.matrix.decomposition.SchurDecomposition;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.scalar.ComplexNumber;

public interface Schur<N extends Number>
extends MatrixDecomposition<N> {
    public static <N extends Number> Schur<N> make(Access2D<N> typical) {
        N tmpNumber = typical.get(0L, 0L);
        if (tmpNumber instanceof Double) {
            return new SchurDecomposition.Primitive();
        }
        throw new IllegalArgumentException();
    }

    public static Schur<Double> makePrimitive() {
        return new SchurDecomposition.Primitive();
    }

    public Array1D<ComplexNumber> getDiagonal();

    public MatrixStore<N> getQ();

    public MatrixStore<N> getU();

    public boolean isOrdered();

    @Override
    default public MatrixStore<N> reconstruct() {
        return MatrixUtils.reconstruct(this);
    }
}

