/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.access.Access2D;
import org.ojalgo.access.Structure2D;
import org.ojalgo.array.Array1D;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.DiagonalAccess;
import org.ojalgo.matrix.decomposition.Maths;
import org.ojalgo.matrix.decomposition.RawDecomposition;
import org.ojalgo.matrix.decomposition.SingularValue;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.matrix.store.RawStore;
import org.ojalgo.matrix.store.operation.DotProduct;
import org.ojalgo.matrix.store.operation.SubtractScaledVector;
import org.ojalgo.type.TypeUtils;
import org.ojalgo.type.context.NumberContext;

final class RawSingularValue
extends RawDecomposition
implements SingularValue<Double> {
    private int m;
    private int n;
    private transient PrimitiveDenseStore myPseudoinverse = null;
    private double[] myS;
    private boolean myTransposed;
    private double[][] myUt;
    private double[][] myVt;

    RawSingularValue() {
    }

    @Override
    public boolean computeValuesOnly(ElementsSupplier<Double> matrix) {
        this.myTransposed = matrix.countRows() < matrix.countColumns();
        double[][] tmpData = this.reset((Structure2D)matrix.get(), !this.myTransposed);
        if (this.myTransposed) {
            matrix.supplyTo(this.getRawInPlaceStore());
        } else {
            matrix.transpose().supplyTo(this.getRawInPlaceStore());
        }
        return this.doDecompose(tmpData, false);
    }

    @Override
    public boolean decompose(ElementsSupplier<Double> matrix) {
        this.myTransposed = matrix.countRows() < matrix.countColumns();
        double[][] tmpData = this.reset((Structure2D)matrix.get(), !this.myTransposed);
        if (this.myTransposed) {
            matrix.supplyTo(this.getRawInPlaceStore());
        } else {
            matrix.transpose().supplyTo(this.getRawInPlaceStore());
        }
        return this.doDecompose(tmpData, true);
    }

    @Override
    public boolean equals(MatrixStore<Double> aStore, NumberContext context) {
        return MatrixUtils.equals(aStore, this, context);
    }

    @Override
    public double getCondition() {
        return this.myS[0] / this.myS[this.n - 1];
    }

    @Override
    public MatrixStore<Double> getD() {
        DiagonalAccess<Double> tmpDiagonal = new DiagonalAccess<Double>(this.getSingularValues(), null, null, PrimitiveMath.ZERO);
        return MatrixStore.PRIMITIVE.makeWrapper(tmpDiagonal).get();
    }

    @Override
    public double getFrobeniusNorm() {
        double retVal = PrimitiveMath.ZERO;
        for (int i = this.n - 1; i >= 0; --i) {
            double tmpVal = this.myS[i];
            retVal += tmpVal * tmpVal;
        }
        return Math.sqrt(retVal);
    }

    @Override
    public MatrixStore<Double> getInverse() {
        return this.doGetInverse(this.preallocate(this.getColDim(), this.getRowDim()));
    }

    @Override
    public double getKyFanNorm(int k) {
        double retVal = PrimitiveMath.ZERO;
        for (int i = Math.min(this.myS.length, k) - 1; i >= 0; --i) {
            retVal += this.myS[i];
        }
        return retVal;
    }

    @Override
    public double getOperatorNorm() {
        return this.myS[0];
    }

    public RawStore getQ1() {
        return this.myTransposed ? this.getV().transpose() : this.getU().transpose();
    }

    public RawStore getQ2() {
        return this.myTransposed ? this.getU().transpose() : this.getV().transpose();
    }

    @Override
    public int getRank() {
        double eps = Math.pow(PrimitiveMath.TWO, -52.0);
        double tol = (double)Math.max(this.m, this.n) * this.myS[0] * eps;
        int r = 0;
        for (int i = 0; i < this.myS.length; ++i) {
            if (!(this.myS[i] > tol)) continue;
            ++r;
        }
        return r;
    }

    @Override
    public Array1D<Double> getSingularValues() {
        return Array1D.PRIMITIVE.copy(this.myS);
    }

    @Override
    public double getTraceNorm() {
        return this.getKyFanNorm(this.myS.length);
    }

    @Override
    public MatrixStore<Double> invert(Access2D<?> original, DecompositionStore<Double> preallocated) {
        this.myTransposed = original.countRows() < original.countColumns();
        double[][] tmpData = this.reset(original, !this.myTransposed);
        if (this.myTransposed) {
            this.getRawInPlaceStore().fillMatching(original);
        } else {
            ((MatrixStore.Builder)MatrixStore.PRIMITIVE.makeWrapper(original).transpose()).supplyTo(this.getRawInPlaceStore());
        }
        this.doDecompose(tmpData, true);
        return this.getInverse(preallocated);
    }

    @Override
    public boolean isFullSize() {
        return false;
    }

    @Override
    public boolean isOrdered() {
        return true;
    }

    @Override
    public boolean isSolvable() {
        return this.isComputed();
    }

    @Override
    public DecompositionStore<Double> preallocate(Structure2D templateBody, Structure2D templateRHS) {
        return this.preallocate(templateBody.countColumns(), templateBody.countRows());
    }

    @Override
    public MatrixStore<Double> reconstruct() {
        return MatrixUtils.reconstruct(this);
    }

    @Override
    public void reset() {
        super.reset();
        this.myPseudoinverse = null;
    }

    @Override
    public void setFullSize(boolean fullSize) {
    }

    @Override
    public final MatrixStore<Double> solve(Access2D<?> body, Access2D<?> rhs, DecompositionStore<Double> preallocated) {
        this.myTransposed = body.countRows() < body.countColumns();
        double[][] tmpData = this.reset(body, !this.myTransposed);
        if (this.myTransposed) {
            this.getRawInPlaceStore().fillMatching(body);
        } else {
            ((MatrixStore.Builder)MatrixStore.PRIMITIVE.makeWrapper(body).transpose()).supplyTo(this.getRawInPlaceStore());
        }
        this.doDecompose(tmpData, true);
        Object tmpRHS = MatrixStore.PRIMITIVE.makeWrapper(rhs).get();
        return this.doGetInverse((PrimitiveDenseStore)preallocated).multiply((Double)tmpRHS);
    }

    @Override
    public MatrixStore<Double> solve(ElementsSupplier<Double> rhs, DecompositionStore<Double> preallocated) {
        return this.doGetInverse((PrimitiveDenseStore)preallocated).multiply((Double)rhs.get());
    }

    @Override
    public MatrixStore<Double> solve(MatrixStore<Double> rhs, DecompositionStore<Double> preallocated) {
        return this.doGetInverse((PrimitiveDenseStore)preallocated).multiply((Double)((Object)rhs));
    }

    @Override
    protected MatrixStore<Double> doGetInverse(PrimitiveDenseStore preallocated) {
        if (this.myPseudoinverse == null) {
            double[][] tmpQ1 = this.getQ1().data;
            double[] tmpSingular = this.myS;
            RawStore tmpMtrx = new RawStore(tmpSingular.length, tmpQ1.length);
            for (int i = 0; i < tmpSingular.length; ++i) {
                int j;
                if (TypeUtils.isZero(tmpSingular[i])) {
                    for (j = 0; j < tmpQ1.length; ++j) {
                        tmpMtrx.set((long)i, (long)j, PrimitiveMath.ZERO);
                    }
                    continue;
                }
                for (j = 0; j < tmpQ1.length; ++j) {
                    tmpMtrx.set((long)i, (long)j, tmpQ1[j][i] / tmpSingular[i]);
                }
            }
            RawStore tmpQ2 = this.getQ2();
            preallocated.fillByMultiplying(tmpQ2, tmpMtrx);
            this.myPseudoinverse = preallocated;
        }
        return this.myPseudoinverse;
    }

    boolean doDecompose(double[][] data, boolean factors) {
        int i;
        double t;
        int j;
        int k;
        int j2;
        double[] tmpAt_k;
        this.m = this.getMaxDim();
        this.n = this.getMinDim();
        this.myUt = factors ? new double[this.n][this.m] : (double[][])null;
        this.myS = new double[this.n];
        this.myVt = factors ? new double[this.n][this.n] : (double[][])null;
        double[] tmpE = new double[this.n];
        double[] tmpWork = new double[this.m];
        double nrm = PrimitiveMath.ZERO;
        int nct = Math.min(this.m - 1, this.n);
        int nrt = Math.max(0, this.n - 2);
        int tmpLimK = Math.max(nct, nrt);
        for (int k2 = 0; k2 < tmpLimK; ++k2) {
            int i2;
            tmpAt_k = data[k2];
            if (k2 < nct) {
                nrm = PrimitiveMath.ZERO;
                for (i2 = k2; i2 < this.m; ++i2) {
                    nrm = Maths.hypot(nrm, tmpAt_k[i2]);
                }
                if (nrm != PrimitiveMath.ZERO) {
                    if (tmpAt_k[k2] < PrimitiveMath.ZERO) {
                        nrm = -nrm;
                    }
                    i2 = k2;
                    while (i2 < this.m) {
                        int n = i2++;
                        tmpAt_k[n] = tmpAt_k[n] / nrm;
                    }
                    int n = k2;
                    tmpAt_k[n] = tmpAt_k[n] + PrimitiveMath.ONE;
                    for (j2 = k2 + 1; j2 < this.n; ++j2) {
                        double t2 = DotProduct.invoke(tmpAt_k, 0, data[j2], 0, k2, this.m);
                        SubtractScaledVector.invoke(data[j2], 0, tmpAt_k, 0, t2 /= tmpAt_k[k2], k2, this.m);
                    }
                }
                this.myS[k2] = -nrm;
            }
            for (j2 = k2 + 1; j2 < this.n; ++j2) {
                tmpE[j2] = data[j2][k2];
            }
            if (factors && k2 < nct) {
                for (i2 = k2; i2 < this.m; ++i2) {
                    this.myUt[k2][i2] = tmpAt_k[i2];
                }
            }
            if (k2 >= nrt) continue;
            nrm = PrimitiveMath.ZERO;
            for (i2 = k2 + 1; i2 < this.n; ++i2) {
                nrm = Maths.hypot(nrm, tmpE[i2]);
            }
            if (nrm != PrimitiveMath.ZERO) {
                if (tmpE[k2 + 1] < PrimitiveMath.ZERO) {
                    nrm = -nrm;
                }
                i2 = k2 + 1;
                while (i2 < this.n) {
                    int n = i2++;
                    tmpE[n] = tmpE[n] / nrm;
                }
                int n = k2 + 1;
                tmpE[n] = tmpE[n] + PrimitiveMath.ONE;
                for (i2 = k2 + 1; i2 < this.m; ++i2) {
                    tmpWork[i2] = PrimitiveMath.ZERO;
                }
                for (j2 = k2 + 1; j2 < this.n; ++j2) {
                    SubtractScaledVector.invoke(tmpWork, 0, data[j2], 0, -tmpE[j2], k2 + 1, this.m);
                }
                for (j2 = k2 + 1; j2 < this.n; ++j2) {
                    SubtractScaledVector.invoke(data[j2], 0, tmpWork, 0, tmpE[j2] / tmpE[k2 + 1], k2 + 1, this.m);
                }
            }
            tmpE[k2] = -nrm;
            if (!factors) continue;
            for (i2 = k2 + 1; i2 < this.n; ++i2) {
                this.myVt[k2][i2] = tmpE[i2];
            }
        }
        int p = this.n;
        if (nct < this.n) {
            this.myS[nct] = data[nct][nct];
        }
        if (nrt + 1 < p) {
            tmpE[nrt] = data[p - 1][nrt];
        }
        tmpE[p - 1] = PrimitiveMath.ZERO;
        if (factors) {
            for (j2 = nct; j2 < this.n; ++j2) {
                for (int i3 = 0; i3 < this.m; ++i3) {
                    this.myUt[j2][i3] = PrimitiveMath.ZERO;
                }
                this.myUt[j2][j2] = PrimitiveMath.ONE;
            }
            for (k = nct - 1; k >= 0; --k) {
                double[] tmpUt_k = this.myUt[k];
                if (this.myS[k] != PrimitiveMath.ZERO) {
                    for (j = k + 1; j < this.n; ++j) {
                        t = DotProduct.invoke(tmpUt_k, 0, this.myUt[j], 0, k, this.m);
                        SubtractScaledVector.invoke(this.myUt[j], 0, tmpUt_k, 0, t /= tmpUt_k[k], k, this.m);
                    }
                    for (i = k; i < this.m; ++i) {
                        tmpUt_k[i] = -tmpUt_k[i];
                    }
                    tmpUt_k[k] = PrimitiveMath.ONE + tmpUt_k[k];
                    for (i = 0; i < k - 1; ++i) {
                        tmpUt_k[i] = PrimitiveMath.ZERO;
                    }
                    continue;
                }
                for (i = 0; i < this.m; ++i) {
                    tmpUt_k[i] = PrimitiveMath.ZERO;
                }
                tmpUt_k[k] = PrimitiveMath.ONE;
            }
        }
        if (factors) {
            for (k = this.n - 1; k >= 0; --k) {
                double[] tmpVt_k = this.myVt[k];
                if (k < nrt && tmpE[k] != PrimitiveMath.ZERO) {
                    for (j = k + 1; j < this.n; ++j) {
                        t = DotProduct.invoke(tmpVt_k, 0, this.myVt[j], 0, k + 1, this.n);
                        SubtractScaledVector.invoke(this.myVt[j], 0, tmpVt_k, 0, t /= tmpVt_k[k + 1], k + 1, this.n);
                    }
                }
                for (i = 0; i < this.n; ++i) {
                    tmpVt_k[i] = PrimitiveMath.ZERO;
                }
                tmpVt_k[k] = PrimitiveMath.ONE;
            }
        }
        int pp = p - 1;
        double eps = Math.pow(PrimitiveMath.TWO, -52.0);
        double tiny = Math.pow(PrimitiveMath.TWO, -966.0);
        block28: while (p > 0) {
            int kase;
            int k3;
            for (k3 = p - 2; k3 >= -1 && k3 != -1; --k3) {
                if (!(Math.abs(tmpE[k3]) <= tiny + eps * (Math.abs(this.myS[k3]) + Math.abs(this.myS[k3 + 1])))) continue;
                tmpE[k3] = PrimitiveMath.ZERO;
                break;
            }
            if (k3 == p - 2) {
                kase = 4;
            } else {
                int ks;
                for (ks = p - 1; ks >= k3 && ks != k3; --ks) {
                    double t3 = (ks != p ? Math.abs(tmpE[ks]) : 0.0) + (ks != k3 + 1 ? Math.abs(tmpE[ks - 1]) : 0.0);
                    if (!(Math.abs(this.myS[ks]) <= tiny + eps * t3)) continue;
                    this.myS[ks] = PrimitiveMath.ZERO;
                    break;
                }
                if (ks == k3) {
                    kase = 3;
                } else if (ks == p - 1) {
                    kase = 1;
                } else {
                    kase = 2;
                    k3 = ks;
                }
            }
            ++k3;
            switch (kase) {
                case 1: {
                    int i4;
                    double sn;
                    double cs;
                    double t4;
                    double f = tmpE[p - 2];
                    tmpE[p - 2] = PrimitiveMath.ZERO;
                    for (int j3 = p - 2; j3 >= k3; --j3) {
                        t4 = Maths.hypot(this.myS[j3], f);
                        cs = this.myS[j3] / t4;
                        sn = f / t4;
                        this.myS[j3] = t4;
                        if (j3 != k3) {
                            f = -sn * tmpE[j3 - 1];
                            tmpE[j3 - 1] = cs * tmpE[j3 - 1];
                        }
                        if (!factors) continue;
                        for (i4 = 0; i4 < this.n; ++i4) {
                            t4 = cs * this.myVt[j3][i4] + sn * this.myVt[p - 1][i4];
                            this.myVt[p - 1][i4] = -sn * this.myVt[j3][i4] + cs * this.myVt[p - 1][i4];
                            this.myVt[j3][i4] = t4;
                        }
                    }
                    continue block28;
                }
                case 2: {
                    int i4;
                    double sn;
                    double cs;
                    double t4;
                    double f = tmpE[k3 - 1];
                    tmpE[k3 - 1] = PrimitiveMath.ZERO;
                    for (int j4 = k3; j4 < p; ++j4) {
                        t4 = Maths.hypot(this.myS[j4], f);
                        cs = this.myS[j4] / t4;
                        sn = f / t4;
                        this.myS[j4] = t4;
                        f = -sn * tmpE[j4];
                        tmpE[j4] = cs * tmpE[j4];
                        if (!factors) continue;
                        for (i4 = 0; i4 < this.m; ++i4) {
                            t4 = cs * this.myUt[j4][i4] + sn * this.myUt[k3 - 1][i4];
                            this.myUt[k3 - 1][i4] = -sn * this.myUt[j4][i4] + cs * this.myUt[k3 - 1][i4];
                            this.myUt[j4][i4] = t4;
                        }
                    }
                    continue block28;
                }
                case 3: {
                    double scale = Math.max(Math.max(Math.max(Math.max(Math.abs(this.myS[p - 1]), Math.abs(this.myS[p - 2])), Math.abs(tmpE[p - 2])), Math.abs(this.myS[k3])), Math.abs(tmpE[k3]));
                    double sp = this.myS[p - 1] / scale;
                    double spm1 = this.myS[p - 2] / scale;
                    double epm1 = tmpE[p - 2] / scale;
                    double sk = this.myS[k3] / scale;
                    double ek = tmpE[k3] / scale;
                    double b = ((spm1 + sp) * (spm1 - sp) + epm1 * epm1) / PrimitiveMath.TWO;
                    double c = sp * epm1 * (sp * epm1);
                    double shift = PrimitiveMath.ZERO;
                    if (b != PrimitiveMath.ZERO | c != PrimitiveMath.ZERO) {
                        shift = Math.sqrt(b * b + c);
                        if (b < PrimitiveMath.ZERO) {
                            shift = -shift;
                        }
                        shift = c / (b + shift);
                    }
                    double f = (sk + sp) * (sk - sp) + shift;
                    double g = sk * ek;
                    for (int j5 = k3; j5 < p - 1; ++j5) {
                        int i5;
                        double t5 = Maths.hypot(f, g);
                        double cs = f / t5;
                        double sn = g / t5;
                        if (j5 != k3) {
                            tmpE[j5 - 1] = t5;
                        }
                        f = cs * this.myS[j5] + sn * tmpE[j5];
                        tmpE[j5] = cs * tmpE[j5] - sn * this.myS[j5];
                        g = sn * this.myS[j5 + 1];
                        this.myS[j5 + 1] = cs * this.myS[j5 + 1];
                        if (factors) {
                            for (i5 = 0; i5 < this.n; ++i5) {
                                t5 = cs * this.myVt[j5][i5] + sn * this.myVt[j5 + 1][i5];
                                this.myVt[j5 + 1][i5] = -sn * this.myVt[j5][i5] + cs * this.myVt[j5 + 1][i5];
                                this.myVt[j5][i5] = t5;
                            }
                        }
                        t5 = Maths.hypot(f, g);
                        cs = f / t5;
                        sn = g / t5;
                        this.myS[j5] = t5;
                        f = cs * tmpE[j5] + sn * this.myS[j5 + 1];
                        this.myS[j5 + 1] = -sn * tmpE[j5] + cs * this.myS[j5 + 1];
                        g = sn * tmpE[j5 + 1];
                        tmpE[j5 + 1] = cs * tmpE[j5 + 1];
                        if (!factors || j5 >= this.m - 1) continue;
                        for (i5 = 0; i5 < this.m; ++i5) {
                            t5 = cs * this.myUt[j5][i5] + sn * this.myUt[j5 + 1][i5];
                            this.myUt[j5 + 1][i5] = -sn * this.myUt[j5][i5] + cs * this.myUt[j5 + 1][i5];
                            this.myUt[j5][i5] = t5;
                        }
                    }
                    tmpE[p - 2] = f;
                    break;
                }
                case 4: {
                    if (this.myS[k3] <= PrimitiveMath.ZERO) {
                        double d = this.myS[k3] = this.myS[k3] < PrimitiveMath.ZERO ? -this.myS[k3] : PrimitiveMath.ZERO;
                        if (factors) {
                            for (int i6 = 0; i6 <= pp; ++i6) {
                                this.myVt[k3][i6] = -this.myVt[k3][i6];
                            }
                        }
                    }
                    while (k3 < pp && !(this.myS[k3] >= this.myS[k3 + 1])) {
                        double t6 = this.myS[k3];
                        this.myS[k3] = this.myS[k3 + 1];
                        this.myS[k3 + 1] = t6;
                        if (factors && k3 < this.n - 1) {
                            tmpAt_k = this.myVt[k3 + 1];
                            this.myVt[k3 + 1] = this.myVt[k3];
                            this.myVt[k3] = tmpAt_k;
                        }
                        if (factors && k3 < this.m - 1) {
                            tmpAt_k = this.myUt[k3 + 1];
                            this.myUt[k3 + 1] = this.myUt[k3];
                            this.myUt[k3] = tmpAt_k;
                        }
                        ++k3;
                    }
                    --p;
                }
            }
        }
        return this.computed(true);
    }

    RawStore getU() {
        return new RawStore(this.myUt, this.n, this.m);
    }

    RawStore getV() {
        return new RawStore(this.myVt, this.n, this.n);
    }
}

