/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.access.Access2D;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.LDL;
import org.ojalgo.matrix.decomposition.RawDecomposition;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.matrix.store.RawStore;
import org.ojalgo.matrix.store.operation.DotProduct;

final class RawLDL
extends RawDecomposition
implements LDL<Double> {
    private boolean mySPD = false;

    RawLDL() {
    }

    @Override
    public Double calculateDeterminant(Access2D<?> matrix) {
        double[][] retVal = this.reset(matrix, false);
        this.doDecompose(retVal, matrix);
        return this.getDeterminant();
    }

    @Override
    public boolean decompose(ElementsSupplier<Double> matrix) {
        double[][] retVal = this.reset(matrix, false);
        RawStore tmpRawInPlaceStore = this.getRawInPlaceStore();
        matrix.supplyTo(tmpRawInPlaceStore);
        return this.doDecompose(retVal, tmpRawInPlaceStore);
    }

    boolean doDecompose(double[][] data, Access2D<?> input) {
        int tmpDiagDim = this.getRowDim();
        this.mySPD = this.getColDim() == tmpDiagDim;
        double[] tmpRowIJ = new double[tmpDiagDim];
        for (int ij = 0; ij < tmpDiagDim; ++ij) {
            double[] tmpRowI = data[ij];
            for (int j = 0; j < ij; ++j) {
                tmpRowIJ[j] = tmpRowI[j] * data[j][j];
            }
            tmpRowI[ij] = input.doubleValue(ij, ij) - DotProduct.invoke(tmpRowI, 0, tmpRowIJ, 0, 0, ij);
            double tmpD = tmpRowI[ij];
            this.mySPD &= tmpD > PrimitiveMath.ZERO;
            for (int i = ij + 1; i < tmpDiagDim; ++i) {
                tmpRowI = data[i];
                tmpRowI[ij] = (input.doubleValue(i, ij) - DotProduct.invoke(tmpRowI, 0, tmpRowIJ, 0, 0, ij)) / tmpD;
            }
        }
        return this.computed(true);
    }

    @Override
    public MatrixStore<Double> getD() {
        return this.getRawInPlaceStore().builder().diagonal(false).build();
    }

    @Override
    public Double getDeterminant() {
        double[][] tmpData = this.getRawInPlaceData();
        double retVal = PrimitiveMath.ONE;
        for (int ij = 0; ij < tmpData.length; ++ij) {
            retVal *= tmpData[ij][ij];
        }
        return retVal;
    }

    @Override
    public MatrixStore<Double> getL() {
        RawStore tmpRawInPlaceStore = this.getRawInPlaceStore();
        MatrixStore.Builder<Double> tmpBuilder = tmpRawInPlaceStore.builder();
        MatrixStore.Builder<Double> tmpTriangular = tmpBuilder.triangular(false, true);
        return tmpTriangular.build();
    }

    @Override
    public int getRank() {
        return 0;
    }

    @Override
    public MatrixStore<Double> invert(Access2D<?> original, DecompositionStore<Double> preallocated) {
        double[][] retVal = this.reset(original, false);
        this.doDecompose(retVal, original);
        return this.getInverse(preallocated);
    }

    @Override
    public boolean isSolvable() {
        return this.isComputed() && this.isSquareAndNotSingular();
    }

    public boolean isSPD() {
        return this.mySPD;
    }

    @Override
    public boolean isSquareAndNotSingular() {
        return false;
    }

    @Override
    public MatrixStore<Double> solve(Access2D<?> body, Access2D<?> rhs, DecompositionStore<Double> preallocated) {
        double[][] retVal = this.reset(body, false);
        this.doDecompose(retVal, body);
        return this.solve(rhs, preallocated);
    }

    @Override
    public MatrixStore<Double> solve(ElementsSupplier<Double> rhs, DecompositionStore<Double> preallocated) {
        return this.doSolve(rhs, (PrimitiveDenseStore)preallocated);
    }

    @Override
    public MatrixStore<Double> solve(MatrixStore<Double> rhs, DecompositionStore<Double> preallocated) {
        return this.doSolve(rhs, (PrimitiveDenseStore)preallocated);
    }

    @Override
    protected MatrixStore<Double> doGetInverse(PrimitiveDenseStore preallocated) {
        preallocated.fillAll(PrimitiveMath.ZERO);
        preallocated.fillDiagonal(0L, 0L, PrimitiveMath.ONE);
        RawStore tmpBody = this.getRawInPlaceStore();
        preallocated.substituteForwards(tmpBody, true, false, true);
        int i = 0;
        while ((long)i < preallocated.countRows()) {
            preallocated.modifyRow((long)i, 0L, PrimitiveFunction.DIVIDE.second((Double)tmpBody.doubleValue(i, i)));
            ++i;
        }
        preallocated.substituteBackwards(tmpBody, true, true, true);
        return preallocated;
    }

    MatrixStore<Double> doSolve(ElementsSupplier<Double> rhs, PrimitiveDenseStore preallocated) {
        rhs.supplyTo(preallocated);
        RawStore tmpBody = this.getRawInPlaceStore();
        preallocated.substituteForwards(tmpBody, true, false, false);
        int i = 0;
        while ((long)i < preallocated.countRows()) {
            preallocated.modifyRow((long)i, 0L, PrimitiveFunction.DIVIDE.second((Double)tmpBody.doubleValue(i, i)));
            ++i;
        }
        preallocated.substituteBackwards(tmpBody, true, true, false);
        return preallocated;
    }
}

