/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.access.Access2D;
import org.ojalgo.access.Structure2D;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.AbstractDecomposition;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.matrix.store.RawStore;

abstract class RawDecomposition
extends AbstractDecomposition<Double> {
    private int myColDim;
    private double[][] myRawInPlaceData;
    private RawStore myRawInPlaceStore;
    private int myRowDim;

    protected RawDecomposition() {
    }

    public MatrixStore<Double> getInverse() {
        return this.doGetInverse(this.preallocate(this.getColDim(), this.getColDim()));
    }

    public final MatrixStore<Double> getInverse(DecompositionStore<Double> preallocated) {
        return this.doGetInverse((PrimitiveDenseStore)preallocated);
    }

    public final MatrixStore<Double> invert(Access2D<?> original) {
        return this.invert(original, this.preallocate(original));
    }

    public abstract MatrixStore<Double> invert(Access2D<?> var1, DecompositionStore<Double> var2);

    public DecompositionStore<Double> preallocate(Structure2D template) {
        long tmpCountRows = template.countRows();
        return this.preallocate(tmpCountRows, tmpCountRows);
    }

    public DecompositionStore<Double> preallocate(Structure2D templateBody, Structure2D templateRHS) {
        return this.preallocate(templateRHS.countRows(), templateRHS.countColumns());
    }

    public final MatrixStore<Double> solve(Access2D<?> body, Access2D<?> rhs) {
        return this.solve(body, rhs, this.preallocate(body, rhs));
    }

    public abstract MatrixStore<Double> solve(Access2D<?> var1, Access2D<?> var2, DecompositionStore<Double> var3);

    public final MatrixStore<Double> solve(ElementsSupplier<Double> rhs) {
        return this.solve(rhs, this.preallocate(this.getRawInPlaceStore(), rhs));
    }

    public abstract MatrixStore<Double> solve(ElementsSupplier<Double> var1, DecompositionStore<Double> var2);

    protected final boolean checkSymmetry() {
        boolean retVal = this.myRowDim == this.myColDim;
        for (int i = 0; retVal && i < this.myRowDim; ++i) {
            for (int j = 0; retVal && j < i; retVal &= this.myRawInPlaceData[i][j] == this.myRawInPlaceData[j][i], ++j) {
            }
        }
        return retVal;
    }

    protected abstract MatrixStore<Double> doGetInverse(PrimitiveDenseStore var1);

    protected final int getColDim() {
        return this.myColDim;
    }

    protected final int getMaxDim() {
        return Math.max(this.myRowDim, this.myColDim);
    }

    protected final int getMinDim() {
        return Math.min(this.myRowDim, this.myColDim);
    }

    protected final double[][] getRawInPlaceData() {
        return this.myRawInPlaceData;
    }

    protected final RawStore getRawInPlaceStore() {
        return this.myRawInPlaceStore;
    }

    protected final int getRowDim() {
        return this.myRowDim;
    }

    protected final PrimitiveDenseStore preallocate(long numberOfRows, long numberOfColumns) {
        return (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(numberOfRows, numberOfColumns);
    }

    void copy(Access2D<?> source, int rows, int columns, double[][] destination) {
        MatrixUtils.copy(source, rows, columns, destination);
    }

    final double[][] reset(Structure2D matrix, boolean transpose) {
        int tmpInPlaceColDim;
        this.reset();
        int tmpInputRowDim = (int)matrix.countRows();
        int tmpInputColDim = (int)matrix.countColumns();
        int tmpInPlaceRowDim = transpose ? tmpInputColDim : tmpInputRowDim;
        int n = tmpInPlaceColDim = transpose ? tmpInputRowDim : tmpInputColDim;
        if (this.myRawInPlaceData == null || this.myRowDim != tmpInputRowDim || this.myColDim != tmpInputColDim) {
            this.myRawInPlaceStore = (RawStore)RawStore.FACTORY.makeZero(tmpInPlaceRowDim, tmpInPlaceColDim);
            this.myRawInPlaceData = this.myRawInPlaceStore.data;
            this.myRowDim = tmpInputRowDim;
            this.myColDim = tmpInputColDim;
        }
        this.aspectRatioNormal(tmpInputRowDim >= tmpInputColDim);
        return this.myRawInPlaceData;
    }

    void transpose(Access2D<?> source, int rows, int columns, double[][] destination) {
        for (int j = 0; j < columns; ++j) {
            double[] tmpColumn = destination[j];
            for (int i = 0; i < rows; ++i) {
                tmpColumn[i] = source.doubleValue(i, j);
            }
        }
    }
}

