/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import java.math.BigDecimal;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.Structure2D;
import org.ojalgo.array.BasicArray;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.InPlaceDecomposition;
import org.ojalgo.matrix.decomposition.LDL;
import org.ojalgo.matrix.decomposition.Pivot;
import org.ojalgo.matrix.store.BigDenseStore;
import org.ojalgo.matrix.store.ComplexDenseStore;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.scalar.Scalar;

abstract class LDLDecomposition<N extends Number>
extends InPlaceDecomposition<N>
implements LDL<N> {
    private Pivot myPivot;

    protected LDLDecomposition(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> factory) {
        super(factory);
    }

    @Override
    public N calculateDeterminant(Access2D<?> matrix) {
        this.decompose(this.wrap(matrix));
        return this.getDeterminant();
    }

    @Override
    public boolean decompose(ElementsSupplier<N> matrix) {
        this.reset();
        DecompositionStore tmpInPlace = this.setInPlace(matrix);
        int tmpRowDim = this.getRowDim();
        int tmpColDim = this.getColDim();
        int tmpMinDim = this.getMinDim();
        this.myPivot = new Pivot(tmpRowDim);
        BasicArray tmpMultipliers = this.makeArray(tmpRowDim);
        for (int ij = 0; ij < tmpMinDim; ++ij) {
            int tmpPivotRow = tmpInPlace.indexOfLargestInDiagonal(ij, ij) / tmpRowDim;
            if (tmpPivotRow != ij) {
                tmpInPlace.exchangeHermitian(tmpPivotRow, ij);
                this.myPivot.change(tmpPivotRow, ij);
            }
            if (tmpInPlace.doubleValue(ij, ij) != PrimitiveMath.ZERO) {
                tmpInPlace.divideAndCopyColumn(ij, ij, tmpMultipliers);
                tmpInPlace.applyLDL(ij, tmpMultipliers);
                continue;
            }
            tmpInPlace.set((long)ij, (long)ij, PrimitiveMath.ZERO);
        }
        return this.computed(true);
    }

    @Override
    public MatrixStore<N> getD() {
        DecompositionStore tmpInPlace = this.getInPlace();
        MatrixStore.Builder tmpBuilder = tmpInPlace.builder();
        MatrixStore.Builder tmpTriangular = tmpBuilder.diagonal(false);
        return tmpTriangular.build();
    }

    @Override
    public N getDeterminant() {
        AggregatorFunction tmpAggrFunc = this.aggregator().product();
        this.getInPlace().visitDiagonal(0L, 0L, tmpAggrFunc);
        if (this.myPivot.signum() == -1) {
            return ((Scalar)tmpAggrFunc.toScalar().negate()).getNumber();
        }
        return tmpAggrFunc.getNumber();
    }

    @Override
    public MatrixStore<N> getInverse(DecompositionStore<N> preallocated) {
        int tmpRowDim = this.getRowDim();
        int[] tmpOrder = this.myPivot.getOrder();
        boolean tmpModified = this.myPivot.isModified();
        if (tmpModified) {
            preallocated.fillAll((double)this.scalar().zero().getNumber());
            for (int i = 0; i < tmpRowDim; ++i) {
                preallocated.set((long)i, (long)tmpOrder[i], PrimitiveMath.ONE);
            }
        }
        DecompositionStore tmpBody = this.getInPlace();
        preallocated.substituteForwards(tmpBody, true, false, !tmpModified);
        BinaryFunction<double> tmpDivide = this.function().divide();
        for (int i = 0; i < tmpRowDim; ++i) {
            preallocated.modifyRow(i, 0L, tmpDivide.second(tmpBody.doubleValue(i, i)));
        }
        preallocated.substituteBackwards(tmpBody, true, true, false);
        return preallocated.builder().row(tmpOrder).build();
    }

    @Override
    public MatrixStore<N> getL() {
        DecompositionStore tmpInPlace = this.getInPlace();
        MatrixStore.Builder tmpBuilder = tmpInPlace.builder();
        MatrixStore.Builder tmpTriangular = tmpBuilder.triangular(false, true);
        return tmpTriangular.build();
    }

    @Override
    public int getRank() {
        int retVal = 0;
        DecompositionStore tmpInPlace = this.getInPlace();
        AggregatorFunction tmpLargest = this.aggregator().largest();
        tmpInPlace.visitDiagonal(0L, 0L, tmpLargest);
        double tmpLargestValue = tmpLargest.doubleValue();
        int tmpMinDim = this.getMinDim();
        for (int ij = 0; ij < tmpMinDim; ++ij) {
            if (tmpInPlace.isSmall(ij, ij, tmpLargestValue)) continue;
            ++retVal;
        }
        return retVal;
    }

    @Override
    public MatrixStore<N> invert(Access2D<?> original) {
        this.decompose(this.wrap(original));
        return this.getInverse();
    }

    @Override
    public MatrixStore<N> invert(Access2D<?> original, DecompositionStore<N> preallocated) {
        this.decompose(this.wrap(original));
        return this.getInverse(preallocated);
    }

    @Override
    public boolean isFullSize() {
        return true;
    }

    @Override
    public boolean isSolvable() {
        return this.isComputed() && this.isSquareAndNotSingular();
    }

    @Override
    public boolean isSquareAndNotSingular() {
        boolean retVal = this.getRowDim() == this.getColDim();
        boolean tmpFirst = false;
        int tmpLast = this.getColDim() - 1;
        retVal = retVal && PrimitiveScalar.isSmall(this.getInPlace().doubleValue(0L, 0L), this.getInPlace().doubleValue(tmpLast, tmpLast));
        return retVal;
    }

    @Override
    public DecompositionStore<N> preallocate(Structure2D template) {
        long tmpCountRows = template.countRows();
        return this.preallocate(tmpCountRows, tmpCountRows);
    }

    @Override
    public DecompositionStore<N> preallocate(Structure2D templateBody, Structure2D templateRHS) {
        return this.preallocate(templateRHS.countRows(), templateRHS.countColumns());
    }

    @Override
    public MatrixStore<N> solve(Access2D<?> body, Access2D<?> rhs) {
        this.decompose(this.wrap(body));
        return this.solve(this.wrap(rhs));
    }

    @Override
    public MatrixStore<N> solve(Access2D<?> body, Access2D<?> rhs, DecompositionStore<N> preallocated) {
        this.decompose(this.wrap(body));
        return this.solve(rhs, preallocated);
    }

    @Override
    public final MatrixStore<N> solve(ElementsSupplier<N> rhs) {
        return this.solve(rhs, this.preallocate(this.getInPlace(), rhs));
    }

    @Override
    public MatrixStore<N> solve(ElementsSupplier<N> rhs, DecompositionStore<N> preallocated) {
        int tmpRowDim = this.getRowDim();
        int[] tmpOrder = this.myPivot.getOrder();
        preallocated.fillMatching((Access1D<?>)rhs.get().builder().row(tmpOrder).get());
        DecompositionStore tmpBody = this.getInPlace();
        preallocated.substituteForwards(tmpBody, true, false, false);
        BinaryFunction<double> tmpDivide = this.function().divide();
        for (int i = 0; i < tmpRowDim; ++i) {
            preallocated.modifyRow(i, 0L, tmpDivide.second(tmpBody.doubleValue(i, i)));
        }
        preallocated.substituteBackwards(tmpBody, true, true, false);
        return preallocated.builder().row(tmpOrder).build();
    }

    static final class Primitive
    extends LDLDecomposition<Double> {
        Primitive() {
            super(PrimitiveDenseStore.FACTORY);
        }
    }

    static final class Complex
    extends LDLDecomposition<ComplexNumber> {
        Complex() {
            super(ComplexDenseStore.FACTORY);
        }
    }

    static final class Big
    extends LDLDecomposition<BigDecimal> {
        Big() {
            super(BigDenseStore.FACTORY);
        }
    }
}

