/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import java.math.BigDecimal;
import org.ojalgo.access.Access2D;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.Hessenberg;
import org.ojalgo.matrix.decomposition.InPlaceDecomposition;
import org.ojalgo.matrix.store.BigDenseStore;
import org.ojalgo.matrix.store.ComplexDenseStore;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.matrix.transformation.Householder;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.type.context.NumberContext;

abstract class HessenbergDecomposition<N extends Number>
extends InPlaceDecomposition<N>
implements Hessenberg<N> {
    private transient DecompositionStore<N> myQ = null;
    private boolean myUpper = true;

    protected HessenbergDecomposition(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> aFactory) {
        super(aFactory);
    }

    @Override
    public final boolean compute(ElementsSupplier<N> matrix, boolean upper) {
        this.reset();
        this.myUpper = upper;
        DecompositionStore tmpStore = this.setInPlace(matrix);
        int tmpRowDim = this.getRowDim();
        int tmpColDim = this.getColDim();
        if (upper) {
            Householder tmpHouseholderCol = this.makeHouseholder(tmpRowDim);
            int tmpLimit = Math.min(tmpRowDim, tmpColDim) - 2;
            for (int ij = 0; ij < tmpLimit; ++ij) {
                if (!tmpStore.generateApplyAndCopyHouseholderColumn(ij + 1, ij, tmpHouseholderCol)) continue;
                tmpStore.transformLeft(tmpHouseholderCol, ij + 1);
                tmpStore.transformRight(tmpHouseholderCol, 0);
            }
        } else {
            Householder tmpHouseholderRow = this.makeHouseholder(tmpColDim);
            int tmpLimit = Math.min(tmpRowDim, tmpColDim) - 2;
            for (int ij = 0; ij < tmpLimit; ++ij) {
                if (!tmpStore.generateApplyAndCopyHouseholderRow(ij, ij + 1, tmpHouseholderRow)) continue;
                tmpStore.transformRight(tmpHouseholderRow, ij + 1);
                tmpStore.transformLeft(tmpHouseholderRow, 0);
            }
        }
        return this.computed(true);
    }

    @Override
    public final boolean decompose(ElementsSupplier<N> matrix) {
        return this.compute(matrix, true);
    }

    @Override
    public final boolean equals(MatrixStore<N> aStore, NumberContext context) {
        return MatrixUtils.equals(aStore, this, context);
    }

    @Override
    public final MatrixStore<N> getH() {
        return this.getInPlace().builder().hessenberg(this.myUpper).build();
    }

    @Override
    public final MatrixStore<N> getQ() {
        if (this.myQ == null) {
            this.myQ = this.makeQ(this.makeEye(this.getRowDim(), this.getColDim()), this.myUpper, true);
        }
        return this.myQ;
    }

    public final boolean isFullSize() {
        return true;
    }

    public final boolean isSolvable() {
        return false;
    }

    @Override
    public boolean isUpper() {
        return this.myUpper;
    }

    @Override
    public void reset() {
        super.reset();
        this.myQ = null;
        this.myUpper = true;
    }

    public MatrixStore<N> solve(Access2D<N> rhs, DecompositionStore<N> preallocated) {
        throw new UnsupportedOperationException();
    }

    private final DecompositionStore<N> makeQ(DecompositionStore<N> aStoreToTransform, boolean tmpUpper, boolean eye) {
        int tmpRowAndColDim = (int)aStoreToTransform.countRows();
        DecompositionStore.HouseholderReference tmpHouseholderReference = new DecompositionStore.HouseholderReference(this.getInPlace(), tmpUpper);
        for (int ij = tmpRowAndColDim - 3; ij >= 0; --ij) {
            tmpHouseholderReference.row = tmpUpper ? ij + 1 : ij;
            int n = tmpHouseholderReference.col = tmpUpper ? ij : ij + 1;
            if (tmpHouseholderReference.isZero()) continue;
            aStoreToTransform.transformLeft(tmpHouseholderReference, eye ? ij : 0);
        }
        return aStoreToTransform;
    }

    final DecompositionStore<N> doQ(DecompositionStore<N> aStoreToTransform) {
        return this.makeQ(aStoreToTransform, this.myUpper, false);
    }

    static final class Primitive
    extends HessenbergDecomposition<Double> {
        Primitive() {
            super(PrimitiveDenseStore.FACTORY);
        }
    }

    static final class Complex
    extends HessenbergDecomposition<ComplexNumber> {
        Complex() {
            super(ComplexDenseStore.FACTORY);
        }
    }

    static final class Big
    extends HessenbergDecomposition<BigDecimal> {
        Big() {
            super(BigDenseStore.FACTORY);
        }
    }
}

