/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import java.math.BigDecimal;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.Structure2D;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.PrimitiveArray;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.aggregator.ComplexAggregator;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.DiagonalAccess;
import org.ojalgo.matrix.decomposition.EigenvalueDecomposition;
import org.ojalgo.matrix.decomposition.MatrixDecomposition;
import org.ojalgo.matrix.decomposition.TridiagonalDecomposition;
import org.ojalgo.matrix.store.BigDenseStore;
import org.ojalgo.matrix.store.ComplexDenseStore;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.type.context.NumberContext;

abstract class HermitianEvD<N extends Number>
extends EigenvalueDecomposition<N>
implements MatrixDecomposition.Solver<N> {
    private static final double EPSILON = Math.pow(2.0, -52.0);
    private Array1D<Double> myDiagonalValues;
    private transient MatrixStore<N> myInverse;
    private final TridiagonalDecomposition<N> myTridiagonal;

    static Array1D<Double> toDiagonal(DiagonalAccess<?> aTridiagonal, DecompositionStore<?> transformationAccumulator) {
        Array1D tmpMainDiagonal = aTridiagonal.mainDiagonal;
        Array1D tmpSubdiagonal = aTridiagonal.subdiagonal;
        int tmpDim = tmpMainDiagonal.size();
        double[] tmpMainDiagData = tmpMainDiagonal.toRawCopy();
        double[] tmpOffDiagData = new double[tmpDim];
        int tmpLength = tmpSubdiagonal.size();
        for (int i = 0; i < tmpLength; ++i) {
            tmpOffDiagData[i] = tmpSubdiagonal.doubleValue(i);
        }
        double tmpShift = PrimitiveMath.ZERO;
        double tmpMagnitude = PrimitiveMath.ZERO;
        for (int l = 0; l < tmpDim; ++l) {
            int m;
            tmpMagnitude = Math.max(tmpMagnitude, Math.abs(tmpMainDiagData[l]) + Math.abs(tmpOffDiagData[l]));
            double tmpLocalEpsilon = EPSILON * tmpMagnitude;
            for (m = l; m < tmpDim && !(Math.abs(tmpOffDiagData[m]) <= tmpLocalEpsilon); ++m) {
            }
            if (m > l) {
                do {
                    double tmp1Ml0 = tmpMainDiagData[l];
                    double tmp1Ml1 = tmpMainDiagData[l + 1];
                    double tmp1Sl0 = tmpOffDiagData[l];
                    double p = (tmp1Ml1 - tmp1Ml0) / (tmp1Sl0 + tmp1Sl0);
                    double r = Math.hypot(p, PrimitiveMath.ONE);
                    if (p < 0.0) {
                        r = -r;
                    }
                    double tmp2Ml0 = tmpMainDiagData[l] = tmp1Sl0 / (p + r);
                    double d = tmp1Sl0 * (p + r);
                    tmpMainDiagData[l + 1] = d;
                    double tmp2Ml1 = d;
                    double tmp2Sl1 = tmpOffDiagData[l + 1];
                    double tmpShiftIncr = tmp1Ml0 - tmp2Ml0;
                    int i = l + 2;
                    while (i < tmpDim) {
                        int n = i++;
                        tmpMainDiagData[n] = tmpMainDiagData[n] - tmpShiftIncr;
                    }
                    tmpShift += tmpShiftIncr;
                    double tmpRotCos = PrimitiveMath.ONE;
                    double tmpRotSin = PrimitiveMath.ZERO;
                    double tmpRotCos2 = tmpRotCos;
                    double tmpRotSin2 = PrimitiveMath.ZERO;
                    double tmpRotCos3 = tmpRotCos;
                    p = tmpMainDiagData[m];
                    for (int i2 = m - 1; i2 >= l; --i2) {
                        double tmp1Mi0 = tmpMainDiagData[i2];
                        double tmp1Si0 = tmpOffDiagData[i2];
                        r = Math.hypot(p, tmp1Si0);
                        tmpRotCos3 = tmpRotCos2;
                        tmpRotCos2 = tmpRotCos;
                        tmpRotSin2 = tmpRotSin;
                        tmpRotCos = p / r;
                        tmpRotSin = tmp1Si0 / r;
                        tmpMainDiagData[i2 + 1] = tmpRotCos2 * p + tmpRotSin * (tmpRotCos * tmpRotCos2 * tmp1Si0 + tmpRotSin * tmp1Mi0);
                        tmpOffDiagData[i2 + 1] = tmpRotSin2 * r;
                        p = tmpRotCos * tmp1Mi0 - tmpRotSin * tmpRotCos2 * tmp1Si0;
                        if (transformationAccumulator == null) continue;
                        transformationAccumulator.rotateRight(i2, i2 + 1, tmpRotCos, tmpRotSin);
                    }
                    p = -tmpRotSin * tmpRotSin2 * tmpRotCos3 * tmp2Sl1 * tmpOffDiagData[l] / tmp2Ml1;
                    tmpMainDiagData[l] = tmpRotCos * p;
                    tmpOffDiagData[l] = tmpRotSin * p;
                } while (Math.abs(tmpOffDiagData[l]) > tmpLocalEpsilon);
            }
            tmpMainDiagData[l] = tmpMainDiagData[l] + tmpShift;
            tmpOffDiagData[l] = PrimitiveMath.ZERO;
        }
        return Array1D.PRIMITIVE.wrap(PrimitiveArray.wrap(tmpMainDiagData));
    }

    private HermitianEvD(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> aFactory) {
        this(aFactory, null);
    }

    protected HermitianEvD(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> aFactory, TridiagonalDecomposition<N> aTridiagonal) {
        super(aFactory);
        this.myTridiagonal = aTridiagonal;
    }

    @Override
    public final boolean equals(MatrixStore<N> aStore, NumberContext context) {
        return MatrixUtils.equals(aStore, this, context);
    }

    @Override
    public final N getDeterminant() {
        AggregatorFunction<ComplexNumber> tmpVisitor = ComplexAggregator.getSet().product();
        this.getEigenvalues().visitAll(tmpVisitor);
        return this.scalar().cast(tmpVisitor.getNumber());
    }

    @Override
    public final MatrixStore<N> getInverse() {
        if (this.myInverse == null) {
            MatrixStore tmpV = this.getV();
            MatrixStore tmpD = this.getD();
            int tmpDim = (int)tmpD.countRows();
            PhysicalStore tmpMtrx = tmpV.conjugate().copy();
            Object tmpZero = this.scalar().zero().getNumber();
            BinaryFunction tmpDivide = this.function().divide();
            for (int i = 0; i < tmpDim; ++i) {
                if (tmpD.isZero(i, i)) {
                    tmpMtrx.fillRow((long)i, 0L, tmpZero);
                    continue;
                }
                tmpMtrx.modifyRow(i, 0L, tmpDivide.second(tmpD.get(i, i)));
            }
            this.myInverse = tmpV.multiply(tmpMtrx);
        }
        return this.myInverse;
    }

    @Override
    public final MatrixStore<N> getInverse(DecompositionStore<N> preallocated) {
        if (this.myInverse == null) {
            MatrixStore<DecompositionStore<N>> tmpV = this.getV();
            MatrixStore tmpD = this.getD();
            int tmpDim = (int)tmpD.countRows();
            DecompositionStore tmpMtrx = preallocated;
            tmpMtrx.fillMatching((Access1D<?>)((Object)tmpV.transpose()));
            Object tmpZero = this.scalar().zero().getNumber();
            BinaryFunction tmpDivide = this.function().divide();
            for (int i = 0; i < tmpDim; ++i) {
                if (tmpD.isZero(i, i)) {
                    tmpMtrx.fillRow((long)i, 0L, tmpZero);
                    continue;
                }
                tmpMtrx.modifyRow(i, 0L, tmpDivide.second(tmpD.get(i, i)));
            }
            this.myInverse = tmpV.multiply(tmpMtrx);
        }
        return this.myInverse;
    }

    @Override
    public final ComplexNumber getTrace() {
        AggregatorFunction<ComplexNumber> tmpVisitor = ComplexAggregator.getSet().sum();
        this.getEigenvalues().visitAll(tmpVisitor);
        return tmpVisitor.getNumber();
    }

    @Override
    public final boolean isHermitian() {
        return true;
    }

    @Override
    public final boolean isOrdered() {
        return true;
    }

    @Override
    public final boolean isSolvable() {
        return this.isComputed() && this.isHermitian();
    }

    @Override
    public void reset() {
        super.reset();
        this.myTridiagonal.reset();
        this.myInverse = null;
    }

    @Override
    protected final boolean doNonsymmetric(ElementsSupplier<N> aMtrx, boolean eigenvaluesOnly) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected final boolean doSymmetric(ElementsSupplier<N> aMtrx, boolean eigenvaluesOnly) {
        int tmpDim = (int)aMtrx.countRows();
        this.myTridiagonal.decompose(aMtrx);
        DiagonalAccess<N> tmpTridiagonal = this.myTridiagonal.getDiagonalAccessD();
        DecompositionStore<N> tmpV = eigenvaluesOnly ? null : this.myTridiagonal.doQ();
        this.myDiagonalValues = HermitianEvD.toDiagonal(tmpTridiagonal, tmpV);
        Array1D<Double> tmpDiagonal = this.myDiagonalValues;
        for (int ij1 = 0; ij1 < tmpDim - 1; ++ij1) {
            double tmpValue1 = tmpDiagonal.doubleValue(ij1);
            int ij2 = ij1;
            double tmpValue2 = tmpValue1;
            for (int ij2exp = ij1 + 1; ij2exp < tmpDim; ++ij2exp) {
                double tmpValue2exp = tmpDiagonal.doubleValue(ij2exp);
                if (!(Math.abs(tmpValue2exp) > Math.abs(tmpValue1)) && (Math.abs(tmpValue2exp) != Math.abs(tmpValue1) || !(tmpValue2exp > tmpValue1))) continue;
                ij2 = ij2exp;
                tmpValue2 = tmpValue2exp;
            }
            if (ij2 == ij1) continue;
            tmpDiagonal.set((long)ij1, tmpValue2);
            tmpDiagonal.set((long)ij2, tmpValue1);
            if (tmpV == null) continue;
            tmpV.exchangeColumns(ij1, ij2);
        }
        if (!eigenvaluesOnly) {
            this.setV(tmpV);
        }
        return this.computed(true);
    }

    @Override
    protected MatrixStore<N> makeD() {
        DiagonalAccess<Double> tmpDiagonal = new DiagonalAccess<Double>(this.myDiagonalValues, null, null, PrimitiveMath.ZERO);
        return this.wrap(tmpDiagonal).diagonal(false).get();
    }

    @Override
    protected Array1D<ComplexNumber> makeEigenvalues() {
        int tmpDim = this.myDiagonalValues.size();
        Access1D retVal = Array1D.COMPLEX.makeZero(tmpDim);
        for (int ij = 0; ij < tmpDim; ++ij) {
            ((Array1D)retVal).set(ij, (Object)ComplexNumber.valueOf(this.myDiagonalValues.doubleValue(ij)));
        }
        return retVal;
    }

    @Override
    protected MatrixStore<N> makeV() {
        return this.myTridiagonal.getQ();
    }

    @Override
    public MatrixStore<N> invert(Access2D<?> original) {
        this.decompose(this.wrap(original));
        return this.getInverse();
    }

    @Override
    public MatrixStore<N> invert(Access2D<?> original, DecompositionStore<N> preallocated) {
        this.decompose(this.wrap(original));
        return this.getInverse(preallocated);
    }

    @Override
    public DecompositionStore<N> preallocate(Structure2D template) {
        long tmpCountRows = template.countRows();
        return this.preallocate(tmpCountRows, tmpCountRows);
    }

    @Override
    public DecompositionStore<N> preallocate(Structure2D templateBody, Structure2D templateRHS) {
        return this.preallocate(templateRHS.countRows(), templateRHS.countColumns());
    }

    @Override
    public MatrixStore<N> solve(Access2D<?> body, Access2D<?> rhs) {
        this.decompose(this.wrap(body));
        return this.solve(this.wrap(rhs));
    }

    @Override
    public MatrixStore<N> solve(Access2D<?> body, Access2D<?> rhs, DecompositionStore<N> preallocated) {
        this.decompose(this.wrap(body));
        return this.solve(rhs, preallocated);
    }

    @Override
    public final MatrixStore<N> solve(ElementsSupplier<N> rhs) {
        return this.getInverse().multiply(rhs.get());
    }

    @Override
    public final MatrixStore<N> solve(ElementsSupplier<N> rhs, DecompositionStore<N> preallocated) {
        preallocated.fillByMultiplying(this.getInverse(), (Access1D<N>)rhs.get());
        return preallocated;
    }

    static final class Primitive
    extends HermitianEvD<Double> {
        Primitive() {
            super(PrimitiveDenseStore.FACTORY, new TridiagonalDecomposition.Primitive());
        }
    }

    static final class Complex
    extends HermitianEvD<ComplexNumber> {
        Complex() {
            super(ComplexDenseStore.FACTORY, new TridiagonalDecomposition.Complex());
        }
    }

    static final class Big
    extends HermitianEvD<BigDecimal> {
        Big() {
            super(BigDenseStore.FACTORY, new TridiagonalDecomposition.Big());
        }
    }
}

