/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import java.math.BigDecimal;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.Structure2D;
import org.ojalgo.array.BasicArray;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.Cholesky;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.InPlaceDecomposition;
import org.ojalgo.matrix.store.BigDenseStore;
import org.ojalgo.matrix.store.ComplexDenseStore;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.type.context.NumberContext;

abstract class CholeskyDecomposition<N extends Number>
extends InPlaceDecomposition<N>
implements Cholesky<N> {
    private boolean mySPD = false;

    protected CholeskyDecomposition(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> aFactory) {
        super(aFactory);
    }

    @Override
    public N calculateDeterminant(Access2D<?> matrix) {
        this.decompose(this.wrap(matrix));
        return this.getDeterminant();
    }

    @Override
    public boolean checkAndCompute(MatrixStore<N> matrix) {
        return this.compute(matrix, true);
    }

    @Override
    public final boolean decompose(ElementsSupplier<N> aStore) {
        return this.compute(aStore, false);
    }

    @Override
    public final boolean equals(MatrixStore<N> aStore, NumberContext context) {
        return MatrixUtils.equals(aStore, this, context);
    }

    @Override
    public N getDeterminant() {
        AggregatorFunction tmpAggrFunc = this.aggregator().product2();
        this.getInPlace().visitDiagonal(0L, 0L, tmpAggrFunc);
        return tmpAggrFunc.getNumber();
    }

    @Override
    public final MatrixStore<N> getInverse(DecompositionStore<N> preallocated) {
        DecompositionStore tmpBody = this.getInPlace();
        preallocated.substituteForwards(tmpBody, false, false, true);
        preallocated.substituteBackwards(tmpBody, false, true, true);
        return preallocated.builder().hermitian(false).build();
    }

    @Override
    public MatrixStore<N> getL() {
        return this.getInPlace().builder().triangular(false, false).build();
    }

    @Override
    public MatrixStore<N> invert(Access2D<?> original) {
        this.decompose(this.wrap(original));
        return this.getInverse();
    }

    @Override
    public MatrixStore<N> invert(Access2D<?> original, DecompositionStore<N> preallocated) {
        this.decompose(this.wrap(original));
        return this.getInverse(preallocated);
    }

    public final boolean isFullSize() {
        return true;
    }

    @Override
    public boolean isSolvable() {
        return this.isComputed() && this.mySPD;
    }

    @Override
    public boolean isSPD() {
        return this.mySPD;
    }

    @Override
    public DecompositionStore<N> preallocate(Structure2D template) {
        long tmpCountRows = template.countRows();
        return this.preallocate(tmpCountRows, tmpCountRows);
    }

    @Override
    public DecompositionStore<N> preallocate(Structure2D templateBody, Structure2D templateRHS) {
        return this.preallocate(templateRHS.countRows(), templateRHS.countColumns());
    }

    @Override
    public void reset() {
        super.reset();
        this.mySPD = false;
    }

    @Override
    public MatrixStore<N> solve(Access2D<?> body, Access2D<?> rhs) {
        this.decompose(this.wrap(body));
        return this.solve(this.wrap(rhs));
    }

    @Override
    public MatrixStore<N> solve(Access2D<?> body, Access2D<?> rhs, DecompositionStore<N> preallocated) {
        this.decompose(this.wrap(body));
        return this.solve(rhs, preallocated);
    }

    @Override
    public final MatrixStore<N> solve(ElementsSupplier<N> rhs) {
        return this.solve(rhs, this.preallocate(this.getInPlace(), rhs));
    }

    @Override
    public final MatrixStore<N> solve(ElementsSupplier<N> rhs, DecompositionStore<N> preallocated) {
        rhs.supplyTo(preallocated);
        DecompositionStore tmpBody = this.getInPlace();
        preallocated.substituteForwards(tmpBody, false, false, false);
        preallocated.substituteBackwards(tmpBody, false, true, false);
        return preallocated;
    }

    final boolean compute(ElementsSupplier<N> matrix, boolean checkHermitian) {
        this.reset();
        DecompositionStore tmpInPlace = this.setInPlace(matrix);
        int tmpRowDim = this.getRowDim();
        int tmpColDim = this.getColDim();
        int tmpMinDim = Math.min(tmpRowDim, tmpColDim);
        boolean tmpPositiveDefinite = tmpRowDim == tmpColDim;
        BasicArray tmpMultipliers = this.makeArray(tmpRowDim);
        if (tmpPositiveDefinite && checkHermitian) {
            tmpPositiveDefinite &= MatrixUtils.isHermitian(tmpInPlace);
        }
        UnaryFunction tmpSqrtFunc = this.function().sqrt();
        for (int ij = 0; tmpPositiveDefinite && ij < tmpMinDim; ++ij) {
            if (tmpInPlace.doubleValue(ij, ij) > PrimitiveMath.ZERO) {
                tmpInPlace.modifyOne(ij, ij, tmpSqrtFunc);
                tmpInPlace.divideAndCopyColumn(ij, ij, tmpMultipliers);
                tmpInPlace.applyCholesky(ij, tmpMultipliers);
                continue;
            }
            tmpPositiveDefinite = false;
        }
        this.mySPD = tmpPositiveDefinite;
        return this.computed(this.mySPD);
    }

    static final class Primitive
    extends CholeskyDecomposition<Double> {
        Primitive() {
            super(PrimitiveDenseStore.FACTORY);
        }
    }

    static final class Complex
    extends CholeskyDecomposition<ComplexNumber> {
        Complex() {
            super(ComplexDenseStore.FACTORY);
        }
    }

    static final class Big
    extends CholeskyDecomposition<BigDecimal> {
        Big() {
            super(BigDenseStore.FACTORY);
        }
    }
}

