/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import java.math.BigDecimal;
import org.ojalgo.access.Access2D;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.BidiagonalDecomposition;
import org.ojalgo.matrix.decomposition.MatrixDecomposition;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.scalar.ComplexNumber;

public interface Bidiagonal<N extends Number>
extends MatrixDecomposition<N>,
MatrixDecomposition.EconomySize<N> {
    public static <N extends Number> Bidiagonal<N> make(Access2D<N> typical) {
        N tmpNumber = typical.get(0L, 0L);
        if (tmpNumber instanceof BigDecimal) {
            return new BidiagonalDecomposition.Big();
        }
        if (tmpNumber instanceof ComplexNumber) {
            return new BidiagonalDecomposition.Complex();
        }
        if (tmpNumber instanceof Double) {
            return new BidiagonalDecomposition.Primitive();
        }
        throw new IllegalArgumentException();
    }

    public static Bidiagonal<BigDecimal> makeBig() {
        return new BidiagonalDecomposition.Big();
    }

    public static Bidiagonal<ComplexNumber> makeComplex() {
        return new BidiagonalDecomposition.Complex();
    }

    public static Bidiagonal<Double> makePrimitive() {
        return new BidiagonalDecomposition.Primitive();
    }

    public MatrixStore<N> getD();

    public MatrixStore<N> getQ1();

    public MatrixStore<N> getQ2();

    public boolean isUpper();

    @Override
    default public MatrixStore<N> reconstruct() {
        return MatrixUtils.reconstruct(this);
    }
}

