/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.machine;

import org.ojalgo.ProgrammingError;
import org.ojalgo.machine.AbstractMachine;
import org.ojalgo.machine.BasicMachine;
import org.ojalgo.machine.Hardware;
import org.ojalgo.netio.BasicLogger;

public final class VirtualMachine
extends AbstractMachine {
    private static final String AMD64 = "amd64";
    private static final String I386 = "i386";
    private static final String X86 = "x86";
    private static final String X86_64 = "x86_64";
    private final Hardware myHardware;
    private final Runtime myRuntime;

    public static String getArchitecture() {
        String tmpProperty = System.getProperty("os.arch").toLowerCase();
        if (tmpProperty.equals(I386)) {
            return X86;
        }
        if (tmpProperty.equals(AMD64)) {
            return X86_64;
        }
        return tmpProperty;
    }

    public static long getMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    public static int getThreads() {
        return Runtime.getRuntime().availableProcessors();
    }

    private VirtualMachine(String architecture, BasicMachine[] levels) {
        super(architecture, levels);
        this.myHardware = null;
        this.myRuntime = null;
        ProgrammingError.throwForIllegalInvocation();
    }

    VirtualMachine(Hardware hardware, Runtime runtime) {
        super(hardware, runtime);
        this.myHardware = hardware;
        this.myRuntime = runtime;
    }

    public void collectGarbage() {
        long tmpWasFree;
        this.myRuntime.runFinalization();
        long tmpIsFree = this.myRuntime.freeMemory();
        do {
            tmpWasFree = tmpIsFree;
            this.myRuntime.gc();
            try {
                Thread.sleep(8L);
            }
            catch (InterruptedException exception) {
                BasicLogger.error(exception.getMessage());
            }
        } while ((tmpIsFree = this.myRuntime.freeMemory()) > tmpWasFree);
        this.myRuntime.runFinalization();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof VirtualMachine)) {
            return false;
        }
        VirtualMachine other = (VirtualMachine)obj;
        return !(this.myHardware == null ? other.myHardware != null : !this.myHardware.equals(other.myHardware));
    }

    public int getAvailableDim1D(long elementSize) {
        return (int)AbstractMachine.elements(this.getAvailableMemory(), elementSize);
    }

    public int getAvailableDim2D(long elementSize) {
        return (int)Math.sqrt(AbstractMachine.elements(this.getAvailableMemory(), elementSize));
    }

    public long getAvailableMemory() {
        long tmpMax = this.myRuntime.maxMemory();
        long tmpTotal = this.myRuntime.totalMemory();
        long tmpFree = this.myRuntime.freeMemory();
        long tmpAvailable = tmpMax - tmpTotal + tmpFree;
        return tmpAvailable;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.myHardware == null ? 0 : this.myHardware.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return super.toString() + ' ' + this.myHardware.toString();
    }
}

