/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.polynomial;

import org.ojalgo.access.Access1D;
import org.ojalgo.array.Array1D;
import org.ojalgo.function.BasicFunction;
import org.ojalgo.function.polynomial.AbstractPolynomial;
import org.ojalgo.matrix.decomposition.QR;
import org.ojalgo.matrix.store.ComplexDenseStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.scalar.ComplexNumber;

public class ComplexPolynomial
extends AbstractPolynomial<ComplexNumber> {
    public ComplexPolynomial(int aDegree) {
        super(Array1D.COMPLEX.makeZero(aDegree + 1));
    }

    ComplexPolynomial(Array1D<ComplexNumber> someCoefficients) {
        super(someCoefficients);
    }

    @Override
    public void estimate(Access1D<?> x, Access1D<?> y) {
        int tmpRowDim = (int)Math.min(x.count(), y.count());
        int tmpColDim = this.size();
        PhysicalStore tmpBody = (PhysicalStore)ComplexDenseStore.FACTORY.makeZero(tmpRowDim, tmpColDim);
        PhysicalStore tmpRHS = (PhysicalStore)ComplexDenseStore.FACTORY.makeZero(tmpRowDim, 1L);
        for (int i = 0; i < tmpRowDim; ++i) {
            ComplexNumber tmpX = ComplexNumber.ONE;
            ComplexNumber tmpXfactor = ComplexNumber.valueOf(x.get(i));
            ComplexNumber tmpY = ComplexNumber.valueOf(y.get(i));
            for (int j = 0; j < tmpColDim; ++j) {
                tmpBody.set((long)i, (long)j, tmpX);
                tmpX = tmpX.multiply(tmpXfactor);
            }
            tmpRHS.set((long)i, 0L, tmpY);
        }
        QR<ComplexNumber> tmpQR = QR.makeComplex();
        tmpQR.decompose(tmpBody);
        this.set(tmpQR.solve(tmpRHS));
    }

    @Override
    public ComplexNumber integrate(ComplexNumber fromPoint, ComplexNumber toPoint) {
        BasicFunction tmpPrim = this.buildPrimitive();
        ComplexNumber tmpFromVal = tmpPrim.invoke(fromPoint);
        ComplexNumber tmpToVal = tmpPrim.invoke(toPoint);
        return tmpToVal.subtract(tmpFromVal);
    }

    @Override
    public ComplexNumber invoke(ComplexNumber arg) {
        int tmpPower = this.degree();
        ComplexNumber retVal = (ComplexNumber)this.get(tmpPower);
        while (--tmpPower >= 0) {
            retVal = ((ComplexNumber)this.get(tmpPower)).add(arg.multiply(retVal));
        }
        return retVal;
    }

    @Override
    public void set(Access1D<?> someCoefficient) {
        int tmpLimit = (int)Math.min((long)this.size(), someCoefficient.count());
        for (int p = 0; p < tmpLimit; ++p) {
            this.set(p, ComplexNumber.valueOf(someCoefficient.get(p)));
        }
    }

    @Override
    protected ComplexNumber getDerivativeFactor(int aPower) {
        int tmpNextIndex = aPower + 1;
        return ((ComplexNumber)this.get(tmpNextIndex)).multiply(tmpNextIndex);
    }

    @Override
    protected ComplexNumber getPrimitiveFactor(int aPower) {
        if (aPower <= 0) {
            return ComplexNumber.ZERO;
        }
        return ((ComplexNumber)this.get(aPower - 1)).divide(aPower);
    }

    @Override
    protected AbstractPolynomial<ComplexNumber> makeInstance(int aSize) {
        return new ComplexPolynomial((Array1D<ComplexNumber>)Array1D.COMPLEX.makeZero(aSize));
    }
}

