/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.multiary;

import java.math.BigDecimal;
import org.ojalgo.access.Access1D;
import org.ojalgo.function.multiary.AbstractMultiary;
import org.ojalgo.matrix.store.BigDenseStore;
import org.ojalgo.matrix.store.ComplexDenseStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.scalar.ComplexNumber;

public final class ConstantFunction<N extends Number>
extends AbstractMultiary<N, ConstantFunction<N>> {
    private final int myArity;
    private final PhysicalStore.Factory<N, ?> myFactory;

    public static ConstantFunction<BigDecimal> makeBig(int arity) {
        return new ConstantFunction<BigDecimal>(arity, BigDenseStore.FACTORY, null);
    }

    public static ConstantFunction<BigDecimal> makeBig(int arity, Number constant) {
        return new ConstantFunction<BigDecimal>(arity, BigDenseStore.FACTORY, constant);
    }

    public static ConstantFunction<ComplexNumber> makeComplex(int arity) {
        return new ConstantFunction<ComplexNumber>(arity, ComplexDenseStore.FACTORY, null);
    }

    public static ConstantFunction<ComplexNumber> makeComplex(int arity, Number constant) {
        return new ConstantFunction<ComplexNumber>(arity, ComplexDenseStore.FACTORY, constant);
    }

    public static ConstantFunction<Double> makePrimitive(int arity) {
        return new ConstantFunction<Double>(arity, PrimitiveDenseStore.FACTORY, null);
    }

    public static ConstantFunction<Double> makePrimitive(int arity, Number constant) {
        return new ConstantFunction<Double>(arity, PrimitiveDenseStore.FACTORY, constant);
    }

    private ConstantFunction() {
        this(0, null, null);
    }

    ConstantFunction(int arity, PhysicalStore.Factory<N, ?> factory, Number constant) {
        this.myArity = arity;
        this.myFactory = factory;
        this.setConstant(constant);
    }

    @Override
    public int arity() {
        return this.myArity;
    }

    @Override
    public MatrixStore<N> getGradient(Access1D<N> arg) {
        return this.factory().builder().makeZero(this.arity(), 1).get();
    }

    @Override
    public MatrixStore<N> getHessian(Access1D<N> arg) {
        return this.factory().builder().makeZero(this.arity(), this.arity()).get();
    }

    @Override
    public N invoke(Access1D<N> arg) {
        return this.getConstant();
    }

    @Override
    protected PhysicalStore.Factory<N, ?> factory() {
        return this.myFactory;
    }
}

