/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function;

import org.ojalgo.ProgrammingError;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.ParameterFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.type.TypeUtils;

public final class PrimitiveFunction
extends FunctionSet<Double> {
    public static final UnaryFunction<Double> ABS = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.abs(arg);
        }
    };
    public static final UnaryFunction<Double> ACOS = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.acos(arg);
        }
    };
    public static final UnaryFunction<Double> ACOSH = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.log(arg + Math.sqrt(arg * arg - PrimitiveMath.ONE));
        }
    };
    public static final BinaryFunction<Double> ADD = new Binary(){

        @Override
        public final double invoke(double arg1, double arg2) {
            return arg1 + arg2;
        }
    };
    public static final UnaryFunction<Double> ASIN = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.asin(arg);
        }
    };
    public static final UnaryFunction<Double> ASINH = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.log(arg + Math.sqrt(arg * arg + PrimitiveMath.ONE));
        }
    };
    public static final UnaryFunction<Double> ATAN = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.atan(arg);
        }
    };
    public static final UnaryFunction<Double> ATANH = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.log((PrimitiveMath.ONE + arg) / (PrimitiveMath.ONE - arg)) / PrimitiveMath.TWO;
        }
    };
    public static final UnaryFunction<Double> CARDINALITY = new Unary(){

        @Override
        public final double invoke(double arg) {
            return TypeUtils.isZero(arg) ? PrimitiveMath.ZERO : PrimitiveMath.ONE;
        }
    };
    public static final UnaryFunction<Double> CONJUGATE = new Unary(){

        @Override
        public final double invoke(double arg) {
            return arg;
        }
    };
    public static final UnaryFunction<Double> COS = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.cos(arg);
        }
    };
    public static final UnaryFunction<Double> COSH = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.cosh(arg);
        }
    };
    public static final BinaryFunction<Double> DIVIDE = new Binary(){

        @Override
        public final double invoke(double arg1, double arg2) {
            return arg1 / arg2;
        }
    };
    public static final UnaryFunction<Double> EXP = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.exp(arg);
        }
    };
    public static final UnaryFunction<Double> EXPM1 = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.expm1(arg);
        }
    };
    public static final BinaryFunction<Double> HYPOT = new Binary(){

        @Override
        public final double invoke(double arg1, double arg2) {
            double retVal;
            if (Math.abs(arg1) > Math.abs(arg2)) {
                retVal = arg2 / arg1;
                retVal = Math.abs(arg1) * Math.sqrt(PrimitiveMath.ONE + retVal * retVal);
            } else if (arg2 != PrimitiveMath.ZERO) {
                retVal = arg1 / arg2;
                retVal = Math.abs(arg2) * Math.sqrt(PrimitiveMath.ONE + retVal * retVal);
            } else {
                retVal = PrimitiveMath.ZERO;
            }
            return retVal;
        }
    };
    public static final UnaryFunction<Double> INVERT = new Unary(){

        @Override
        public final double invoke(double arg) {
            return PrimitiveMath.ONE / arg;
        }
    };
    public static final UnaryFunction<Double> LOG = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.log(arg);
        }
    };
    public static final UnaryFunction<Double> LOG10 = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.log10(arg);
        }
    };
    public static final UnaryFunction<Double> LOG1P = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.log1p(arg);
        }
    };
    public static final BinaryFunction<Double> MAX = new Binary(){

        @Override
        public final double invoke(double arg1, double arg2) {
            return Math.max(arg1, arg2);
        }
    };
    public static final BinaryFunction<Double> MIN = new Binary(){

        @Override
        public final double invoke(double arg1, double arg2) {
            return Math.min(arg1, arg2);
        }
    };
    public static final BinaryFunction<Double> MULTIPLY = new Binary(){

        @Override
        public final double invoke(double arg1, double arg2) {
            return arg1 * arg2;
        }
    };
    public static final UnaryFunction<Double> NEGATE = new Unary(){

        @Override
        public final double invoke(double arg) {
            return -arg;
        }
    };
    public static final BinaryFunction<Double> POW = new Binary(){

        @Override
        public final double invoke(double arg1, double arg2) {
            return Math.pow(arg1, arg2);
        }
    };
    public static final ParameterFunction<Double> POWER = new Parameter(){

        @Override
        public final double invoke(double arg, int param) {
            if (param < 0) {
                return INVERT.invoke(POWER.invoke(arg, -param));
            }
            double retVal = PrimitiveMath.ONE;
            while (param > 0) {
                retVal *= arg;
                --param;
            }
            return retVal;
        }
    };
    public static final ParameterFunction<Double> ROOT = new Parameter(){

        @Override
        public final double invoke(double arg, int param) {
            if (param != 0) {
                return Math.pow(arg, PrimitiveMath.ONE / (double)param);
            }
            throw new IllegalArgumentException();
        }
    };
    public static final ParameterFunction<Double> SCALE = new Parameter(){

        @Override
        public final double invoke(double arg, int param) {
            if (param < 0) {
                throw new ProgrammingError("Cannot have exponents smaller than zero.");
            }
            long tmpFactor = 1L;
            long tmp10 = (long)PrimitiveMath.TEN;
            while (param > 0) {
                tmpFactor *= tmp10;
                --param;
            }
            return Math.rint((double)tmpFactor * arg) / (double)tmpFactor;
        }
    };
    public static final UnaryFunction<Double> SIGNUM = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.signum(arg);
        }
    };
    public static final UnaryFunction<Double> SIN = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.sin(arg);
        }
    };
    public static final UnaryFunction<Double> SINH = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.sinh(arg);
        }
    };
    public static final UnaryFunction<Double> SQRT = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.sqrt(arg);
        }
    };
    public static final UnaryFunction<Double> SQRT1PX2 = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.sqrt(PrimitiveMath.ONE + arg * arg);
        }
    };
    public static final BinaryFunction<Double> SUBTRACT = new Binary(){

        @Override
        public final double invoke(double arg1, double arg2) {
            return arg1 - arg2;
        }
    };
    public static final UnaryFunction<Double> TAN = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.tan(arg);
        }
    };
    public static final UnaryFunction<Double> TANH = new Unary(){

        @Override
        public final double invoke(double arg) {
            return Math.tanh(arg);
        }
    };
    public static final UnaryFunction<Double> VALUE = new Unary(){

        @Override
        public final double invoke(double arg) {
            return arg;
        }
    };
    private static final PrimitiveFunction SET = new PrimitiveFunction();

    public static PrimitiveFunction getSet() {
        return SET;
    }

    private PrimitiveFunction() {
    }

    @Override
    public UnaryFunction<Double> abs() {
        return ABS;
    }

    @Override
    public UnaryFunction<Double> acos() {
        return ACOS;
    }

    @Override
    public UnaryFunction<Double> acosh() {
        return ACOSH;
    }

    @Override
    public BinaryFunction<Double> add() {
        return ADD;
    }

    @Override
    public UnaryFunction<Double> asin() {
        return ASIN;
    }

    @Override
    public UnaryFunction<Double> asinh() {
        return ASINH;
    }

    @Override
    public UnaryFunction<Double> atan() {
        return ATAN;
    }

    @Override
    public UnaryFunction<Double> atanh() {
        return ATANH;
    }

    @Override
    public UnaryFunction<Double> cardinality() {
        return CARDINALITY;
    }

    @Override
    public UnaryFunction<Double> conjugate() {
        return CONJUGATE;
    }

    @Override
    public UnaryFunction<Double> cos() {
        return COS;
    }

    @Override
    public UnaryFunction<Double> cosh() {
        return COSH;
    }

    @Override
    public BinaryFunction<Double> divide() {
        return DIVIDE;
    }

    @Override
    public UnaryFunction<Double> exp() {
        return EXP;
    }

    @Override
    public UnaryFunction<Double> expm1() {
        return EXPM1;
    }

    @Override
    public BinaryFunction<Double> hypot() {
        return HYPOT;
    }

    @Override
    public UnaryFunction<Double> invert() {
        return INVERT;
    }

    @Override
    public UnaryFunction<Double> log() {
        return LOG;
    }

    @Override
    public UnaryFunction<Double> log10() {
        return LOG10;
    }

    @Override
    public UnaryFunction<Double> log1p() {
        return LOG1P;
    }

    @Override
    public BinaryFunction<Double> max() {
        return MAX;
    }

    @Override
    public BinaryFunction<Double> min() {
        return MIN;
    }

    @Override
    public BinaryFunction<Double> multiply() {
        return MULTIPLY;
    }

    @Override
    public UnaryFunction<Double> negate() {
        return NEGATE;
    }

    @Override
    public BinaryFunction<Double> pow() {
        return POW;
    }

    @Override
    public ParameterFunction<Double> power() {
        return POWER;
    }

    @Override
    public ParameterFunction<Double> root() {
        return ROOT;
    }

    @Override
    public ParameterFunction<Double> scale() {
        return SCALE;
    }

    @Override
    public UnaryFunction<Double> signum() {
        return SIGNUM;
    }

    @Override
    public UnaryFunction<Double> sin() {
        return SIN;
    }

    @Override
    public UnaryFunction<Double> sinh() {
        return SINH;
    }

    @Override
    public UnaryFunction<Double> sqrt() {
        return SQRT;
    }

    @Override
    public UnaryFunction<Double> sqrt1px2() {
        return SQRT1PX2;
    }

    @Override
    public BinaryFunction<Double> subtract() {
        return SUBTRACT;
    }

    @Override
    public UnaryFunction<Double> tan() {
        return TAN;
    }

    @Override
    public UnaryFunction<Double> tanh() {
        return TANH;
    }

    @Override
    public UnaryFunction<Double> value() {
        return VALUE;
    }

    @FunctionalInterface
    public static interface Unary
    extends UnaryFunction<Double> {
        @Override
        default public Double invoke(Double arg) {
            return this.invoke((double)arg);
        }
    }

    @FunctionalInterface
    public static interface Parameter
    extends ParameterFunction<Double> {
        @Override
        default public Double invoke(Double arg, int param) {
            return this.invoke((double)arg, param);
        }
    }

    @FunctionalInterface
    public static interface Binary
    extends BinaryFunction<Double> {
        @Override
        default public Double invoke(Double arg1, Double arg2) {
            return this.invoke((double)arg1, (double)arg2);
        }
    }
}

